/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.indexing.impl;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.indexing.impl.TextIndexStorage;
import org.netbeans.modules.cnd.repository.api.Repository;
import org.netbeans.modules.cnd.repository.api.RepositoryListener;
import org.netbeans.modules.cnd.repository.impl.spi.LayerDescriptor;
import org.netbeans.modules.cnd.repository.impl.spi.LayerListener;
import org.netbeans.modules.cnd.repository.impl.spi.LayeringSupport;

public final class TextIndexStorageManager
implements LayerListener {
    public static final String FIELD_IDS = "ids";
    public static final String FIELD_UNIT_ID = "unitId";
    private static final Object lock = new Object();
    private static final Map<Integer, TextIndexStorage> storages = new HashMap<Integer, TextIndexStorage>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TextIndexStorage get(int unitID) {
        Object object = lock;
        synchronized (object) {
            TextIndexStorage storage;
            LayeringSupport ls = Repository.getLayeringSupport((int)unitID);
            if (ls == null) {
                return null;
            }
            Integer storageID = ls.getStorageID();
            Map<Integer, TextIndexStorage> map = storages;
            synchronized (map) {
                storage = storages.get(storageID);
                if (storage == null) {
                    storage = new TextIndexStorage(ls);
                    storages.put(storageID, storage);
                }
            }
            return storage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean layerOpened(LayerDescriptor layerDescriptor) {
        boolean isOK = true;
        Map<Integer, TextIndexStorage> map = storages;
        synchronized (map) {
            for (TextIndexStorage textIndexStorage : storages.values()) {
                isOK &= textIndexStorage.isValid();
            }
        }
        return isOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        Map<Integer, TextIndexStorage> map = storages;
        synchronized (map) {
            for (TextIndexStorage storage : storages.values()) {
                storage.shutdown();
            }
            storages.clear();
        }
    }

    public static class Shutdown
    implements Runnable {
        @Override
        public void run() {
            TextIndexStorageManager.shutdown();
        }
    }

    public static class Startup
    implements Runnable,
    RepositoryListener {
        @Override
        public void run() {
            Repository.registerRepositoryListener((RepositoryListener)this);
        }

        public boolean unitOpened(int unitId) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unitRemoved(int unitId) {
            if (unitId < 0) {
                return;
            }
            Object object = lock;
            synchronized (object) {
                TextIndexStorage index = TextIndexStorageManager.get(unitId);
                if (index != null) {
                    index.unitRemoved(unitId);
                }
            }
        }

        public void unitClosed(int unitId) {
        }
    }
}

