/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreeScanner;
import java.util.List;
import org.netbeans.modules.debugger.jpda.projects.ASTOperationCreationDelegate;
import org.netbeans.spi.debugger.jpda.EditorContext;

class MethodArgumentsScanner
extends TreeScanner<EditorContext.MethodArgument[], Object> {
    private int offset;
    private CompilationUnitTree tree;
    private SourcePositions positions;
    private LineMap lineMap;
    private boolean methodInvocation;
    private ASTOperationCreationDelegate positionDelegate;
    private EditorContext.MethodArgument[] arguments;

    public MethodArgumentsScanner(int offset, CompilationUnitTree tree, SourcePositions positions, boolean methodInvocation, ASTOperationCreationDelegate positionDelegate) {
        this.offset = offset;
        this.tree = tree;
        this.positions = positions;
        this.lineMap = tree.getLineMap();
        this.methodInvocation = methodInvocation;
        this.positionDelegate = positionDelegate;
    }

    @Override
    public EditorContext.MethodArgument[] visitMethodInvocation(MethodInvocationTree node, Object p) {
        if (!this.methodInvocation || (long)this.offset != this.positions.getEndPosition(this.tree, node.getMethodSelect())) {
            return (EditorContext.MethodArgument[])super.visitMethodInvocation(node, p);
        }
        List<? extends ExpressionTree> args = node.getArguments();
        List<? extends Tree> argTypes = node.getTypeArguments();
        this.arguments = this.composeArguments(args, argTypes);
        return this.arguments;
    }

    @Override
    public EditorContext.MethodArgument[] visitNewClass(NewClassTree node, Object p) {
        if (!this.methodInvocation || (long)this.offset != this.positions.getEndPosition(this.tree, node.getIdentifier())) {
            return (EditorContext.MethodArgument[])super.visitNewClass(node, p);
        }
        List<? extends ExpressionTree> args = node.getArguments();
        List<? extends Tree> argTypes = node.getTypeArguments();
        this.arguments = this.composeArguments(args, argTypes);
        return this.arguments;
    }

    @Override
    public EditorContext.MethodArgument[] visitMethod(MethodTree node, Object p) {
        long startMethod = this.positions.getStartPosition(this.tree, node);
        long endMethod = this.positions.getEndPosition(this.tree, node);
        if (this.methodInvocation || startMethod == -1L || endMethod == -1L || (long)this.offset < this.lineMap.getLineNumber(startMethod) || (long)this.offset > this.lineMap.getLineNumber(endMethod)) {
            return (EditorContext.MethodArgument[])super.visitMethod(node, p);
        }
        List<? extends VariableTree> args = node.getParameters();
        List<? extends TypeParameterTree> argTypes = node.getTypeParameters();
        int n = args.size();
        this.arguments = new EditorContext.MethodArgument[n];
        for (int i = 0; i < n; ++i) {
            VariableTree var = args.get(i);
            long startOffset = this.positions.getStartPosition(this.tree, var);
            long endOffset = this.positions.getEndPosition(this.tree, var);
            if (startOffset == -1L || endOffset == -1L) {
                return new EditorContext.MethodArgument[0];
            }
            this.arguments[i] = new EditorContext.MethodArgument(var.getName().toString(), var.getType().toString(), this.positionDelegate.createPosition((int)startOffset, (int)this.lineMap.getLineNumber(startOffset), (int)this.lineMap.getColumnNumber(startOffset)), this.positionDelegate.createPosition((int)endOffset, (int)this.lineMap.getLineNumber(endOffset), (int)this.lineMap.getColumnNumber(endOffset)));
        }
        return this.arguments;
    }

    EditorContext.MethodArgument[] getArguments() {
        return this.arguments;
    }

    private final EditorContext.MethodArgument[] composeArguments(List<? extends Tree> args, List<? extends Tree> argTypes) {
        int n = args.size();
        EditorContext.MethodArgument[] arguments = new EditorContext.MethodArgument[n];
        for (int i = 0; i < n; ++i) {
            Tree var = args.get(i);
            long startOffset = this.positions.getStartPosition(this.tree, var);
            long endOffset = this.positions.getEndPosition(this.tree, var);
            if (startOffset == -1L || endOffset == -1L) {
                return new EditorContext.MethodArgument[0];
            }
            arguments[i] = new EditorContext.MethodArgument(var.toString(), argTypes.size() > i ? argTypes.get(i).toString() : "", this.positionDelegate.createPosition((int)startOffset, (int)this.lineMap.getLineNumber(startOffset), (int)this.lineMap.getColumnNumber(startOffset)), this.positionDelegate.createPosition((int)endOffset, (int)this.lineMap.getLineNumber(endOffset), (int)this.lineMap.getColumnNumber(endOffset)));
        }
        return arguments;
    }
}

