/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.ui;

import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

public class FileChooser
extends JFileChooser {
    private static File currentChooserFile = null;

    public FileChooser(String titleText, String buttonText, int mode, javax.swing.filechooser.FileFilter[] filters, String feedFilePath, boolean useParent) {
        super(FileChooser.computeCurrentDir(feedFilePath, useParent));
        this.setFileHidingEnabled(false);
        this.setFileSelectionMode(mode);
        this.setDialogTitle(titleText);
        if (buttonText != null) {
            this.setApproveButtonText(buttonText);
        }
        if (filters != null) {
            for (int i = 0; i < filters.length; ++i) {
                this.addChoosableFileFilter(filters[i]);
            }
            this.setFileFilter(filters[0]);
        }
        File parent = this.getCurrentDirectory();
        File file = FileChooser.getCurrentChooserFile();
        if (parent != null && file != null && parent.equals(file.getParentFile())) {
            this.setSelectedFile(file);
        }
    }

    private static File computeCurrentDir(String feedFilePath, boolean useParent) {
        File feedFilePathFile = null;
        if (feedFilePath != null && feedFilePath.length() > 0) {
            feedFilePathFile = new File(feedFilePath);
        }
        if (feedFilePathFile != null && feedFilePathFile.exists()) {
            FileChooser.setCurrentChooserFile(feedFilePathFile);
        }
        if (FileChooser.getCurrentChooserFile() == null && feedFilePathFile == null) {
            feedFilePathFile = new File(FileChooser.getLastPath());
        }
        if (FileChooser.getCurrentChooserFile() == null && feedFilePathFile != null && feedFilePathFile.getParentFile() != null && feedFilePathFile.getParentFile().exists()) {
            FileChooser.setCurrentChooserFile(feedFilePathFile.getParentFile());
            useParent = false;
        }
        if (FileChooser.getCurrentChooserFile() != null) {
            if (useParent) {
                if (FileChooser.getCurrentChooserFile() != null && FileChooser.getCurrentChooserFile().exists()) {
                    return FileChooser.getCurrentChooserFile().getParentFile();
                }
            } else if (FileChooser.getCurrentChooserFile() != null && FileChooser.getCurrentChooserFile().exists()) {
                return FileChooser.getCurrentChooserFile();
            }
        } else {
            File sdFile;
            String sd = System.getProperty("spro.pwd");
            if (sd != null && (sdFile = new File(sd)).exists()) {
                return FileChooser.wrapFileNoCanonicalize(sdFile);
            }
        }
        return null;
    }

    private static String getLastPath() {
        Preferences pref;
        String res;
        File file;
        String feed = System.getProperty("user.home");
        if (feed == null) {
            feed = "";
        }
        if (!(file = new File(res = (pref = NbPreferences.forModule(FileChooser.class)).get("last-file", feed))).exists() && !res.equals(feed)) {
            res = feed;
        }
        return res;
    }

    @Override
    public int showDialog(Component parent, String approveButtonText) throws HeadlessException {
        FileDialog fileDialog;
        if (Boolean.getBoolean("nb.native.filechooser") && null != (fileDialog = this.createFileDialog(parent, this.getCurrentDirectory()))) {
            return this.showFileDialog(fileDialog, 0);
        }
        return super.showDialog(parent, approveButtonText);
    }

    private FileDialog createFileDialog(Component parentComponent, File currentDirectory) {
        boolean dirsOnly;
        boolean bl = dirsOnly = this.getFileSelectionMode() == 1;
        if (!Boolean.getBoolean("nb.native.filechooser")) {
            return null;
        }
        if (dirsOnly && !Utilities.isMac()) {
            return null;
        }
        Frame parentFrame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parentComponent);
        FileDialog fileDialog = new FileDialog(parentFrame);
        String dialogTitle = this.getDialogTitle();
        if (dialogTitle != null) {
            fileDialog.setTitle(dialogTitle);
        }
        if (null != currentDirectory) {
            fileDialog.setDirectory(currentDirectory.getAbsolutePath());
        }
        return fileDialog;
    }

    public int showFileDialog(FileDialog fileDialog, int mode) {
        boolean dirsOnly;
        String oldFileDialogProp = System.getProperty("apple.awt.fileDialogForDirectories");
        boolean bl = dirsOnly = this.getFileSelectionMode() == 1;
        if (dirsOnly) {
            System.setProperty("apple.awt.fileDialogForDirectories", "true");
        }
        fileDialog.setMode(mode);
        fileDialog.setVisible(true);
        if (dirsOnly) {
            if (null != oldFileDialogProp) {
                System.setProperty("apple.awt.fileDialogForDirectories", oldFileDialogProp);
            } else {
                System.clearProperty("apple.awt.fileDialogForDirectories");
            }
        }
        if (fileDialog.getDirectory() != null && fileDialog.getFile() != null) {
            this.setSelectedFile(new File(fileDialog.getDirectory(), fileDialog.getFile()));
            this.setSelectedFiles(new File[]{new File(fileDialog.getDirectory(), fileDialog.getFile())});
            return 0;
        }
        return 1;
    }

    @Override
    public int showOpenDialog(Component parent) {
        int ret = super.showOpenDialog(parent);
        if (ret != 1 && this.getSelectedFile().exists()) {
            FileChooser.setCurrentChooserFile(this.getSelectedFile());
            Preferences pref = NbPreferences.forModule(FileChooser.class);
            pref.put("last-file", FileChooser.getCurrentChooserFile().getAbsolutePath());
        }
        return ret;
    }

    public static File getCurrentChooserFile() {
        return currentChooserFile;
    }

    public static void setCurrentChooserFile(File aCurrentChooserFile) {
        currentChooserFile = FileChooser.wrapFileNoCanonicalize(aCurrentChooserFile);
    }

    private static File wrapFileNoCanonicalize(File f) {
        if (f instanceof NonCanonicalizingFile) {
            return f;
        }
        if (f != null) {
            return new NonCanonicalizingFile(f);
        }
        return null;
    }

    private static File[] wrapFilesNoCanonicalize(File[] fs) {
        if (fs != null) {
            for (int i = 0; i < fs.length; ++i) {
                fs[i] = FileChooser.wrapFileNoCanonicalize(fs[i]);
            }
        }
        return fs;
    }

    private static final class NonCanonicalizingFile
    extends File {
        public NonCanonicalizingFile(File orig) {
            this(orig.getPath());
        }

        private NonCanonicalizingFile(String path) {
            super(path);
        }

        private NonCanonicalizingFile(URI uri) {
            super(uri);
        }

        @Override
        public File getCanonicalFile() throws IOException {
            return FileChooser.wrapFileNoCanonicalize(FileUtil.normalizeFile((File)super.getAbsoluteFile()));
        }

        @Override
        public String getCanonicalPath() throws IOException {
            return FileUtil.normalizeFile((File)super.getAbsoluteFile()).getAbsolutePath();
        }

        @Override
        public File getParentFile() {
            return FileChooser.wrapFileNoCanonicalize(super.getParentFile());
        }

        @Override
        public File getAbsoluteFile() {
            return FileChooser.wrapFileNoCanonicalize(super.getAbsoluteFile());
        }

        @Override
        public File[] listFiles() {
            return FileChooser.wrapFilesNoCanonicalize(super.listFiles());
        }

        @Override
        public File[] listFiles(FileFilter filter) {
            return FileChooser.wrapFilesNoCanonicalize(super.listFiles(filter));
        }

        @Override
        public File[] listFiles(FilenameFilter filter) {
            return FileChooser.wrapFilesNoCanonicalize(super.listFiles(filter));
        }
    }
}

