/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute.ui;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import org.apache.maven.execution.ExecutionEvent;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.execute.cmd.ExecMojo;
import org.netbeans.modules.maven.execute.cmd.ExecProject;
import org.netbeans.modules.maven.execute.cmd.ExecutionEventObject;
import org.netbeans.modules.maven.execute.ui.Bundle;
import org.netbeans.modules.maven.execute.ui.DebugPluginSourceAction;
import org.netbeans.modules.maven.execute.ui.GotoPluginSourceAction;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Pair;
import org.openide.util.lookup.Lookups;

public class ShowExecutionPanel
extends JPanel
implements ExplorerManager.Provider {
    private static final String ERROR_ICON = "org/netbeans/modules/maven/execute/ui/error.png";
    private static final String LIFECYCLE_ICON = "org/netbeans/modules/maven/execute/ui/lifecycle.png";
    private static final String ICON_PHASE = "org/netbeans/modules/maven/execute/ui/phase.png";
    private final ExplorerManager manager = new ExplorerManager();
    private boolean showPhases = false;
    private boolean showOnlyErrors = false;
    private Project prj;
    private RunConfig config;
    private JButton btnCollapse;
    private JButton btnExpand;
    private JToggleButton btnFailedToggle;
    private JToggleButton btnPhaseToggle;
    private JScrollPane btvExec;
    private JToolBar.Separator jSeparator1;
    private JToolBar jToolBar1;

    public ShowExecutionPanel() {
        this.initComponents();
        ((BeanTreeView)this.btvExec).setRootVisible(false);
        ((BeanTreeView)this.btvExec).setSelectionMode(1);
        this.btnPhaseToggle.setIcon(ImageUtilities.loadImageIcon((String)ICON_PHASE, (boolean)true));
        this.btnPhaseToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowExecutionPanel.this.showPhases = ShowExecutionPanel.this.btnPhaseToggle.isSelected();
                ExecutionEventObject.Tree item = (ExecutionEventObject.Tree)ShowExecutionPanel.this.manager.getRootContext().getLookup().lookup(ExecutionEventObject.Tree.class);
                ShowExecutionPanel.this.manager.setRootContext(ShowExecutionPanel.this.createNodeForExecutionEventTree(item));
                ShowExecutionPanel.this.expandCollapseChildNodes(ShowExecutionPanel.this.manager.getRootContext(), false, false);
            }
        });
        this.btnFailedToggle.setIcon(ImageUtilities.loadImageIcon((String)ERROR_ICON, (boolean)true));
        this.btnFailedToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowExecutionPanel.this.showOnlyErrors = ShowExecutionPanel.this.btnFailedToggle.isSelected();
                ExecutionEventObject.Tree item = (ExecutionEventObject.Tree)ShowExecutionPanel.this.manager.getRootContext().getLookup().lookup(ExecutionEventObject.Tree.class);
                ShowExecutionPanel.this.manager.setRootContext(ShowExecutionPanel.this.createNodeForExecutionEventTree(item));
                ShowExecutionPanel.this.expandCollapseChildNodes(ShowExecutionPanel.this.manager.getRootContext(), false, false);
            }
        });
    }

    private void initComponents() {
        this.btvExec = new BeanTreeView();
        this.jToolBar1 = new JToolBar();
        this.btnPhaseToggle = new JToggleButton();
        this.btnFailedToggle = new JToggleButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.btnCollapse = new JButton();
        this.btnExpand = new JButton();
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        Mnemonics.setLocalizedText((AbstractButton)this.btnPhaseToggle, (String)NbBundle.getMessage(ShowExecutionPanel.class, (String)"ShowExecutionPanel.btnPhaseToggle.text"));
        this.btnPhaseToggle.setToolTipText(NbBundle.getMessage(ShowExecutionPanel.class, (String)"ShowExecutionPanel.btnPhaseToggle.toolTipText"));
        this.btnPhaseToggle.setFocusable(false);
        this.jToolBar1.add(this.btnPhaseToggle);
        Mnemonics.setLocalizedText((AbstractButton)this.btnFailedToggle, (String)NbBundle.getMessage(ShowExecutionPanel.class, (String)"ShowExecutionPanel.btnFailedToggle.text"));
        this.btnFailedToggle.setToolTipText(NbBundle.getMessage(ShowExecutionPanel.class, (String)"ShowExecutionPanel.btnFailedToggle.toolTipText"));
        this.btnFailedToggle.setFocusable(false);
        this.jToolBar1.add(this.btnFailedToggle);
        this.jToolBar1.add(this.jSeparator1);
        Mnemonics.setLocalizedText((AbstractButton)this.btnCollapse, (String)NbBundle.getMessage(ShowExecutionPanel.class, (String)"ShowExecutionPanel.btnCollapse.text"));
        this.btnCollapse.setToolTipText(NbBundle.getMessage(ShowExecutionPanel.class, (String)"ShowExecutionPanel.btnCollapse.toolTipText"));
        this.btnCollapse.setFocusable(false);
        this.btnCollapse.setHorizontalTextPosition(0);
        this.btnCollapse.setVerticalTextPosition(3);
        this.btnCollapse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShowExecutionPanel.this.btnCollapseActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnCollapse);
        Mnemonics.setLocalizedText((AbstractButton)this.btnExpand, (String)NbBundle.getMessage(ShowExecutionPanel.class, (String)"ShowExecutionPanel.btnExpand.text"));
        this.btnExpand.setToolTipText(NbBundle.getMessage(ShowExecutionPanel.class, (String)"ShowExecutionPanel.btnExpand.toolTipText"));
        this.btnExpand.setFocusable(false);
        this.btnExpand.setHorizontalTextPosition(0);
        this.btnExpand.setVerticalTextPosition(3);
        this.btnExpand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShowExecutionPanel.this.btnExpandActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnExpand);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btvExec).addComponent(this.jToolBar1, -1, 564, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.btvExec, -1, 349, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jToolBar1, -2, 25, -2).addContainerGap()));
    }

    private void btnCollapseActionPerformed(ActionEvent evt) {
        this.expandCollapseChildNodes(this.manager.getRootContext(), true, true);
    }

    private void btnExpandActionPerformed(ActionEvent evt) {
        this.expandCollapseChildNodes(this.manager.getRootContext(), false, true);
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public void setTreeToDisplay(ExecutionEventObject.Tree item, RunConfig config) {
        this.prj = config.getProject();
        this.config = config;
        this.manager.setRootContext(this.createNodeForExecutionEventTree(item));
        this.manager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("selectedNodes".equals(evt.getPropertyName())) {
                    ExecutionEventObject.Tree tree;
                    Node[] sel;
                    Object newO;
                    Object oldO = evt.getOldValue();
                    if (oldO instanceof Node[]) {
                        // empty if block
                    }
                    if ((newO = evt.getNewValue()) instanceof Node[] && (sel = (Node[])newO).length > 0 && (tree = (ExecutionEventObject.Tree)sel[0].getLookup().lookup(ExecutionEventObject.Tree.class)) != null) {
                        tree.expandFold();
                        tree.getStartOffset().scrollTo();
                    }
                }
            }
        });
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.expandCollapseChildNodes(this.manager.getRootContext(), false, false);
    }

    private Node createNodeForExecutionEventTree(ExecutionEventObject.Tree item) {
        ExecutionEventObject se = item.getStartEvent();
        if (se != null) {
            AbstractNode nd = new AbstractNode(this.createChildren(item.getChildrenNodes()), Lookups.fixed((Object[])new Object[]{item}));
            switch (se.type) {
                case ProjectStarted: {
                    return new ProjectNode(this.showPhases ? this.createPhasedChildren(item.getChildrenNodes()) : this.createChildren(item.getChildrenNodes()), Lookups.fixed((Object[])new Object[]{item}));
                }
                case MojoStarted: {
                    return new MojoNode(this.createChildren(item.getChildrenNodes()), Lookups.fixed((Object[])new Object[]{item, this.config}));
                }
            }
            nd.setDisplayName(se.type.name());
            nd.setName(se.type.name());
            return nd;
        }
        return new AbstractNode(this.createChildren(item.getChildrenNodes()), Lookups.fixed((Object[])new Object[]{item}));
    }

    private Children createChildren(final List<ExecutionEventObject.Tree> childrenNodes) {
        if (childrenNodes.isEmpty()) {
            return Children.LEAF;
        }
        return Children.create((ChildFactory)new ChildFactory<ExecutionEventObject.Tree>(){

            protected boolean createKeys(List<ExecutionEventObject.Tree> toPopulate) {
                if (ShowExecutionPanel.this.showOnlyErrors) {
                    for (ExecutionEventObject.Tree item : childrenNodes) {
                        ExecutionEventObject end = item.getEndEvent();
                        if (end == null || !ExecutionEvent.Type.ProjectFailed.equals((Object)end.type) && !ExecutionEvent.Type.MojoFailed.equals((Object)end.type) && !ExecutionEvent.Type.ForkedProjectFailed.equals((Object)end.type) && !ExecutionEvent.Type.ForkFailed.equals((Object)end.type)) continue;
                        toPopulate.add(item);
                    }
                } else {
                    toPopulate.addAll(childrenNodes);
                }
                return true;
            }

            protected Node createNodeForKey(ExecutionEventObject.Tree key) {
                return ShowExecutionPanel.this.createNodeForExecutionEventTree(key);
            }
        }, (boolean)false);
    }

    private Children createPhasedChildren(final List<ExecutionEventObject.Tree> childrenNodes) {
        return Children.create((ChildFactory)new ChildFactory<Pair<String, List<ExecutionEventObject.Tree>>>(){

            protected boolean createKeys(List<Pair<String, List<ExecutionEventObject.Tree>>> toPopulate) {
                HashMap<String, Pair> phases = new HashMap<String, Pair>();
                for (ExecutionEventObject.Tree item : childrenNodes) {
                    ExecMojo mojo = (ExecMojo)item.getStartEvent();
                    String phaseString = mojo.phase != null ? mojo.phase : "<none>";
                    Pair phase = (Pair)phases.get(phaseString);
                    if (phase == null) {
                        phase = Pair.of((Object)phaseString, new ArrayList());
                        phases.put(phaseString, phase);
                        toPopulate.add((Pair<String, List<ExecutionEventObject.Tree>>)phase);
                    }
                    ((List)phase.second()).add(item);
                }
                return true;
            }

            protected Node createNodeForKey(Pair<String, List<ExecutionEventObject.Tree>> key) {
                return ShowExecutionPanel.this.createPhaseNode((Pair<String, List<ExecutionEventObject.Tree>>)key);
            }
        }, (boolean)false);
    }

    private Node createPhaseNode(Pair<String, List<ExecutionEventObject.Tree>> key) {
        Children childs;
        if (this.showOnlyErrors) {
            boolean atLeastOne = false;
            for (ExecutionEventObject.Tree ch : (List)key.second()) {
                ExecutionEventObject end = ch.getEndEvent();
                if (end == null || !ExecutionEvent.Type.ProjectFailed.equals((Object)end.type) && !ExecutionEvent.Type.MojoFailed.equals((Object)end.type) && !ExecutionEvent.Type.ForkedProjectFailed.equals((Object)end.type) && !ExecutionEvent.Type.ForkFailed.equals((Object)end.type)) continue;
                atLeastOne = true;
                break;
            }
            childs = atLeastOne ? this.createChildren((List)key.second()) : Children.LEAF;
        } else {
            childs = this.createChildren((List)key.second());
        }
        AbstractNode nd = new AbstractNode(childs, Lookup.EMPTY);
        nd.setName((String)key.first());
        nd.setDisplayName((String)key.first());
        nd.setIconBaseWithExtension(ICON_PHASE);
        return nd;
    }

    private void expandCollapseChildNodes(Node parent, boolean collapse, boolean recursive) {
        for (Node nd : parent.getChildren().getNodes(true)) {
            if (recursive) {
                this.expandCollapseChildNodes(nd, collapse, recursive);
            }
            if (collapse) {
                ((BeanTreeView)this.btvExec).collapseNode(nd);
                continue;
            }
            ((BeanTreeView)this.btvExec).expandNode(nd);
        }
    }

    private static class GotoSourceAction
    extends AbstractAction {
        private final ExecMojo mojo;

        public GotoSourceAction(ExecMojo start) {
            this.putValue("Name", Bundle.ACT_GOTO_Exec());
            this.setEnabled(start.getLocation() != null);
            this.mojo = start;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.mojo.getLocation() != null) {
                ModelUtils.openAtSource(this.mojo.getLocation());
            }
        }
    }

    private static class GotoOutputAction
    extends AbstractAction {
        private final ExecutionEventObject.Tree item;

        public GotoOutputAction(ExecutionEventObject.Tree item) {
            this.putValue("Name", Bundle.ACT_GOTO_Output());
            this.item = item;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.item.expandFold();
            this.item.getStartOffset().scrollTo();
        }
    }

    private static class ProjectNode
    extends AbstractNode {
        private final ExecProject start;
        private final ExecProject end;

        public ProjectNode(Children children, Lookup lookup) {
            super(children, lookup);
            this.start = (ExecProject)((ExecutionEventObject.Tree)lookup.lookup(ExecutionEventObject.Tree.class)).getStartEvent();
            this.end = (ExecProject)((ExecutionEventObject.Tree)lookup.lookup(ExecutionEventObject.Tree.class)).getEndEvent();
            assert (this.start != null && this.end != null);
            this.setIconBaseWithExtension(ShowExecutionPanel.LIFECYCLE_ICON);
            this.setDisplayName(this.start.gav.artifactId);
        }

        public String getHtmlDisplayName() {
            return "<html><font color='!controlShadow'>" + this.start.gav.groupId + " </font><b>" + this.start.gav.artifactId + "</b> " + this.start.gav.version + "</html>";
        }

        public String getShortDescription() {
            return "<html>Project GAV: " + this.start.gav.getId() + (this.start.currentProjectLocation != null ? "<br/>Location: " + this.start.currentProjectLocation.getAbsolutePath() : "") + "</html>";
        }

        public Image getIcon(int type) {
            Image img = super.getIcon(type);
            if (ExecutionEvent.Type.ProjectFailed.equals((Object)this.end.type)) {
                Image ann = ImageUtilities.loadImage((String)ShowExecutionPanel.ERROR_ICON);
                return ImageUtilities.mergeImages((Image)img, (Image)ann, (int)8, (int)0);
            }
            return img;
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }
    }

    private static class MojoNode
    extends AbstractNode {
        private final ExecMojo start;
        private final ExecMojo end;
        private final ExecutionEventObject.Tree tree;
        private final RunConfig config;

        public MojoNode(Children children, Lookup lookup) {
            super(children, lookup);
            this.tree = (ExecutionEventObject.Tree)lookup.lookup(ExecutionEventObject.Tree.class);
            this.start = (ExecMojo)this.tree.getStartEvent();
            this.end = (ExecMojo)this.tree.getEndEvent();
            this.config = (RunConfig)lookup.lookup(RunConfig.class);
            assert (this.start != null && this.end != null);
            this.setIconBaseWithExtension("org/netbeans/modules/maven/execute/ui/mojo.png");
            this.setDisplayName(this.start.goal);
        }

        public String getHtmlDisplayName() {
            return "<html><b>" + this.start.goal + "</b>" + (this.end.getErrorMessage() != null ? " <font color='#a40000'>" + this.end.getErrorMessage() + "</font>" : "") + " <font color='!controlShadow'>" + this.start.plugin.groupId + ":" + this.start.plugin.artifactId + ":" + this.start.plugin.version + "</font></html>";
        }

        public String getShortDescription() {
            return "<html>Goal: " + this.start.goal + "<br/>Phase: " + this.start.phase + "<br/>Execution Id: " + this.start.executionId + (this.end.getErrorMessage() != null ? "<br/>Error: <b>" + this.end.getErrorMessage() + "</b>" : "") + "</html>";
        }

        public Action[] getActions(boolean context) {
            return new Action[]{new GotoOutputAction(this.tree), new GotoSourceAction(this.start), new GotoPluginSourceAction(this.start, this.config), new DebugPluginSourceAction(this.start, this.config)};
        }

        public Image getIcon(int type) {
            Image img = super.getIcon(type);
            if (ExecutionEvent.Type.MojoFailed.equals((Object)this.end.type)) {
                Image ann = ImageUtilities.loadImage((String)ShowExecutionPanel.ERROR_ICON);
                return ImageUtilities.mergeImages((Image)img, (Image)ann, (int)8, (int)0);
            }
            return img;
        }
    }
}

