/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.browser.webview.ext;

import com.sun.javafx.scene.web.Debugger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.util.Callback;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;
import org.netbeans.core.browser.webview.TransportImplementationWithURLToLoad;
import org.netbeans.core.browser.webview.ext.WebBrowserImpl;
import org.netbeans.modules.web.webkit.debugging.spi.Command;
import org.netbeans.modules.web.webkit.debugging.spi.Response;
import org.netbeans.modules.web.webkit.debugging.spi.ResponseCallback;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class WebKitDebuggingTransport
implements TransportImplementationWithURLToLoad {
    private WebBrowserImpl browserImpl;
    private Debugger debugger;
    private FXCallback fxCallback;
    private ResponseCallback callback;
    private volatile String urlToLoad;
    private static RequestProcessor RP = new RequestProcessor("JavaFX debugging callback");
    private static final Logger LOGGER = Logger.getLogger(WebKitDebuggingTransport.class.getName());

    public WebKitDebuggingTransport(WebBrowserImpl browserImpl) {
        this.browserImpl = browserImpl;
    }

    public boolean attach() {
        this.debugger = this.browserImpl.getEngine().impl_getDebugger();
        this.fxCallback = new FXCallback(this.callback);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                WebKitDebuggingTransport.this.debugger.setMessageCallback((Callback)WebKitDebuggingTransport.this.fxCallback);
                WebKitDebuggingTransport.this.debugger.setEnabled(true);
            }
        });
        return true;
    }

    public boolean detach() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (WebKitDebuggingTransport.this.debugger != null) {
                    WebKitDebuggingTransport.this.debugger.setEnabled(false);
                }
            }
        });
        return true;
    }

    public void sendCommand(final Command command) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    if (WebKitDebuggingTransport.this.debugger != null && WebKitDebuggingTransport.this.debugger.isEnabled()) {
                        WebKitDebuggingTransport.this.debugger.sendMessage(command.toString());
                    }
                }
                catch (Throwable t) {
                    LOGGER.log(Level.WARNING, "sending commend triggered exception. command=" + command.toString(), t);
                }
            }
        });
    }

    public void registerResponseCallback(ResponseCallback callback) {
        this.callback = callback;
    }

    public String getConnectionName() {
        return this.browserImpl.getURL();
    }

    @Override
    public void setURLToLoad(String urlToLoad) {
        this.urlToLoad = urlToLoad;
    }

    public URL getConnectionURL() {
        String urlStr = this.urlToLoad;
        if (urlStr == null) {
            urlStr = this.browserImpl.getURL();
        }
        if (urlStr != null) {
            try {
                return new URL(urlStr);
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    public String getVersion() {
        return "version 1.0";
    }

    private static class FXCallback
    implements Callback<String, Void> {
        private ResponseCallback responseCallback;

        public FXCallback(ResponseCallback responseCallback) {
            this.responseCallback = responseCallback;
        }

        public Void call(final String p) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        JSONObject json = (JSONObject)JSONValue.parseWithException((String)p);
                        FXCallback.this.responseCallback.handleResponse(new Response(json));
                    }
                    catch (ParseException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
            return null;
        }
    }
}

