/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.options;

import org.netbeans.modules.cnd.api.xml.VersionException;
import org.netbeans.modules.cnd.api.xml.XMLDecoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoderStream;
import org.netbeans.modules.cnd.debugger.common2.debugger.Log;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.EngineProfile;
import org.xml.sax.Attributes;

public class EngineProfileXMLCodec
extends XMLDecoder
implements XMLEncoder {
    private static final int thisversion = 1;
    private EngineProfile profile;
    static final String TAG_ENGINE = "engine";

    public EngineProfileXMLCodec(EngineProfile profile) {
        this.profile = profile;
    }

    public String tag() {
        return this.profile.getId();
    }

    public void start(Attributes atts) throws VersionException {
        String what = "Engine profile";
        int maxVersion = 1;
        this.checkVersion(atts, what, maxVersion);
    }

    public void end() {
        this.profile.clearChanged();
    }

    public void startElement(String element, Attributes atts) {
        if (Log.XML.debug) {
            System.out.println("  startElement: " + element);
            System.out.println("  startElement atts: " + atts);
        }
    }

    public void endElement(String element, String currentText) {
        if (Log.XML.debug) {
            System.out.println("  endElement: " + element);
            System.out.println("  endElement: " + currentText);
        }
        if (element.equals(TAG_ENGINE)) {
            this.profile.setEngineByID(currentText);
        }
    }

    public void encode(XMLEncoderStream xes) {
        xes.elementOpen(this.tag(), 1);
        xes.element(TAG_ENGINE, this.profile.getEngineType().getDebuggerID());
        xes.elementClose(this.tag());
    }
}

