/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.datatype;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import nu.validator.datatype.AbstractDatatype;
import org.relaxng.datatype.DatatypeException;

abstract class AbstractRel
extends AbstractDatatype {
    private static final Pattern CURIE = Pattern.compile("(([[:A-Z_a-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd]][[-.0-9:A-Z_a-z\u00b7\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u037d\u037f-\u1fff\u200c-\u200d\u203f\u2040\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd]]*)?:)[^ ]*");

    AbstractRel() {
    }

    @Override
    public void checkValid(CharSequence literal) throws DatatypeException {
        HashSet<String> tokensSeen = new HashSet<String>();
        StringBuilder builder = new StringBuilder();
        int len = literal.length();
        for (int i = 0; i < len; ++i) {
            char c = literal.charAt(i);
            if (this.isWhitespace(c) && builder.length() > 0) {
                this.checkToken(literal, builder, i, tokensSeen);
                builder.setLength(0);
                continue;
            }
            if (this.isWhitespace(c)) continue;
            builder.append(AbstractRel.toAsciiLowerCase(c));
        }
        if (builder.length() > 0) {
            this.checkToken(literal, builder, len, tokensSeen);
        }
    }

    private void checkToken(CharSequence literal, StringBuilder builder, int i, Set<String> tokensSeen) throws DatatypeException {
        String token = builder.toString();
        if (tokensSeen.contains(token)) {
            throw this.newDatatypeException(i - 1, "Duplicate keyword ", token, ".");
        }
        tokensSeen.add(token);
        if (!this.isRegistered(literal, token)) {
            if ("1".equals(System.getProperty("nu.validator.schema.rdfa-full"))) {
                if (!CURIE.matcher(token).matches()) {
                    this.errNotRegistered(i - 1, token);
                }
            } else {
                this.errNotRegistered(i - 1, token);
            }
        }
    }

    private void errNotRegistered(int position, String token) throws DatatypeException {
        throw this.newDatatypeException(position, "The string ", token, " is not a registered keyword.");
    }

    protected abstract boolean isRegistered(CharSequence var1, String var2) throws DatatypeException;
}

