/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.netbeans.modules.nativeexecution.ConnectionManagerAccessor;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.AsynchronousAction;
import org.netbeans.modules.nativeexecution.api.util.Authentication;
import org.netbeans.modules.nativeexecution.api.util.ConnectionListener;
import org.netbeans.modules.nativeexecution.api.util.HostInfoCache;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.PasswordManager;
import org.netbeans.modules.nativeexecution.api.util.SlowListenerDetector;
import org.netbeans.modules.nativeexecution.jsch.JSchChannelsSupport;
import org.netbeans.modules.nativeexecution.jsch.JSchConnectionTask;
import org.netbeans.modules.nativeexecution.spi.support.JSchAccess;
import org.netbeans.modules.nativeexecution.spi.support.NativeExecutionUserNotification;
import org.netbeans.modules.nativeexecution.support.MiscUtils;
import org.netbeans.modules.nativeexecution.support.NativeTaskExecutorService;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public final class ConnectionManager {
    private static final java.util.logging.Logger log = org.netbeans.modules.nativeexecution.support.Logger.getInstance();
    private static final ConcurrentHashMap<ExecutionEnvironment, JSchChannelsSupport> channelsSupport = new ConcurrentHashMap();
    private static List<ConnectionListener> connectionListeners = new CopyOnWriteArrayList<ConnectionListener>();
    private static final Object channelsSupportLock = new Object();
    private static HashMap<ExecutionEnvironment, ConnectToAction> connectionActions = new HashMap();
    private static final ConcurrentHashMap<ExecutionEnvironment, JSch> jschPool = new ConcurrentHashMap();
    private final ConcurrentHashMap<ExecutionEnvironment, JSchConnectionTask> connectionTasks = new ConcurrentHashMap();
    private static final boolean UNIT_TEST_MODE = Boolean.getBoolean("nativeexecution.mode.unittest");
    private static final ConnectionManager instance = new ConnectionManager();
    private final ConnectionContinuation DEFAULT_CC;
    private final AbstractList<ExecutionEnvironment> recentConnections = new ArrayList<ExecutionEnvironment>();
    private final ConnectionWatcher connectionWatcher;
    final int connectionWatcherInterval;
    private final SlowListenerDetector slowConnectionListenerDetector;
    private static final int RETRY_MAX = 10;

    private ConnectionManager() {
        Level level;
        int timeout = Integer.getInteger("nativeexecution.slow.connection.listener.timeout", 500);
        try {
            level = Level.parse(System.getProperty("nativeexecution.slow.connection.listener.level", "SEVERE"));
        }
        catch (IllegalArgumentException ex) {
            level = Level.FINE;
        }
        this.slowConnectionListenerDetector = timeout > 0 && log.isLoggable(level) ? new SlowListenerDetector(timeout, log, level) : null;
        if (log.isLoggable(Level.FINEST)) {
            JSch.setLogger((Logger)new Logger(){

                public boolean isEnabled(int level) {
                    return true;
                }

                public void log(int level, String message) {
                    log.log(Level.FINEST, "JSCH: {0}", message);
                }
            });
        }
        this.DEFAULT_CC = new ConnectionContinuation(){

            @Override
            public void connectionEstablished(ExecutionEnvironment env) {
                NativeExecutionUserNotification.getDefault().notifyStatus(NbBundle.getMessage(ConnectionManager.class, (String)"ConnectionManager.status.established", (Object)env.getDisplayName()));
            }

            @Override
            public void connectionCancelled(ExecutionEnvironment env) {
                NativeExecutionUserNotification.getDefault().notifyStatus(NbBundle.getMessage(ConnectionManager.class, (String)"ConnectionManager.status.cancelled", (Object)env.getDisplayName()));
            }

            @Override
            public void connectionFailed(ExecutionEnvironment env, IOException ex) {
                String message = NbBundle.getMessage(ConnectionManager.class, (String)"ConnectionManager.status.failed", (Object)env.getDisplayName(), (Object)ex.getLocalizedMessage());
                NativeExecutionUserNotification.getDefault().notifyStatus(message);
                NativeExecutionUserNotification.getDefault().notify(message, NativeExecutionUserNotification.Descriptor.ERROR);
            }
        };
        this.restoreRecentConnectionsList();
        this.connectionWatcherInterval = Integer.getInteger("nativeexecution.connection.watch.interval", 4000);
        this.connectionWatcher = this.connectionWatcherInterval > 0 ? new ConnectionWatcher() : null;
    }

    public void addConnectionListener(ConnectionListener listener) {
        connectionListeners.add(listener);
    }

    public void removeConnectionListener(ConnectionListener listener) {
        connectionListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ExecutionEnvironment> getRecentConnections() {
        AbstractList<ExecutionEnvironment> abstractList = this.recentConnections;
        synchronized (abstractList) {
            return Collections.unmodifiableList(new ArrayList<ExecutionEnvironment>(this.recentConnections));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateRecentConnectionsList(ExecutionEnvironment execEnv) {
        AbstractList<ExecutionEnvironment> abstractList = this.recentConnections;
        synchronized (abstractList) {
            this.recentConnections.remove(execEnv);
            this.recentConnections.add(0, execEnv);
            this.storeRecentConnectionsList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeRecentConnectionsList() {
        Preferences prefs = NbPreferences.forModule(ConnectionManager.class);
        AbstractList<ExecutionEnvironment> abstractList = this.recentConnections;
        synchronized (abstractList) {
            for (int i = 0; i < this.recentConnections.size(); ++i) {
                prefs.put(ConnectionManager.getConnectoinsHistoryKey(i), ExecutionEnvironmentFactory.toUniqueID(this.recentConnections.get(i)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restoreRecentConnectionsList() {
        Preferences prefs = NbPreferences.forModule(ConnectionManager.class);
        AbstractList<ExecutionEnvironment> abstractList = this.recentConnections;
        synchronized (abstractList) {
            String id;
            this.recentConnections.clear();
            int idx = 0;
            while ((id = prefs.get(ConnectionManager.getConnectoinsHistoryKey(idx), null)) != null) {
                this.recentConnections.add(ExecutionEnvironmentFactory.fromUniqueID(id));
                ++idx;
            }
        }
    }

    private static String getConnectoinsHistoryKey(int idx) {
        return ConnectionManager.class.getName() + "_connection.history_" + idx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearRecentConnectionsList() {
        AbstractList<ExecutionEnvironment> abstractList = this.recentConnections;
        synchronized (abstractList) {
            this.recentConnections.clear();
        }
    }

    private void fireConnected(ExecutionEnvironment execEnv) {
        if (this.connectionWatcher != null) {
            this.connectionWatcher.connected(execEnv);
        }
        for (ConnectionListener connectionListener : connectionListeners) {
            if (this.slowConnectionListenerDetector != null) {
                this.slowConnectionListenerDetector.start("ConnectionListener.connected");
            }
            connectionListener.connected(execEnv);
            if (this.slowConnectionListenerDetector == null) continue;
            this.slowConnectionListenerDetector.stop();
        }
        this.updateRecentConnectionsList(execEnv);
    }

    private void fireDisconnected(ExecutionEnvironment execEnv) {
        if (this.connectionWatcher != null) {
            this.connectionWatcher.disconnected(execEnv);
        }
        for (ConnectionListener connectionListener : connectionListeners) {
            if (this.slowConnectionListenerDetector != null) {
                this.slowConnectionListenerDetector.start("ConnectionListener.disconnected");
            }
            connectionListener.disconnected(execEnv);
            if (this.slowConnectionListenerDetector == null) continue;
            this.slowConnectionListenerDetector.stop();
        }
    }

    public boolean isConnectedTo(ExecutionEnvironment execEnv) {
        return this.isConnectedTo(execEnv, true);
    }

    boolean isConnectedTo(ExecutionEnvironment execEnv, boolean checkHostInfo) {
        if (execEnv.isLocal()) {
            return true;
        }
        JSchChannelsSupport support = channelsSupport.get(execEnv);
        if (support != null) {
            if (support.isConnected()) {
                if (checkHostInfo) {
                    return HostInfoUtils.isHostInfoAvailable(execEnv);
                }
                return true;
            }
            if (this.connectionWatcher != null) {
                this.connectionWatcher.schedule();
            }
            return false;
        }
        return false;
    }

    private boolean connect(ExecutionEnvironment env, ConnectionContinuation continuation) {
        boolean connected = this.isConnectedTo(env);
        if (connected) {
            return true;
        }
        try {
            this.connectTo(env);
        }
        catch (IOException ex) {
            if (continuation != null) {
                continuation.connectionFailed(env, ex);
            }
            return false;
        }
        catch (CancellationException ex) {
            if (continuation != null) {
                continuation.connectionCancelled(env);
            }
            return false;
        }
        connected = this.isConnectedTo(env);
        if (connected && continuation != null) {
            continuation.connectionEstablished(env);
        }
        return connected;
    }

    public boolean connect(ExecutionEnvironment env) {
        return this.connect(env, this.DEFAULT_CC);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void connectTo(ExecutionEnvironment env) throws IOException, CancellationException {
        JSch old;
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalThreadStateException("Should never be called from AWT thread");
        }
        if (this.isConnectedTo(env)) {
            return;
        }
        JSch jsch = jschPool.get(env);
        if (jsch == null && (old = jschPool.putIfAbsent(env, jsch = new JSch())) != null) {
            jsch = old;
        }
        if (!UNIT_TEST_MODE) {
            try {
                this.initiateConnection(env, jsch);
                return;
            }
            catch (IOException e) {
                if (MiscUtils.isJSCHTooLongException(e)) {
                    MiscUtils.showJSCHTooLongNotification(env.getDisplayName());
                }
                if (e.getCause() instanceof JSchException) return;
                throw e;
            }
        } else {
            IOException ex = null;
            for (int retry = 10; retry > 0; --retry) {
                try {
                    this.initiateConnection(env, jsch);
                    return;
                }
                catch (IOException e) {
                    if (!(e.getCause() instanceof JSchException)) {
                        throw e;
                    }
                    if (!"Auth fail".equals(e.getCause().getMessage())) {
                        throw e;
                    }
                    ex = e;
                    System.out.println("AUTH_FAIL: Connection failed, re-runing test " + retry);
                    continue;
                }
            }
            System.out.println("AUTH_FAIL: Retry limit reached");
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initiateConnection(ExecutionEnvironment env, JSch jsch) throws IOException, CancellationException {
        Object connectionTask = this.connectionTasks.get(env);
        try {
            JSchChannelsSupport cs;
            Object oldTask;
            if (connectionTask == null) {
                JSchConnectionTask newTask = new JSchConnectionTask(jsch, env);
                oldTask = this.connectionTasks.putIfAbsent(env, newTask);
                if (oldTask != null) {
                    connectionTask = oldTask;
                } else {
                    connectionTask = newTask;
                    ((JSchConnectionTask)connectionTask).start();
                }
            }
            if ((cs = ((JSchConnectionTask)connectionTask).getResult()) != null) {
                if (!cs.isConnected()) {
                    throw new IOException("JSchChannelsSupport lost connection with " + env.getDisplayName() + "during initialization ");
                }
                oldTask = channelsSupportLock;
                synchronized (oldTask) {
                    channelsSupport.put(env, cs);
                }
            } else {
                JSchConnectionTask.Problem problem = ((JSchConnectionTask)connectionTask).getProblem();
                switch (problem.type) {
                    case CONNECTION_CANCELLED: {
                        throw new CancellationException("Connection cancelled for " + env);
                    }
                }
                if (problem.cause instanceof Error) {
                    log.log(Level.INFO, "Error when connecting " + env, problem.cause);
                }
                throw new IOException(problem.type.name() + " " + env, problem.cause);
            }
            log.log(Level.FINEST, "Getting host info for {0}", env);
            HostInfo hostInfo = HostInfoUtils.getHostInfo(env, true);
            log.log(Level.FINE, "New connection established: {0} - {1}", new String[]{env.toString(), hostInfo.getOS().getName()});
            this.fireConnected(env);
        }
        catch (InterruptedException ex) {
            ((JSchConnectionTask)connectionTask).cancel();
            throw new CancellationException();
        }
        catch (ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            this.connectionTasks.remove(env);
        }
    }

    public static ConnectionManager getInstance() {
        HostInfoCache.initializeIfNeeded();
        return instance;
    }

    public synchronized AsynchronousAction getConnectToAction(ExecutionEnvironment execEnv, Runnable onConnect) {
        if (connectionActions.containsKey(execEnv)) {
            return connectionActions.get(execEnv);
        }
        ConnectToAction action = new ConnectToAction(execEnv, onConnect);
        connectionActions.put(execEnv, action);
        return action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconnect(ExecutionEnvironment env) throws IOException, InterruptedException {
        Object object = channelsSupportLock;
        synchronized (object) {
            if (channelsSupport.containsKey(env)) {
                try {
                    channelsSupport.get(env).reconnect(env);
                    if (this.connectionWatcher != null) {
                        this.connectionWatcher.connected(env);
                    }
                }
                catch (JSchException ex) {
                    throw new IOException(ex);
                }
            }
        }
    }

    public void disconnect(ExecutionEnvironment env) {
        this.disconnectImpl(env);
        PasswordManager.getInstance().onExplicitDisconnect(env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectImpl(ExecutionEnvironment env) {
        Object object = channelsSupportLock;
        synchronized (object) {
            if (channelsSupport.containsKey(env)) {
                JSchChannelsSupport cs = channelsSupport.remove(env);
                cs.disconnect();
                this.fireDisconnected(env);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void shutdown() {
        log.fine("Shutting down Connection Manager");
        Object object = channelsSupportLock;
        synchronized (object) {
            for (JSchChannelsSupport cs : channelsSupport.values()) {
                cs.disconnect();
            }
        }
    }

    public void forget(ExecutionEnvironment env) {
        if (env == null) {
            return;
        }
        Authentication.getFor(env).remove();
        jschPool.remove(env);
    }

    static {
        ConnectionManagerAccessor.setDefault(new ConnectionManagerAccessorImpl());
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                ConnectionManager.shutdown();
            }
        }));
    }

    private class ConnectionWatcher
    implements Runnable {
        private final Set<ExecutionEnvironment> brokenConnections = new HashSet<ExecutionEnvironment>();
        private final RequestProcessor.Task myTask = new RequestProcessor("Connection Watcher", 1).create((Runnable)this);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block8: {
                try {
                    ArrayList<ExecutionEnvironment> candidates = new ArrayList<ExecutionEnvironment>();
                    for (JSchChannelsSupport cs : channelsSupport.values()) {
                        if (cs.isConnected()) continue;
                        candidates.add(cs.getExecutionEnvironment());
                    }
                    if (candidates.isEmpty()) break block8;
                    Object object = channelsSupportLock;
                    synchronized (object) {
                        for (ExecutionEnvironment env : candidates) {
                            JSchChannelsSupport cs = (JSchChannelsSupport)channelsSupport.get(env);
                            if (cs == null || cs.isConnected() || this.brokenConnections.contains(env)) continue;
                            ConnectionManager.this.fireDisconnected(env);
                            this.brokenConnections.add(env);
                        }
                    }
                }
                finally {
                    this.scheduleIfNeed();
                }
            }
        }

        public void schedule() {
            this.myTask.schedule(500);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleIfNeed() {
            Object object = channelsSupportLock;
            synchronized (object) {
                if (!channelsSupport.isEmpty()) {
                    this.myTask.schedule(ConnectionManager.this.connectionWatcherInterval);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disconnected(ExecutionEnvironment env) {
            Object object = channelsSupportLock;
            synchronized (object) {
                this.brokenConnections.remove(env);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connected(ExecutionEnvironment env) {
            Object object = channelsSupportLock;
            synchronized (object) {
                this.brokenConnections.remove(env);
            }
            this.schedule();
        }
    }

    private static interface ConnectionContinuation {
        public void connectionEstablished(ExecutionEnvironment var1);

        public void connectionCancelled(ExecutionEnvironment var1);

        public void connectionFailed(ExecutionEnvironment var1, IOException var2);
    }

    private static class JSchAccessImpl
    implements JSchAccess {
        private final ExecutionEnvironment env;

        public JSchAccessImpl(ExecutionEnvironment env) {
            this.env = env;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getServerVersion() throws JSchException {
            Object object = channelsSupportLock;
            synchronized (object) {
                if (channelsSupport.containsKey(this.env)) {
                    JSchChannelsSupport cs = (JSchChannelsSupport)channelsSupport.get(this.env);
                    return cs.getServerVersion();
                }
            }
            return null;
        }

        @Override
        public Channel openChannel(String type) throws JSchException, InterruptedException, JSchException {
            try {
                return ConnectionManagerAccessor.getDefault().openAndAcquireChannel(this.env, type, true);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }

        @Override
        public void releaseChannel(Channel channel) throws JSchException {
            ConnectionManagerAccessor.getDefault().closeAndReleaseChannel(this.env, channel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setPortForwardingR(String bind_address, int rport, String host, int lport) throws JSchException {
            Object object = channelsSupportLock;
            synchronized (object) {
                if (channelsSupport.containsKey(this.env)) {
                    JSchChannelsSupport cs = (JSchChannelsSupport)channelsSupport.get(this.env);
                    cs.setPortForwardingR(bind_address, rport, host, lport);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int setPortForwardingL(int lport, String host, int rport) throws JSchException {
            Object object = channelsSupportLock;
            synchronized (object) {
                if (channelsSupport.containsKey(this.env)) {
                    JSchChannelsSupport cs = (JSchChannelsSupport)channelsSupport.get(this.env);
                    return cs.setPortForwardingL(lport, host, rport);
                }
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void delPortForwardingR(int rport) throws JSchException {
            Object object = channelsSupportLock;
            synchronized (object) {
                if (channelsSupport.containsKey(this.env)) {
                    JSchChannelsSupport cs = (JSchChannelsSupport)channelsSupport.get(this.env);
                    cs.delPortForwardingR(rport);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void delPortForwardingL(int lport) throws JSchException {
            Object object = channelsSupportLock;
            synchronized (object) {
                if (channelsSupport.containsKey(this.env)) {
                    JSchChannelsSupport cs = (JSchChannelsSupport)channelsSupport.get(this.env);
                    cs.delPortForwardingL(lport);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getConfig(String key) {
            Object object = channelsSupportLock;
            synchronized (object) {
                if (channelsSupport.containsKey(this.env)) {
                    JSchChannelsSupport cs = (JSchChannelsSupport)channelsSupport.get(this.env);
                    return cs.getConfig(key);
                }
            }
            return null;
        }
    }

    private static final class ConnectionManagerAccessorImpl
    extends ConnectionManagerAccessor {
        private ConnectionManagerAccessorImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Channel openAndAcquireChannel(ExecutionEnvironment env, String type, boolean waitIfNoAvailable) throws InterruptedException, JSchException, IOException {
            Object object = channelsSupportLock;
            synchronized (object) {
                if (channelsSupport.containsKey(env)) {
                    JSchChannelsSupport cs = (JSchChannelsSupport)channelsSupport.get(env);
                    return cs.acquireChannel(type, waitIfNoAvailable);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void closeAndReleaseChannel(ExecutionEnvironment env, Channel channel) throws JSchException {
            JSchChannelsSupport cs = null;
            Object object = channelsSupportLock;
            synchronized (object) {
                if (channelsSupport.containsKey(env)) {
                    cs = (JSchChannelsSupport)channelsSupport.get(env);
                }
            }
            if (cs != null && channel != null) {
                cs.releaseChannel(channel);
            }
        }

        @Override
        public void reconnect(ExecutionEnvironment env) throws IOException {
            try {
                instance.reconnect(env);
            }
            catch (InterruptedException ex) {
                throw new IOException(ex);
            }
        }

        @Override
        public void changeAuth(ExecutionEnvironment env, Authentication auth) {
            JSch jsch = (JSch)jschPool.get(env);
            if (jsch != null) {
                try {
                    jsch.removeAllIdentity();
                }
                catch (JSchException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                try {
                    String knownHosts = auth.getKnownHostsFile();
                    if (knownHosts != null) {
                        jsch.setKnownHosts(knownHosts);
                    }
                }
                catch (JSchException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                switch (auth.getType()) {
                    case SSH_KEY: {
                        try {
                            jsch.addIdentity(auth.getSSHKeyFile());
                            break;
                        }
                        catch (JSchException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            }
        }

        @Override
        public JSchAccess getJSchAccess(ExecutionEnvironment env) {
            return new JSchAccessImpl(env);
        }
    }

    private static class ConnectToAction
    extends AbstractAction
    implements AsynchronousAction {
        private static final ConnectionManager cm = ConnectionManager.getInstance();
        private final ExecutionEnvironment env;
        private final Runnable onConnect;

        private ConnectToAction(ExecutionEnvironment execEnv, Runnable onConnect) {
            this.env = execEnv;
            this.onConnect = onConnect;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NativeTaskExecutorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        ConnectToAction.this.invoke();
                    }
                    catch (Throwable ex) {
                        log.warning(ex.getMessage());
                    }
                }
            }, "Connecting to " + this.env.toString());
        }

        @Override
        public synchronized void invoke() throws IOException, CancellationException {
            if (cm.isConnectedTo(this.env)) {
                return;
            }
            cm.connectTo(this.env);
            this.onConnect.run();
        }
    }

    public static class CancellationException
    extends Exception {
        public CancellationException() {
        }

        public CancellationException(String message) {
            super(message);
        }
    }
}

