/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.impl.spi;

import org.netbeans.modules.cnd.repository.impl.spi.FSConverter;
import org.netbeans.modules.cnd.repository.impl.spi.FilePathConverter;
import org.netbeans.modules.cnd.repository.impl.spi.LayerDescriptor;
import org.netbeans.modules.cnd.repository.impl.spi.LayeringSupport;
import org.netbeans.modules.cnd.repository.impl.spi.UnitsConverter;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.LocalFileSystem;

public final class LayerConvertersProvider {
    private final LayerConvertersProviderInstance layerProviderInstance;

    private LayerConvertersProvider(LayerConvertersProviderInstance layerProviderInstance) {
        this.layerProviderInstance = layerProviderInstance;
    }

    public static LayerConvertersProvider getReadInstance(UnitsConverter readUnitsConverter, FSConverter readFSConverter, FilePathConverter readFilePathConverter) {
        return new LayerConvertersProvider(new LayerConvertersProviderInstanceImpl1(readUnitsConverter, null, readFSConverter, null, readFilePathConverter, null));
    }

    public static LayerConvertersProvider getWriteInstance(UnitsConverter writeUnitsConverter, FSConverter writeFSConverter, FilePathConverter writeFilePathConverter) {
        return new LayerConvertersProvider(new LayerConvertersProviderInstanceImpl1(null, writeUnitsConverter, null, writeFSConverter, null, writeFilePathConverter));
    }

    public static LayerConvertersProvider getInstance(LayeringSupport layeringSupport, LayerDescriptor layerDescriptor) {
        return new LayerConvertersProvider(new LayerConvertersProviderInstanceImpl2(layeringSupport, layerDescriptor));
    }

    public UnitsConverter getReadUnitsConverter() {
        return this.layerProviderInstance.getReadUnitsConverter();
    }

    public UnitsConverter getWriteUnitsConverter() {
        return this.layerProviderInstance.getWriteUnitsConverter();
    }

    public FSConverter getReadFSConverter() {
        return this.layerProviderInstance.getReadFSConverter();
    }

    public FSConverter getWriteFSConverter() {
        return this.layerProviderInstance.getWriteFSConverter();
    }

    public FilePathConverter getReadFilePathConverter() {
        return this.layerProviderInstance.getReadFilePathConverter();
    }

    public FilePathConverter getWriteFilePathConverter() {
        return this.layerProviderInstance.getWriteFilePathConverter();
    }

    private static final class UnsupportedFilePathConverter
    implements FilePathConverter {
        private UnsupportedFilePathConverter() {
        }

        @Override
        public CharSequence layerToClient(int fileIdx) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public int clientToLayer(CharSequence filePath) {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    private static final class NoopFSConverter
    implements FSConverter {
        private NoopFSConverter() {
        }

        @Override
        public FileSystem layerToClient(int fsIdx) {
            return new LocalFileSystem();
        }

        @Override
        public int clientToLayer(FileSystem fileSystem) {
            return 0;
        }
    }

    private static final class NoopUnitIDConverter
    implements UnitsConverter {
        private NoopUnitIDConverter() {
        }

        @Override
        public int clientToLayer(int clientUnitID) {
            return clientUnitID;
        }

        @Override
        public int layerToClient(int unitIDInLayer) {
            return unitIDInLayer;
        }
    }

    private static class LayerConvertersProviderInstanceImpl2
    implements LayerConvertersProviderInstance {
        private final LayeringSupport layeringSupport;
        private final LayerDescriptor layerDescriptor;

        public LayerConvertersProviderInstanceImpl2(LayeringSupport layeringSupport, LayerDescriptor layerDescriptor) {
            this.layeringSupport = layeringSupport;
            this.layerDescriptor = layerDescriptor;
        }

        @Override
        public UnitsConverter getReadUnitsConverter() {
            return this.layeringSupport.getReadUnitsConverter(this.layerDescriptor);
        }

        @Override
        public UnitsConverter getWriteUnitsConverter() {
            return this.layeringSupport.getWriteUnitsConverter(this.layerDescriptor);
        }

        @Override
        public FSConverter getReadFSConverter() {
            return this.layeringSupport.getReadFSConverter(this.layerDescriptor);
        }

        @Override
        public FSConverter getWriteFSConverter() {
            return this.layeringSupport.getWriteFSConverter(this.layerDescriptor);
        }

        @Override
        public FilePathConverter getReadFilePathConverter() {
            return new UnsupportedFilePathConverter();
        }

        @Override
        public FilePathConverter getWriteFilePathConverter() {
            return new UnsupportedFilePathConverter();
        }
    }

    private static class LayerConvertersProviderInstanceImpl1
    implements LayerConvertersProviderInstance {
        private final UnitsConverter readUnitsConverter;
        private final UnitsConverter writeUnitsConverter;
        private final FSConverter readFSConverter;
        private final FSConverter writeFSConverter;
        private final FilePathConverter readFilePathConverter;
        private final FilePathConverter writeFilePathConverter;

        public LayerConvertersProviderInstanceImpl1(UnitsConverter readUnitsConverter, UnitsConverter writeUnitsConverter, FSConverter readFSConverter, FSConverter writeFSConverter, FilePathConverter readFilePathConverter, FilePathConverter writeFilePathConverter) {
            this.readUnitsConverter = readUnitsConverter == null ? new NoopUnitIDConverter() : readUnitsConverter;
            this.writeUnitsConverter = writeUnitsConverter == null ? new NoopUnitIDConverter() : writeUnitsConverter;
            this.readFSConverter = readFSConverter == null ? new NoopFSConverter() : readFSConverter;
            this.writeFSConverter = writeFSConverter == null ? new NoopFSConverter() : writeFSConverter;
            this.readFilePathConverter = readFilePathConverter == null ? new UnsupportedFilePathConverter() : readFilePathConverter;
            this.writeFilePathConverter = writeFilePathConverter == null ? new UnsupportedFilePathConverter() : writeFilePathConverter;
        }

        @Override
        public UnitsConverter getReadUnitsConverter() {
            return this.readUnitsConverter;
        }

        @Override
        public UnitsConverter getWriteUnitsConverter() {
            return this.writeUnitsConverter;
        }

        @Override
        public FSConverter getReadFSConverter() {
            return this.readFSConverter;
        }

        @Override
        public FSConverter getWriteFSConverter() {
            return this.writeFSConverter;
        }

        @Override
        public FilePathConverter getReadFilePathConverter() {
            return this.readFilePathConverter;
        }

        @Override
        public FilePathConverter getWriteFilePathConverter() {
            return this.writeFilePathConverter;
        }
    }

    private static interface LayerConvertersProviderInstance {
        public UnitsConverter getReadUnitsConverter();

        public UnitsConverter getWriteUnitsConverter();

        public FSConverter getReadFSConverter();

        public FSConverter getWriteFSConverter();

        public FilePathConverter getReadFilePathConverter();

        public FilePathConverter getWriteFilePathConverter();
    }
}

