/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.client;

import java.util.logging.Level;
import javax.swing.JButton;
import org.netbeans.modules.git.remote.Git;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.client.CommandReport;
import org.netbeans.modules.git.remote.client.CredentialsCallback;
import org.netbeans.modules.git.remote.client.GitCanceledException;
import org.netbeans.modules.git.remote.client.GitClient;
import org.netbeans.modules.git.remote.ui.repository.remote.RemoteRepository;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class GitClientExceptionHandler {
    private final boolean handleAuthenticationIssues;
    private final GitClient client;

    public GitClientExceptionHandler(GitClient client, boolean handleAuthenticationIssues) {
        this.client = client;
        this.handleAuthenticationIssues = handleAuthenticationIssues;
    }

    boolean handleException(Exception ex) {
        boolean handled = false;
        if (this.handleAuthenticationIssues && ex instanceof GitException.AuthorizationException) {
            return this.handleException((GitException.AuthorizationException)ex);
        }
        return handled;
    }

    private boolean handleException(GitException.AuthorizationException ex) {
        boolean confirmed = false;
        String repositoryUrl = ex.getRepositoryUrl();
        if (repositoryUrl == null || repositoryUrl.trim().isEmpty()) {
            Git.LOG.log(Level.INFO, "empty repository URL", (Throwable)ex);
        }
        if (RemoteRepository.updateFor(repositoryUrl, this.client.getRepositoryRoot())) {
            this.client.setCallback(new CredentialsCallback());
            confirmed = true;
        }
        return confirmed;
    }

    public static void notifyException(Exception ex, boolean annotate) {
        if (GitClientExceptionHandler.isCancelledAction(ex)) {
            return;
        }
        Git.LOG.log(Level.INFO, ex.getMessage(), ex);
        if (annotate) {
            String msg = GitClientExceptionHandler.getMessage(ex);
            GitClientExceptionHandler.annotate(msg);
        }
    }

    public static void annotate(String msg) {
        CommandReport report = new CommandReport(NbBundle.getMessage(GitClientExceptionHandler.class, (String)"MSG_SubversionCommandError"), msg);
        JButton ok = new JButton(NbBundle.getMessage(GitClientExceptionHandler.class, (String)"CTL_CommandReport_OK"));
        NotifyDescriptor descriptor = new NotifyDescriptor((Object)report, NbBundle.getMessage(GitClientExceptionHandler.class, (String)"MSG_CommandFailed_Title"), -1, 0, new Object[]{ok}, (Object)ok);
        DialogDisplayer.getDefault().notify(descriptor);
    }

    public static boolean isCancelledAction(Exception ex) {
        Throwable sourceException;
        for (sourceException = ex; sourceException != null && !(sourceException instanceof GitCanceledException); sourceException = sourceException.getCause()) {
        }
        return sourceException instanceof GitCanceledException;
    }

    private static String getMessage(Exception ex) {
        Throwable cause;
        String message = cause.getLocalizedMessage();
        for (cause = ex; message == null && cause != null; cause = cause.getCause()) {
            message = cause.getLocalizedMessage();
        }
        return message == null ? "" : message;
    }
}

