/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.commit;

import java.util.List;
import org.netbeans.modules.git.remote.FileInformation;
import org.netbeans.modules.git.remote.GitFileNode;
import org.netbeans.modules.git.remote.ui.commit.Bundle;
import org.netbeans.modules.git.remote.ui.commit.CommitAction;
import org.netbeans.modules.remotefs.versioning.util.common.VCSCommitTable;
import org.netbeans.modules.remotefs.versioning.util.common.VCSCommitTableModel;
import org.netbeans.modules.versioning.util.common.VCSCommitOptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class GitCommitTable
extends VCSCommitTable<GitFileNode.GitLocalFileNode> {
    private String errroMessage;
    private boolean amend;
    private boolean emptyAllowed;

    public GitCommitTable() {
        this(true, false);
    }

    public GitCommitTable(boolean editable, boolean allowEmpty) {
        super(new VCSCommitTableModel(), editable);
        this.emptyAllowed = allowEmpty;
    }

    public boolean containsCommitable() {
        List list = this.getCommitFiles();
        boolean ret = false;
        this.errroMessage = null;
        boolean isEmpty = true;
        if (this.amend) {
            return true;
        }
        for (GitFileNode.GitLocalFileNode fileNode : list) {
            VCSCommitOptions co = fileNode.getCommitOptions();
            if (co == VCSCommitOptions.EXCLUDE) continue;
            isEmpty = false;
            FileInformation info = fileNode.getInformation();
            if (info.containsStatus(FileInformation.Status.IN_CONFLICT)) {
                this.errroMessage = NbBundle.getMessage(CommitAction.class, (String)"MSG_CommitForm_ErrorConflicts");
                return false;
            }
            if (info.isRenamed() && info.getOldFile() != null && (Utilities.isMac() || Utilities.isWindows()) && info.getOldFile().getPath().equalsIgnoreCase(fileNode.getFile().getPath())) {
                this.errroMessage = Bundle.MSG_Warning_RenamedFiles();
            }
            ret = true;
        }
        if (isEmpty) {
            if (this.emptyAllowed) {
                ret = true;
            } else {
                this.errroMessage = NbBundle.getMessage(CommitAction.class, (String)"MSG_ERROR_NO_FILES");
            }
        }
        return ret;
    }

    public String getErrorMessage() {
        return this.errroMessage;
    }

    public boolean isAmend() {
        return this.amend;
    }

    public void setAmend(boolean amend) {
        this.amend = amend;
    }
}

