/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.target.impl;

import org.clang.basic.LangOptions;
import org.clang.basic.MacroBuilder;
import org.clang.basic.target.TargetInfo;
import org.clang.basic.target.TargetOptions;
import org.clang.basic.target.impl.SparcTargetInfo;
import org.clank.support.Destructors;
import org.clank.support.NativePointer;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;

public class SparcV8TargetInfo
extends SparcTargetInfo
implements Destructors.ClassWithDestructor {
    public SparcV8TargetInfo(Triple Triple2, TargetOptions Opts) {
        super(Triple2, Opts);
        this.resetDataLayout(new StringRef("E-m:e-p:32:32-i64:64-f128:64-n32-S64"));
        switch (this.getTriple().getOS()) {
            default: {
                this.SizeType = TargetInfo.IntType.UnsignedInt;
                this.IntPtrType = TargetInfo.IntType.SignedInt;
                this.PtrDiffType = TargetInfo.IntType.SignedInt;
                break;
            }
            case NetBSD: 
            case OpenBSD: {
                this.SizeType = TargetInfo.IntType.UnsignedLong;
                this.IntPtrType = TargetInfo.IntType.SignedLong;
                this.PtrDiffType = TargetInfo.IntType.SignedLong;
            }
        }
        this.MaxAtomicInlineWidth = (byte)64;
        this.MaxAtomicPromoteWidth = (byte)64;
    }

    @Override
    public void getTargetDefines(LangOptions Opts, MacroBuilder Builder2) {
        super.getTargetDefines(Opts, Builder2);
        switch (this.getCPUGeneration(this.CPU)) {
            case CG_V8: {
                Builder2.defineMacro(new Twine("__sparcv8"));
                if (this.getTriple().getOS() == Triple.OSType.Solaris) break;
                Builder2.defineMacro(new Twine("__sparcv8__"));
                break;
            }
            case CG_V9: {
                Builder2.defineMacro(new Twine("__sparcv9"));
                if (this.getTriple().getOS() == Triple.OSType.Solaris) break;
                Builder2.defineMacro(new Twine("__sparcv9__"));
                Builder2.defineMacro(new Twine("__sparc_v9__"));
            }
        }
        if (this.getTriple().getVendor() == Triple.VendorType.Myriad) {
            switch (this.CPU) {
                case CK_MYRIAD2_1: {
                    Builder2.defineMacro(new Twine("__myriad2"), new Twine(NativePointer.$1));
                    Builder2.defineMacro(new Twine("__myriad2__"), new Twine(NativePointer.$1));
                    break;
                }
                case CK_MYRIAD2_2: {
                    Builder2.defineMacro(new Twine("__myriad2"), new Twine(NativePointer.$2));
                    Builder2.defineMacro(new Twine("__myriad2__"), new Twine(NativePointer.$2));
                    break;
                }
            }
        }
    }

    @Override
    public boolean hasSjLjLowering() {
        return true;
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    @Override
    public String toString() {
        return "" + super.toString();
    }
}

