/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.target.impl;

import org.clang.basic.BasicClangGlobals;
import org.clang.basic.Builtin;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.LangOptions;
import org.clang.basic.MacroBuilder;
import org.clang.basic.SanitizerKind;
import org.clang.basic.VersionTuple;
import org.clang.basic.impl.JavaHugeTargetStaticsBuiltinInfoDelegate;
import org.clang.basic.target.TargetInfo;
import org.clang.basic.target.TargetOptions;
import org.clang.basic.target.impl.AArch64beTargetInfo;
import org.clang.basic.target.impl.AArch64leTargetInfo;
import org.clang.basic.target.impl.AMDGPUTargetInfo;
import org.clang.basic.target.impl.ARMbeTargetInfo;
import org.clang.basic.target.impl.ARMleTargetInfo;
import org.clang.basic.target.impl.AndroidX86_32TargetInfo;
import org.clang.basic.target.impl.AndroidX86_64TargetInfo;
import org.clang.basic.target.impl.BPFTargetInfo;
import org.clang.basic.target.impl.BitrigI386TargetInfo;
import org.clang.basic.target.impl.BitrigTargetInfo;
import org.clang.basic.target.impl.BitrigX86_64TargetInfo;
import org.clang.basic.target.impl.CloudABITargetInfo;
import org.clang.basic.target.impl.CygwinARMTargetInfo;
import org.clang.basic.target.impl.CygwinX86_32TargetInfo;
import org.clang.basic.target.impl.CygwinX86_64TargetInfo;
import org.clang.basic.target.impl.DarwinAArch64TargetInfo;
import org.clang.basic.target.impl.DarwinARMTargetInfo;
import org.clang.basic.target.impl.DarwinI386TargetInfo;
import org.clang.basic.target.impl.DarwinPPC32TargetInfo;
import org.clang.basic.target.impl.DarwinPPC64TargetInfo;
import org.clang.basic.target.impl.DarwinX86_64TargetInfo;
import org.clang.basic.target.impl.DragonFlyBSDTargetInfo;
import org.clang.basic.target.impl.FreeBSDTargetInfo;
import org.clang.basic.target.impl.HaikuTargetInfo;
import org.clang.basic.target.impl.HaikuX86_32TargetInfo;
import org.clang.basic.target.impl.HexagonTargetInfo;
import org.clang.basic.target.impl.ItaniumWindowsARMleTargetInfo;
import org.clang.basic.target.impl.KFreeBSDTargetInfo;
import org.clang.basic.target.impl.LanaiTargetInfo;
import org.clang.basic.target.impl.Le64TargetInfo;
import org.clang.basic.target.impl.LinuxTargetInfo;
import org.clang.basic.target.impl.MCUX86_32TargetInfo;
import org.clang.basic.target.impl.MSP430TargetInfo;
import org.clang.basic.target.impl.MicrosoftARMleTargetInfo;
import org.clang.basic.target.impl.MicrosoftX86_32TargetInfo;
import org.clang.basic.target.impl.MicrosoftX86_64TargetInfo;
import org.clang.basic.target.impl.MinGWARMTargetInfo;
import org.clang.basic.target.impl.MinGWX86_32TargetInfo;
import org.clang.basic.target.impl.MinGWX86_64TargetInfo;
import org.clang.basic.target.impl.MinixTargetInfo;
import org.clang.basic.target.impl.MipsTargetInfo;
import org.clang.basic.target.impl.NVPTX32TargetInfo;
import org.clang.basic.target.impl.NVPTX64TargetInfo;
import org.clang.basic.target.impl.NaClMips32TargetInfo;
import org.clang.basic.target.impl.NaClTargetInfo;
import org.clang.basic.target.impl.NetBSDI386TargetInfo;
import org.clang.basic.target.impl.NetBSDTargetInfo;
import org.clang.basic.target.impl.OpenBSDI386TargetInfo;
import org.clang.basic.target.impl.OpenBSDTargetInfo;
import org.clang.basic.target.impl.OpenBSDX86_64TargetInfo;
import org.clang.basic.target.impl.PNaClTargetInfo;
import org.clang.basic.target.impl.PPC32TargetInfo;
import org.clang.basic.target.impl.PPC64TargetInfo;
import org.clang.basic.target.impl.PS3PPUTargetInfo;
import org.clang.basic.target.impl.PS4OSTargetInfo;
import org.clang.basic.target.impl.RTEMSTargetInfo;
import org.clang.basic.target.impl.RTEMSX86_32TargetInfo;
import org.clang.basic.target.impl.RenderScript32TargetInfo;
import org.clang.basic.target.impl.RenderScript64TargetInfo;
import org.clang.basic.target.impl.SPIR32TargetInfo;
import org.clang.basic.target.impl.SPIR64TargetInfo;
import org.clang.basic.target.impl.SolarisTargetInfo;
import org.clang.basic.target.impl.SparcV8TargetInfo;
import org.clang.basic.target.impl.SparcV8elTargetInfo;
import org.clang.basic.target.impl.SparcV9TargetInfo;
import org.clang.basic.target.impl.SystemZTargetInfo;
import org.clang.basic.target.impl.TCETargetInfo;
import org.clang.basic.target.impl.TargetInfoImpl;
import org.clang.basic.target.impl.WebAssembly32TargetInfo;
import org.clang.basic.target.impl.WebAssembly64TargetInfo;
import org.clang.basic.target.impl.WebAssemblyOSTargetInfo;
import org.clang.basic.target.impl.X86_32TargetInfo;
import org.clang.basic.target.impl.X86_64TargetInfo;
import org.clang.basic.target.impl.XCoreTargetInfo;
import org.clank.java.std;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.support.llvm;

public final class TargetsStatics {
    public static int[] NVPTXAddrSpaceMap = new int[]{1, 3, 4, 0, 1, 4, 3};
    public static int[] AMDGPUAddrSpaceMap = new int[]{1, 3, 2, 4, 1, 2, 3};
    public static char.ptr DataLayoutStringR600 = NativePointer.$((String)"e-p:32:32-i64:64-v16:16-v24:32-v32:32-v48:64-v96:128-v192:256-v256:256-v512:512-v1024:1024-v2048:2048-n32:64");
    public static char.ptr DataLayoutStringSI = NativePointer.$((String)"e-p:32:32-p1:64:64-p2:64:64-p3:32:32-p4:64:64-p5:32:32-i64:64-v16:16-v24:32-v32:32-v48:64-v96:128-v192:256-v256:256-v512:512-v1024:1024-v2048:2048-n32:64");
    public static Builtin.Info[] BuiltinInfo = JavaHugeTargetStaticsBuiltinInfoDelegate.BuiltinInfo;
    public static char.ptr[] GCCRegNames = new char.ptr[]{NativePointer.$((String)"ax"), NativePointer.$((String)"dx"), NativePointer.$((String)"cx"), NativePointer.$((String)"bx"), NativePointer.$((String)"si"), NativePointer.$((String)"di"), NativePointer.$((String)"bp"), NativePointer.$((String)"sp"), NativePointer.$((String)"st"), NativePointer.$((String)"st(1)"), NativePointer.$((String)"st(2)"), NativePointer.$((String)"st(3)"), NativePointer.$((String)"st(4)"), NativePointer.$((String)"st(5)"), NativePointer.$((String)"st(6)"), NativePointer.$((String)"st(7)"), NativePointer.$((String)"argp"), NativePointer.$((String)"flags"), NativePointer.$((String)"fpcr"), NativePointer.$((String)"fpsr"), NativePointer.$((String)"dirflag"), NativePointer.$((String)"frame"), NativePointer.$((String)"xmm0"), NativePointer.$((String)"xmm1"), NativePointer.$((String)"xmm2"), NativePointer.$((String)"xmm3"), NativePointer.$((String)"xmm4"), NativePointer.$((String)"xmm5"), NativePointer.$((String)"xmm6"), NativePointer.$((String)"xmm7"), NativePointer.$((String)"mm0"), NativePointer.$((String)"mm1"), NativePointer.$((String)"mm2"), NativePointer.$((String)"mm3"), NativePointer.$((String)"mm4"), NativePointer.$((String)"mm5"), NativePointer.$((String)"mm6"), NativePointer.$((String)"mm7"), NativePointer.$((String)"r8"), NativePointer.$((String)"r9"), NativePointer.$((String)"r10"), NativePointer.$((String)"r11"), NativePointer.$((String)"r12"), NativePointer.$((String)"r13"), NativePointer.$((String)"r14"), NativePointer.$((String)"r15"), NativePointer.$((String)"xmm8"), NativePointer.$((String)"xmm9"), NativePointer.$((String)"xmm10"), NativePointer.$((String)"xmm11"), NativePointer.$((String)"xmm12"), NativePointer.$((String)"xmm13"), NativePointer.$((String)"xmm14"), NativePointer.$((String)"xmm15"), NativePointer.$((String)"ymm0"), NativePointer.$((String)"ymm1"), NativePointer.$((String)"ymm2"), NativePointer.$((String)"ymm3"), NativePointer.$((String)"ymm4"), NativePointer.$((String)"ymm5"), NativePointer.$((String)"ymm6"), NativePointer.$((String)"ymm7"), NativePointer.$((String)"ymm8"), NativePointer.$((String)"ymm9"), NativePointer.$((String)"ymm10"), NativePointer.$((String)"ymm11"), NativePointer.$((String)"ymm12"), NativePointer.$((String)"ymm13"), NativePointer.$((String)"ymm14"), NativePointer.$((String)"ymm15"), NativePointer.$((String)"xmm16"), NativePointer.$((String)"xmm17"), NativePointer.$((String)"xmm18"), NativePointer.$((String)"xmm19"), NativePointer.$((String)"xmm20"), NativePointer.$((String)"xmm21"), NativePointer.$((String)"xmm22"), NativePointer.$((String)"xmm23"), NativePointer.$((String)"xmm24"), NativePointer.$((String)"xmm25"), NativePointer.$((String)"xmm26"), NativePointer.$((String)"xmm27"), NativePointer.$((String)"xmm28"), NativePointer.$((String)"xmm29"), NativePointer.$((String)"xmm30"), NativePointer.$((String)"xmm31"), NativePointer.$((String)"ymm16"), NativePointer.$((String)"ymm17"), NativePointer.$((String)"ymm18"), NativePointer.$((String)"ymm19"), NativePointer.$((String)"ymm20"), NativePointer.$((String)"ymm21"), NativePointer.$((String)"ymm22"), NativePointer.$((String)"ymm23"), NativePointer.$((String)"ymm24"), NativePointer.$((String)"ymm25"), NativePointer.$((String)"ymm26"), NativePointer.$((String)"ymm27"), NativePointer.$((String)"ymm28"), NativePointer.$((String)"ymm29"), NativePointer.$((String)"ymm30"), NativePointer.$((String)"ymm31"), NativePointer.$((String)"zmm0"), NativePointer.$((String)"zmm1"), NativePointer.$((String)"zmm2"), NativePointer.$((String)"zmm3"), NativePointer.$((String)"zmm4"), NativePointer.$((String)"zmm5"), NativePointer.$((String)"zmm6"), NativePointer.$((String)"zmm7"), NativePointer.$((String)"zmm8"), NativePointer.$((String)"zmm9"), NativePointer.$((String)"zmm10"), NativePointer.$((String)"zmm11"), NativePointer.$((String)"zmm12"), NativePointer.$((String)"zmm13"), NativePointer.$((String)"zmm14"), NativePointer.$((String)"zmm15"), NativePointer.$((String)"zmm16"), NativePointer.$((String)"zmm17"), NativePointer.$((String)"zmm18"), NativePointer.$((String)"zmm19"), NativePointer.$((String)"zmm20"), NativePointer.$((String)"zmm21"), NativePointer.$((String)"zmm22"), NativePointer.$((String)"zmm23"), NativePointer.$((String)"zmm24"), NativePointer.$((String)"zmm25"), NativePointer.$((String)"zmm26"), NativePointer.$((String)"zmm27"), NativePointer.$((String)"zmm28"), NativePointer.$((String)"zmm29"), NativePointer.$((String)"zmm30"), NativePointer.$((String)"zmm31")};
    public static TargetInfo.AddlRegName[] AddlRegNames = new TargetInfo.AddlRegName[]{new TargetInfo.AddlRegName(new char.ptr[]{NativePointer.$((String)"al"), NativePointer.$((String)"ah"), NativePointer.$((String)"eax"), NativePointer.$((String)"rax")}, 0), new TargetInfo.AddlRegName(new char.ptr[]{NativePointer.$((String)"bl"), NativePointer.$((String)"bh"), NativePointer.$((String)"ebx"), NativePointer.$((String)"rbx")}, 3), new TargetInfo.AddlRegName(new char.ptr[]{NativePointer.$((String)"cl"), NativePointer.$((String)"ch"), NativePointer.$((String)"ecx"), NativePointer.$((String)"rcx")}, 2), new TargetInfo.AddlRegName(new char.ptr[]{NativePointer.$((String)"dl"), NativePointer.$((String)"dh"), NativePointer.$((String)"edx"), NativePointer.$((String)"rdx")}, 1), new TargetInfo.AddlRegName(new char.ptr[]{NativePointer.$((String)"esi"), NativePointer.$((String)"rsi")}, 4), new TargetInfo.AddlRegName(new char.ptr[]{NativePointer.$((String)"edi"), NativePointer.$((String)"rdi")}, 5), new TargetInfo.AddlRegName(new char.ptr[]{NativePointer.$((String)"esp"), NativePointer.$((String)"rsp")}, 7), new TargetInfo.AddlRegName(new char.ptr[]{NativePointer.$((String)"ebp"), NativePointer.$((String)"rbp")}, 6), new TargetInfo.AddlRegName(new char.ptr[]{NativePointer.$((String)"r8d"), NativePointer.$((String)"r8w"), NativePointer.$((String)"r8b")}, 38), new TargetInfo.AddlRegName(new char.ptr[]{NativePointer.$((String)"r9d"), NativePointer.$((String)"r9w"), NativePointer.$((String)"r9b")}, 39), new TargetInfo.AddlRegName(new char.ptr[]{NativePointer.$((String)"r10d"), NativePointer.$((String)"r10w"), NativePointer.$((String)"r10b")}, 40), new TargetInfo.AddlRegName(new char.ptr[]{NativePointer.$((String)"r11d"), NativePointer.$((String)"r11w"), NativePointer.$((String)"r11b")}, 41), new TargetInfo.AddlRegName(new char.ptr[]{NativePointer.$((String)"r12d"), NativePointer.$((String)"r12w"), NativePointer.$((String)"r12b")}, 42), new TargetInfo.AddlRegName(new char.ptr[]{NativePointer.$((String)"r13d"), NativePointer.$((String)"r13w"), NativePointer.$((String)"r13b")}, 43), new TargetInfo.AddlRegName(new char.ptr[]{NativePointer.$((String)"r14d"), NativePointer.$((String)"r14w"), NativePointer.$((String)"r14b")}, 44), new TargetInfo.AddlRegName(new char.ptr[]{NativePointer.$((String)"r15d"), NativePointer.$((String)"r15w"), NativePointer.$((String)"r15b")}, 45)};
    public static int[] TCEOpenCLAddrSpaceMap = new int[]{3, 4, 5, 0, 0, 0, 0};
    public static int[] SPIRAddrSpaceMap = new int[]{1, 3, 2, 4, 0, 0, 0};

    public static void DefineStd(MacroBuilder Builder2, StringRef MacroName, LangOptions Opts) {
        assert (MacroName.$at(0) != 95) : "Identifier should be in the user's namespace";
        if (Opts.GNUMode) {
            Builder2.defineMacro(new Twine(MacroName));
        }
        Builder2.defineMacro(llvm.$add_char$ptr$C_StringRef((String)"__", (StringRef)MacroName));
        Builder2.defineMacro(llvm.$add_Twine((Twine)llvm.$add_char$ptr$C_StringRef((String)"__", (StringRef)MacroName), (Twine)new Twine("__")));
    }

    public static void defineCPUMacros(MacroBuilder Builder2, StringRef CPUName) {
        TargetsStatics.defineCPUMacros(Builder2, CPUName, true);
    }

    public static void defineCPUMacros(MacroBuilder Builder2, StringRef CPUName, boolean Tuning) {
        Builder2.defineMacro(llvm.$add_char$ptr$C_StringRef((String)"__", (StringRef)CPUName));
        Builder2.defineMacro(llvm.$add_Twine((Twine)llvm.$add_char$ptr$C_StringRef((String)"__", (StringRef)CPUName), (Twine)new Twine("__")));
        if (Tuning) {
            Builder2.defineMacro(llvm.$add_Twine((Twine)llvm.$add_char$ptr$C_StringRef((String)"__tune_", (StringRef)CPUName), (Twine)new Twine("__")));
        }
    }

    public static TargetInfoImpl AllocateTarget(Triple _Triple, TargetOptions Opts) {
        Triple.OSType os = _Triple.getOS();
        switch (_Triple.getArch()) {
            default: {
                return null;
            }
            case xcore: {
                return new XCoreTargetInfo(_Triple, Opts);
            }
            case hexagon: {
                return new HexagonTargetInfo(_Triple, Opts);
            }
            case lanai: {
                return new LanaiTargetInfo(_Triple, Opts);
            }
            case aarch64: {
                if (_Triple.isOSDarwin()) {
                    return new DarwinAArch64TargetInfo(_Triple, Opts);
                }
                switch (os) {
                    case CloudABI: {
                        return new CloudABITargetInfo<AArch64leTargetInfo>(new AArch64leTargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case FreeBSD: {
                        return new FreeBSDTargetInfo<AArch64leTargetInfo>(new AArch64leTargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case Linux: {
                        return new LinuxTargetInfo<AArch64leTargetInfo>(new AArch64leTargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case NetBSD: {
                        return new NetBSDTargetInfo<AArch64leTargetInfo>(new AArch64leTargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                }
                return new AArch64leTargetInfo(_Triple, Opts);
            }
            case aarch64_be: {
                switch (os) {
                    case FreeBSD: {
                        return new FreeBSDTargetInfo<AArch64beTargetInfo>(new AArch64beTargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case Linux: {
                        return new LinuxTargetInfo<AArch64beTargetInfo>(new AArch64beTargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case NetBSD: {
                        return new NetBSDTargetInfo<AArch64beTargetInfo>(new AArch64beTargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                }
                return new AArch64beTargetInfo(_Triple, Opts);
            }
            case arm: 
            case thumb: {
                if (_Triple.isOSBinFormatMachO()) {
                    return new DarwinARMTargetInfo(_Triple, Opts);
                }
                switch (os) {
                    case Linux: {
                        return new LinuxTargetInfo<ARMleTargetInfo>(new ARMleTargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case FreeBSD: {
                        return new FreeBSDTargetInfo<ARMleTargetInfo>(new ARMleTargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case NetBSD: {
                        return new NetBSDTargetInfo<ARMleTargetInfo>(new ARMleTargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case OpenBSD: {
                        return new OpenBSDTargetInfo<ARMleTargetInfo>(new ARMleTargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case Bitrig: {
                        return new BitrigTargetInfo<ARMleTargetInfo>(new ARMleTargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case RTEMS: {
                        return new RTEMSTargetInfo<ARMleTargetInfo>(new ARMleTargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case NaCl: {
                        return new NaClTargetInfo<ARMleTargetInfo>(new ARMleTargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case Win32: {
                        switch (_Triple.getEnvironment()) {
                            case Cygnus: {
                                return new CygwinARMTargetInfo(_Triple, Opts);
                            }
                            case GNU: {
                                return new MinGWARMTargetInfo(_Triple, Opts);
                            }
                            case Itanium: {
                                return new ItaniumWindowsARMleTargetInfo(_Triple, Opts);
                            }
                        }
                        return new MicrosoftARMleTargetInfo(_Triple, Opts);
                    }
                }
                return new ARMleTargetInfo(_Triple, Opts);
            }
            case armeb: 
            case thumbeb: {
                if (_Triple.isOSDarwin()) {
                    return new DarwinARMTargetInfo(_Triple, Opts);
                }
                switch (os) {
                    case Linux: {
                        return new LinuxTargetInfo<ARMbeTargetInfo>(new ARMbeTargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case FreeBSD: {
                        return new FreeBSDTargetInfo<ARMbeTargetInfo>(new ARMbeTargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case NetBSD: {
                        return new NetBSDTargetInfo<ARMbeTargetInfo>(new ARMbeTargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case OpenBSD: {
                        return new OpenBSDTargetInfo<ARMbeTargetInfo>(new ARMbeTargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case Bitrig: {
                        return new BitrigTargetInfo<ARMbeTargetInfo>(new ARMbeTargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case RTEMS: {
                        return new RTEMSTargetInfo<ARMbeTargetInfo>(new ARMbeTargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case NaCl: {
                        return new NaClTargetInfo<ARMbeTargetInfo>(new ARMbeTargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                }
                return new ARMbeTargetInfo(_Triple, Opts);
            }
            case bpfeb: 
            case bpfel: {
                return new BPFTargetInfo(_Triple, Opts);
            }
            case msp430: {
                return new MSP430TargetInfo(_Triple, Opts);
            }
            case mips: {
                switch (os) {
                    case Linux: {
                        return new LinuxTargetInfo<MipsTargetInfo>(new MipsTargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case RTEMS: {
                        return new RTEMSTargetInfo<MipsTargetInfo>(new MipsTargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case FreeBSD: {
                        return new FreeBSDTargetInfo<MipsTargetInfo>(new MipsTargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case NetBSD: {
                        return new NetBSDTargetInfo<MipsTargetInfo>(new MipsTargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                }
                return new MipsTargetInfo(_Triple, Opts);
            }
            case mipsel: {
                switch (os) {
                    case Linux: {
                        return new LinuxTargetInfo<MipsTargetInfo>(new MipsTargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case RTEMS: {
                        return new RTEMSTargetInfo<MipsTargetInfo>(new MipsTargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case FreeBSD: {
                        return new FreeBSDTargetInfo<MipsTargetInfo>(new MipsTargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case NetBSD: {
                        return new NetBSDTargetInfo<MipsTargetInfo>(new MipsTargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case NaCl: {
                        return new NaClTargetInfo<NaClMips32TargetInfo>(new NaClMips32TargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                }
                return new MipsTargetInfo(_Triple, Opts);
            }
            case mips64: {
                switch (os) {
                    case Linux: {
                        return new LinuxTargetInfo<MipsTargetInfo>(new MipsTargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case RTEMS: {
                        return new RTEMSTargetInfo<MipsTargetInfo>(new MipsTargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case FreeBSD: {
                        return new FreeBSDTargetInfo<MipsTargetInfo>(new MipsTargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case NetBSD: {
                        return new NetBSDTargetInfo<MipsTargetInfo>(new MipsTargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case OpenBSD: {
                        return new OpenBSDTargetInfo<MipsTargetInfo>(new MipsTargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                }
                return new MipsTargetInfo(_Triple, Opts);
            }
            case mips64el: {
                switch (os) {
                    case Linux: {
                        return new LinuxTargetInfo<MipsTargetInfo>(new MipsTargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case RTEMS: {
                        return new RTEMSTargetInfo<MipsTargetInfo>(new MipsTargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case FreeBSD: {
                        return new FreeBSDTargetInfo<MipsTargetInfo>(new MipsTargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case NetBSD: {
                        return new NetBSDTargetInfo<MipsTargetInfo>(new MipsTargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case OpenBSD: {
                        return new OpenBSDTargetInfo<MipsTargetInfo>(new MipsTargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                }
                return new MipsTargetInfo(_Triple, Opts);
            }
            case le32: {
                switch (os) {
                    case NaCl: {
                        return new NaClTargetInfo<PNaClTargetInfo>(new PNaClTargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                }
                return null;
            }
            case le64: {
                return new Le64TargetInfo(_Triple, Opts);
            }
            case ppc: {
                if (_Triple.isOSDarwin()) {
                    return new DarwinPPC32TargetInfo(_Triple, Opts);
                }
                switch (os) {
                    case Linux: {
                        return new LinuxTargetInfo<PPC32TargetInfo>(new PPC32TargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case FreeBSD: {
                        return new FreeBSDTargetInfo<PPC32TargetInfo>(new PPC32TargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case NetBSD: {
                        return new NetBSDTargetInfo<PPC32TargetInfo>(new PPC32TargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case OpenBSD: {
                        return new OpenBSDTargetInfo<PPC32TargetInfo>(new PPC32TargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case RTEMS: {
                        return new RTEMSTargetInfo<PPC32TargetInfo>(new PPC32TargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                }
                return new PPC32TargetInfo(_Triple, Opts);
            }
            case ppc64: {
                if (_Triple.isOSDarwin()) {
                    return new DarwinPPC64TargetInfo(_Triple, Opts);
                }
                switch (os) {
                    case Linux: {
                        return new LinuxTargetInfo<PPC64TargetInfo>(new PPC64TargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case Lv2: {
                        return new PS3PPUTargetInfo<PPC64TargetInfo>(new PPC64TargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case FreeBSD: {
                        return new FreeBSDTargetInfo<PPC64TargetInfo>(new PPC64TargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case NetBSD: {
                        return new NetBSDTargetInfo<PPC64TargetInfo>(new PPC64TargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                }
                return new PPC64TargetInfo(_Triple, Opts);
            }
            case ppc64le: {
                switch (os) {
                    case Linux: {
                        return new LinuxTargetInfo<PPC64TargetInfo>(new PPC64TargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case NetBSD: {
                        return new NetBSDTargetInfo<PPC64TargetInfo>(new PPC64TargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                }
                return new PPC64TargetInfo(_Triple, Opts);
            }
            case nvptx: {
                return new NVPTX32TargetInfo(_Triple, Opts);
            }
            case nvptx64: {
                return new NVPTX64TargetInfo(_Triple, Opts);
            }
            case amdgcn: 
            case r600: {
                return new AMDGPUTargetInfo(_Triple, Opts);
            }
            case sparc: {
                switch (os) {
                    case Linux: {
                        return new LinuxTargetInfo<SparcV8TargetInfo>(new SparcV8TargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case Solaris: {
                        return new SolarisTargetInfo<SparcV8TargetInfo>(new SparcV8TargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case NetBSD: {
                        return new NetBSDTargetInfo<SparcV8TargetInfo>(new SparcV8TargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case OpenBSD: {
                        return new OpenBSDTargetInfo<SparcV8TargetInfo>(new SparcV8TargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case RTEMS: {
                        return new RTEMSTargetInfo<SparcV8TargetInfo>(new SparcV8TargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                }
                return new SparcV8TargetInfo(_Triple, Opts);
            }
            case sparcel: {
                switch (os) {
                    case Linux: {
                        return new LinuxTargetInfo<SparcV8elTargetInfo>(new SparcV8elTargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case NetBSD: {
                        return new NetBSDTargetInfo<SparcV8elTargetInfo>(new SparcV8elTargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case OpenBSD: {
                        return new OpenBSDTargetInfo<SparcV8elTargetInfo>(new SparcV8elTargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case RTEMS: {
                        return new RTEMSTargetInfo<SparcV8elTargetInfo>(new SparcV8elTargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                }
                return new SparcV8elTargetInfo(_Triple, Opts);
            }
            case sparcv9: {
                switch (os) {
                    case Linux: {
                        return new LinuxTargetInfo<SparcV9TargetInfo>(new SparcV9TargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case Solaris: {
                        return new SolarisTargetInfo<SparcV9TargetInfo>(new SparcV9TargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case NetBSD: {
                        return new NetBSDTargetInfo<SparcV9TargetInfo>(new SparcV9TargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case OpenBSD: {
                        return new OpenBSDTargetInfo<SparcV9TargetInfo>(new SparcV9TargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case FreeBSD: {
                        return new FreeBSDTargetInfo<SparcV9TargetInfo>(new SparcV9TargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                }
                return new SparcV9TargetInfo(_Triple, Opts);
            }
            case systemz: {
                switch (os) {
                    case Linux: {
                        return new LinuxTargetInfo<SystemZTargetInfo>(new SystemZTargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                }
                return new SystemZTargetInfo(_Triple, Opts);
            }
            case tce: {
                return new TCETargetInfo(_Triple, Opts);
            }
            case x86: {
                if (_Triple.isOSDarwin()) {
                    return new DarwinI386TargetInfo(_Triple, Opts);
                }
                switch (os) {
                    case CloudABI: {
                        return new CloudABITargetInfo<X86_32TargetInfo>(new X86_32TargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case Linux: {
                        switch (_Triple.getEnvironment()) {
                            default: {
                                return new LinuxTargetInfo<X86_32TargetInfo>(new X86_32TargetInfo(_Triple, Opts), _Triple, Opts);
                            }
                            case Android: 
                        }
                        return new AndroidX86_32TargetInfo(_Triple, Opts);
                    }
                    case DragonFly: {
                        return new DragonFlyBSDTargetInfo<X86_32TargetInfo>(new X86_32TargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case NetBSD: {
                        return new NetBSDI386TargetInfo(_Triple, Opts);
                    }
                    case OpenBSD: {
                        return new OpenBSDI386TargetInfo(_Triple, Opts);
                    }
                    case Bitrig: {
                        return new BitrigI386TargetInfo(_Triple, Opts);
                    }
                    case FreeBSD: {
                        return new FreeBSDTargetInfo<X86_32TargetInfo>(new X86_32TargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case KFreeBSD: {
                        return new KFreeBSDTargetInfo<X86_32TargetInfo>(new X86_32TargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case Minix: {
                        return new MinixTargetInfo<X86_32TargetInfo>(new X86_32TargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case Solaris: {
                        return new SolarisTargetInfo<X86_32TargetInfo>(new X86_32TargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case Win32: {
                        switch (_Triple.getEnvironment()) {
                            case Cygnus: {
                                return new CygwinX86_32TargetInfo(_Triple, Opts);
                            }
                            case GNU: {
                                return new MinGWX86_32TargetInfo(_Triple, Opts);
                            }
                        }
                        return new MicrosoftX86_32TargetInfo(_Triple, Opts);
                    }
                    case Haiku: {
                        return new HaikuX86_32TargetInfo(_Triple, Opts);
                    }
                    case RTEMS: {
                        return new RTEMSX86_32TargetInfo(_Triple, Opts);
                    }
                    case NaCl: {
                        return new NaClTargetInfo<X86_32TargetInfo>(new X86_32TargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case ELFIAMCU: {
                        return new MCUX86_32TargetInfo(_Triple, Opts);
                    }
                }
                return new X86_32TargetInfo(_Triple, Opts);
            }
            case x86_64: {
                if (_Triple.isOSDarwin() || _Triple.isOSBinFormatMachO()) {
                    return new DarwinX86_64TargetInfo(_Triple, Opts);
                }
                switch (os) {
                    case CloudABI: {
                        return new CloudABITargetInfo<X86_64TargetInfo>(new X86_64TargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case Linux: {
                        switch (_Triple.getEnvironment()) {
                            default: {
                                return new LinuxTargetInfo<X86_64TargetInfo>(new X86_64TargetInfo(_Triple, Opts), _Triple, Opts);
                            }
                            case Android: 
                        }
                        return new AndroidX86_64TargetInfo(_Triple, Opts);
                    }
                    case DragonFly: {
                        return new DragonFlyBSDTargetInfo<X86_64TargetInfo>(new X86_64TargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case NetBSD: {
                        return new NetBSDTargetInfo<X86_64TargetInfo>(new X86_64TargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case OpenBSD: {
                        return new OpenBSDX86_64TargetInfo(_Triple, Opts);
                    }
                    case Bitrig: {
                        return new BitrigX86_64TargetInfo(_Triple, Opts);
                    }
                    case FreeBSD: {
                        return new FreeBSDTargetInfo<X86_64TargetInfo>(new X86_64TargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case KFreeBSD: {
                        return new KFreeBSDTargetInfo<X86_64TargetInfo>(new X86_64TargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case Solaris: {
                        return new SolarisTargetInfo<X86_64TargetInfo>(new X86_64TargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case Win32: {
                        switch (_Triple.getEnvironment()) {
                            case Cygnus: {
                                return new CygwinX86_64TargetInfo(_Triple, Opts);
                            }
                            case GNU: {
                                return new MinGWX86_64TargetInfo(_Triple, Opts);
                            }
                        }
                        return new MicrosoftX86_64TargetInfo(_Triple, Opts);
                    }
                    case Haiku: {
                        return new HaikuTargetInfo<X86_64TargetInfo>(new X86_64TargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case NaCl: {
                        return new NaClTargetInfo<X86_64TargetInfo>(new X86_64TargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                    case PS4: {
                        return new PS4OSTargetInfo<X86_64TargetInfo>(new X86_64TargetInfo(_Triple, Opts), _Triple, Opts);
                    }
                }
                return new X86_64TargetInfo(_Triple, Opts);
            }
            case spir: {
                if (_Triple.getOS() != Triple.OSType.UnknownOS || _Triple.getEnvironment() != Triple.EnvironmentType.UnknownEnvironment) {
                    return null;
                }
                return new SPIR32TargetInfo(_Triple, Opts);
            }
            case spir64: {
                if (_Triple.getOS() != Triple.OSType.UnknownOS || _Triple.getEnvironment() != Triple.EnvironmentType.UnknownEnvironment) {
                    return null;
                }
                return new SPIR64TargetInfo(_Triple, Opts);
            }
            case wasm32: {
                if (!_Triple.$eq(new Triple(new Twine("wasm32-unknown-unknown")))) {
                    return null;
                }
                return new WebAssemblyOSTargetInfo<WebAssembly32TargetInfo>(new WebAssembly32TargetInfo(_Triple, Opts), _Triple, Opts);
            }
            case wasm64: {
                if (!_Triple.$eq(new Triple(new Twine("wasm64-unknown-unknown")))) {
                    return null;
                }
                return new WebAssemblyOSTargetInfo<WebAssembly64TargetInfo>(new WebAssembly64TargetInfo(_Triple, Opts), _Triple, Opts);
            }
            case renderscript32: {
                return new LinuxTargetInfo<RenderScript32TargetInfo>(new RenderScript32TargetInfo(_Triple, Opts), _Triple, Opts);
            }
            case renderscript64: 
        }
        return new LinuxTargetInfo<RenderScript64TargetInfo>(new RenderScript64TargetInfo(_Triple, Opts), _Triple, Opts);
    }

    public static void getDarwinDefines(MacroBuilder Builder2, LangOptions Opts, Triple Triple2, StringRef PlatformName, VersionTuple PlatformMinVersion) {
        Builder2.defineMacro(new Twine("__APPLE_CC__"), new Twine("6000"));
        Builder2.defineMacro(new Twine("__APPLE__"));
        Builder2.defineMacro(new Twine("OBJC_NEW_PROPERTIES"));
        if (Opts.Sanitize.has(SanitizerKind.Address)) {
            Builder2.defineMacro(new Twine("_FORTIFY_SOURCE"), new Twine(NativePointer.$0));
        }
        if (!Opts.ObjC1) {
            Builder2.defineMacro(new Twine("__weak"), new Twine("__attribute__((objc_gc(weak)))"));
            Builder2.defineMacro(new Twine("__strong"), new Twine(NativePointer.$EMPTY));
            Builder2.defineMacro(new Twine("__unsafe_unretained"), new Twine(NativePointer.$EMPTY));
        }
        if (Opts.Static) {
            Builder2.defineMacro(new Twine("__STATIC__"));
        } else {
            Builder2.defineMacro(new Twine("__DYNAMIC__"));
        }
        if (Opts.POSIXThreads) {
            Builder2.defineMacro(new Twine("_REENTRANT"));
        }
        uint.ref Maj = NativePointer.create_uint$ref();
        uint.ref Min = NativePointer.create_uint$ref();
        uint.ref Rev = NativePointer.create_uint$ref();
        if (Triple2.isMacOSX()) {
            Triple2.getMacOSXVersion(Maj, Min, Rev);
            PlatformName.$assignMove("macos");
        } else {
            Triple2.getOSVersion(Maj, Min, Rev);
            PlatformName.$assignMove(Triple.getOSTypeName((Triple.OSType)Triple2.getOS()));
        }
        if (llvm.$eq_StringRef((StringRef)PlatformName, (String)"win32")) {
            PlatformMinVersion.$assignMove(new VersionTuple(Maj.$deref(), Min.$deref(), Rev.$deref()));
            return;
        }
        if (Triple2.isiOS()) {
            assert (Unsigned.$less_uint((uint.ref)Maj, (int)10) && Unsigned.$less_uint((uint.ref)Min, (int)100) && Unsigned.$less_uint((uint.ref)Rev, (int)100)) : "Invalid version!";
            byte[] Str = NativePointer.new$char((int)6, (byte[])new byte[0]);
            Str[0] = Unsigned.$uint2char((int)(48 + Maj.$deref()));
            Str[1] = Unsigned.$uint2char((int)(48 + Min.$deref() / 10));
            Str[2] = Unsigned.$uint2char((int)(48 + Min.$deref() % 10));
            Str[3] = Unsigned.$uint2char((int)(48 + Rev.$deref() / 10));
            Str[4] = Unsigned.$uint2char((int)(48 + Rev.$deref() % 10));
            Str[5] = 0;
            if (Triple2.isTvOS()) {
                Builder2.defineMacro(new Twine("__ENVIRONMENT_TV_OS_VERSION_MIN_REQUIRED__"), new Twine(Str));
            } else {
                Builder2.defineMacro(new Twine("__ENVIRONMENT_IPHONE_OS_VERSION_MIN_REQUIRED__"), new Twine(Str));
            }
        } else if (Triple2.isWatchOS()) {
            assert (Unsigned.$less_uint((uint.ref)Maj, (int)10) && Unsigned.$less_uint((uint.ref)Min, (int)100) && Unsigned.$less_uint((uint.ref)Rev, (int)100)) : "Invalid version!";
            byte[] Str = NativePointer.new$char((int)6, (byte[])new byte[0]);
            Str[0] = Unsigned.$uint2char((int)(48 + Maj.$deref()));
            Str[1] = Unsigned.$uint2char((int)(48 + Min.$deref() / 10));
            Str[2] = Unsigned.$uint2char((int)(48 + Min.$deref() % 10));
            Str[3] = Unsigned.$uint2char((int)(48 + Rev.$deref() / 10));
            Str[4] = Unsigned.$uint2char((int)(48 + Rev.$deref() % 10));
            Str[5] = 0;
            Builder2.defineMacro(new Twine("__ENVIRONMENT_WATCH_OS_VERSION_MIN_REQUIRED__"), new Twine(Str));
        } else if (Triple2.isMacOSX()) {
            assert (Unsigned.$less_uint((uint.ref)Maj, (int)100) && Unsigned.$less_uint((uint.ref)Min, (int)100) && Unsigned.$less_uint((uint.ref)Rev, (int)100)) : "Invalid version!";
            byte[] Str = NativePointer.new$char((int)7, (byte[])new byte[0]);
            if (Unsigned.$less_uint((uint.ref)Maj, (int)10) || Maj.$deref() == 10 && Unsigned.$less_uint((uint.ref)Min, (int)10)) {
                Str[0] = Unsigned.$uint2char((int)(48 + Maj.$deref() / 10));
                Str[1] = Unsigned.$uint2char((int)(48 + Maj.$deref() % 10));
                Str[2] = Unsigned.$uint2char((int)(48 + std.min((int)Min.$deref(), (int)9)));
                Str[3] = Unsigned.$uint2char((int)(48 + std.min((int)Rev.$deref(), (int)9)));
                Str[4] = 0;
            } else {
                Str[0] = Unsigned.$uint2char((int)(48 + Maj.$deref() / 10));
                Str[1] = Unsigned.$uint2char((int)(48 + Maj.$deref() % 10));
                Str[2] = Unsigned.$uint2char((int)(48 + Min.$deref() / 10));
                Str[3] = Unsigned.$uint2char((int)(48 + Min.$deref() % 10));
                Str[4] = Unsigned.$uint2char((int)(48 + Rev.$deref() / 10));
                Str[5] = Unsigned.$uint2char((int)(48 + Rev.$deref() % 10));
                Str[6] = 0;
            }
            Builder2.defineMacro(new Twine("__ENVIRONMENT_MAC_OS_X_VERSION_MIN_REQUIRED__"), new Twine(Str));
        }
        if (Triple2.isOSDarwin()) {
            Builder2.defineMacro(new Twine("__MACH__"));
        }
        if (Triple2.isWatchABI()) {
            Builder2.defineMacro(new Twine("__ARM_DWARF_EH__"));
        }
        PlatformMinVersion.$assignMove(new VersionTuple(Maj.$deref(), Min.$deref(), Rev.$deref()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean ppcUserFeaturesCheck(DiagnosticsEngine Diags, std.vectorString FeaturesVec) {
        if (std.$noteq___normal_iterator$C((abstract_iterator)std.find((type.iterator)FeaturesVec.begin(), (type.iterator)FeaturesVec.end(), (Object)"-vsx"), (abstract_iterator)FeaturesVec.end())) {
            if (std.$noteq___normal_iterator$C((abstract_iterator)std.find((type.iterator)FeaturesVec.begin(), (type.iterator)FeaturesVec.end(), (Object)"+power8-vector"), (abstract_iterator)FeaturesVec.end())) {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C(BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)$c$.track((Object)Diags.Report(31)), "-mpower8-vector"), "-mno-vsx"));
                    boolean bl = false;
                    return bl;
                }
                finally {
                    $c$.$destroy();
                }
            }
            if (std.$noteq___normal_iterator$C((abstract_iterator)std.find((type.iterator)FeaturesVec.begin(), (type.iterator)FeaturesVec.end(), (Object)"+direct-move"), (abstract_iterator)FeaturesVec.end())) {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C(BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)$c$.track((Object)Diags.Report(31)), "-mdirect-move"), "-mno-vsx"));
                    boolean bl = false;
                    return bl;
                }
                finally {
                    $c$.$destroy();
                }
            }
            if (std.$noteq___normal_iterator$C((abstract_iterator)std.find((type.iterator)FeaturesVec.begin(), (type.iterator)FeaturesVec.end(), (Object)"+float128"), (abstract_iterator)FeaturesVec.end())) {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C(BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)$c$.track((Object)Diags.Report(31)), "-mfloat128"), "-mno-vsx"));
                    boolean bl = false;
                    return bl;
                }
                finally {
                    $c$.$destroy();
                }
            }
        }
        return true;
    }

    public static void addCygMingDefines(LangOptions Opts, MacroBuilder Builder2) {
        if (Opts.MicrosoftExt) {
            Builder2.defineMacro(new Twine(NativePointer.$__declspec), new Twine(NativePointer.$__declspec));
        } else {
            Builder2.defineMacro(new Twine("__declspec(a)"), new Twine("__attribute__((a))"));
        }
        if (!Opts.MicrosoftExt) {
            char.ptr[] CCs;
            for (char.ptr CC : CCs = new char.ptr[]{NativePointer.$((String)"cdecl"), NativePointer.$((String)"stdcall"), NativePointer.$((String)"fastcall"), NativePointer.$((String)"thiscall"), NativePointer.$((String)"pascal")}) {
                std.string GCCSpelling = new std.string((CharSequence)"__attribute__((__");
                GCCSpelling.$addassign(CC);
                GCCSpelling.$addassign((CharSequence)"__))");
                Builder2.defineMacro(llvm.$add_Twine((Twine)new Twine(NativePointer.$UNDERSCORE), (Twine)new Twine(CC)), new Twine(GCCSpelling));
                Builder2.defineMacro(llvm.$add_Twine((Twine)new Twine("__"), (Twine)new Twine(CC)), new Twine(GCCSpelling));
            }
        }
    }

    public static void addMinGWDefines(LangOptions Opts, MacroBuilder Builder2) {
        Builder2.defineMacro(new Twine("__MSVCRT__"));
        Builder2.defineMacro(new Twine("__MINGW32__"));
        TargetsStatics.addCygMingDefines(Opts, Builder2);
    }
}

