/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit.commands;

import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitRevisionInfo;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.commands.CommitCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.GitCommand;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.remotefs.versioning.api.ProcessUtils;
import org.openide.util.Cancellable;

public class ResolveCommand
extends GitCommand {
    private final String name;
    private GitRevisionInfo result;
    private final ProgressMonitor monitor;

    public ResolveCommand(JGitRepository repository, GitClassFactory gitFactory, String name, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.name = name;
        this.monitor = monitor;
    }

    public GitRevisionInfo getResult() {
        return this.result;
    }

    @Override
    protected void prepare() throws GitException {
        super.prepare();
        this.addArgument(0, "show");
        this.addArgument(0, "--raw");
        this.addArgument(0, this.name);
    }

    @Override
    protected void run() throws GitException {
        block4: {
            ProcessUtils.Canceler canceled = new ProcessUtils.Canceler();
            if (this.monitor != null) {
                this.monitor.setCancelDelegate((Cancellable)canceled);
            }
            try {
                final GitRevisionInfo.GitRevCommit status = new GitRevisionInfo.GitRevCommit();
                new GitCommand.Runner(canceled, 0){

                    @Override
                    public void outputParser(String output) throws GitException {
                        CommitCommand.parseLog(output, status);
                    }
                }.runCLI();
                this.result = this.getClassFactory().createRevisionInfo(status, this.getRepository());
            }
            catch (GitException t) {
                throw t;
            }
            catch (Throwable t) {
                if (canceled.canceled()) break block4;
                throw new GitException(t);
            }
        }
    }
}

