/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.toolchain;

import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public final class PlatformTypes {
    public static final int PLATFORM_SOLARIS_SPARC = 0;
    public static final int PLATFORM_SOLARIS_INTEL = 1;
    public static final int PLATFORM_LINUX = 2;
    public static final int PLATFORM_WINDOWS = 3;
    public static final int PLATFORM_MACOSX = 4;
    public static final int PLATFORM_GENERIC = 5;
    public static final int PLATFORM_NONE = 6;
    private static int defaultPlatform = -1;

    private PlatformTypes() {
    }

    public static int getPlatformFromHostInfo(HostInfo hostInfo) {
        HostInfo.OSFamily osFamily = hostInfo.getOSFamily();
        switch (osFamily) {
            case SUNOS: {
                HostInfo.CpuFamily cpuFamily = hostInfo.getCpuFamily();
                switch (cpuFamily) {
                    case SPARC: {
                        return 0;
                    }
                    case X86: {
                        return 1;
                    }
                }
                Exceptions.printStackTrace((Throwable)new IllegalStateException("Unexpected cpu type " + cpuFamily + " for " + osFamily));
                return 6;
            }
            case LINUX: {
                return 2;
            }
            case WINDOWS: {
                return 3;
            }
            case MACOSX: {
                return 4;
            }
            case UNKNOWN: {
                return 5;
            }
        }
        Exceptions.printStackTrace((Throwable)new IllegalStateException("Unexpected os " + osFamily));
        return 6;
    }

    public static int getDefaultPlatform() {
        if (defaultPlatform <= 0) {
            String arch = System.getProperty("os.arch");
            defaultPlatform = Utilities.isWindows() ? 3 : (Utilities.isMac() ? 4 : (Utilities.getOperatingSystem() == 8 ? (arch.indexOf("86") >= 0 ? 1 : 0) : (Utilities.getOperatingSystem() == 16 ? 2 : 5)));
        }
        return defaultPlatform;
    }

    public static String toString(int platform) {
        String out;
        switch (platform) {
            case 0: {
                out = "PLATFORM_SOLARIS_SPARC";
                break;
            }
            case 1: {
                out = "PLATFORM_SOLARIS_INTEL";
                break;
            }
            case 2: {
                out = "PLATFORM_LINUX";
                break;
            }
            case 3: {
                out = "PLATFORM_WINDOWS";
                break;
            }
            case 4: {
                out = "PLATFORM_MACOSX";
                break;
            }
            case 5: {
                out = "PLATFORM_GENERIC";
                break;
            }
            case 6: {
                out = "PLATFORM_NONE";
                break;
            }
            default: {
                out = "Error";
            }
        }
        return out;
    }
}

