/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.dd.model;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.j2ee.deployment.common.api.Version;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerLibraryDependency;
import org.netbeans.modules.j2ee.weblogic9.dd.model.BaseDescriptorModel;
import org.netbeans.modules.j2ee.weblogic9.dd.model.JspDescriptorType;
import org.netbeans.modules.j2ee.weblogic9.dd.model.LibraryRefType;
import org.netbeans.modules.j2ee.weblogic9.dd.model.ResourceDescriptionType;
import org.netbeans.modules.j2ee.weblogic9.dd.model.WeblogicWebApp;
import org.netbeans.modules.j2ee.weblogic9.dd.web1211.FastSwapType;
import org.netbeans.modules.schema2beans.NullEntityResolver;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public final class WebApplicationModel
extends BaseDescriptorModel {
    private static final Pattern SCHEMA_1031 = Pattern.compile("http://xmlns\\.oracle\\.com/weblogic/weblogic-web-app/1\\.[0-3]/weblogic-web-app\\.xsd");
    private static final Pattern SCHEMA_1211 = Pattern.compile("http://xmlns\\.oracle\\.com/weblogic/weblogic-web-app/1\\.[4-7]/weblogic-web-app\\.xsd");
    private static final Pattern SCHEMA_1221 = Pattern.compile("http://xmlns\\.oracle\\.com/weblogic/weblogic-web-app/1\\.[8]/weblogic-web-app\\.xsd");
    private final WeblogicWebApp bean;

    private WebApplicationModel(WeblogicWebApp bean) {
        super(bean);
        this.bean = bean;
    }

    public static WebApplicationModel forFile(File file) throws IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
        try {
            WebApplicationModel webApplicationModel = WebApplicationModel.forInputStream(is);
            return webApplicationModel;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    public static WebApplicationModel forInputStream(InputStream is) throws IOException {
        Document doc;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver((EntityResolver)NullEntityResolver.newInstance());
            doc = builder.parse(is);
        }
        catch (SAXException ex) {
            throw new RuntimeException(NbBundle.getMessage(WebApplicationModel.class, (String)"MSG_CantCreateXMLDOMDocument"), ex);
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(NbBundle.getMessage(WebApplicationModel.class, (String)"MSG_CantCreateXMLDOMDocument"), ex);
        }
        String ns = doc.getDocumentElement().getNamespaceURI();
        if ("http://xmlns.oracle.com/weblogic/weblogic-web-app".equals(ns)) {
            String value = doc.getDocumentElement().getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
            if (SCHEMA_1031.matcher(value).matches()) {
                return new WebApplicationModel(org.netbeans.modules.j2ee.weblogic9.dd.web1031.WeblogicWebApp.createGraph(doc));
            }
            if (SCHEMA_1211.matcher(value).matches()) {
                return new WebApplicationModel(org.netbeans.modules.j2ee.weblogic9.dd.web1211.WeblogicWebApp.createGraph(doc));
            }
            if (SCHEMA_1221.matcher(value).matches()) {
                return new WebApplicationModel(org.netbeans.modules.j2ee.weblogic9.dd.web1221.WeblogicWebApp.createGraph(doc));
            }
            return new WebApplicationModel(org.netbeans.modules.j2ee.weblogic9.dd.web1221.WeblogicWebApp.createGraph(doc));
        }
        if ("http://www.bea.com/ns/weblogic/weblogic-web-app".equals(ns)) {
            return new WebApplicationModel(org.netbeans.modules.j2ee.weblogic9.dd.web1030.WeblogicWebApp.createGraph(doc));
        }
        return new WebApplicationModel(org.netbeans.modules.j2ee.weblogic9.dd.web90.WeblogicWebApp.createGraph(doc));
    }

    public static WebApplicationModel generate(@NullAllowed Version serverVersion) {
        if (serverVersion != null) {
            if (serverVersion.isAboveOrEqual(VERSION_12_2_1)) {
                return WebApplicationModel.generate1221();
            }
            if (serverVersion.isAboveOrEqual(VERSION_12_1_1)) {
                return WebApplicationModel.generate1211();
            }
            if (serverVersion.isAboveOrEqual(VERSION_10_3_1)) {
                return WebApplicationModel.generate1031();
            }
            if (serverVersion.isAboveOrEqual(VERSION_10_3_0)) {
                return WebApplicationModel.generate1030();
            }
        }
        return WebApplicationModel.generate90();
    }

    private static WebApplicationModel generate90() {
        org.netbeans.modules.j2ee.weblogic9.dd.web90.WeblogicWebApp webLogicWebApp = new org.netbeans.modules.j2ee.weblogic9.dd.web90.WeblogicWebApp();
        webLogicWebApp.createAttribute("xmlns:j2ee", "xmlns:j2ee", 513, null, null);
        webLogicWebApp.setAttributeValue("xmlns:j2ee", "http://java.sun.com/xml/ns/j2ee");
        webLogicWebApp.setAttributeValue("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        webLogicWebApp.setAttributeValue("xsi:schemaLocation", "http://www.bea.com/ns/weblogic/90 http://www.bea.com/ns/weblogic/90/weblogic-web-app.xsd");
        return new WebApplicationModel(webLogicWebApp);
    }

    private static WebApplicationModel generate1030() {
        org.netbeans.modules.j2ee.weblogic9.dd.web1030.WeblogicWebApp webLogicWebApp = new org.netbeans.modules.j2ee.weblogic9.dd.web1030.WeblogicWebApp();
        webLogicWebApp.setAttributeValue("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        webLogicWebApp.setAttributeValue("xsi:schemaLocation", "http://www.bea.com/ns/weblogic/weblogic-web-app http://www.bea.com/ns/weblogic/weblogic-web-app/1.0/weblogic-web-app.xsd");
        return new WebApplicationModel(webLogicWebApp);
    }

    private static WebApplicationModel generate1031() {
        org.netbeans.modules.j2ee.weblogic9.dd.web1031.WeblogicWebApp webLogicWebApp = new org.netbeans.modules.j2ee.weblogic9.dd.web1031.WeblogicWebApp();
        webLogicWebApp.setAttributeValue("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        webLogicWebApp.setAttributeValue("xsi:schemaLocation", "http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd http://xmlns.oracle.com/weblogic/weblogic-web-app http://xmlns.oracle.com/weblogic/weblogic-web-app/1.0/weblogic-web-app.xsd");
        return new WebApplicationModel(webLogicWebApp);
    }

    private static WebApplicationModel generate1211() {
        org.netbeans.modules.j2ee.weblogic9.dd.web1211.WeblogicWebApp webLogicWebApp = new org.netbeans.modules.j2ee.weblogic9.dd.web1211.WeblogicWebApp();
        webLogicWebApp.setAttributeValue("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        webLogicWebApp.setAttributeValue("xsi:schemaLocation", "http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd http://xmlns.oracle.com/weblogic/weblogic-web-app http://xmlns.oracle.com/weblogic/weblogic-web-app/1.4/weblogic-web-app.xsd");
        return new WebApplicationModel(webLogicWebApp);
    }

    private static WebApplicationModel generate1221() {
        org.netbeans.modules.j2ee.weblogic9.dd.web1221.WeblogicWebApp webLogicWebApp = new org.netbeans.modules.j2ee.weblogic9.dd.web1221.WeblogicWebApp();
        webLogicWebApp.setAttributeValue("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        webLogicWebApp.setAttributeValue("xsi:schemaLocation", "http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd http://xmlns.oracle.com/weblogic/weblogic-web-app http://xmlns.oracle.com/weblogic/weblogic-web-app/1.8/weblogic-web-app.xsd");
        return new WebApplicationModel(webLogicWebApp);
    }

    @CheckForNull
    public String getContextRoot() {
        String[] roots = this.bean.getContextRoot();
        if (roots == null || roots.length < 1) {
            return null;
        }
        return roots[0];
    }

    public void setContextRoot(String root) {
        this.bean.setContextRoot(new String[]{root});
    }

    public void setReference(String referenceName, String jndiName) {
        for (ResourceDescriptionType type : this.bean.getResourceDescription()) {
            String refName = type.getResRefName();
            if (!referenceName.equals(refName)) continue;
            type.setJndiName(jndiName);
            return;
        }
        ResourceDescriptionType type = this.bean.addResourceDescription();
        type.setResRefName(referenceName);
        type.setJndiName(jndiName);
    }

    public String getReferenceJndiName(String referenceName) {
        for (ResourceDescriptionType type : this.bean.getResourceDescription()) {
            String refName = type.getResRefName();
            if (!referenceName.equals(refName)) continue;
            return type.getJndiName();
        }
        return null;
    }

    public Set<ServerLibraryDependency> getLibraries() {
        HashSet<ServerLibraryDependency> ranges = new HashSet<ServerLibraryDependency>();
        for (LibraryRefType libRef : this.bean.getLibraryRef()) {
            ranges.add(this.getLibrary(libRef));
        }
        return ranges;
    }

    public void addLibrary(ServerLibraryDependency library) {
        LibraryRefType[] current;
        for (LibraryRefType libRef : current = this.bean.getLibraryRef()) {
            ServerLibraryDependency lib = this.getLibrary(libRef);
            if (!library.equals((Object)lib)) continue;
            return;
        }
        LibraryRefType libRef = this.bean.addLibraryRef();
        libRef.setLibraryName(library.getName());
        if (library.isExactMatch()) {
            libRef.setExactMatch(library.isExactMatch());
        }
        if (library.getSpecificationVersion() != null) {
            libRef.setSpecificationVersion(library.getSpecificationVersion().toString());
        }
        if (library.getImplementationVersion() != null) {
            libRef.setImplementationVersion(library.getImplementationVersion().toString());
        }
    }

    public void setKeepJspGenerated(boolean keep) {
        JspDescriptorType[] desc;
        for (JspDescriptorType type : desc = this.getJspDescriptor()) {
            type.setKeepgenerated(keep);
        }
    }

    public void setDebug(boolean debug) {
        JspDescriptorType[] desc;
        for (JspDescriptorType type : desc = this.getJspDescriptor()) {
            type.setDebug(debug);
        }
    }

    public void setFastSwap(boolean fast) {
        if (this.bean instanceof org.netbeans.modules.j2ee.weblogic9.dd.web1031.WeblogicWebApp) {
            org.netbeans.modules.j2ee.weblogic9.dd.web1031.FastSwapType fastSwap = new org.netbeans.modules.j2ee.weblogic9.dd.web1031.FastSwapType();
            fastSwap.setEnabled(fast);
            ((org.netbeans.modules.j2ee.weblogic9.dd.web1031.WeblogicWebApp)this.bean).setFastSwap(fastSwap);
        } else if (this.bean instanceof org.netbeans.modules.j2ee.weblogic9.dd.web1211.WeblogicWebApp) {
            FastSwapType fastSwap = new FastSwapType();
            fastSwap.setEnabled(fast);
            ((org.netbeans.modules.j2ee.weblogic9.dd.web1211.WeblogicWebApp)this.bean).setFastSwap(fastSwap);
        }
    }

    private JspDescriptorType[] getJspDescriptor() {
        JspDescriptorType[] jspDescriptor = this.bean.getJspDescriptor();
        if (jspDescriptor != null && jspDescriptor.length > 0) {
            return jspDescriptor;
        }
        return new JspDescriptorType[]{this.bean.addJspDescriptor()};
    }

    private ServerLibraryDependency getLibrary(LibraryRefType libRef) {
        Version impl;
        String name = libRef.getLibraryName();
        String specVersionString = libRef.getSpecificationVersion();
        String implVersionString = libRef.getImplementationVersion();
        boolean exactMatch = libRef.isExactMatch();
        Version spec = specVersionString == null ? null : Version.fromJsr277NotationWithFallback((String)specVersionString);
        Version version = impl = implVersionString == null ? null : Version.fromJsr277NotationWithFallback((String)implVersionString);
        if (exactMatch) {
            return ServerLibraryDependency.exactVersion((String)name, (Version)spec, (Version)impl);
        }
        return ServerLibraryDependency.minimalVersion((String)name, (Version)spec, (Version)impl);
    }
}

