/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.cache;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.netbeans.modules.cnd.utils.cache.TinyMaps;
import org.netbeans.modules.cnd.utils.cache.TinySingletonMap;

final class TinyTwoValuesMap<K, V>
implements Map<K, V>,
TinyMaps.CompactMap<K, V> {
    private K firstKey;
    private V firstValue;
    private K secondKey;
    private V secondValue;

    public TinyTwoValuesMap() {
    }

    TinyTwoValuesMap(TinySingletonMap<K, V> map) {
        this.firstKey = map.getKey();
        assert (this.firstKey != null);
        this.firstValue = map.getValue();
    }

    public K getFirstKey() {
        return this.firstKey;
    }

    public V getFirstValue() {
        return this.firstValue;
    }

    public K getSecondKey() {
        return this.secondKey;
    }

    public V getSecondValue() {
        return this.secondValue;
    }

    @Override
    public int size() {
        if (this.firstKey == null) {
            return 0;
        }
        if (this.secondKey == null) {
            return 1;
        }
        return 2;
    }

    @Override
    public boolean isEmpty() {
        return this.firstKey == null;
    }

    @Override
    public boolean containsKey(Object aKey) {
        if (this.firstKey == null) {
            return false;
        }
        if (this.firstKey.equals(aKey)) {
            return true;
        }
        if (this.secondKey == null) {
            return false;
        }
        return this.secondKey.equals(aKey);
    }

    @Override
    public boolean containsValue(Object aValue) {
        return this.firstValue != null && this.firstValue.equals(aValue) || this.secondValue != null && this.secondValue.equals(aValue);
    }

    @Override
    public V get(Object aKey) {
        if (this.firstKey != null && this.firstKey.equals(aKey)) {
            return this.firstValue;
        }
        if (this.secondKey != null && this.secondKey.equals(aKey)) {
            return this.secondValue;
        }
        return null;
    }

    @Override
    public V put(K aKey, V aValue) {
        assert (aKey != null);
        if (this.firstKey == null) {
            assert (this.secondKey == null) : "first key is always filled the first";
            this.firstKey = aKey;
            this.firstValue = aValue;
            return null;
        }
        if (this.firstKey.equals(aKey)) {
            V out = this.firstValue;
            this.firstValue = aValue;
            return out;
        }
        if (this.secondKey == null) {
            this.secondKey = aKey;
            this.secondValue = aValue;
            return null;
        }
        if (this.secondKey.equals(aKey)) {
            V out = this.secondValue;
            this.secondValue = aValue;
            return out;
        }
        assert (false) : "this map can not contain more than two elements";
        return null;
    }

    @Override
    public V remove(Object aKey) {
        if (this.firstKey == null) {
            return null;
        }
        if (this.firstKey.equals(aKey)) {
            V res = this.firstValue;
            this.firstKey = this.secondKey;
            this.firstValue = this.secondValue;
            this.secondKey = null;
            this.secondValue = null;
            return res;
        }
        if (this.secondKey == null) {
            return null;
        }
        if (this.secondKey.equals(aKey)) {
            V res = this.secondValue;
            this.secondKey = null;
            this.secondValue = null;
            return res;
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void clear() {
        this.firstKey = null;
        this.firstValue = null;
        this.secondKey = null;
        this.secondValue = null;
    }

    @Override
    public Set<K> keySet() {
        if (this.firstKey == null) {
            return Collections.emptySet();
        }
        if (this.secondKey == null) {
            return Collections.singleton(this.firstKey);
        }
        return new Set<K>(){

            @Override
            public int size() {
                return 2;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public boolean contains(Object o) {
                return TinyTwoValuesMap.this.firstKey.equals(o) || TinyTwoValuesMap.this.secondKey.equals(o);
            }

            @Override
            public Iterator<K> iterator() {
                return new Iterator<K>(){
                    private byte index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < 2;
                    }

                    @Override
                    public K next() {
                        if (this.index < 2) {
                            this.index = (byte)(this.index + 1);
                            if (this.index == 1) {
                                return TinyTwoValuesMap.this.firstKey;
                            }
                            return TinyTwoValuesMap.this.secondKey;
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }
                };
            }

            @Override
            public Object[] toArray() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public <T> T[] toArray(T[] a) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public boolean add(K e) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public boolean addAll(Collection<? extends K> c) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
    }

    @Override
    public Collection<V> values() {
        if (this.firstKey == null) {
            return Collections.emptyList();
        }
        if (this.secondKey == null) {
            return Collections.singleton(this.firstValue);
        }
        List<Object> asList = Arrays.asList(this.firstValue, this.secondValue);
        return asList;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.firstKey == null) {
            return Collections.emptySet();
        }
        return new Set<Map.Entry<K, V>>(){
            final int size;
            {
                this.size = TinyTwoValuesMap.this.size();
            }

            @Override
            public int size() {
                return this.size;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    private byte index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < size;
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        if (this.index < size) {
                            final byte entryIndex = this.index;
                            this.index = (byte)(this.index + 1);
                            return new Map.Entry<K, V>(){

                                @Override
                                public K getKey() {
                                    return entryIndex == 0 ? TinyTwoValuesMap.this.firstKey : TinyTwoValuesMap.this.secondKey;
                                }

                                @Override
                                public V getValue() {
                                    return entryIndex == 0 ? TinyTwoValuesMap.this.firstValue : TinyTwoValuesMap.this.secondValue;
                                }

                                @Override
                                public V setValue(V value) {
                                    Object res;
                                    if (entryIndex == 0) {
                                        res = TinyTwoValuesMap.this.firstValue;
                                        TinyTwoValuesMap.this.firstValue = value;
                                    } else {
                                        res = TinyTwoValuesMap.this.secondValue;
                                        TinyTwoValuesMap.this.secondValue = value;
                                    }
                                    return res;
                                }
                            };
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }
                };
            }

            @Override
            public boolean contains(Object o) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public Object[] toArray() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public <T> T[] toArray(T[] a) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public boolean add(Map.Entry<K, V> o) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<K, V>> c) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
    }

    @Override
    public Map<K, V> expandForNextKeyIfNeeded(K newElem) {
        if (this.firstKey == null || this.firstKey.equals(newElem)) {
            return this;
        }
        if (this.secondKey == null || this.secondKey.equals(newElem)) {
            return this;
        }
        return new TinyMaps.TinyMap4(this);
    }
}

