/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.folding;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.DocumentUtilities;
import org.netbeans.modules.cnd.editor.parser.CppFoldRecord;
import org.netbeans.modules.cnd.editor.parser.FoldingParser;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class CppFile {
    private static final Logger log = Logger.getLogger(CppFile.class.getName());
    public static final int FOLD_PARSING = 1;
    public static final int COMPLETION_PARSING = 2;
    public static final int PARSING_INITIALIZED = 0;
    public static final int PARSING_STARTED = 1;
    public static final int FOLD_PARSING_COMPLETE = 2;
    public static final int PARSING_COMPLETED = 3;
    public static final int PARSING_FAILED = 4;
    public static final int INITIAL_COMMENT_FOLD = 1;
    public static final int BLOCK_COMMENT_FOLD = 2;
    public static final int COMMENTS_FOLD = 3;
    public static final int INCLUDES_FOLD = 4;
    public static final int IFDEF_FOLD = 5;
    public static final int CLASS_FOLD = 6;
    public static final int FUNCTION_FOLD = 7;
    public static final int CONSTRUCTOR_FOLD = 8;
    public static final int DESTRUCTOR_FOLD = 9;
    public static final int NAMESPACE_FOLD = 10;
    public static final int COMPOUND_BLOCK_FOLD = 11;
    private int state = 0;
    private volatile long version = -1L;
    private CppFoldRecord initialCommentFoldRecord;
    private final List<CppFoldRecord> includesFoldRecords = new ArrayList<CppFoldRecord>();
    private final List<CppFoldRecord> blockFoldRecords = new ArrayList<CppFoldRecord>();

    public CppFile(String filename) {
    }

    public void startParsing(Document doc) {
        if (!this.needsUpdate(doc)) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "CppFile.startParsing: Parsing {0} [{1}]", new Object[]{this.getShortName(doc), Thread.currentThread().getName()});
        }
        this.state = 1;
        try {
            if (this.startParsing(Integer.getInteger("CppFoldFlags", 0), doc)) {
                this.state = 2;
            }
        }
        catch (NoSuchMethodError er) {
            log.log(Level.FINE, "CppFile.startParsing: NoSuchMethodError: {0}", er.getMessage());
        }
        catch (UnsatisfiedLinkError ule) {
            log.log(Level.FINE, "CppFile.startParsing: UnsatisfiedLinkError: {0}", ule.getMessage());
        }
        finally {
            if (this.state != 2) {
                this.state = 4;
            }
        }
    }

    public boolean isParsingFailed() {
        return this.state == 4;
    }

    private boolean startParsing(int flags, final Document doc) {
        FoldingParser p = (FoldingParser)Lookup.getDefault().lookup(FoldingParser.class);
        if (p != null) {
            this.blockFoldRecords.clear();
            this.initialCommentFoldRecord = null;
            this.includesFoldRecords.clear();
            final Object[] res = new Object[]{null, null};
            doc.render(new Runnable(){

                @Override
                public void run() {
                    try {
                        CppFile.this.version = org.netbeans.lib.editor.util.swing.DocumentUtilities.getDocumentTimestamp((Document)doc);
                        int length = doc.getLength();
                        char[] buf = new char[length];
                        DocumentUtilities.copyText((Document)doc, (int)0, (int)length, (char[])buf, (int)0);
                        res[0] = buf;
                    }
                    catch (BadLocationException e) {
                        res[1] = e;
                    }
                }
            });
            if (res[1] != null) {
                ((BadLocationException)res[1]).printStackTrace(System.err);
                return false;
            }
            if (res[0] == null) {
                return false;
            }
            FileObject fo = NbEditorUtilities.getFileObject((Document)doc);
            List<CppFoldRecord> folds = p.parse(fo, (char[])res[0]);
            if (folds == null) {
                return false;
            }
            for (CppFoldRecord fold : folds) {
                this.addNewFold((StyledDocument)doc, fold);
            }
        }
        return true;
    }

    public void waitScanFinished(int type) {
        while (this.state == 1) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public boolean needsUpdate(Document doc) {
        long documentTimestamp = org.netbeans.lib.editor.util.swing.DocumentUtilities.getDocumentTimestamp((Document)doc);
        return documentTimestamp != this.version;
    }

    private String getShortName(Document doc) {
        String longname = (String)doc.getProperty("title");
        int slash = longname.lastIndexOf(File.separatorChar);
        if (slash != -1) {
            return longname.substring(slash + 1);
        }
        return longname;
    }

    public CppFoldRecord getInitialCommentFold() {
        return this.initialCommentFoldRecord;
    }

    public List<CppFoldRecord> getIncludesFolds() {
        return this.includesFoldRecords;
    }

    public List<CppFoldRecord> getBlockFolds() {
        return this.blockFoldRecords;
    }

    private void addNewFold(StyledDocument doc, CppFoldRecord fold) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "CppFile.addNewFold: {0}", fold.toString());
        }
        switch (fold.getType()) {
            case 1: {
                if (this.initialCommentFoldRecord != null) break;
                this.initialCommentFoldRecord = fold;
                break;
            }
            case 4: {
                this.includesFoldRecords.add(fold);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                this.blockFoldRecords.add(fold);
            }
        }
    }
}

