/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.hc;

import com.sun.tools.javac.util.Pair;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LambdaMetafactory {
    public static final int FLAG_SERIALIZABLE = 1;
    public static final int FLAG_MARKERS = 2;
    public static final int FLAG_BRIDGES = 4;
    private static final Logger LOG = Logger.getLogger(LambdaMetafactory.class.getName());
    private static final byte[] PATTERN;
    private static final byte[] REPLACE;
    private static final boolean DO_TRANSLATE;
    private static final Method mm;
    private static final Method am;
    private static final ReflectiveOperationException refOpEx;

    public static CallSite metafactory(MethodHandles.Lookup caller, String invokedName, MethodType invokedType, MethodType samMethodType, MethodHandle implMethod, MethodType instantiatedMethodType) {
        if (mm != null) {
            try {
                return (CallSite)mm.invoke(null, caller, invokedName, LambdaMetafactory.translate(invokedType), LambdaMetafactory.translate(samMethodType), LambdaMetafactory.translate(implMethod), LambdaMetafactory.translate(instantiatedMethodType));
            }
            catch (InvocationTargetException e) {
                return (CallSite)LambdaMetafactory.sthrow(e.getCause());
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException(refOpEx);
    }

    public static CallSite altMetafactory(MethodHandles.Lookup caller, String invokedName, MethodType invokedType, Object ... args) {
        if (am != null) {
            try {
                return (CallSite)am.invoke(null, caller, invokedName, LambdaMetafactory.translate(invokedType), args);
            }
            catch (InvocationTargetException e) {
                return (CallSite)LambdaMetafactory.sthrow(e.getCause());
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException(refOpEx);
    }

    public static byte[] translateClassFile(byte[] data, int start, int end) {
        if (DO_TRANSLATE) {
            int index = LambdaMetafactory.find(data, start, end, PATTERN);
            while (index >= 0) {
                System.arraycopy(REPLACE, 0, data, index, REPLACE.length);
                index = LambdaMetafactory.find(data, index + PATTERN.length, end, PATTERN);
            }
        }
        return data;
    }

    private static int find(byte[] data, int start, int end, byte[] pattern) {
        int i;
        int j = 0;
        for (i = start; i < end && j < pattern.length; ++i) {
            if (data[i] == pattern[j]) {
                ++j;
                continue;
            }
            j = 0;
        }
        return j == pattern.length ? i - j : -1;
    }

    private static MethodHandle translate(MethodHandle handle) {
        try {
            Field typeFld = MethodHandle.class.getDeclaredField("type");
            typeFld.setAccessible(true);
            LambdaMetafactory.translate((MethodType)typeFld.get(handle));
            Method internalMemberName = MethodHandle.class.getDeclaredMethod("internalMemberName", new Class[0]);
            internalMemberName.setAccessible(true);
            Object member = internalMemberName.invoke((Object)handle, new Object[0]);
            if (member != null) {
                Class<?> memberNameClz = member.getClass();
                Method getMethodType = memberNameClz.getDeclaredMethod("getMethodType", new Class[0]);
                getMethodType.setAccessible(true);
                MethodType type = (MethodType)getMethodType.invoke(member, new Object[0]);
                if (type != null) {
                    LambdaMetafactory.translate(type);
                }
            }
        }
        catch (ReflectiveOperationException e) {
            LOG.warning(e.getMessage());
        }
        return handle;
    }

    private static MethodType translate(MethodType mt) {
        Class<?> rtype;
        TypeDescriptor.OfField origRtype = mt.returnType();
        boolean changeRtype = origRtype != (rtype = LambdaMetafactory.translate(origRtype));
        boolean changePtypes = false;
        Class[] ptypes = new Class[mt.parameterCount()];
        for (int i = 0; i < ptypes.length; ++i) {
            TypeDescriptor.OfField origPtype = mt.parameterType(i);
            ptypes[i] = LambdaMetafactory.translate(origPtype);
            changePtypes |= origPtype != ptypes[i];
        }
        try {
            if (changeRtype) {
                Field rtypeFld = MethodType.class.getDeclaredField("rtype");
                rtypeFld.setAccessible(true);
                rtypeFld.set(mt, rtype);
            }
            if (changePtypes) {
                Field ptypesFld = MethodType.class.getDeclaredField("ptypes");
                ptypesFld.setAccessible(true);
                ptypesFld.set(mt, ptypes);
            }
        }
        catch (ReflectiveOperationException e) {
            LOG.warning(e.getMessage());
        }
        return mt;
    }

    private static Class<?> translate(Class<?> clz) {
        if (clz.isPrimitive()) {
            return clz;
        }
        if (clz.isArray()) {
            Class<?> newCompType;
            Class<?> oldCompType = clz.getComponentType();
            if (oldCompType != (newCompType = LambdaMetafactory.translate(oldCompType))) {
                clz = Array.newInstance(newCompType, 0).getClass();
            }
            return clz;
        }
        try {
            String fqn = clz.getName();
            return LambdaMetafactory.class.getClassLoader().loadClass(fqn);
        }
        catch (ClassNotFoundException cnf) {
            return clz;
        }
    }

    private static Pair<String, Integer> parseJavaVersion(String version) {
        int index;
        String ver = null;
        int update = 0;
        if (version != null && (index = version.lastIndexOf(95)) > 0) {
            ver = version.substring(0, index);
            if (index + 1 < version.length()) {
                try {
                    update = Integer.parseInt(version.substring(index + 1));
                }
                catch (NumberFormatException e) {
                    LOG.log(Level.FINE, "Invalid update version in: {0}", version);
                }
            }
        }
        return Pair.of(ver, update);
    }

    private static <R, T extends Throwable> R sthrow(Throwable t) throws T {
        throw t;
    }

    static {
        try {
            PATTERN = "java/lang/invoke/LambdaMetafactory".getBytes("UTF-8");
            REPLACE = "com/sun/tools/hc/LambdaMetafactory".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        Pair<String, Integer> parsedJavaVersion = LambdaMetafactory.parseJavaVersion(System.getProperty("java.version"));
        DO_TRANSLATE = "1.8.0".equals(parsedJavaVersion.fst) && (Integer)parsedJavaVersion.snd < 51;
        Method mfm = null;
        Method amm = null;
        ReflectiveOperationException roe = null;
        try {
            Class<?> clz = Class.forName("java.lang.invoke.LambdaMetafactory");
            mfm = clz.getMethod("metafactory", MethodHandles.Lookup.class, String.class, MethodType.class, MethodType.class, MethodHandle.class, MethodType.class);
            amm = clz.getMethod("altMetafactory", MethodHandles.Lookup.class, String.class, MethodType.class, new Object[0].getClass());
        }
        catch (ReflectiveOperationException e) {
            roe = e;
        }
        mm = mfm;
        am = amm;
        refOpEx = roe;
    }
}

