/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import com.sun.tools.javac.file.PathFileObject;
import com.sun.tools.javac.file.RelativePath;
import com.sun.tools.javac.util.Context;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.ProviderNotFoundException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.tools.FileObject;

public class JRTIndex {
    private static JRTIndex sharedInstance;
    private final FileSystem jrtfs = FileSystems.getFileSystem(URI.create("jrt:/"));
    private final Map<RelativePath.RelativeDirectory, SoftReference<Entry>> entries = new HashMap<RelativePath.RelativeDirectory, SoftReference<Entry>>();
    private ResourceBundle ctBundle;

    public static synchronized JRTIndex getSharedInstance() {
        if (sharedInstance == null) {
            try {
                sharedInstance = new JRTIndex();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return sharedInstance;
    }

    public static JRTIndex instance(Context context) {
        try {
            JRTIndex instance = context.get(JRTIndex.class);
            if (instance == null) {
                instance = new JRTIndex();
                context.put(JRTIndex.class, instance);
            }
            return instance;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static boolean isAvailable() {
        try {
            FileSystems.getFileSystem(URI.create("jrt:/"));
            return true;
        }
        catch (FileSystemNotFoundException | ProviderNotFoundException e) {
            return false;
        }
    }

    private JRTIndex() throws IOException {
    }

    public CtSym getCtSym(CharSequence packageName) throws IOException {
        return this.getEntry((RelativePath.RelativeDirectory)RelativePath.RelativeDirectory.forPackage((CharSequence)packageName)).ctSym;
    }

    synchronized Entry getEntry(RelativePath.RelativeDirectory rd) throws IOException {
        Entry e;
        SoftReference<Entry> ref = this.entries.get(rd);
        Entry entry = e = ref == null ? null : ref.get();
        if (e == null) {
            Path dir;
            LinkedHashMap<String, Path> files = new LinkedHashMap<String, Path>();
            LinkedHashSet<RelativePath.RelativeDirectory> subdirs = new LinkedHashSet<RelativePath.RelativeDirectory>();
            if (rd.path.isEmpty()) {
                dir = this.jrtfs.getPath("/modules", new String[0]);
            } else {
                Path pkgs = this.jrtfs.getPath("/packages", new String[0]);
                dir = pkgs.resolve(rd.getPath().replaceAll("/$", "").replace("/", "."));
            }
            if (Files.exists(dir, new LinkOption[0])) {
                try (DirectoryStream<Path> modules = Files.newDirectoryStream(dir);){
                    for (Path module : modules) {
                        Path p = rd.getFile(module);
                        if (!Files.exists(p, new LinkOption[0])) continue;
                        DirectoryStream<Path> stream = Files.newDirectoryStream(p);
                        Throwable throwable = null;
                        try {
                            for (Path entry2 : stream) {
                                String name = entry2.getFileName().toString();
                                if (Files.isRegularFile(entry2, new LinkOption[0])) {
                                    files.put(name, entry2);
                                    continue;
                                }
                                if (!Files.isDirectory(entry2, new LinkOption[0])) continue;
                                subdirs.add(new RelativePath.RelativeDirectory(rd, name));
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (stream == null) continue;
                            if (throwable != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            stream.close();
                        }
                    }
                }
            }
            e = new Entry(Collections.unmodifiableMap(files), Collections.unmodifiableSet(subdirs), this.getCtInfo(rd));
            this.entries.put(rd, new SoftReference<Entry>(e));
        }
        return e;
    }

    public boolean isInJRT(FileObject fo) {
        if (fo instanceof PathFileObject) {
            Path path = ((PathFileObject)fo).getPath();
            return path.getFileSystem() == this.jrtfs;
        }
        return false;
    }

    private CtSym getCtInfo(RelativePath.RelativeDirectory dir) {
        if (dir.path.isEmpty()) {
            return CtSym.EMPTY;
        }
        if (this.ctBundle == null) {
            String bundleName = "com.sun.tools.javac.resources.ct";
            this.ctBundle = ResourceBundle.getBundle("com.sun.tools.javac.resources.ct");
        }
        try {
            String attrs = this.ctBundle.getString(dir.path.replace('/', '.') + '*');
            boolean hidden = false;
            boolean proprietary = false;
            String minProfile = null;
            String[] stringArray = attrs.split(" +", 0);
            int n = stringArray.length;
            block10: for (int i = 0; i < n; ++i) {
                String attr;
                switch (attr = stringArray[i]) {
                    case "hidden": {
                        hidden = true;
                        continue block10;
                    }
                    case "proprietary": {
                        proprietary = true;
                        continue block10;
                    }
                    default: {
                        minProfile = attr;
                    }
                }
            }
            return new CtSym(hidden, proprietary, minProfile);
        }
        catch (MissingResourceException e) {
            return CtSym.EMPTY;
        }
    }

    public static class CtSym {
        public final boolean hidden;
        public final boolean proprietary;
        public final String minProfile;
        static final CtSym EMPTY = new CtSym(false, false, null);

        CtSym(boolean hidden, boolean proprietary, String minProfile) {
            this.hidden = hidden;
            this.proprietary = proprietary;
            this.minProfile = minProfile;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("CtSym[");
            boolean needSep = false;
            if (this.hidden) {
                sb.append("hidden");
                needSep = true;
            }
            if (this.proprietary) {
                if (needSep) {
                    sb.append(",");
                }
                sb.append("proprietary");
                needSep = true;
            }
            if (this.minProfile != null) {
                if (needSep) {
                    sb.append(",");
                }
                sb.append(this.minProfile);
            }
            sb.append("]");
            return sb.toString();
        }
    }

    class Entry {
        final Map<String, Path> files;
        final Set<RelativePath.RelativeDirectory> subdirs;
        final CtSym ctSym;

        private Entry(Map<String, Path> files, Set<RelativePath.RelativeDirectory> subdirs, CtSym ctSym) {
            this.files = files;
            this.subdirs = subdirs;
            this.ctSym = ctSym;
        }
    }
}

