/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.jvm;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Pair;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;

public class JNIWriter {
    protected static final Context.Key<JNIWriter> jniWriterKey = new Context.Key();
    private final JavaFileManager fileManager;
    Types types;
    Symtab syms;
    private final Log log;
    private boolean verbose;
    private boolean checkAll;
    private Context context;
    private static final boolean isWindows = System.getProperty("os.name").startsWith("Windows");

    public static JNIWriter instance(Context context) {
        JNIWriter instance = context.get(jniWriterKey);
        if (instance == null) {
            instance = new JNIWriter(context);
        }
        return instance;
    }

    private JNIWriter(Context context) {
        context.put(jniWriterKey, this);
        this.fileManager = context.get(JavaFileManager.class);
        this.log = Log.instance(context);
        Options options = Options.instance(context);
        this.verbose = options.isSet(Option.VERBOSE);
        this.checkAll = options.isSet("javah:full");
        this.context = context;
    }

    private void lazyInit() {
        if (this.types == null) {
            this.types = Types.instance(this.context);
        }
        if (this.syms == null) {
            this.syms = Symtab.instance(this.context);
        }
    }

    static boolean isSynthetic(Symbol s) {
        return JNIWriter.hasFlag(s, 4096);
    }

    static boolean isStatic(Symbol s) {
        return JNIWriter.hasFlag(s, 8);
    }

    static boolean isFinal(Symbol s) {
        return JNIWriter.hasFlag(s, 16);
    }

    static boolean isNative(Symbol s) {
        return JNIWriter.hasFlag(s, 256);
    }

    private static boolean hasFlag(Symbol m, int flag) {
        return (m.flags() & (long)flag) != 0L;
    }

    public boolean needsHeader(Symbol.ClassSymbol c) {
        this.lazyInit();
        if (c.isLocal() || JNIWriter.isSynthetic(c)) {
            return false;
        }
        return this.checkAll ? this.needsHeader(c.outermostClass(), true) : this.needsHeader(c, false);
    }

    private boolean needsHeader(Symbol.ClassSymbol c, boolean checkNestedClasses) {
        if (c.isLocal() || JNIWriter.isSynthetic(c)) {
            return false;
        }
        for (Symbol sym : c.members_field.getSymbols(Scope.LookupKind.NON_RECURSIVE)) {
            if (sym.kind == Kinds.Kind.MTH && JNIWriter.isNative(sym)) {
                return true;
            }
            for (Attribute.Compound a : sym.getDeclarationAttributes()) {
                if (a.type.tsym != this.syms.nativeHeaderType.tsym) continue;
                return true;
            }
        }
        if (checkNestedClasses) {
            for (Symbol sym : c.members_field.getSymbols(Scope.LookupKind.NON_RECURSIVE)) {
                if (sym.kind != Kinds.Kind.TYP || !this.needsHeader((Symbol.ClassSymbol)sym, true)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject write(Symbol.ClassSymbol c) throws IOException {
        String className = c.flatName().toString();
        FileObject outFile = this.fileManager.getFileForOutput(StandardLocation.NATIVE_HEADER_OUTPUT, "", className.replaceAll("[.$]", "_") + ".h", null);
        PrintWriter out = new PrintWriter(outFile.openWriter());
        try {
            this.write(out, c);
            if (this.verbose) {
                this.log.printVerbose("wrote.file", outFile);
            }
            out.close();
            out = null;
        }
        finally {
            if (out != null) {
                out.close();
                outFile.delete();
                outFile = null;
            }
        }
        return outFile;
    }

    public void write(PrintWriter out, Symbol.ClassSymbol sym) throws IOException {
        this.lazyInit();
        try {
            String cname = JNIWriter.encode(sym.fullname, EncoderType.CLASS);
            this.fileTop(out);
            this.includes(out);
            this.guardBegin(out, cname);
            this.cppGuardBegin(out);
            this.writeStatics(out, sym);
            this.writeMethods(out, sym, cname);
            this.cppGuardEnd(out);
            this.guardEnd(out);
        }
        catch (TypeSignature.SignatureException e) {
            throw new IOException(e);
        }
    }

    protected void writeStatics(PrintWriter out, Symbol.ClassSymbol sym) throws IOException {
        ArrayList<Symbol.ClassSymbol> clist = new ArrayList<Symbol.ClassSymbol>();
        Symbol.ClassSymbol cd = sym;
        while (cd != null) {
            clist.add(cd);
            cd = (Symbol.ClassSymbol)cd.getSuperclass().tsym;
        }
        Collections.reverse(clist);
        for (Symbol.ClassSymbol cd2 : clist) {
            for (Symbol i : cd2.getEnclosedElements()) {
                Symbol.VarSymbol v;
                if (!JNIWriter.isFinal(i) || !i.isStatic() || i.kind != Kinds.Kind.VAR || (v = (Symbol.VarSymbol)i).getConstantValue() == null) continue;
                Pair<Symbol.ClassSymbol, Symbol.VarSymbol> p = new Pair<Symbol.ClassSymbol, Symbol.VarSymbol>(sym, v);
                JNIWriter.printStaticDefines(out, p);
            }
        }
    }

    static void printStaticDefines(PrintWriter out, Pair<Symbol.ClassSymbol, Symbol.VarSymbol> p) {
        Symbol.ClassSymbol cls = (Symbol.ClassSymbol)p.fst;
        Symbol.VarSymbol f = (Symbol.VarSymbol)p.snd;
        Object value = f.getConstantValue();
        String valueStr = null;
        switch (((Type)f.asType()).getKind()) {
            case BOOLEAN: {
                valueStr = (Boolean)value != false ? "1L" : "0L";
                break;
            }
            case BYTE: 
            case SHORT: 
            case INT: {
                valueStr = value.toString() + "L";
                break;
            }
            case LONG: {
                valueStr = value.toString() + (isWindows ? "i64" : "LL");
                break;
            }
            case CHAR: {
                Character ch = (Character)value;
                valueStr = String.valueOf(ch.charValue() & 0xFFFF) + "L";
                break;
            }
            case FLOAT: {
                float fv = ((Float)value).floatValue();
                valueStr = Float.isInfinite(fv) ? (fv < 0.0f ? "-" : "") + "Inff" : value.toString() + "f";
                break;
            }
            case DOUBLE: {
                double d = (Double)value;
                valueStr = Double.isInfinite(d) ? (d < 0.0 ? "-" : "") + "InfD" : value.toString();
                break;
            }
            default: {
                valueStr = null;
            }
        }
        if (valueStr != null) {
            out.print("#undef ");
            String cname = JNIWriter.encode(cls.getQualifiedName(), EncoderType.CLASS);
            String fname = JNIWriter.encode(f.getSimpleName(), EncoderType.FIELDSTUB);
            out.println(cname + "_" + fname);
            out.print("#define " + cname + "_");
            out.println(fname + " " + valueStr);
        }
    }

    protected void writeMethods(PrintWriter out, Symbol.ClassSymbol sym, String cname) throws IOException, TypeSignature.SignatureException {
        List<Symbol> classmethods = sym.getEnclosedElements();
        for (Symbol md : classmethods) {
            if (!JNIWriter.isNative(md)) continue;
            TypeSignature newtypesig = new TypeSignature(this.types);
            Name methodName = md.getSimpleName();
            boolean isOverloaded = false;
            for (Symbol md2 : classmethods) {
                if (md2 == md || !methodName.equals(md2.getSimpleName()) || !JNIWriter.isNative(md2)) continue;
                isOverloaded = true;
            }
            out.println("/*");
            out.println(" * Class:     " + cname);
            out.println(" * Method:    " + JNIWriter.encode(methodName, EncoderType.FIELDSTUB));
            out.println(" * Signature: " + newtypesig.getSignature(md.type));
            out.println(" */");
            out.println("JNIEXPORT " + this.jniType(this.types.erasure(md.type.getReturnType())) + " JNICALL " + this.encodeMethod(md, sym, isOverloaded));
            out.print("  (JNIEnv *, ");
            out.print(md.isStatic() ? "jclass" : "jobject");
            for (Type arg : this.types.erasure(md.type.getParameterTypes())) {
                out.print(", ");
                out.print(this.jniType(arg));
            }
            out.println(");");
            out.println();
        }
    }

    protected final String jniType(Type t) {
        switch (t.getKind()) {
            case ARRAY: {
                Type ct = ((Type.ArrayType)t).getComponentType();
                switch (ct.getKind()) {
                    case BOOLEAN: {
                        return "jbooleanArray";
                    }
                    case BYTE: {
                        return "jbyteArray";
                    }
                    case CHAR: {
                        return "jcharArray";
                    }
                    case SHORT: {
                        return "jshortArray";
                    }
                    case INT: {
                        return "jintArray";
                    }
                    case LONG: {
                        return "jlongArray";
                    }
                    case FLOAT: {
                        return "jfloatArray";
                    }
                    case DOUBLE: {
                        return "jdoubleArray";
                    }
                    case ARRAY: 
                    case DECLARED: {
                        return "jobjectArray";
                    }
                }
                throw new Error(ct.toString());
            }
            case VOID: {
                return "void";
            }
            case BOOLEAN: {
                return "jboolean";
            }
            case BYTE: {
                return "jbyte";
            }
            case CHAR: {
                return "jchar";
            }
            case SHORT: {
                return "jshort";
            }
            case INT: {
                return "jint";
            }
            case LONG: {
                return "jlong";
            }
            case FLOAT: {
                return "jfloat";
            }
            case DOUBLE: {
                return "jdouble";
            }
            case DECLARED: {
                if (t.tsym.type == this.syms.stringType) {
                    return "jstring";
                }
                if (this.types.isAssignable(t, this.syms.throwableType)) {
                    return "jthrowable";
                }
                if (this.types.isAssignable(t, this.syms.classType)) {
                    return "jclass";
                }
                return "jobject";
            }
        }
        Assert.check(false, "jni unknown type");
        return null;
    }

    protected void fileTop(PrintWriter out) {
        out.println("/* DO NOT EDIT THIS FILE - it is machine generated */");
    }

    protected void includes(PrintWriter out) {
        out.println("#include <jni.h>");
    }

    protected void cppGuardBegin(PrintWriter out) {
        out.println("#ifdef __cplusplus");
        out.println("extern \"C\" {");
        out.println("#endif");
    }

    protected void cppGuardEnd(PrintWriter out) {
        out.println("#ifdef __cplusplus");
        out.println("}");
        out.println("#endif");
    }

    protected void guardBegin(PrintWriter out, String cname) {
        out.println("/* Header for class " + cname + " */");
        out.println();
        out.println("#ifndef _Included_" + cname);
        out.println("#define _Included_" + cname);
    }

    protected void guardEnd(PrintWriter out) {
        out.println("#endif");
    }

    String encodeMethod(Symbol msym, Symbol.ClassSymbol clazz, boolean isOverloaded) throws TypeSignature.SignatureException {
        StringBuilder result = new StringBuilder(100);
        result.append("Java_");
        result.append(JNIWriter.encode(clazz.flatname.toString(), EncoderType.JNI));
        result.append('_');
        result.append(JNIWriter.encode(msym.getSimpleName(), EncoderType.JNI));
        if (isOverloaded) {
            TypeSignature typeSig = new TypeSignature(this.types);
            StringBuilder sig = typeSig.getParameterSignature(msym.type);
            result.append("__").append(JNIWriter.encode(sig, EncoderType.JNI));
        }
        return result.toString();
    }

    static String encode(CharSequence name, EncoderType mtype) {
        StringBuilder result = new StringBuilder(100);
        int length = name.length();
        block16: for (int i = 0; i < length; ++i) {
            char ch = name.charAt(i);
            if (JNIWriter.isalnum(ch)) {
                result.append(ch);
                continue;
            }
            switch (mtype) {
                case CLASS: {
                    switch (ch) {
                        case '.': 
                        case '_': {
                            result.append("_");
                            continue block16;
                        }
                        case '$': {
                            result.append("__");
                            continue block16;
                        }
                    }
                    result.append(JNIWriter.encodeChar(ch));
                    continue block16;
                }
                case JNI: {
                    switch (ch) {
                        case '.': 
                        case '/': {
                            result.append("_");
                            continue block16;
                        }
                        case '_': {
                            result.append("_1");
                            continue block16;
                        }
                        case ';': {
                            result.append("_2");
                            continue block16;
                        }
                        case '[': {
                            result.append("_3");
                            continue block16;
                        }
                    }
                    result.append(JNIWriter.encodeChar(ch));
                    continue block16;
                }
                case SIGNATURE: {
                    result.append(JNIWriter.isprint(ch) ? Character.valueOf(ch) : JNIWriter.encodeChar(ch));
                    continue block16;
                }
                case FIELDSTUB: {
                    result.append(ch == '_' ? Character.valueOf(ch) : JNIWriter.encodeChar(ch));
                    continue block16;
                }
                default: {
                    result.append(JNIWriter.encodeChar(ch));
                }
            }
        }
        return result.toString();
    }

    static String encodeChar(char ch) {
        int i;
        String s = Integer.toHexString(ch);
        int nzeros = 5 - s.length();
        char[] result = new char[6];
        result[0] = 95;
        for (i = 1; i <= nzeros; ++i) {
            result[i] = 48;
        }
        i = nzeros + 1;
        int j = 0;
        while (i < 6) {
            result[i] = s.charAt(j);
            ++i;
            ++j;
        }
        return new String(result);
    }

    private static boolean isalnum(char ch) {
        return ch <= '\u007f' && (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9');
    }

    private static boolean isprint(char ch) {
        return ch >= ' ' && ch <= '~';
    }

    static class SimpleTypeVisitor<R, P>
    implements Type.Visitor<R, P> {
        protected final R DEFAULT_VALUE;

        protected SimpleTypeVisitor() {
            this.DEFAULT_VALUE = null;
        }

        protected SimpleTypeVisitor(R defaultValue) {
            this.DEFAULT_VALUE = defaultValue;
        }

        protected R defaultAction(Type t, P p) {
            return this.DEFAULT_VALUE;
        }

        @Override
        public R visitClassType(Type.ClassType t, P p) {
            return this.defaultAction(t, p);
        }

        @Override
        public R visitWildcardType(Type.WildcardType t, P p) {
            return this.defaultAction(t, p);
        }

        @Override
        public R visitArrayType(Type.ArrayType t, P p) {
            return this.defaultAction(t, p);
        }

        @Override
        public R visitMethodType(Type.MethodType t, P p) {
            return this.defaultAction(t, p);
        }

        @Override
        public R visitPackageType(Type.PackageType t, P p) {
            return this.defaultAction(t, p);
        }

        @Override
        public R visitTypeVar(Type.TypeVar t, P p) {
            return this.defaultAction(t, p);
        }

        @Override
        public R visitCapturedType(Type.CapturedType t, P p) {
            return this.defaultAction(t, p);
        }

        @Override
        public R visitForAll(Type.ForAll t, P p) {
            return this.defaultAction(t, p);
        }

        @Override
        public R visitUndetVar(Type.UndetVar t, P p) {
            return this.defaultAction(t, p);
        }

        @Override
        public R visitErrorType(Type.ErrorType t, P p) {
            return this.defaultAction(t, p);
        }

        @Override
        public R visitType(Type t, P p) {
            return this.defaultAction(t, p);
        }
    }

    private static class TypeSignature {
        JavacElements elems;
        Types types;
        private static final String SIG_VOID = "V";
        private static final String SIG_BOOLEAN = "Z";
        private static final String SIG_BYTE = "B";
        private static final String SIG_CHAR = "C";
        private static final String SIG_SHORT = "S";
        private static final String SIG_INT = "I";
        private static final String SIG_LONG = "J";
        private static final String SIG_FLOAT = "F";
        private static final String SIG_DOUBLE = "D";
        private static final String SIG_ARRAY = "[";
        private static final String SIG_CLASS = "L";

        public TypeSignature(Types types) {
            this.types = types;
        }

        StringBuilder getParameterSignature(Type mType) throws SignatureException {
            StringBuilder result = new StringBuilder();
            for (Type pType : mType.getParameterTypes()) {
                result.append((CharSequence)this.getJvmSignature(pType));
            }
            return result;
        }

        StringBuilder getReturnSignature(Type mType) throws SignatureException {
            return this.getJvmSignature(mType.getReturnType());
        }

        StringBuilder getSignature(Type mType) throws SignatureException {
            StringBuilder sb = new StringBuilder();
            sb.append("(").append((CharSequence)this.getParameterSignature(mType)).append(")");
            sb.append((CharSequence)this.getReturnSignature(mType));
            return sb;
        }

        StringBuilder getJvmSignature(Type type) {
            Type t = this.types.erasure(type);
            StringBuilder sig = new StringBuilder();
            JvmTypeVisitor jv = new JvmTypeVisitor();
            jv.visitType(t, sig);
            return sig;
        }

        static class JvmTypeVisitor
        extends SimpleTypeVisitor<Type, StringBuilder> {
            JvmTypeVisitor() {
            }

            @Override
            public Type visitClassType(Type.ClassType t, StringBuilder s) {
                this.setDeclaredType(t, s);
                return null;
            }

            @Override
            public Type visitArrayType(Type.ArrayType t, StringBuilder s) {
                s.append(TypeSignature.SIG_ARRAY);
                return t.getComponentType().accept(this, s);
            }

            @Override
            public Type visitType(Type t, StringBuilder s) {
                if (t.isPrimitiveOrVoid()) {
                    s.append(this.getJvmPrimitiveSignature(t));
                    return null;
                }
                return t.accept(this, s);
            }

            private void setDeclaredType(Type t, StringBuilder s) {
                String classname = t.tsym.getQualifiedName().toString();
                classname = classname.replace('.', '/');
                s.append(TypeSignature.SIG_CLASS).append(classname).append(";");
            }

            private String getJvmPrimitiveSignature(Type t) {
                switch (t.getKind()) {
                    case VOID: {
                        return TypeSignature.SIG_VOID;
                    }
                    case BOOLEAN: {
                        return TypeSignature.SIG_BOOLEAN;
                    }
                    case BYTE: {
                        return TypeSignature.SIG_BYTE;
                    }
                    case CHAR: {
                        return TypeSignature.SIG_CHAR;
                    }
                    case SHORT: {
                        return TypeSignature.SIG_SHORT;
                    }
                    case INT: {
                        return TypeSignature.SIG_INT;
                    }
                    case LONG: {
                        return TypeSignature.SIG_LONG;
                    }
                    case FLOAT: {
                        return TypeSignature.SIG_FLOAT;
                    }
                    case DOUBLE: {
                        return TypeSignature.SIG_DOUBLE;
                    }
                }
                Assert.error("unknown type: should not happen");
                return null;
            }
        }

        static class SignatureException
        extends Exception {
            private static final long serialVersionUID = 1L;

            SignatureException(String reason) {
                super(reason);
            }
        }
    }

    static enum EncoderType {
        CLASS,
        FIELDSTUB,
        FIELD,
        JNI,
        SIGNATURE;

    }
}

