/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.AbsentInformationException;
import com.sun.source.util.TreePathScanner;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.function.Function;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.debugger.jpda.SourcePathProvider;
import org.openide.util.Exceptions;
import org.openide.util.Pair;

public class EditorContextBridge {
    public static final String FIELD = "field";
    public static final String METHOD = "method";
    public static final String CLASS = "class";
    public static final String LINE = "line";
    private static EditorContext context;

    public static EditorContext getContext() {
        if (context == null) {
            List l = DebuggerManager.getDebuggerManager().lookup(null, EditorContext.class);
            context = (EditorContext)l.get(0);
            int k = l.size();
            for (int i = 1; i < k; ++i) {
                context = new CompoundContextProvider((EditorContext)l.get(i), context);
            }
        }
        return context;
    }

    public static <R, D> R parseExpression(String expression, String url, int line, TreePathScanner<R, D> visitor, D context, SourcePathProvider sp) throws InvalidExpressionException {
        try {
            return (R)EditorContextBridge.getContext().getClass().getMethod("parseExpression", String.class, String.class, Integer.TYPE, TreePathScanner.class, Object.class, SourcePathProvider.class).invoke((Object)EditorContextBridge.getContext(), expression, url, line, visitor, context, sp);
        }
        catch (InvocationTargetException itex) {
            Throwable tex = itex.getTargetException();
            if (tex instanceof RuntimeException) {
                throw (RuntimeException)tex;
            }
            if (tex instanceof InvalidExpressionException) {
                throw (InvalidExpressionException)tex;
            }
            Exceptions.printStackTrace((Throwable)tex);
            return null;
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public static <R, D> R interpretOrCompileCode(String code, String url, int line, TreePathScanner<Boolean, D> canInterpret, TreePathScanner<R, D> interpreter, D context, boolean staticContext, Function<Pair<String, byte[]>, Boolean> compiledClassHandler, SourcePathProvider sp) throws InvalidExpressionException {
        try {
            return (R)EditorContextBridge.getContext().getClass().getMethod("interpretOrCompileCode", String.class, String.class, Integer.TYPE, TreePathScanner.class, TreePathScanner.class, Object.class, Boolean.TYPE, Function.class, SourcePathProvider.class).invoke((Object)EditorContextBridge.getContext(), code, url, line, canInterpret, interpreter, context, staticContext, compiledClassHandler, sp);
        }
        catch (InvocationTargetException itex) {
            Throwable tex = itex.getTargetException();
            if (tex instanceof RuntimeException) {
                throw (RuntimeException)tex;
            }
            if (tex instanceof InvalidExpressionException) {
                throw (InvalidExpressionException)tex;
            }
            Exceptions.printStackTrace((Throwable)tex);
            return null;
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public static String getFileName(LineBreakpoint b) {
        try {
            return new File(new URL(b.getURL()).getFile()).getName();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static boolean showSource(LineBreakpoint b, Object timeStamp) {
        if (b.getLineNumber() < 1) {
            return EditorContextBridge.getContext().showSource(b.getURL(), 1, timeStamp);
        }
        return EditorContextBridge.getContext().showSource(b.getURL(), b.getLineNumber(), timeStamp);
    }

    public static String getRelativePath(JPDAThread thread, String stratumn) {
        try {
            return EditorContextBridge.convertSlash(thread.getSourcePath(stratumn));
        }
        catch (AbsentInformationException e) {
            return EditorContextBridge.getRelativePath(thread.getClassName());
        }
    }

    public static String getRelativePath(CallStackFrame csf, String stratumn) {
        try {
            return EditorContextBridge.convertSlash(csf.getSourcePath(stratumn));
        }
        catch (AbsentInformationException e) {
            return EditorContextBridge.getRelativePath(csf.getClassName());
        }
    }

    public static String getRelativePath(String className) {
        int i = className.indexOf(36);
        if (i > 0) {
            className = className.substring(0, i);
        }
        String sourceName = className.replace('.', '/') + ".java";
        return sourceName;
    }

    private static String convertSlash(String original) {
        return original.replace(File.separatorChar, '/');
    }

    public static int getCurrentOffset() {
        try {
            return (Integer)EditorContextBridge.getContext().getClass().getMethod("getCurrentOffset", new Class[0]).invoke((Object)EditorContextBridge.getContext(), new Object[0]);
        }
        catch (InvocationTargetException itex) {
            Throwable tex = itex.getTargetException();
            if (tex instanceof RuntimeException) {
                throw (RuntimeException)tex;
            }
            Exceptions.printStackTrace((Throwable)tex);
            return 0;
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return 0;
        }
    }

    private static class CompoundAnnotation {
        Object annotation1;
        Object annotation2;
    }

    private static class CompoundContextProvider
    extends EditorContext {
        private EditorContext cp1;
        private EditorContext cp2;

        CompoundContextProvider(EditorContext cp1, EditorContext cp2) {
            this.cp1 = cp1;
            this.cp2 = cp2;
        }

        public void createTimeStamp(Object timeStamp) {
            this.cp1.createTimeStamp(timeStamp);
            this.cp2.createTimeStamp(timeStamp);
        }

        public void disposeTimeStamp(Object timeStamp) {
            this.cp1.disposeTimeStamp(timeStamp);
            this.cp2.disposeTimeStamp(timeStamp);
        }

        public void updateTimeStamp(Object timeStamp, String url) {
            this.cp1.updateTimeStamp(timeStamp, url);
            this.cp2.updateTimeStamp(timeStamp, url);
        }

        public String getCurrentClassName() {
            String s = this.cp1.getCurrentClassName();
            if (s.trim().length() < 1) {
                return this.cp2.getCurrentClassName();
            }
            return s;
        }

        public String getCurrentURL() {
            String s = this.cp1.getCurrentURL();
            if (s.trim().length() < 1) {
                return this.cp2.getCurrentURL();
            }
            return s;
        }

        public String getCurrentFieldName() {
            String s = this.cp1.getCurrentFieldName();
            if (s == null || s.trim().length() < 1) {
                return this.cp2.getCurrentFieldName();
            }
            return s;
        }

        public int getCurrentLineNumber() {
            int i = this.cp1.getCurrentLineNumber();
            if (i < 1) {
                return this.cp2.getCurrentLineNumber();
            }
            return i;
        }

        public int getCurrentOffset() {
            Integer i = null;
            try {
                i = (Integer)this.cp1.getClass().getMethod("getCurrentOffset", new Class[0]).invoke((Object)this.cp1, new Object[0]);
            }
            catch (InvocationTargetException itex) {
                Throwable tex = itex.getTargetException();
                if (tex instanceof RuntimeException) {
                    throw (RuntimeException)tex;
                }
                Exceptions.printStackTrace((Throwable)tex);
                return 0;
            }
            catch (Exception itex) {
                // empty catch block
            }
            if (i == null || i < 1) {
                try {
                    i = (Integer)this.cp2.getClass().getMethod("getCurrentOffset", new Class[0]).invoke((Object)this.cp2, new Object[0]);
                }
                catch (InvocationTargetException itex) {
                    Throwable tex = itex.getTargetException();
                    if (tex instanceof RuntimeException) {
                        throw (RuntimeException)tex;
                    }
                    Exceptions.printStackTrace((Throwable)tex);
                    return 0;
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return 0;
                }
            }
            return i;
        }

        public String getCurrentMethodName() {
            String s = this.cp1.getCurrentMethodName();
            if (s == null || s.trim().length() < 1) {
                return this.cp2.getCurrentMethodName();
            }
            return s;
        }

        public String getSelectedIdentifier() {
            String s = this.cp1.getSelectedIdentifier();
            if (s == null || s.trim().length() < 1) {
                return this.cp2.getSelectedIdentifier();
            }
            return s;
        }

        public String getSelectedMethodName() {
            String s = this.cp1.getSelectedMethodName();
            if (s == null || s.trim().length() < 1) {
                return this.cp2.getSelectedMethodName();
            }
            return s;
        }

        public void removeAnnotation(Object annotation) {
            CompoundAnnotation ca = (CompoundAnnotation)annotation;
            this.cp1.removeAnnotation(ca.annotation1);
            this.cp2.removeAnnotation(ca.annotation2);
        }

        public Object annotate(String sourceName, int lineNumber, String annotationType, Object timeStamp) {
            CompoundAnnotation ca = new CompoundAnnotation();
            ca.annotation1 = this.cp1.annotate(sourceName, lineNumber, annotationType, timeStamp);
            ca.annotation2 = this.cp2.annotate(sourceName, lineNumber, annotationType, timeStamp);
            return ca;
        }

        public <R, D> R parseExpression(String expression, String url, int line, TreePathScanner<R, D> visitor, D context, SourcePathProvider sp) {
            Throwable tex;
            Object ret = null;
            try {
                ret = this.cp1.getClass().getMethod("parseExpression", String.class, String.class, Integer.TYPE, TreePathScanner.class, Object.class, SourcePathProvider.class).invoke((Object)this.cp1, expression, url, line, visitor, context, sp);
            }
            catch (InvocationTargetException itex) {
                tex = itex.getTargetException();
                if (tex instanceof RuntimeException) {
                    throw (RuntimeException)tex;
                }
                Exceptions.printStackTrace((Throwable)tex);
            }
            catch (Exception itex) {
                // empty catch block
            }
            if (ret == null) {
                try {
                    ret = this.cp2.getClass().getMethod("parseExpression", String.class, String.class, Integer.TYPE, TreePathScanner.class, Object.class, SourcePathProvider.class).invoke((Object)this.cp2, expression, url, line, visitor, context, sp);
                }
                catch (InvocationTargetException itex) {
                    tex = itex.getTargetException();
                    if (tex instanceof RuntimeException) {
                        throw (RuntimeException)tex;
                    }
                    Exceptions.printStackTrace((Throwable)tex);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return (R)ret;
        }

        public int getLineNumber(Object annotation, Object timeStamp) {
            int ln = this.cp1.getLineNumber(annotation, timeStamp);
            if (ln >= 0) {
                return ln;
            }
            return this.cp2.getLineNumber(annotation, timeStamp);
        }

        public boolean showSource(String sourceName, int lineNumber, Object timeStamp) {
            return this.cp1.showSource(sourceName, lineNumber, timeStamp) | this.cp2.showSource(sourceName, lineNumber, timeStamp);
        }

        public int getFieldLineNumber(String url, String className, String fieldName) {
            int ln = this.cp1.getFieldLineNumber(url, className, fieldName);
            if (ln != -1) {
                return ln;
            }
            return this.cp2.getFieldLineNumber(url, className, fieldName);
        }

        public String getClassName(String url, int lineNumber) {
            String className = this.cp1.getClassName(url, lineNumber);
            if (className != null && className.length() > 0) {
                return className;
            }
            return this.cp2.getClassName(url, lineNumber);
        }

        public String[] getImports(String url) {
            String[] r1 = this.cp1.getImports(url);
            String[] r2 = this.cp2.getImports(url);
            String[] r = new String[r1.length + r2.length];
            System.arraycopy(r1, 0, r, 0, r1.length);
            System.arraycopy(r2, 0, r, r1.length, r2.length);
            return r;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.cp1.addPropertyChangeListener(l);
            this.cp2.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.cp1.removePropertyChangeListener(l);
            this.cp2.removePropertyChangeListener(l);
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
            this.cp1.addPropertyChangeListener(propertyName, l);
            this.cp2.addPropertyChangeListener(propertyName, l);
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener l) {
            this.cp1.removePropertyChangeListener(propertyName, l);
            this.cp2.removePropertyChangeListener(propertyName, l);
        }

        public EditorContext.Operation[] getOperations(String url, int lineNumber, EditorContext.BytecodeProvider bytecodeProvider) {
            EditorContext.Operation[] operations = this.cp1.getOperations(url, lineNumber, bytecodeProvider);
            if (operations != null) {
                return operations;
            }
            return this.cp2.getOperations(url, lineNumber, bytecodeProvider);
        }

        public EditorContext.MethodArgument[] getArguments(String url, EditorContext.Operation operation) {
            EditorContext.MethodArgument[] args;
            try {
                args = this.cp1.getArguments(url, operation);
            }
            catch (UnsupportedOperationException uoex) {
                args = this.cp2.getArguments(url, operation);
            }
            return args;
        }

        public EditorContext.MethodArgument[] getArguments(String url, int methodLineNumber) {
            EditorContext.MethodArgument[] args;
            try {
                args = this.cp1.getArguments(url, methodLineNumber);
            }
            catch (UnsupportedOperationException uoex) {
                args = this.cp2.getArguments(url, methodLineNumber);
            }
            return args;
        }
    }
}

