/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project.refactoring;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.openide.util.Exceptions;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class JavaCardXMLRefactoringSupport {
    private XPathFactory xpFactory = XPathFactory.newInstance();
    private XPath xPath = this.xpFactory.newXPath();
    private XPathExpression dynamicallyLoadedClassXPression;
    private XPathExpression shareableInterfaceClassXPression;
    private DocumentBuilder docBuilder;
    private Document doc;

    public JavaCardXMLRefactoringSupport() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setIgnoringElementContentWhitespace(true);
        try {
            this.docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Internal error: failed to obtain DocumentBuilder instance.", e);
        }
        try {
            this.dynamicallyLoadedClassXPression = this.xPath.compile("/javacard-app/dynamically-loaded-classes/class/@name");
            this.shareableInterfaceClassXPression = this.xPath.compile("/javacard-app/shareable-interface-classes/class/@name");
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException("Internal initialization failure", e);
        }
    }

    private JavaCardXMLRefactoringSupport(Document doc) {
        this.doc = doc;
    }

    public Document getDocument() {
        return this.doc;
    }

    public static JavaCardXMLRefactoringSupport fromFile(File file) {
        try {
            JavaCardXMLRefactoringSupport supp = new JavaCardXMLRefactoringSupport();
            supp.doc = supp.docBuilder.parse(file);
            return supp;
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public NodeList getDynamicallyLoadedClassElements() {
        try {
            return (NodeList)this.dynamicallyLoadedClassXPression.evaluate(this.doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException ex) {
            return null;
        }
    }

    public NodeList getShareableInterfaceClassElements() {
        try {
            return (NodeList)this.shareableInterfaceClassXPression.evaluate(this.doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException ex) {
            return null;
        }
    }
}

