/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver.toolchains.impl;

import org.clang.basic.SanitizerKind;
import org.clang.driver.Driver;
import org.clang.driver.Tool;
import org.clang.driver.ToolChain;
import org.clang.driver.options;
import org.clang.driver.toolchains.impl.Generic_ELF;
import org.clang.driver.tools.impl.FreebsdStatics;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.option.ArgList;
import org.llvm.option.ArgStringList;
import org.llvm.option.OptSpecifier;

public class FreeBSD
extends Generic_ELF
implements Destructors.ClassWithDestructor {
    public FreeBSD(Driver D, Triple _Triple, ArgList Args) {
        super(D, _Triple, Args);
        if ((_Triple.getArch() == Triple.ArchType.x86 || _Triple.getArch() == Triple.ArchType.ppc) && D.getVFS().exists(new Twine(std.$add_string$C_T((std.string)this.getDriver().SysRoot, (String)"/usr/lib32/crt1.o")))) {
            this.getFilePaths().push_back((Object)std.$add_string$C_T((std.string)this.getDriver().SysRoot, (String)"/usr/lib32"));
        } else {
            this.getFilePaths().push_back((Object)std.$add_string$C_T((std.string)this.getDriver().SysRoot, (String)"/usr/lib"));
        }
    }

    @Override
    public boolean HasNativeLLVMSupport() {
        return true;
    }

    @Override
    public boolean IsMathErrnoDefault() {
        return false;
    }

    @Override
    public boolean IsObjCNonFragileABIDefault() {
        return true;
    }

    @Override
    public ToolChain.CXXStdlibType GetDefaultCXXStdlibType() {
        if (Unsigned.$greatereq_uint((int)this.getTriple().getOSMajorVersion(), (int)10)) {
            return ToolChain.CXXStdlibType.CST_Libcxx;
        }
        return ToolChain.CXXStdlibType.CST_Libstdcxx;
    }

    @Override
    public void AddClangCXXStdlibIncludeArgs(ArgList DriverArgs, ArgStringList CC1Args) {
        if (DriverArgs.hasArg(new OptSpecifier(options.ID.OPT_nostdlibinc.getValue())) || DriverArgs.hasArg(new OptSpecifier(options.ID.OPT_nostdincxx.getValue()))) {
            return;
        }
        switch (this.GetCXXStdlibType(DriverArgs)) {
            case CST_Libcxx: {
                FreeBSD.addSystemInclude(DriverArgs, CC1Args, new Twine(std.$add_string$C_T((std.string)this.getDriver().SysRoot, (String)"/usr/include/c++/v1")));
                break;
            }
            case CST_Libstdcxx: {
                FreeBSD.addSystemInclude(DriverArgs, CC1Args, new Twine(std.$add_string$C_T((std.string)this.getDriver().SysRoot, (String)"/usr/include/c++/4.2")));
                FreeBSD.addSystemInclude(DriverArgs, CC1Args, new Twine(std.$add_string$C_T((std.string)this.getDriver().SysRoot, (String)"/usr/include/c++/4.2/backward")));
            }
        }
    }

    @Override
    public void AddCXXStdlibLibArgs(ArgList Args, ArgStringList CmdArgs) {
        ToolChain.CXXStdlibType Type2 = this.GetCXXStdlibType(Args);
        boolean Profiling = Args.hasArg(new OptSpecifier(options.ID.OPT_pg.getValue()));
        switch (Type2) {
            case CST_Libcxx: {
                CmdArgs.push_back((Object)(Profiling ? NativePointer.$((String)"-lc++_p") : NativePointer.$((String)"-lc++")));
                break;
            }
            case CST_Libstdcxx: {
                CmdArgs.push_back((Object)(Profiling ? NativePointer.$((String)"-lstdc++_p") : NativePointer.$((String)"-lstdc++")));
            }
        }
    }

    @Override
    public boolean UseSjLjExceptions(ArgList Args) {
        switch (this.getTriple().getEnvironment()) {
            case GNUEABIHF: 
            case GNUEABI: 
            case EABI: {
                return false;
            }
        }
        return this.getTriple().getArch() == Triple.ArchType.arm || this.getTriple().getArch() == Triple.ArchType.thumb;
    }

    @Override
    public boolean isPIEDefault() {
        return this.getSanitizerArgs().requiresPIE();
    }

    @Override
    public long getSupportedSanitizers() {
        boolean IsX86 = this.getTriple().getArch() == Triple.ArchType.x86;
        boolean IsX86_64 = this.getTriple().getArch() == Triple.ArchType.x86_64;
        boolean IsMIPS64 = this.getTriple().getArch() == Triple.ArchType.mips64 || this.getTriple().getArch() == Triple.ArchType.mips64el;
        long Res = super.getSupportedSanitizers();
        Res |= SanitizerKind.Address;
        Res |= SanitizerKind.Vptr;
        if (IsX86_64 || IsMIPS64) {
            Res |= SanitizerKind.Leak;
            Res |= SanitizerKind.Thread;
        }
        if (IsX86 || IsX86_64) {
            Res |= SanitizerKind.SafeStack;
        }
        return Res;
    }

    @Override
    public int GetDefaultDwarfVersion() {
        return 2;
    }

    @Override
    public boolean GetDefaultStandaloneDebug() {
        return true;
    }

    @Override
    protected Tool buildAssembler() {
        return new FreebsdStatics.Assembler(this);
    }

    @Override
    protected Tool buildLinker() {
        return new FreebsdStatics.Linker(this);
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    @Override
    public String toString() {
        return "" + super.toString();
    }
}

