/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.codeception.coverage;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.codeception.coverage.ClassMetricsImpl;
import org.netbeans.modules.php.codeception.coverage.CoverageImpl;
import org.netbeans.modules.php.codeception.coverage.CoverageMetricsImpl;
import org.netbeans.modules.php.codeception.coverage.FileMetricsImpl;
import org.openide.filesystems.FileUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class CodeceptionCoverageLogParser
extends DefaultHandler {
    private static final Logger LOGGER = Logger.getLogger(CodeceptionCoverageLogParser.class.getName());
    final XMLReader xmlReader;
    private final CoverageImpl coverage;
    private CoverageImpl.FileImpl file;
    private CoverageImpl.ClassImpl clazz;
    private Content content = null;

    private CodeceptionCoverageLogParser(CoverageImpl coverage) throws SAXException {
        assert (coverage != null);
        this.coverage = coverage;
        this.xmlReader = FileUtils.createXmlReader();
    }

    public static void parse(Reader reader, CoverageImpl coverage) {
        try {
            CodeceptionCoverageLogParser parser = new CodeceptionCoverageLogParser(coverage);
            parser.xmlReader.setContentHandler(parser);
            parser.xmlReader.parse(new InputSource(reader));
        }
        catch (SAXException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        catch (Throwable ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("coverage".equals(qName)) {
            this.processCoverage(attributes);
        } else if ("file".equals(qName)) {
            this.processFile(attributes);
        } else if ("class".equals(qName)) {
            this.processClass(attributes);
        } else if ("metrics".equals(qName)) {
            this.processMetrics(attributes);
        } else if ("line".equals(qName)) {
            this.processLine(attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("file".equals(qName)) {
            this.endFile();
        } else if ("class".equals(qName)) {
            this.endClass();
        }
    }

    private void processCoverage(Attributes attributes) {
        assert (this.content == null);
        this.content = Content.COVERAGE;
        this.coverage.setGenerated(this.getGenerated(attributes));
    }

    private void processFile(Attributes attributes) {
        assert (this.content.equals((Object)Content.COVERAGE));
        assert (this.file == null);
        this.content = Content.FILE;
        this.file = new CoverageImpl.FileImpl(this.getPath(attributes));
        this.coverage.addFile(this.file);
    }

    private void processClass(Attributes attributes) {
        assert (this.content.equals((Object)Content.FILE));
        assert (this.file != null);
        assert (this.clazz == null);
        this.content = Content.CLASS;
        this.clazz = new CoverageImpl.ClassImpl(this.getName(attributes), this.getNamespace(attributes));
        this.file.addClass(this.clazz);
    }

    private void processMetrics(Attributes attributes) {
        assert (this.content != null);
        switch (this.content) {
            case COVERAGE: {
                assert (this.file == null);
                assert (this.clazz == null);
                this.coverage.setMetrics(new CoverageMetricsImpl(this.getFiles(attributes), this.getLoc(attributes), this.getNcloc(attributes), this.getClasses(attributes), this.getMethods(attributes), this.getCoveredMethods(attributes), this.getConditionals(attributes), this.getCoveredConditionals(attributes), this.getStatements(attributes), this.getCoveredStatements(attributes), this.getElements(attributes), this.getCoveredElements(attributes)));
                break;
            }
            case FILE: {
                assert (this.file != null);
                assert (this.clazz == null);
                this.file.setMetrics(new FileMetricsImpl(this.getLoc(attributes), this.getNcloc(attributes), this.getClasses(attributes), this.getMethods(attributes), this.getCoveredMethods(attributes), this.getConditionals(attributes), this.getCoveredConditionals(attributes), this.getStatements(attributes), this.getCoveredStatements(attributes), this.getElements(attributes), this.getCoveredElements(attributes)));
                break;
            }
            case CLASS: {
                assert (this.file != null);
                assert (this.clazz != null);
                this.clazz.setMetrics(new ClassMetricsImpl(this.getMethods(attributes), this.getCoveredMethods(attributes), this.getConditionals(attributes), this.getCoveredConditionals(attributes), this.getStatements(attributes), this.getCoveredStatements(attributes), this.getElements(attributes), this.getCoveredElements(attributes)));
                break;
            }
            default: {
                assert (false) : "Unknown content type: " + (Object)((Object)this.content);
                break;
            }
        }
    }

    private void processLine(Attributes attributes) {
        assert (this.file != null);
        assert (this.clazz == null);
        this.file.addLine(new CoverageImpl.LineImpl(this.getNum(attributes), this.getType(attributes), this.getName(attributes), this.getCrap(attributes), this.getCount(attributes)));
    }

    private void endFile() {
        assert (this.content.equals((Object)Content.FILE));
        assert (this.file != null);
        this.file = null;
        this.content = Content.COVERAGE;
    }

    private void endClass() {
        assert (this.content.equals((Object)Content.CLASS));
        assert (this.clazz != null);
        this.clazz = null;
        this.content = Content.FILE;
    }

    private long getGenerated(Attributes attributes) {
        return this.getLong(attributes, "generated");
    }

    private String getPath(Attributes attributes) {
        return FileUtil.normalizeFile((File)new File(attributes.getValue("name"))).getAbsolutePath();
    }

    private String getName(Attributes attributes) {
        return attributes.getValue("name");
    }

    private String getNamespace(Attributes attributes) {
        return attributes.getValue("namespace");
    }

    private int getNum(Attributes attributes) {
        return this.getInt(attributes, "num");
    }

    private String getType(Attributes attributes) {
        return attributes.getValue("type");
    }

    private int getCrap(Attributes attributes) {
        return this.getInt(attributes, "crap");
    }

    private int getCount(Attributes attributes) {
        return this.getInt(attributes, "count");
    }

    private int getFiles(Attributes attributes) {
        return this.getInt(attributes, "files");
    }

    private int getLoc(Attributes attributes) {
        return this.getInt(attributes, "loc");
    }

    private int getNcloc(Attributes attributes) {
        return this.getInt(attributes, "ncloc");
    }

    private int getClasses(Attributes attributes) {
        return this.getInt(attributes, "classes");
    }

    private int getMethods(Attributes attributes) {
        return this.getInt(attributes, "methods");
    }

    private int getCoveredMethods(Attributes attributes) {
        return this.getInt(attributes, "coveredmethods");
    }

    private int getConditionals(Attributes attributes) {
        return this.getInt(attributes, "conditionals");
    }

    private int getCoveredConditionals(Attributes attributes) {
        return this.getInt(attributes, "coveredconditionals");
    }

    private int getStatements(Attributes attributes) {
        return this.getInt(attributes, "statements");
    }

    private int getCoveredStatements(Attributes attributes) {
        return this.getInt(attributes, "coveredstatements");
    }

    private int getElements(Attributes attributes) {
        return this.getInt(attributes, "elements");
    }

    private int getCoveredElements(Attributes attributes) {
        return this.getInt(attributes, "coveredelements");
    }

    private int getInt(Attributes attributes, String name) {
        int i = -1;
        try {
            i = Integer.parseInt(attributes.getValue(name));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return i;
    }

    private long getLong(Attributes attributes, String name) {
        long l = -1L;
        try {
            l = Long.parseLong(attributes.getValue(name));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return l;
    }

    private static enum Content {
        COVERAGE,
        FILE,
        CLASS;

    }
}

