/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.commands;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.groovy.grailsproject.GrailsProject;
import org.netbeans.modules.groovy.grailsproject.commands.GrailsCommand;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class GrailsCommandChooser
extends JPanel {
    private static final Object NO_TASK_ITEM = GrailsCommandChooser.getMessage("GrailsCommandChooser.no.matching.task", new String[0]);
    private static boolean debug;
    private static String lastTask;
    private static Map<String, Map<GrailsCommand, ParameterContainer>> prjToTask;
    private final GrailsProject project;
    private final List<GrailsCommand> allTasks = new ArrayList<GrailsCommand>();
    private JButton runButton;
    private boolean refreshNeeded;
    private JCheckBox debugCheckbox;
    private JLabel matchingTaskLabel;
    private JList matchingTaskList;
    private JScrollPane matchingTaskSP;
    private JTextField rakeTaskField;
    private JPanel rakeTaskFieldPanel;
    private JLabel rakeTaskHint;
    private JLabel rakeTaskLabel;
    private JLabel taskParamLabel;
    private JComboBox taskParametersComboBox;

    public static CommandDescriptor select(GrailsProject project) {
        assert (EventQueue.isDispatchThread()) : "must be called from EDT";
        final JButton runButton = new JButton(GrailsCommandChooser.getMessage("GrailsCommandChooser.runButton", new String[0]));
        final GrailsCommandChooser chooserPanel = new GrailsCommandChooser(project, runButton);
        String title = GrailsCommandChooser.getMessage("GrailsCommandChooser.title", ProjectUtils.getInformation((Project)project).getDisplayName());
        runButton.getAccessibleContext().setAccessibleDescription(GrailsCommandChooser.getMessage("GrailsCommandChooser.runButton.accessibleDescription", new String[0]));
        GrailsCommandChooser.setRunButtonState(runButton, chooserPanel);
        chooserPanel.matchingTaskList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                GrailsCommandChooser.setRunButtonState(runButton, chooserPanel);
                chooserPanel.initTaskParameters();
            }
        });
        final JButton refreshButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)refreshButton, (String)GrailsCommandChooser.getMessage("GrailsCommandChooser.refreshButton", new String[0]));
        refreshButton.getAccessibleContext().setAccessibleDescription(GrailsCommandChooser.getMessage("GrailsCommandChooser.refreshButton.accessibleDescription", new String[0]));
        refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                refreshButton.setEnabled(false);
                runButton.setEnabled(false);
                chooserPanel.reloadTasks(new Runnable(){

                    @Override
                    public void run() {
                        assert (EventQueue.isDispatchThread()) : "is EDT";
                        refreshButton.setEnabled(true);
                        GrailsCommandChooser.setRunButtonState(runButton, chooserPanel);
                    }
                });
            }
        });
        Object[] options = new Object[]{refreshButton, runButton, DialogDescriptor.CANCEL_OPTION};
        DialogDescriptor descriptor = new DialogDescriptor((Object)chooserPanel, title, true, options, (Object)runButton, 0, null, null);
        descriptor.setClosingOptions(new Object[]{runButton, DialogDescriptor.CANCEL_OPTION});
        Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        dialog.getAccessibleContext().setAccessibleName(GrailsCommandChooser.getMessage("GrailsCommandChooser.accessibleName", new String[0]));
        dialog.getAccessibleContext().setAccessibleDescription(GrailsCommandChooser.getMessage("GrailsCommandChooser.accessibleDescription", new String[0]));
        if (chooserPanel.refreshNeeded) {
            refreshButton.setEnabled(false);
            runButton.setEnabled(false);
            chooserPanel.reloadTasks(new Runnable(){

                @Override
                public void run() {
                    assert (EventQueue.isDispatchThread()) : "is EDT";
                    refreshButton.setEnabled(true);
                    GrailsCommandChooser.setRunButtonState(runButton, chooserPanel);
                }
            });
        }
        dialog.setVisible(true);
        if (descriptor.getValue() == runButton) {
            GrailsCommand task = chooserPanel.getSelectedTask();
            debug = chooserPanel.debugCheckbox.isSelected();
            lastTask = task.getCommand();
            chooserPanel.storeParameters();
            return new CommandDescriptor(task, chooserPanel.getParameters(), debug);
        }
        return null;
    }

    private void initTaskParameters() {
        GrailsCommand task = this.getSelectedTask();
        ArrayList<String> params = new ArrayList<String>();
        params.add("");
        params.addAll(this.getStoredParams(task));
        this.taskParametersComboBox.setModel(new DefaultComboBoxModel<Object>(params.toArray()));
        this.preselectLastSelectedParam(task);
    }

    private void preselectLastSelectedParam(GrailsCommand task) {
        ParameterContainer params = this.getTasksToParams().get(task);
        if (params == null) {
            return;
        }
        String lastSelected = params.getLastSelected();
        if (lastSelected == null) {
            this.taskParametersComboBox.setSelectedItem("");
            return;
        }
        for (int i = 0; i < this.taskParametersComboBox.getItemCount(); ++i) {
            Object item = this.taskParametersComboBox.getItemAt(i);
            if (!item.equals(lastSelected)) continue;
            this.taskParametersComboBox.setSelectedIndex(i);
            break;
        }
    }

    private Map<GrailsCommand, ParameterContainer> getTasksToParams() {
        String prjDir = this.project.getProjectDirectory().getPath();
        Map<GrailsCommand, ParameterContainer> result = prjToTask.get(prjDir);
        if (result == null) {
            result = new HashMap<GrailsCommand, ParameterContainer>();
            prjToTask.put(prjDir, result);
        }
        return result;
    }

    private List<String> getStoredParams(GrailsCommand task) {
        if (task == null) {
            return Collections.emptyList();
        }
        Map<GrailsCommand, ParameterContainer> tasksToParams = this.getTasksToParams();
        if (tasksToParams == null) {
            return Collections.emptyList();
        }
        ParameterContainer stored = tasksToParams.get(task);
        if (stored == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(stored.getParams());
        Collections.sort(result);
        return result;
    }

    private String getParameters() {
        Object selected = this.taskParametersComboBox.getSelectedItem();
        return selected.toString().trim();
    }

    private static void setRunButtonState(JButton runButton, GrailsCommandChooser chooserPanel) {
        runButton.setEnabled(chooserPanel.getSelectedTask() != null);
    }

    private GrailsCommandChooser(GrailsProject project, JButton runButton) {
        this.runButton = runButton;
        this.project = project;
        this.initComponents();
        this.matchingTaskList.setCellRenderer(new GrailsCommandRenderer());
        this.debugCheckbox.setSelected(debug);
        this.refreshNeeded = this.reloadAllTasks();
        this.refreshTaskList();
        this.rakeTaskField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                GrailsCommandChooser.this.refreshTaskList();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                GrailsCommandChooser.this.refreshTaskList();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                GrailsCommandChooser.this.refreshTaskList();
            }
        });
        this.preselectLastlySelected();
        this.initTaskParameters();
    }

    private void storeParameters() {
        ParameterContainer params;
        String prjDir = this.project.getProjectDirectory().getPath();
        Map<GrailsCommand, ParameterContainer> taskToParams = prjToTask.get(prjDir);
        if (taskToParams == null) {
            taskToParams = new HashMap<GrailsCommand, ParameterContainer>();
            prjToTask.put(prjDir, taskToParams);
        }
        if ((params = taskToParams.get(this.getSelectedTask())) == null) {
            params = new ParameterContainer();
            taskToParams.put(this.getSelectedTask(), params);
        }
        String currentParam = this.getParameters();
        params.addParam(currentParam);
        params.setLastSelected(currentParam);
    }

    private void preselectLastlySelected() {
        if (lastTask == null) {
            return;
        }
        for (GrailsCommand task : this.allTasks) {
            if (!lastTask.equals(task.getCommand())) continue;
            this.matchingTaskList.setSelectedValue(task, true);
            break;
        }
        this.initTaskParameters();
    }

    private boolean reloadAllTasks() {
        this.allTasks.clear();
        List<GrailsCommand> commands = this.project.getCommandSupport().getGrailsCommands();
        if (commands != null) {
            this.allTasks.addAll(commands);
            return false;
        }
        return true;
    }

    private void refreshTaskList() {
        String filter = this.rakeTaskField.getText().trim();
        DefaultListModel<Object> model = new DefaultListModel<Object>();
        List<GrailsCommand> matching = Filter.getFilteredTasks(this.allTasks, filter);
        for (GrailsCommand task : matching) {
            model.addElement(task);
        }
        this.matchingTaskList.setModel(model);
        if (model.isEmpty()) {
            model.addElement(NO_TASK_ITEM);
        }
        this.matchingTaskList.setSelectedIndex(0);
        this.initTaskParameters();
    }

    private void reloadTasks(final Runnable uiFinishAction) {
        final Object task = this.matchingTaskList.getSelectedValue();
        final JComponent[] comps = new JComponent[]{this.matchingTaskSP, this.matchingTaskLabel, this.matchingTaskLabel, this.matchingTaskList, this.rakeTaskLabel, this.rakeTaskField, this.debugCheckbox, this.taskParamLabel, this.taskParametersComboBox, this.rakeTaskHint};
        this.setEnabled(comps, false);
        this.matchingTaskList.setListData(new Object[]{GrailsCommandChooser.getMessage("GrailsCommandChooser.reloading.tasks", new String[0])});
        this.project.getCommandSupport().refreshGrailsCommandsLater(new Runnable(){

            @Override
            public void run() {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GrailsCommandChooser.this.reloadAllTasks();
                        GrailsCommandChooser.this.refreshTaskList();
                        GrailsCommandChooser.this.matchingTaskList.setSelectedValue(task, true);
                        uiFinishAction.run();
                        GrailsCommandChooser.this.setEnabled(comps, true);
                        GrailsCommandChooser.this.rakeTaskField.requestFocus();
                    }
                });
            }
        });
    }

    private void setEnabled(JComponent[] comps, boolean enabled) {
        for (JComponent comp : comps) {
            comp.setEnabled(enabled);
        }
    }

    private GrailsCommand getSelectedTask() {
        Object val = this.matchingTaskList.getSelectedValue();
        if (val != null && !NO_TASK_ITEM.equals(val)) {
            return (GrailsCommand)val;
        }
        return null;
    }

    private static String getMessage(String key, String ... args) {
        return NbBundle.getMessage(GrailsCommandChooser.class, (String)key, (Object[])args);
    }

    private void initComponents() {
        this.rakeTaskLabel = new JLabel();
        this.taskParamLabel = new JLabel();
        this.matchingTaskLabel = new JLabel();
        this.matchingTaskSP = new JScrollPane();
        this.matchingTaskList = new JList();
        this.rakeTaskFieldPanel = new JPanel();
        this.rakeTaskField = new JTextField();
        this.rakeTaskHint = new JLabel();
        this.taskParametersComboBox = new JComboBox();
        this.debugCheckbox = new JCheckBox();
        this.rakeTaskLabel.setLabelFor(this.rakeTaskField);
        Mnemonics.setLocalizedText((JLabel)this.rakeTaskLabel, (String)NbBundle.getMessage(GrailsCommandChooser.class, (String)"GrailsCommandChooser.rakeTaskLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.taskParamLabel, (String)NbBundle.getMessage(GrailsCommandChooser.class, (String)"GrailsCommandChooser.taskParamLabel.text"));
        this.matchingTaskLabel.setLabelFor(this.matchingTaskList);
        Mnemonics.setLocalizedText((JLabel)this.matchingTaskLabel, (String)NbBundle.getMessage(GrailsCommandChooser.class, (String)"GrailsCommandChooser.matchingTaskLabel.text"));
        this.matchingTaskList.setFont(new Font("Monospaced", 0, 12));
        this.matchingTaskList.setSelectionMode(0);
        this.matchingTaskList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                GrailsCommandChooser.this.matchingTaskListMouseClicked(evt);
            }
        });
        this.matchingTaskSP.setViewportView(this.matchingTaskList);
        this.rakeTaskFieldPanel.setLayout(new BorderLayout());
        this.rakeTaskField.setText(NbBundle.getMessage(GrailsCommandChooser.class, (String)"GrailsCommandChooser.rakeTaskField.text"));
        this.rakeTaskField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                GrailsCommandChooser.this.rakeTaskFieldKeyPressed(evt);
            }
        });
        this.rakeTaskFieldPanel.add((Component)this.rakeTaskField, "North");
        Mnemonics.setLocalizedText((JLabel)this.rakeTaskHint, (String)NbBundle.getMessage(GrailsCommandChooser.class, (String)"GrailsCommandChooser.rakeTaskHint.text"));
        this.rakeTaskFieldPanel.add((Component)this.rakeTaskHint, "South");
        this.taskParametersComboBox.setEditable(true);
        this.taskParametersComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        Mnemonics.setLocalizedText((AbstractButton)this.debugCheckbox, (String)NbBundle.getMessage(GrailsCommandChooser.class, (String)"GrailsCommandChooser.debugCheckbox.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.matchingTaskSP, GroupLayout.Alignment.LEADING, -1, 677, Short.MAX_VALUE).addComponent(this.debugCheckbox, GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rakeTaskLabel).addComponent(this.taskParamLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.taskParametersComboBox, 0, 575, Short.MAX_VALUE).addComponent(this.rakeTaskFieldPanel, -1, 575, Short.MAX_VALUE))).addComponent(this.matchingTaskLabel, GroupLayout.Alignment.LEADING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rakeTaskLabel).addComponent(this.rakeTaskFieldPanel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.taskParamLabel).addComponent(this.taskParametersComboBox, -2, 21, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.matchingTaskLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.matchingTaskSP, -1, 352, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.debugCheckbox).addContainerGap()));
    }

    private void handleNavigationKeys(KeyEvent evt) {
        Object actionKey = this.matchingTaskList.getInputMap().get(KeyStroke.getKeyStrokeForEvent(evt));
        boolean isListScrollAction = "selectPreviousRow".equals(actionKey) || "selectPreviousRowExtendSelection".equals(actionKey) || "selectNextRow".equals(actionKey) || "selectNextRowExtendSelection".equals(actionKey) || "scrollUp".equals(actionKey) || "scrollUpExtendSelection".equals(actionKey) || "scrollDown".equals(actionKey) || "scrollDownExtendSelection".equals(actionKey);
        int selectedIndex = this.matchingTaskList.getSelectedIndex();
        ListModel model = this.matchingTaskList.getModel();
        int modelSize = model.getSize();
        if ("selectNextRow".equals(actionKey) && selectedIndex == modelSize - 1) {
            this.matchingTaskList.setSelectedIndex(0);
            this.matchingTaskList.ensureIndexIsVisible(0);
            return;
        }
        if ("selectPreviousRow".equals(actionKey) && selectedIndex == 0) {
            int last = modelSize - 1;
            this.matchingTaskList.setSelectedIndex(last);
            this.matchingTaskList.ensureIndexIsVisible(last);
            return;
        }
        if (isListScrollAction) {
            Action action = this.matchingTaskList.getActionMap().get(actionKey);
            action.actionPerformed(new ActionEvent(this.matchingTaskList, 0, (String)actionKey));
            evt.consume();
        }
    }

    private void rakeTaskFieldKeyPressed(KeyEvent evt) {
        this.handleNavigationKeys(evt);
    }

    private void matchingTaskListMouseClicked(MouseEvent evt) {
        if (this.runButton.isEnabled() && evt.getClickCount() == 2) {
            this.runButton.doClick();
        }
    }

    static {
        prjToTask = new HashMap<String, Map<GrailsCommand, ParameterContainer>>();
    }

    private static class ParameterContainer {
        private final Set<String> params = new HashSet<String>();
        private String lastSelected;

        private ParameterContainer() {
        }

        public void addParam(String param) {
            this.params.add(param);
        }

        public String getLastSelected() {
            return this.lastSelected;
        }

        public void setLastSelected(String lastSelected) {
            this.lastSelected = lastSelected;
        }

        public Set<String> getParams() {
            return this.params;
        }
    }

    static final class Filter {
        private final String filter;
        private final List<GrailsCommand> tasks;

        private Filter(List<GrailsCommand> tasks, String filter) {
            this.tasks = tasks;
            this.filter = filter;
        }

        static List<GrailsCommand> getFilteredTasks(List<GrailsCommand> allTasks, String filter) {
            Filter f = new Filter(allTasks, filter);
            return f.filter();
        }

        private List<GrailsCommand> filter() {
            ArrayList<GrailsCommand> matching = new ArrayList<GrailsCommand>();
            Pattern pattern = this.getPattern();
            if (pattern != null) {
                for (GrailsCommand task : this.tasks) {
                    Matcher m = pattern.matcher(task.getCommand());
                    if (!m.matches()) continue;
                    matching.add(task);
                }
            } else {
                ArrayList<GrailsCommand> exact = new ArrayList<GrailsCommand>();
                for (GrailsCommand task : this.tasks) {
                    String filterLC;
                    String taskLC = task.getCommand().toLowerCase(Locale.ENGLISH);
                    if (taskLC.startsWith(filterLC = this.filter.toLowerCase(Locale.ENGLISH))) {
                        exact.add(task);
                        continue;
                    }
                    if (!taskLC.contains(filterLC)) continue;
                    matching.add(task);
                }
                matching.addAll(0, exact);
            }
            return matching;
        }

        private Pattern getPattern() {
            if (this.filter.contains("?") || this.filter.contains("*")) {
                String reFilter = Filter.removeRegexpEscapes(this.filter);
                reFilter = reFilter.replace(".", "\\.");
                reFilter = reFilter.replace("?", ".");
                reFilter = reFilter.replace("*", ".*");
                return Pattern.compile(".*" + reFilter + ".*", 2);
            }
            return null;
        }

        private static String removeRegexpEscapes(String text) {
            StringBuilder sb = new StringBuilder();
            block3: for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                switch (c) {
                    case '\\': {
                        continue block3;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            return sb.toString();
        }
    }

    private static class GrailsCommandRenderer
    extends JLabel
    implements ListCellRenderer {
        public GrailsCommandRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                Color bgColor = list.getBackground();
                Color bgColorDarker = new Color(Math.abs(bgColor.getRed() - 10), Math.abs(bgColor.getGreen() - 10), Math.abs(bgColor.getBlue() - 10));
                this.setBackground(index % 2 == 0 ? bgColor : bgColorDarker);
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            if (value instanceof GrailsCommand) {
                GrailsCommand task = (GrailsCommand)value;
                String descripton = task.getDescription();
                StringBuilder text = new StringBuilder("<html>");
                text.append("<b>").append(task.getCommand()).append("</b>");
                if (descripton != null) {
                    text.append(" : ").append(descripton);
                }
                text.append("</html>");
                this.setText(text.toString());
            } else {
                this.setText(value.toString());
            }
            return this;
        }
    }

    public static class CommandDescriptor {
        private final GrailsCommand task;
        private final String params;
        private final boolean debug;

        private CommandDescriptor(GrailsCommand task, String params, boolean debug) {
            this.task = task;
            this.params = params.length() == 0 ? null : params;
            this.debug = debug;
        }

        public GrailsCommand getGrailsCommand() {
            return this.task;
        }

        public String getCommandParams() {
            return this.params;
        }

        public boolean isDebug() {
            return this.debug;
        }
    }
}

