/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.j2ee;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.awt.Component;
import java.awt.EventQueue;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.progress.aggregate.AggregateProgressFactory;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.codestructure.CodeStructure;
import org.netbeans.modules.form.project.ClassPathUtils;
import org.netbeans.modules.form.project.ClassSource;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.api.entity.generator.EntitiesFromDBGenerator;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Attributes;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Id;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.JoinColumn;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceMetadata;
import org.netbeans.modules.j2ee.persistence.dd.common.Persistence;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.dd.common.Property;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityRelation;
import org.netbeans.modules.j2ee.persistence.provider.InvalidPersistenceXmlException;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceLocationProvider;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.nbform.project.ClassSourceResolver;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public class J2EEUtils {
    public static final boolean TABLE_CLOSURE = true;

    private J2EEUtils() {
    }

    public static PersistenceUnit findPersistenceUnit(Persistence persistence, String dbURL) {
        for (PersistenceUnit unit : persistence.getPersistenceUnit()) {
            Provider provider = ProviderUtil.getProvider((PersistenceUnit)unit);
            String unitURL = ProviderUtil.getProperty((PersistenceUnit)unit, (String)provider.getJdbcUrl()).getValue();
            if (!dbURL.equals(unitURL)) continue;
            return unit;
        }
        return null;
    }

    public static PersistenceUnit createPersistenceUnit(Project project, DatabaseConnection connection) throws IOException, InvalidPersistenceXmlException {
        FileObject persistenceXML = ProviderUtil.getDDFile((Project)project);
        Persistence persistence = PersistenceMetadata.getDefault().getRoot(persistenceXML);
        String dbURL = connection.getDatabaseURL();
        String dbName = dbURL.substring(dbURL.lastIndexOf(47) + 1);
        String puName = dbName + "PU";
        PersistenceUnit unit = J2EEUtils.findPersistenceUnit(persistence, puName);
        int count = 0;
        while (unit != null) {
            puName = dbName + "PU" + ++count;
            unit = J2EEUtils.findPersistenceUnit(persistence, puName);
        }
        Provider provider = persistence.getPersistenceUnit().length > 0 ? ProviderUtil.getProvider((PersistenceUnit)persistence.getPersistenceUnit(0)) : ProviderUtil.ECLIPSELINK_PROVIDER;
        unit = ProviderUtil.buildPersistenceUnit((String)puName, (Provider)provider, (DatabaseConnection)connection, (String)persistence.getVersion());
        unit.setTransactionType("RESOURCE_LOCAL");
        if ((J2EEUtils.nullOrEmpty(connection.getUser()) || J2EEUtils.nullOrEmpty(connection.getPassword())) && (ProviderUtil.TOPLINK_PROVIDER1_0.equals((Object)provider) || ProviderUtil.ECLIPSELINK_PROVIDER.equals((Object)provider) || ProviderUtil.ECLIPSELINK_PROVIDER2_0.equals((Object)provider)) && connection.getDriverClass().startsWith("org.apache.derby.jdbc.")) {
            String userPropName = provider.getJdbcUsername();
            String passwdPropName = provider.getJdbcPassword();
            for (Property prop : unit.getProperties().getProperty2()) {
                String propName = prop.getName();
                if (!userPropName.equals(propName) && !passwdPropName.equals(propName) || !J2EEUtils.nullOrEmpty(prop.getValue())) continue;
                prop.setValue("app");
            }
        }
        if ("org.apache.derby.jdbc.EmbeddedDriver".equals(connection.getDriverClass())) {
            ProviderUtil.setTableGeneration((PersistenceUnit)unit, (String)"tableGenerationCreate", (Provider)provider);
            if (!dbURL.contains(";create=true")) {
                if (!dbURL.endsWith(";")) {
                    dbURL = dbURL + ";";
                }
                dbURL = dbURL + "create=true";
                Property prop = ProviderUtil.getProperty((PersistenceUnit)unit, (String)provider.getJdbcUrl());
                if (prop != null) {
                    prop.setValue(dbURL);
                }
            }
        }
        ProviderUtil.addPersistenceUnit((PersistenceUnit)unit, (Project)project);
        return unit;
    }

    public static boolean nullOrEmpty(String s) {
        return s == null || "".equals(s);
    }

    public static String[] getPersistenceUnitNames(Project project) {
        Persistence persistence;
        FileObject persistenceXML;
        try {
            persistenceXML = J2EEUtils.getPersistenceXML(project, false);
        }
        catch (InvalidPersistenceXmlException ipxex) {
            Logger.getLogger(J2EEUtils.class.getName()).log(Level.INFO, ipxex.getMessage(), ipxex);
            return new String[0];
        }
        if (persistenceXML == null) {
            return new String[0];
        }
        try {
            persistence = PersistenceMetadata.getDefault().getRoot(persistenceXML);
        }
        catch (IOException ioex) {
            Logger.getLogger(J2EEUtils.class.getName()).log(Level.INFO, ioex.getMessage(), ioex);
            return new String[0];
        }
        PersistenceUnit[] unit = persistence.getPersistenceUnit();
        String[] names = new String[unit.length];
        for (int i = 0; i < unit.length; ++i) {
            names[i] = unit[i].getName();
        }
        return names;
    }

    public static void addEntityToUnit(String entityClass, PersistenceUnit unit, Project project) {
        boolean added = false;
        for (String clazz : unit.getClass2()) {
            if (!entityClass.equals(clazz)) continue;
            added = true;
            break;
        }
        if (!added) {
            try {
                ProviderUtil.addManagedClass((PersistenceUnit)unit, (String)entityClass, (PUDataObject)ProviderUtil.getPUDataObject((Project)project));
            }
            catch (InvalidPersistenceXmlException ipxex) {
                Logger.getLogger(J2EEUtils.class.getName()).log(Level.INFO, ipxex.getMessage(), ipxex);
            }
        }
    }

    public static boolean updateProjectForTopLink(FileObject fileInProject) {
        try {
            Library lib;
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileInProject, (String)"classpath/execute");
            FileObject fob = classPath.findResource("oracle/toplink/essentials/ejb/cmp3/EntityManagerFactoryProvider.class");
            if (fob == null) {
                fob = classPath.findResource("oracle/toplink/essentials/PersistenceProvider.class");
            }
            if (fob == null && (lib = LibraryManager.getDefault().getLibrary("toplink")) != null) {
                ClassSource cs = new ClassSource("", new ClassSource.Entry[]{new ClassSourceResolver.LibraryEntry(lib)});
                return ClassPathUtils.updateProject((FileObject)fileInProject, (ClassSource)cs);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(J2EEUtils.class.getName()).log(Level.INFO, ex.getMessage(), ex);
        }
        return false;
    }

    public static boolean updateProjectForEclipseLink(FileObject fileInProject) {
        try {
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileInProject, (String)"classpath/execute");
            FileObject fob = classPath.findResource("org/eclipse/persistence/jpa/PersistenceProvider.class");
            if (fob == null) {
                ClassSource cs = new ClassSource("", new ClassSource.Entry[]{new ClassSourceResolver.LibraryEntry(LibraryManager.getDefault().getLibrary("eclipselink"))});
                return ClassPathUtils.updateProject((FileObject)fileInProject, (ClassSource)cs);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(J2EEUtils.class.getName()).log(Level.INFO, ex.getMessage(), ex);
        }
        return false;
    }

    public static boolean updateProjectWithJARs(URL[] urls, String refClassName, FileObject fileInProject) {
        try {
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileInProject, (String)"classpath/execute");
            String resourceName = refClassName.replace('.', '/') + ".class";
            FileObject fob = classPath.findResource(resourceName);
            if (fob == null) {
                ArrayList<ClassSourceResolver.JarEntry> cpEntries = new ArrayList<ClassSourceResolver.JarEntry>(urls.length);
                for (URL url : urls) {
                    FileObject jar = URLMapper.findFileObject((URL)url);
                    if (jar == null) continue;
                    cpEntries.add(new ClassSourceResolver.JarEntry(FileUtil.toFile((FileObject)jar)));
                }
                return ClassPathUtils.updateProject((FileObject)fileInProject, (ClassSource)new ClassSource("", cpEntries));
            }
        }
        catch (IOException ex) {
            Logger.getLogger(J2EEUtils.class.getName()).log(Level.INFO, ex.getMessage(), ex);
        }
        return false;
    }

    public static FileObject getPersistenceXML(Project project, boolean create) throws InvalidPersistenceXmlException {
        FileObject persistenceXML = ProviderUtil.getDDFile((Project)project);
        if (persistenceXML == null && create) {
            ProviderUtil.getPUDataObject((Project)project);
            persistenceXML = ProviderUtil.getDDFile((Project)project);
        }
        return persistenceXML;
    }

    public static RADComponent findEntityManager(FormModel model, String puName) {
        for (RADComponent metacomp : model.getAllComponents()) {
            if (!"javax.persistence.EntityManager".equals(metacomp.getBeanClass().getName())) continue;
            try {
                FormProperty prop = (FormProperty)metacomp.getPropertyByName("persistenceUnit");
                Object name = prop.getRealValue();
                if (!puName.equals(name)) continue;
                return metacomp;
            }
            catch (Exception ex) {
                Logger.getLogger(J2EEUtils.class.getName()).log(Level.INFO, ex.getMessage(), ex);
            }
        }
        return null;
    }

    public static RADComponent createEntityManager(FormModel model, String puName) throws Exception {
        assert (EventQueue.isDispatchThread());
        FileObject formFile = FormEditor.getFormDataObject((FormModel)model).getFormFile();
        Class emClass = ClassPathUtils.loadClass((String)"javax.persistence.EntityManager", (FileObject)formFile);
        RADComponent entityManager = new RADComponent();
        entityManager.initialize(model);
        entityManager.initInstance(emClass);
        entityManager.getPropertyByName("persistenceUnit").setValue((Object)puName);
        J2EEUtils.renameComponent(entityManager, false, puName + "EntityManager", "entityManager");
        model.addComponent(entityManager, null, true);
        return entityManager;
    }

    public static String[] findEntity(MetadataModel<EntityMappingsMetadata> mappings, final String tableName) throws IOException {
        String[] entity = null;
        try {
            entity = (String[])mappings.runReadActionWhenReady((MetadataModelAction)new MetadataModelAction<EntityMappingsMetadata, String[]>(){

                public String[] run(EntityMappingsMetadata metadata) {
                    Entity[] entity = metadata.getRoot().getEntity();
                    for (int i = 0; i < entity.length; ++i) {
                        String name = entity[i].getTable().getName();
                        if (!tableName.equals(name = J2EEUtils.unquote(name))) continue;
                        return new String[]{entity[i].getName(), entity[i].getClass2()};
                    }
                    return null;
                }
            }).get();
        }
        catch (InterruptedException iex) {
            Logger.getLogger(J2EEUtils.class.getName()).log(Level.INFO, iex.getMessage(), iex);
        }
        catch (ExecutionException eex) {
            Logger.getLogger(J2EEUtils.class.getName()).log(Level.INFO, eex.getMessage(), eex);
        }
        return entity;
    }

    public static String unquote(String name) {
        while (name.startsWith("\"") && name.endsWith("\"")) {
            name = name.substring(1, name.length() - 1);
        }
        return name;
    }

    private static String[] generateEntityClass(Project project, SourceGroup location, String packageName, DatabaseConnection dbconn, List<String> tableNames, PersistenceUnit unit) {
        try {
            boolean regenTablesAttrs = "org.apache.derby.jdbc.EmbeddedDriver".equals(dbconn.getDriverClass());
            EntitiesFromDBGenerator generator = new EntitiesFromDBGenerator(tableNames, true, true, regenTablesAttrs, EntityRelation.FetchType.DEFAULT, EntityRelation.CollectionType.LIST, packageName, location, dbconn, project, unit);
            Set entities = generator.generate(AggregateProgressFactory.createProgressContributor((String)"PENDING"));
            String[] result = new String[entities.size()];
            int count = 0;
            for (FileObject fob : entities) {
                result[count++] = packageName + '.' + fob.getName();
            }
            return result;
        }
        catch (SQLException sex) {
            Logger.getLogger(J2EEUtils.class.getName()).log(Level.INFO, null, sex);
        }
        catch (IOException ioex) {
            Logger.getLogger(J2EEUtils.class.getName()).log(Level.INFO, null, ioex);
        }
        return null;
    }

    public static Connection establishConnection(DatabaseConnection connection) {
        Connection con = connection.getJDBCConnection();
        if (con == null) {
            ConnectionManager.getDefault().showConnectionDialog(connection);
            con = connection.getJDBCConnection();
        }
        return con;
    }

    public static void updateProjectForUnit(FileObject fileInProject, PersistenceUnit unit, JDBCDriver driver) {
        Provider provider = ProviderUtil.getProvider((PersistenceUnit)unit);
        if (provider != null && ProviderUtil.ECLIPSELINK_PROVIDER.getProviderClass().equals(provider.getProviderClass())) {
            J2EEUtils.updateProjectForEclipseLink(fileInProject);
        } else if (ProviderUtil.TOPLINK_PROVIDER1_0.equals((Object)provider)) {
            J2EEUtils.updateProjectForTopLink(fileInProject);
        }
        J2EEUtils.updateProjectWithJARs(driver.getURLs(), driver.getClassName(), fileInProject);
    }

    public static PersistenceUnit initPersistenceUnit(FileObject persistenceXML, DatabaseConnection connection) throws IOException, InvalidPersistenceXmlException {
        Project project = FileOwnerQuery.getOwner((FileObject)persistenceXML);
        J2EEUtils.establishConnection(connection);
        Persistence persistence = PersistenceMetadata.getDefault().getRoot(persistenceXML);
        PersistenceUnit unit = J2EEUtils.findPersistenceUnit(persistence, connection.getDatabaseURL());
        if (unit == null) {
            unit = J2EEUtils.createPersistenceUnit(project, connection);
        }
        return unit;
    }

    public static void createEntity(FileObject dir, PersistenceScope scope, PersistenceUnit unit, DatabaseConnection connection, String tableName, String[] relatedTableNames) throws IOException {
        Project project = FileOwnerQuery.getOwner((FileObject)dir);
        String packageName = scope.getClassPath().getResourceName(dir, '.', false);
        SourceGroup[] groups = J2EEUtils.getJavaSourceGroups(project);
        SourceGroup location = groups[0];
        for (int i = 0; i < groups.length; ++i) {
            boolean contains;
            try {
                contains = groups[i].contains(dir);
            }
            catch (IllegalArgumentException iaex) {
                contains = false;
            }
            if (!contains) continue;
            location = groups[i];
            break;
        }
        LinkedList<String> tableNames = new LinkedList<String>();
        tableNames.add(tableName);
        if (relatedTableNames != null) {
            List<String> relatedTables = Arrays.asList(relatedTableNames);
            if (relatedTables.contains(tableName)) {
                tableNames.remove(tableName);
            }
            tableNames.addAll(relatedTables);
        }
        J2EEUtils.generateEntityClass(project, location, packageName, connection, tableNames, unit);
        try {
            block5: for (int i = 0; i < 30; ++i) {
                MetadataModel mappings = scope.getEntityMappingsModel(unit.getName());
                for (String table : tableNames) {
                    String[] entityInfo = J2EEUtils.findEntity((MetadataModel<EntityMappingsMetadata>)mappings, table);
                    if (entityInfo != null) continue;
                    Thread.sleep(1000L);
                    continue block5;
                }
                break;
            }
        }
        catch (InterruptedException iex) {
            Logger.getLogger(J2EEUtils.class.getName()).log(Level.INFO, iex.getMessage(), iex);
        }
    }

    public static String fieldToProperty(String fieldName) {
        char first = fieldName.charAt(0);
        if (fieldName.length() > 1) {
            char second = fieldName.charAt(1);
            String suffix = fieldName.substring(1);
            first = Character.isLowerCase(second) ? Character.toLowerCase(first) : Character.toUpperCase(first);
            return first + suffix;
        }
        return Character.toString(Character.toLowerCase(first));
    }

    public static void renameComponent(RADComponent comp, boolean inModel, String ... name) {
        String newName;
        String oldName = comp.getName();
        FormModel formModel = comp.getFormModel();
        int index = 0;
        while (!Utilities.isJavaIdentifier((String)name[index])) {
            ++index;
        }
        String prefix = name[index];
        CodeStructure codeStructure = formModel.getCodeStructure();
        if (codeStructure.isVariableNameReserved(prefix) && !prefix.equals(oldName)) {
            index = 0;
            while (codeStructure.isVariableNameReserved(prefix + index) && !prefix.equals(oldName)) {
                ++index;
            }
            newName = prefix + index;
        } else {
            newName = prefix;
        }
        if (inModel) {
            comp.setName(newName);
        } else {
            comp.setStoredName(newName);
        }
    }

    public static boolean hasPrimaryKey(DatabaseConnection connection, String tableName) {
        Connection con = connection.getJDBCConnection();
        boolean hasPK = false;
        try {
            ResultSet rs = con.getMetaData().getPrimaryKeys(con.getCatalog(), connection.getSchema(), tableName);
            hasPK = rs.next();
            rs.close();
        }
        catch (Exception ex) {
            Logger.getLogger(J2EEUtils.class.getName()).log(Level.INFO, ex.getMessage(), ex);
        }
        return hasPK;
    }

    public static List<DBColumnInfo> tableNamesForConnection(DatabaseConnection connection) {
        Connection con = connection.getJDBCConnection();
        LinkedList<DBColumnInfo> tables = new LinkedList<DBColumnInfo>();
        try {
            ResultSet rs = con.getMetaData().getTables(con.getCatalog(), connection.getSchema(), "%", new String[]{"TABLE"});
            while (rs.next()) {
                boolean hasPK;
                String tableName;
                tables.add(new DBColumnInfo(tableName, hasPK, (hasPK = J2EEUtils.hasPrimaryKey(connection, tableName = rs.getString("TABLE_NAME"))) ? null : NbBundle.getMessage(J2EEUtils.class, (String)"MSG_NO_PK")));
            }
            rs.close();
        }
        catch (Exception ex) {
            Logger.getLogger(J2EEUtils.class.getName()).log(Level.INFO, ex.getMessage(), ex);
        }
        return tables;
    }

    public static void makeEntityObservable(FileObject fileInProject, String[] entityInfo, MetadataModel<EntityMappingsMetadata> mappings) {
        List<String> properties;
        String resName;
        if (entityInfo == null) {
            return;
        }
        ClassPath cp = ClassPath.getClassPath((FileObject)fileInProject, (String)"classpath/source");
        FileObject entity = cp.findResource(resName = entityInfo[1].replace('.', '/') + ".java");
        if (entity == null) {
            return;
        }
        try {
            properties = J2EEUtils.propertiesForColumns(mappings, entityInfo[0], null);
        }
        catch (IOException ioex) {
            return;
        }
        JavaSource source = JavaSource.forFileObject((FileObject)entity);
        final boolean[] alreadyUpdated = new boolean[1];
        try {
            source.runModificationTask((Task)new CancellableTask<WorkingCopy>(){

                /*
                 * WARNING - void declaration
                 */
                public void run(WorkingCopy wc) throws Exception {
                    void var5_10;
                    wc.toPhase(JavaSource.Phase.RESOLVED);
                    CompilationUnitTree cu = wc.getCompilationUnit();
                    ClassTree clazz = null;
                    for (Tree tree : cu.getTypeDecls()) {
                        ClassTree candidate;
                        if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind()) || !(candidate = (ClassTree)tree).getModifiers().getFlags().contains((Object)Modifier.PUBLIC)) continue;
                        clazz = candidate;
                        break;
                    }
                    for (Tree tree : clazz.getMembers()) {
                        VariableTree variable;
                        String string;
                        if (Tree.Kind.VARIABLE != tree.getKind() || !(string = (variable = (VariableTree)tree).getType().toString()).endsWith("PropertyChangeSupport")) continue;
                        alreadyUpdated[0] = true;
                    }
                    TreeMaker make = wc.getTreeMaker();
                    ClassTree classTree = clazz;
                    if (!alreadyUpdated[0]) {
                        TypeElement transientElement = wc.getElements().getTypeElement("javax.persistence.Transient");
                        TypeMirror typeMirror = transientElement.asType();
                        Tree transientType = make.Type(typeMirror);
                        AnnotationTree transientTree = make.Annotation(transientType, Collections.EMPTY_LIST);
                        ModifiersTree modifiers = make.Modifiers(2L, Collections.singletonList(transientTree));
                        TypeElement changeSupportElement = wc.getElements().getTypeElement("java.beans.PropertyChangeSupport");
                        TypeMirror changeSupportMirror = changeSupportElement.asType();
                        Tree changeSupportType = make.Type(changeSupportMirror);
                        NewClassTree changeSupportConstructor = make.NewClass(null, Collections.EMPTY_LIST, make.QualIdent((Element)changeSupportElement), Collections.singletonList(make.Identifier((CharSequence)"this")), null);
                        VariableTree changeSupport = make.Variable(modifiers, (CharSequence)"changeSupport", changeSupportType, (ExpressionTree)changeSupportConstructor);
                        ClassTree classTree2 = make.insertClassMember(clazz, 0, (Tree)changeSupport);
                    }
                    for (Tree tree : var5_10.getMembers()) {
                        ExpressionTree expression;
                        StatementTree statement;
                        BlockTree block;
                        MethodTree method;
                        String methodName;
                        if (tree.getKind() != Tree.Kind.METHOD || !(methodName = (method = (MethodTree)tree).getName().toString()).startsWith("set") || methodName.length() <= 3 || !Character.isUpperCase(methodName.charAt(3)) || method.getParameters().size() != 1) continue;
                        String propName = methodName.substring(3);
                        if (propName.length() == 1 || Character.isLowerCase(propName.charAt(1))) {
                            propName = Character.toLowerCase(propName.charAt(0)) + propName.substring(1);
                        }
                        if (!properties.contains(propName) || (block = method.getBody()).getStatements().size() != 1 || (statement = block.getStatements().get(0)).getKind() != Tree.Kind.EXPRESSION_STATEMENT || (expression = ((ExpressionStatementTree)statement).getExpression()).getKind() != Tree.Kind.ASSIGNMENT) continue;
                        AssignmentTree assignment = (AssignmentTree)expression;
                        String parName = assignment.getExpression().toString();
                        VariableTree parameter = method.getParameters().get(0);
                        if (!parameter.getName().toString().equals(parName)) continue;
                        ExpressionTree persistentVariable = assignment.getVariable();
                        String parameterName = parameter.getName().toString();
                        String oldParameterName = "old" + Character.toUpperCase(parameterName.charAt(0)) + parameterName.substring(1);
                        Tree parameterTree = parameter.getType();
                        VariableTree oldParameter = make.Variable(make.Modifiers(Collections.EMPTY_SET), (CharSequence)oldParameterName, parameterTree, persistentVariable);
                        BlockTree newBlock = make.insertBlockStatement(block, 0, (StatementTree)oldParameter);
                        MemberSelectTree fireMethod = make.MemberSelect((ExpressionTree)make.Identifier((CharSequence)"changeSupport"), (CharSequence)"firePropertyChange");
                        LinkedList<ExpressionTree> fireArgs = new LinkedList<ExpressionTree>();
                        fireArgs.add(make.Literal((Object)propName));
                        fireArgs.add(make.Identifier((CharSequence)oldParameterName));
                        fireArgs.add(make.Identifier((CharSequence)parameterName));
                        MethodInvocationTree notification = make.MethodInvocation(Collections.EMPTY_LIST, (ExpressionTree)fireMethod, fireArgs);
                        newBlock = make.addBlockStatement(newBlock, (StatementTree)make.ExpressionStatement((ExpressionTree)notification));
                        wc.rewrite((Tree)block, (Tree)newBlock);
                    }
                    wc.rewrite((Tree)clazz, (Tree)var5_10);
                }

                public void cancel() {
                }
            }).commit();
            if (alreadyUpdated[0]) {
                return;
            }
            source.runModificationTask((Task)new CancellableTask<WorkingCopy>(){

                public void run(WorkingCopy wc) throws Exception {
                    wc.toPhase(JavaSource.Phase.RESOLVED);
                    CompilationUnitTree cu = wc.getCompilationUnit();
                    ClassTree clazz = null;
                    for (Tree tree : cu.getTypeDecls()) {
                        ClassTree candidate;
                        if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind()) || !(candidate = (ClassTree)tree).getModifiers().getFlags().contains((Object)Modifier.PUBLIC)) continue;
                        clazz = candidate;
                        break;
                    }
                    TreeMaker make = wc.getTreeMaker();
                    ModifiersTree modifiersTree = make.Modifiers(Collections.EMPTY_SET, Collections.EMPTY_LIST);
                    TypeElement changeListenerElement = wc.getElements().getTypeElement("java.beans.PropertyChangeListener");
                    VariableTree par = make.Variable(modifiersTree, (CharSequence)"listener", (Tree)make.QualIdent((Element)changeListenerElement), null);
                    TypeElement changeSupportElement = wc.getElements().getTypeElement("java.beans.PropertyChangeSupport");
                    VariableTree changeSupport = make.Variable(modifiersTree, (CharSequence)"changeSupport", (Tree)make.QualIdent((Element)changeSupportElement), null);
                    MemberSelectTree addCall = make.MemberSelect((ExpressionTree)make.Identifier((CharSequence)changeSupport.getName()), (CharSequence)"addPropertyChangeListener");
                    MethodInvocationTree addInvocation = make.MethodInvocation(Collections.EMPTY_LIST, (ExpressionTree)addCall, Collections.singletonList(make.Identifier((CharSequence)par.getName())));
                    MethodTree addMethod = make.Method(make.Modifiers(1L, Collections.EMPTY_LIST), (CharSequence)"addPropertyChangeListener", (Tree)make.PrimitiveType(TypeKind.VOID), Collections.EMPTY_LIST, Collections.singletonList(par), Collections.EMPTY_LIST, make.Block(Collections.singletonList(make.ExpressionStatement((ExpressionTree)addInvocation)), false), null);
                    ClassTree modifiedClass = make.addClassMember(clazz, (Tree)addMethod);
                    wc.rewrite((Tree)clazz, (Tree)modifiedClass);
                }

                public void cancel() {
                }
            }).commit();
            source.runModificationTask((Task)new CancellableTask<WorkingCopy>(){

                public void run(WorkingCopy wc) throws Exception {
                    wc.toPhase(JavaSource.Phase.RESOLVED);
                    CompilationUnitTree cu = wc.getCompilationUnit();
                    ClassTree clazz = null;
                    for (Tree tree : cu.getTypeDecls()) {
                        ClassTree candidate;
                        if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind()) || !(candidate = (ClassTree)tree).getModifiers().getFlags().contains((Object)Modifier.PUBLIC)) continue;
                        clazz = candidate;
                        break;
                    }
                    TreeMaker make = wc.getTreeMaker();
                    ModifiersTree modifiersTree = make.Modifiers(Collections.EMPTY_SET, Collections.EMPTY_LIST);
                    TypeElement changeListenerElement = wc.getElements().getTypeElement("java.beans.PropertyChangeListener");
                    VariableTree par = make.Variable(modifiersTree, (CharSequence)"listener", (Tree)make.QualIdent((Element)changeListenerElement), null);
                    TypeElement changeSupportElement = wc.getElements().getTypeElement("java.beans.PropertyChangeSupport");
                    VariableTree changeSupport = make.Variable(modifiersTree, (CharSequence)"changeSupport", (Tree)make.QualIdent((Element)changeSupportElement), null);
                    MemberSelectTree removeCall = make.MemberSelect((ExpressionTree)make.Identifier((CharSequence)changeSupport.getName()), (CharSequence)"removePropertyChangeListener");
                    MethodInvocationTree removeInvocation = make.MethodInvocation(Collections.EMPTY_LIST, (ExpressionTree)removeCall, Collections.singletonList(make.Identifier((CharSequence)par.getName())));
                    MethodTree removeMethod = make.Method(make.Modifiers(1L, Collections.EMPTY_LIST), (CharSequence)"removePropertyChangeListener", (Tree)make.PrimitiveType(TypeKind.VOID), Collections.EMPTY_LIST, Collections.singletonList(par), Collections.EMPTY_LIST, make.Block(Collections.singletonList(make.ExpressionStatement((ExpressionTree)removeInvocation)), false), null);
                    ClassTree modifiedClass = make.addClassMember(clazz, (Tree)removeMethod);
                    wc.rewrite((Tree)clazz, (Tree)modifiedClass);
                }

                public void cancel() {
                }
            }).commit();
        }
        catch (IOException ioex) {
            Logger.getLogger(J2EEUtils.class.getName()).log(Level.INFO, ioex.getMessage(), ioex);
        }
    }

    public static List<String> typesOfProperties(FileObject fileInProject, String entityClass, final List<String> propertyNames) {
        ClassPath cp = ClassPath.getClassPath((FileObject)fileInProject, (String)"classpath/source");
        String resourceName = entityClass.replace('.', '/') + ".java";
        FileObject entity = cp.findResource(resourceName);
        final LinkedList<String> types = new LinkedList<String>();
        if (entity == null) {
            return types;
        }
        JavaSource source = JavaSource.forFileObject((FileObject)entity);
        try {
            source.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void run(CompilationController cc) throws Exception {
                    String type;
                    cc.toPhase(JavaSource.Phase.RESOLVED);
                    CompilationUnitTree cu = cc.getCompilationUnit();
                    ClassTree clazz = null;
                    for (Tree tree : cu.getTypeDecls()) {
                        ClassTree candidate;
                        if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind()) || !(candidate = (ClassTree)tree).getModifiers().getFlags().contains((Object)Modifier.PUBLIC)) continue;
                        clazz = candidate;
                        break;
                    }
                    HashMap<String, String> variables = new HashMap<String, String>();
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    Element classElement = cc.getTrees().getElement(cc.getTrees().getPath(cu, clazz));
                    for (VariableElement variable : ElementFilter.fieldsIn(classElement.getEnclosedElements())) {
                        String name = variable.getSimpleName().toString();
                        String type2 = variable.asType().toString();
                        variables.put(name, type2);
                    }
                    for (ExecutableElement method : ElementFilter.methodsIn(classElement.getEnclosedElements())) {
                        type = method.getReturnType().toString();
                        String name = method.getSimpleName().toString();
                        name = name.startsWith("get") ? name.substring(3) : (name.startsWith("is") && type.equals("boolean") ? name.substring(2) : null);
                        if (name == null || name.length() <= 0) continue;
                        if (name.length() == 1 || Character.isLowerCase(name.charAt(1))) {
                            name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
                        }
                        hashMap.put(name, type);
                    }
                    for (String name : propertyNames) {
                        type = (String)hashMap.get(name);
                        if (type == null) {
                            type = (String)variables.get(name);
                        }
                        if (type != null) {
                            if ((type = FormUtils.autobox((String)type)).startsWith("java.lang.")) {
                                type = type.substring(10);
                            }
                            type = type + ".class";
                        }
                        types.add(type);
                    }
                }

                public void cancel() {
                }
            }, true);
        }
        catch (IOException ioex) {
            Logger.getLogger(J2EEUtils.class.getName()).log(Level.INFO, ioex.getMessage(), ioex);
        }
        return types;
    }

    public static List<String> propertiesForColumns(MetadataModel<EntityMappingsMetadata> mappings, final String entityName, final List<String> columns) throws IOException {
        List properties = Collections.emptyList();
        try {
            properties = (List)mappings.runReadActionWhenReady((MetadataModelAction)new MetadataModelAction<EntityMappingsMetadata, List<String>>(){

                public List<String> run(EntityMappingsMetadata metadata) {
                    String columnName;
                    String propName;
                    Entity[] entities = metadata.getRoot().getEntity();
                    Entity entity = null;
                    for (int i = 0; i < entities.length; ++i) {
                        if (!entityName.equals(entities[i].getName())) continue;
                        entity = entities[i];
                        break;
                    }
                    if (entity == null) {
                        return Collections.emptyList();
                    }
                    boolean all = columns == null;
                    LinkedList<String> props = new LinkedList<String>();
                    HashMap<String, String> columnToProperty = all ? null : new HashMap<String, String>();
                    Attributes attrs = entity.getAttributes();
                    for (Id id : attrs.getId()) {
                        propName = J2EEUtils.fieldToProperty(id.getName());
                        if (all) {
                            props.add(propName);
                            continue;
                        }
                        columnName = id.getColumn().getName();
                        columnName = J2EEUtils.unquote(columnName);
                        columnToProperty.put(columnName, propName);
                    }
                    for (Id id : attrs.getBasic()) {
                        propName = J2EEUtils.fieldToProperty(id.getName());
                        if ("<error>".equals(propName)) continue;
                        if (all) {
                            props.add(propName);
                            continue;
                        }
                        columnName = id.getColumn().getName();
                        columnName = J2EEUtils.unquote(columnName);
                        columnToProperty.put(columnName, propName);
                    }
                    for (Id id : attrs.getManyToOne()) {
                        String columnName2;
                        propName = J2EEUtils.fieldToProperty(id.getName());
                        if ("<error>".equals(propName)) continue;
                        if (all) {
                            props.add(propName);
                            continue;
                        }
                        JoinColumn[] joinColumn = id.getJoinColumn();
                        if (joinColumn.length == 0) {
                            String columnName3 = id.getName().toUpperCase() + "_ID";
                        } else {
                            columnName2 = id.getJoinColumn(0).getName();
                        }
                        columnName2 = J2EEUtils.unquote(columnName2);
                        columnToProperty.put(columnName2, propName);
                    }
                    if (!all) {
                        for (String column : columns) {
                            String propName2 = (String)columnToProperty.get(column);
                            if (propName2 == null) {
                                Logger.getLogger(J2EEUtils.class.getName()).log(Level.INFO, "WARNING: Cannot find property for column {0}", column);
                                continue;
                            }
                            props.add(propName2);
                        }
                    }
                    return props;
                }
            }).get();
        }
        catch (InterruptedException iex) {
            Logger.getLogger(J2EEUtils.class.getName()).log(Level.INFO, iex.getMessage(), iex);
        }
        catch (ExecutionException eex) {
            Logger.getLogger(J2EEUtils.class.getName()).log(Level.INFO, eex.getMessage(), eex);
        }
        return properties;
    }

    private static SourceGroup[] getJavaSourceGroups(Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        return sourceGroups;
    }

    static boolean supportsJPA(FormModel formModel) {
        Project project;
        PersistenceLocationProvider provider = null;
        FormDataObject fdo = FormEditor.getFormDataObject((FormModel)formModel);
        if (fdo != null && (project = FileOwnerQuery.getOwner((FileObject)fdo.getPrimaryFile())) != null) {
            provider = (PersistenceLocationProvider)project.getLookup().lookup(PersistenceLocationProvider.class);
        }
        return provider != null;
    }

    public static class DBColumnInfo {
        private String name;
        private boolean valid;
        private String message;

        DBColumnInfo(String name, boolean valid, String message) {
            this.name = name;
            this.valid = valid;
            this.message = message;
        }

        public String getName() {
            return this.name;
        }

        public boolean isValid() {
            return this.valid;
        }

        public String getMessage() {
            return this.message;
        }

        public static ListCellRenderer getRenderer() {
            return new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (value instanceof DBColumnInfo) {
                        DBColumnInfo column = (DBColumnInfo)value;
                        String label = column.getName() + (column.isValid() ? "" : " (" + column.getMessage() + ")");
                        this.setText(label);
                        this.setEnabled(column.isValid());
                    }
                    return this;
                }
            };
        }
    }
}

