/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metamodel;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.eclipse.persistence.descriptors.CMPPolicy;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.CMP3Policy;
import org.eclipse.persistence.internal.jpa.metamodel.AttributeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.ManagedTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.MetamodelImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.mappings.DatabaseMapping;

public abstract class IdentifiableTypeImpl<X>
extends ManagedTypeImpl<X>
implements IdentifiableType<X> {
    private IdentifiableType<? super X> superType;
    private Set<SingularAttribute<? super X, ?>> idAttributes;
    private SingularAttribute<? super X, ?> versionAttribute;

    protected IdentifiableTypeImpl(MetamodelImpl metamodel, ClassDescriptor descriptor) {
        super(metamodel, descriptor);
    }

    protected void initializeIdAttributes() {
        this.idAttributes = new HashSet();
        for (Attribute attribute : this.getAttributes()) {
            if (((AttributeImpl)attribute).isPlural() || !((SingularAttribute)attribute).isId()) continue;
            this.idAttributes.add((SingularAttribute)attribute);
        }
    }

    @Override
    public <Y> SingularAttribute<X, Y> getDeclaredId(Class<Y> type) {
        SingularAttribute<X, Y> anId = this.getId(type);
        return (SingularAttribute)this.getDeclaredAttribute(anId.getName(), true);
    }

    @Override
    public <Y> SingularAttribute<X, Y> getDeclaredVersion(Class<Y> type) {
        SingularAttribute<X, Y> aVersion = this.getVersion(type);
        return (SingularAttribute)this.getDeclaredAttribute(aVersion.getName(), true);
    }

    @Override
    public Set<SingularAttribute<? super X, ?>> getIdClassAttributes() {
        List<String> idClassNamesList = this.getMetamodel().getProject().getMetamodelIdClassMap().get(this.getJavaType().getCanonicalName());
        if (idClassNamesList != null) {
            return this.idAttributes;
        }
        throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_identifiable_type_has_no_idclass_attribute", new Object[]{this}));
    }

    @Override
    public <Y> SingularAttribute<? super X, Y> getId(Class<Y> type) {
        SingularAttribute<X, ?> idAttribute = null;
        if (!this.hasSingleIdAttribute()) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_identifiable_id_attribute_is_incorrect_idclass", new Object[]{this}));
        }
        for (SingularAttribute<X, ?> anAttribute : this.idAttributes) {
            if (type == null || Object.class == type || type != null && type.getCanonicalName().equals(anAttribute.getJavaType().getCanonicalName())) {
                idAttribute = anAttribute;
                continue;
            }
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_identifiable_id_attribute_type_incorrect", new Object[]{anAttribute, this, type, anAttribute.getJavaType()}));
        }
        return idAttribute;
    }

    @Override
    public Type<?> getIdType() {
        CMPPolicy cmpPolicy = this.getDescriptor().getCMPPolicy();
        if (cmpPolicy == null) {
            List<DatabaseMapping> pkMappings = this.getDescriptor().getObjectBuilder().getPrimaryKeyMappings();
            if (pkMappings.isEmpty()) {
                for (DatabaseMapping aMapping : this.getDescriptor().getMappings()) {
                    Attribute anAttribute;
                    if (!aMapping.isJPAId() || (anAttribute = this.getAttribute(aMapping.getAttributeName())) == null) continue;
                    return this.getMetamodel().getType(((Bindable)((Object)anAttribute)).getBindableJavaType());
                }
            }
            if (pkMappings.size() == 1) {
                Class aClass = pkMappings.get(0).getAttributeClassification();
                return this.getMetamodel().getType(aClass);
            }
        }
        if (cmpPolicy.isCMP3Policy()) {
            return this.getMetamodel().getType(((CMP3Policy)cmpPolicy).getPKClass());
        }
        throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_incompatible_persistence_config_for_getIdType", new Object[]{this}));
    }

    @Override
    public IdentifiableType<? super X> getSupertype() {
        return this.superType;
    }

    @Override
    public <Y> SingularAttribute<? super X, Y> getVersion(Class<Y> type) {
        if (this.getVersion() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_identifiable_no_version_attribute_present", new Object[]{this}));
        }
        if (type == null || Object.class == type || type != null && type.getCanonicalName().equals(this.versionAttribute.getJavaType().getCanonicalName())) {
            return this.versionAttribute;
        }
        throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_identifiable_version_attribute_type_incorrect", new Object[]{this.versionAttribute, this, type, this.versionAttribute.getJavaType()}));
    }

    private <Y> SingularAttribute<? super X, ?> getVersion() {
        if (this.hasVersionAttribute()) {
            return this.versionAttribute;
        }
        return null;
    }

    @Override
    public boolean hasSingleIdAttribute() {
        List<DatabaseField> pkFields = this.getDescriptor().getPrimaryKeyFields();
        if (pkFields.isEmpty()) {
            return false;
        }
        Class pkClass = null;
        if (this.getDescriptor().hasCMPPolicy()) {
            pkClass = ((CMP3Policy)this.getDescriptor().getCMPPolicy()).getPKClass();
            if (pkClass == null) {
                return false;
            }
        } else {
            return pkFields.size() < 2;
        }
        for (List<String> idClassNamesList : this.getMetamodel().getProject().getMetamodelIdClassMap().values()) {
            for (String idClassName : idClassNamesList) {
                if (!idClassName.equals(pkClass.getCanonicalName())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean hasVersionAttribute() {
        if (this.versionAttribute != null) {
            return true;
        }
        for (Attribute attribute : this.getAttributes()) {
            if (((AttributeImpl)attribute).isPlural() || !((SingularAttribute)attribute).isVersion()) continue;
            this.versionAttribute = (SingularAttribute)attribute;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isIdentifiableType() {
        return true;
    }

    protected void setSupertype(IdentifiableType<? super X> superType) {
        this.superType = superType;
    }
}

