/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.api;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.modules.javacard.common.GuiUtils;
import org.netbeans.modules.javacard.common.Utils;
import org.netbeans.modules.javacard.spi.Card;
import org.netbeans.modules.javacard.spi.Cards;
import org.netbeans.modules.javacard.spi.DeviceManagerDialogProvider;
import org.netbeans.modules.javacard.spi.JavacardPlatform;
import org.netbeans.modules.javacard.spi.PlatformAndDeviceProvider;
import org.netbeans.modules.javacard.spi.ProjectKind;
import org.netbeans.modules.javacard.spi.capabilities.CardInfo;
import org.netbeans.modules.javacard.spi.impl.TempPlatformAndDeviceProvider;
import org.netbeans.validation.api.AbstractValidator;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.ui.ValidationGroupProvider;
import org.netbeans.validation.api.ui.ValidationUI;
import org.netbeans.validation.api.ui.swing.SwingValidationGroup;
import org.openide.awt.HtmlRenderer;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public final class PlatformAndDevicePanel
extends JPanel
implements ActionListener,
ValidationGroupProvider,
Lookup.Provider {
    private final JComboBox platforms;
    private final JComboBox devices;
    private final JButton manageCardsButton = new JButton(NbBundle.getMessage(PlatformAndDevicePanel.class, (String)"LBL_MANAGE_DEVICES"));
    private final JButton managePlatformsButton = new JButton(NbBundle.getMessage(PlatformAndDevicePanel.class, (String)"LBL_MANAGE_PLATFORMS"));
    private final R r = new R();
    private final SwingValidationGroup grp = SwingValidationGroup.create((ValidationUI[])new ValidationUI[0]);
    private PlatformAndDeviceProvider props;
    private final InstanceContent content = new InstanceContent();
    private final AbstractLookup lkp = new AbstractLookup((AbstractLookup.Content)this.content);
    private ProjectKind kind;

    public PlatformAndDevicePanel() {
        this(new TempPlatformAndDeviceProvider());
    }

    public PlatformAndDevicePanel(PlatformAndDeviceProvider props) {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        if (props == null) {
            props = new TempPlatformAndDeviceProvider();
        }
        this.props = props;
        this.platforms = new JComboBox();
        this.devices = new JComboBox();
        this.platforms.setRenderer(this.r);
        this.devices.setRenderer(this.r);
        this.fullInit();
        JLabel platformsLabel = new JLabel(NbBundle.getMessage(PlatformAndDevicePanel.class, (String)"LBL_PLATFORMS"));
        platformsLabel.setLabelFor(this.platforms);
        JLabel cardsLabel = new JLabel(NbBundle.getMessage(PlatformAndDevicePanel.class, (String)"LBL_DEVICES"));
        cardsLabel.setLabelFor(this.devices);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(cardsLabel).addComponent(platformsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.platforms, 0, 190, Short.MAX_VALUE).addComponent(this.devices, 0, 190, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.manageCardsButton, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.managePlatformsButton, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(platformsLabel).addComponent(this.platforms, -2, -1, -2).addComponent(this.managePlatformsButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(cardsLabel).addComponent(this.devices, -2, -1, -2).addComponent(this.manageCardsButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.manageCardsButton.addActionListener(this);
        this.managePlatformsButton.addActionListener(this);
        this.platforms.addActionListener(this);
        this.devices.addActionListener(this);
        GuiUtils.prepareContainer((Container)this);
        this.grp.add((Object)this.platforms, (Validator)new PlatformValidator());
        this.grp.add((Object)this.devices, (Validator)new CardValidator());
        HelpCtx.setHelpIDString((JComponent)this, (String)"org.netbeans.modules.javacard.CustomizeDevice");
    }

    public void setProjectKind(ProjectKind kind) {
        this.kind = kind;
    }

    public Lookup getLookup() {
        return this.lkp;
    }

    void fullInit() {
        this.platforms.setModel(new PlatformsModel());
        this.platformsChanged();
    }

    public void setPlatformAndCard(PlatformAndDeviceProvider prov) {
        if (prov == null) {
            prov = new TempPlatformAndDeviceProvider();
        }
        this.props = prov;
        this.fullInit();
        this.updateLookup();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.platforms) {
            this.platformsChanged();
        } else if (o == this.devices) {
            this.cardsChanged();
        } else if (o == this.managePlatformsButton) {
            this.managePlatforms();
        } else if (o == this.manageCardsButton) {
            this.manageCards();
        }
        this.updateLookup();
    }

    private void platformsChanged() {
        if (this.platforms == null) {
            return;
        }
        JavacardPlatform pform = this.platforms.getSelectedItem() instanceof JavacardPlatform ? (JavacardPlatform)((Object)this.platforms.getSelectedItem()) : null;
        this.updateCardsModel();
        this.devices.setEnabled(pform != null && pform.isValid());
        DataObject dob = Utils.findPlatformDataObjectNamed((String)this.props.getPlatformName());
        DeviceManagerDialogProvider prov = dob == null ? null : (DeviceManagerDialogProvider)dob.getLookup().lookup(DeviceManagerDialogProvider.class);
        this.manageCardsButton.setEnabled(pform != null && pform.isValid() && prov != null);
        this.grp.performValidation();
        this.updateLookup();
    }

    private void updateCardsModel() {
        JavacardPlatform pform;
        JavacardPlatform javacardPlatform = pform = this.platforms.getSelectedItem() instanceof JavacardPlatform ? (JavacardPlatform)((Object)this.platforms.getSelectedItem()) : null;
        if (pform != null) {
            this.devices.setModel(new CardsModel(pform));
            this.props.setPlatformName(pform.getSystemName());
        } else {
            this.devices.setModel(new CardsModel(JavacardPlatform.createBrokenJavacardPlatform("null")));
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.grp.performValidation();
        this.updateLookup();
    }

    private void updateLookup() {
        JavacardPlatform pform;
        HashSet<Object> stuff = new HashSet<Object>();
        JavacardPlatform javacardPlatform = pform = this.platforms.getSelectedItem() instanceof JavacardPlatform ? (JavacardPlatform)((Object)this.platforms.getSelectedItem()) : null;
        if (pform != null) {
            stuff.add((Object)pform);
        }
        if (this.devices.getSelectedItem() instanceof Card) {
            stuff.add(this.devices.getSelectedItem());
        }
        this.content.set(stuff, null);
    }

    private void cardsChanged() {
        Card card;
        Card card2 = card = this.devices.getSelectedItem() instanceof Card ? (Card)this.devices.getSelectedItem() : null;
        if (card != null) {
            this.props.setActiveDevice(card.getSystemId());
        }
        this.grp.performValidation();
        this.updateLookup();
    }

    private void managePlatforms() {
        JavacardPlatform toSelect = (JavacardPlatform)((Object)this.platforms.getSelectedItem());
        PlatformsCustomizer.showCustomizer((JavaPlatform)toSelect);
        this.fullInit();
    }

    private void manageCards() {
        DataObject dob = Utils.findPlatformDataObjectNamed((String)this.props.getPlatformName());
        DeviceManagerDialogProvider prov = (DeviceManagerDialogProvider)dob.getLookup().lookup(DeviceManagerDialogProvider.class);
        assert (prov != null);
        prov.showManageDevicesDialog(this);
        this.updateCardsModel();
    }

    public SwingValidationGroup getValidationGroup() {
        return this.grp;
    }

    public void setPlatformAndCard(String activePlatform, String activeDevice) {
        PlatformAndDeviceProvider tempProps;
        PlatformAndDeviceProvider platformAndDeviceProvider = tempProps = this.props == null ? new TempPlatformAndDeviceProvider() : this.props;
        if (activeDevice != null) {
            tempProps.setActiveDevice(activeDevice);
        }
        if (activePlatform != null) {
            tempProps.setPlatformName(activePlatform);
        }
        this.setPlatformAndCard(tempProps);
        this.updateLookup();
    }

    private class CardsModel
    implements ComboBoxModel,
    ChangeListener {
        private final Cards cards;
        private final List<Card> list = new ArrayList<Card>();
        private Card sel;
        private final List<ListDataListener> ls = new ArrayList<ListDataListener>();

        public CardsModel(JavacardPlatform pl) {
            this.cards = pl.getCards();
            this.refresh();
            this.cards.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)this.cards));
        }

        void refresh() {
            String name;
            this.list.addAll(this.cards.getCards(false));
            String string = name = PlatformAndDevicePanel.this.props == null ? null : PlatformAndDevicePanel.this.props.getActiveDevice();
            if (name != null) {
                Card c = this.cards.find(name, true);
                if (!this.list.contains(c)) {
                    this.list.add(c);
                }
                this.sel = c;
            }
        }

        @Override
        public void setSelectedItem(Object anItem) {
            if (anItem == null && this.list.size() > 0) {
                anItem = this.list.get(0);
            }
            this.sel = (Card)anItem;
            PlatformAndDevicePanel.this.updateLookup();
        }

        @Override
        public Object getSelectedItem() {
            if (this.sel == null) {
                return "<font color='!controlShadow'>" + NbBundle.getMessage(CardsModel.class, (String)"MSG_NO_CARDS");
            }
            return this.sel;
        }

        @Override
        public int getSize() {
            return this.list.size();
        }

        @Override
        public Object getElementAt(int index) {
            return index == -1 ? this.sel : this.list.get(index);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.ls.add(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.ls.remove(l);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.refresh();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PlatformAndDevicePanel.this.grp.performValidation();
                }
            });
        }
    }

    private final class PlatformsModel
    implements ComboBoxModel,
    FileChangeListener,
    Runnable {
        private JavacardPlatform sel;
        private final List<JavacardPlatform> list = Collections.synchronizedList(new ArrayList());
        private final List<ListDataListener> ls = new ArrayList<ListDataListener>();
        private volatile boolean enqueued;

        PlatformsModel() {
            String name = PlatformAndDevicePanel.this.props == null ? null : PlatformAndDevicePanel.this.props.getPlatformName();
            this.refresh();
            if (name != null) {
                boolean found = false;
                for (JavacardPlatform fo : this.list) {
                    if (!name.equals(fo.getSystemName())) continue;
                    this.sel = fo;
                    found = true;
                    break;
                }
                if (!found) {
                    String expectedCard = PlatformAndDevicePanel.this.props == null ? null : PlatformAndDevicePanel.this.props.getActiveDevice();
                    this.sel = expectedCard != null ? JavacardPlatform.createBrokenJavacardPlatform(name, Arrays.asList(expectedCard)) : JavacardPlatform.createBrokenJavacardPlatform(name);
                }
            }
        }

        void refresh() {
            JavacardPlatform old = this.sel;
            this.list.clear();
            boolean found = false;
            JavacardPlatform first = null;
            for (FileObject fo : Utils.findAllRegisteredJavacardPlatformFiles()) {
                try {
                    JavacardPlatform pform = (JavacardPlatform)((Object)DataObject.find((FileObject)fo).getNodeDelegate().getLookup().lookup(JavacardPlatform.class));
                    this.list.add(pform);
                    if (first == null) {
                        first = pform;
                    }
                }
                catch (DataObjectNotFoundException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                found = old != null && ((Object)((Object)old)).equals((Object)this.sel);
            }
            if (!found) {
                this.sel = old != null ? JavacardPlatform.createBrokenJavacardPlatform(old.getSystemName()) : first;
            }
            for (ListDataListener l : this.ls) {
                l.contentsChanged(new ListDataEvent(this, 0, 0, this.list.size()));
            }
            PlatformAndDevicePanel.this.platformsChanged();
        }

        @Override
        public void setSelectedItem(Object anItem) {
            JavacardPlatform jc;
            if (anItem == null && this.list.size() > 0) {
                anItem = this.list.get(0);
            }
            if (anItem == null) {
                boolean change = true;
                this.sel = null;
            }
            if (this.sel != (jc = (JavacardPlatform)((Object)anItem))) {
                this.sel = jc;
                for (ListDataListener l : this.ls) {
                    l.contentsChanged(new ListDataEvent(this, 0, -1, -1));
                }
            }
            PlatformAndDevicePanel.this.updateLookup();
        }

        @Override
        public Object getSelectedItem() {
            if (this.sel == null && this.list.size() == 0) {
                return NbBundle.getMessage(PlatformAndDevicePanel.class, (String)"MSG_CREATE_A_PLATFORM");
            }
            return this.sel;
        }

        @Override
        public int getSize() {
            return this.list.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.list.get(index);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.ls.add(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.ls.remove(l);
        }

        @Override
        public void run() {
            try {
                this.refresh();
            }
            finally {
                this.enqueued = false;
            }
        }

        public void doRefresh() {
            if (!this.enqueued) {
                EventQueue.invokeLater(this);
            }
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileDataCreated(FileEvent fe) {
            this.refresh();
        }

        public void fileChanged(FileEvent fe) {
            this.refresh();
        }

        public void fileDeleted(FileEvent fe) {
            this.refresh();
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.refresh();
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }
    }

    private class R
    extends DefaultListCellRenderer {
        HtmlRenderer.Renderer ren = HtmlRenderer.createRenderer();

        private R() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean leadSelection) {
            Image image = null;
            if (value instanceof JavacardPlatform) {
                JavacardPlatform pl = (JavacardPlatform)((Object)value);
                value = pl.getDisplayName();
                DataObject dob = Utils.findPlatformDataObjectNamed((String)pl.getSystemName());
                image = dob == null ? null : dob.getNodeDelegate().getIcon(1);
            } else if (value instanceof Card) {
                Card card = (Card)value;
                CardInfo info = (CardInfo)card.getLookup().lookup(CardInfo.class);
                value = info.getDisplayName();
                image = info.getIcon();
                if (!card.isValid()) {
                    value = "<font color='!controlShadow'>" + value;
                }
            } else if (value == null) {
                value = NbBundle.getMessage(R.class, (String)"NULL");
            }
            this.ren.setHtml(true);
            JLabel lbl = (JLabel)this.ren.getListCellRendererComponent(list, value, index, isSelected, leadSelection);
            this.ren.setHtml(true);
            if (image != null) {
                this.ren.setIcon(ImageUtilities.image2Icon((Image)image));
                this.ren.setIconTextGap(3);
            }
            this.ren.setText(value.toString());
            return lbl;
        }
    }

    private static class CardValidator
    extends AbstractValidator<ComboBoxModel> {
        CardValidator() {
            super(ComboBoxModel.class);
        }

        public void validate(Problems prblms, String string, ComboBoxModel t) {
            Card c;
            if (t.getSelectedItem() == null || !(t.getSelectedItem() instanceof Card)) {
                prblms.add(NbBundle.getMessage(PlatformValidator.class, (String)"LBL_NO_CARD_SELECTED"));
                return;
            }
            if (t.getSelectedItem() instanceof Card && !(c = (Card)t.getSelectedItem()).isValid()) {
                prblms.add(NbBundle.getMessage(PlatformValidator.class, (String)"MSG_BAD_CARD"));
            }
        }
    }

    private class PlatformValidator
    extends AbstractValidator<ComboBoxModel> {
        PlatformValidator() {
            super(ComboBoxModel.class);
        }

        public void validate(Problems prblms, String string, ComboBoxModel t) {
            if (t.getSelectedItem() == null || !(t.getSelectedItem() instanceof JavacardPlatform)) {
                prblms.add(NbBundle.getMessage(PlatformValidator.class, (String)"LBL_NO_PLATFORM_SELECTED"));
                return;
            }
            if (t.getSelectedItem() instanceof JavacardPlatform) {
                JavacardPlatform p = (JavacardPlatform)((Object)t.getSelectedItem());
                if (!p.isValid()) {
                    String nm = p.getDisplayName();
                    prblms.add(NbBundle.getMessage(PlatformValidator.class, (String)"MSG_BAD_PLATFORM", (Object)nm));
                    return;
                }
                if (PlatformAndDevicePanel.this.kind != null && !p.supportedProjectKinds().contains((Object)PlatformAndDevicePanel.this.kind)) {
                    prblms.add(NbBundle.getMessage(PlatformAndDevicePanel.class, (String)"MSG_UNSUPPORTED_PROJECT_TYPE", (Object)p.getDisplayName(), (Object)PlatformAndDevicePanel.this.kind.getDisplayName()));
                }
            }
        }
    }
}

