/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rdr.InStream;
import com.tigervnc.rdr.OutStream;
import com.tigervnc.rfb.AuthFailureException;
import com.tigervnc.rfb.CMsgHandler;
import com.tigervnc.rfb.CMsgReader;
import com.tigervnc.rfb.CMsgWriter;
import com.tigervnc.rfb.CSecurity;
import com.tigervnc.rfb.ConnFailedException;
import com.tigervnc.rfb.DecodeManager;
import com.tigervnc.rfb.Exception;
import com.tigervnc.rfb.LogWriter;
import com.tigervnc.rfb.ModifiablePixelBuffer;
import com.tigervnc.rfb.Rect;
import com.tigervnc.rfb.ScreenSet;
import com.tigervnc.rfb.Security;
import com.tigervnc.rfb.SecurityClient;
import java.awt.image.Raster;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class CConnection
extends CMsgHandler {
    public static final int RFBSTATE_UNINITIALISED = 0;
    public static final int RFBSTATE_PROTOCOL_VERSION = 1;
    public static final int RFBSTATE_SECURITY_TYPES = 2;
    public static final int RFBSTATE_SECURITY = 3;
    public static final int RFBSTATE_SECURITY_RESULT = 4;
    public static final int RFBSTATE_INITIALISATION = 5;
    public static final int RFBSTATE_NORMAL = 6;
    public static final int RFBSTATE_INVALID = 7;
    private InStream is = null;
    private OutStream os = null;
    private CMsgReader reader_ = null;
    private CMsgWriter writer_ = null;
    private boolean deleteStreamsWhenDone;
    private boolean shared = false;
    private int state_ = 0;
    private String serverName;
    private boolean useProtocol3_3 = false;
    protected ModifiablePixelBuffer framebuffer = null;
    private DecodeManager decoder = new DecodeManager(this);
    public CSecurity csecurity = null;
    public SecurityClient security = new SecurityClient();
    public static final int maxSecTypes = 8;
    int nSecTypes;
    int[] secTypes;
    int serverPort;
    boolean clientSecTypeOrder;
    static LogWriter vlog = new LogWriter("CConnection");

    public final void setServerName(String string) {
        this.serverName = string;
    }

    public final void setShared(boolean bl) {
        this.shared = bl;
    }

    public final void setProtocol3_3(boolean bl) {
        this.useProtocol3_3 = bl;
    }

    public final void setStreams(InStream inStream, OutStream outStream) {
        this.is = inStream;
        this.os = outStream;
    }

    public void setFramebuffer(ModifiablePixelBuffer modifiablePixelBuffer) {
        this.decoder.flush();
        if (this.framebuffer != null && modifiablePixelBuffer != null) {
            Rect rect = new Rect();
            byte[] byArray = new byte[4];
            rect.setXYWH(0, 0, Math.min(modifiablePixelBuffer.width(), this.framebuffer.width()), Math.min(modifiablePixelBuffer.height(), this.framebuffer.height()));
            Raster raster = this.framebuffer.getBuffer(rect);
            modifiablePixelBuffer.imageRect(this.framebuffer.getPF(), rect, raster);
            if (modifiablePixelBuffer.width() > this.framebuffer.width()) {
                rect.setXYWH(this.framebuffer.width(), 0, modifiablePixelBuffer.width() - this.framebuffer.width(), modifiablePixelBuffer.height());
                modifiablePixelBuffer.fillRect(rect, byArray);
            }
            if (modifiablePixelBuffer.height() > this.framebuffer.height()) {
                rect.setXYWH(0, this.framebuffer.height(), modifiablePixelBuffer.width(), modifiablePixelBuffer.height() - this.framebuffer.height());
                modifiablePixelBuffer.fillRect(rect, byArray);
            }
        }
        this.framebuffer = modifiablePixelBuffer;
    }

    public final void initialiseProtocol() {
        this.state_ = 1;
    }

    public void processMsg() {
        switch (this.state_) {
            case 1: {
                this.processVersionMsg();
                break;
            }
            case 2: {
                this.processSecurityTypesMsg();
                break;
            }
            case 3: {
                this.processSecurityMsg();
                break;
            }
            case 4: {
                this.processSecurityResultMsg();
                break;
            }
            case 5: {
                this.processInitMsg();
                break;
            }
            case 6: {
                this.reader_.readMsg();
                break;
            }
            case 0: {
                throw new Exception("CConnection.processMsg: not initialised yet?");
            }
            default: {
                throw new Exception("CConnection.processMsg: invalid state");
            }
        }
    }

    private void processVersionMsg() {
        vlog.debug("reading protocol version");
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        if (!this.cp.readVersion(this.is, atomicBoolean)) {
            this.state_ = 7;
            throw new Exception("reading version failed: not an RFB server?");
        }
        if (!atomicBoolean.get()) {
            return;
        }
        vlog.info("Server supports RFB protocol version " + this.cp.majorVersion + "." + this.cp.minorVersion);
        if (this.cp.beforeVersion(3, 3)) {
            String string = "Server gave unsupported RFB protocol version " + this.cp.majorVersion + "." + this.cp.minorVersion;
            vlog.error(string);
            this.state_ = 7;
            throw new Exception(string);
        }
        if (this.useProtocol3_3 || this.cp.beforeVersion(3, 7)) {
            this.cp.setVersion(3, 3);
        } else if (this.cp.afterVersion(3, 8)) {
            this.cp.setVersion(3, 8);
        }
        this.cp.writeVersion(this.os);
        this.state_ = 2;
        vlog.info("Using RFB protocol version " + this.cp.majorVersion + "." + this.cp.minorVersion);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processSecurityTypesMsg() {
        int n;
        block11: {
            List<Object> list;
            block10: {
                vlog.debug("processing security types message");
                n = 0;
                list = new ArrayList();
                list = this.security.GetEnabledSecTypes();
                if (!this.cp.isVersion(3, 3)) break block10;
                n = this.is.readU32();
                if (n == 0) {
                    this.throwConnFailedException();
                    break block11;
                } else {
                    if (n != 1 && n != 2) {
                        vlog.error("Unknown 3.3 security type " + n);
                        throw new Exception("Unknown 3.3 security type");
                    }
                    Iterator<Object> iterator = list.iterator();
                    while (iterator.hasNext()) {
                        int n2 = (Integer)iterator.next();
                        if (n2 != n) continue;
                        n = n2;
                        break;
                    }
                    if (!list.contains(n)) {
                        n = 0;
                    }
                }
                break block11;
            }
            int n3 = this.is.readU8();
            if (n3 == 0) {
                this.throwConnFailedException();
            }
            block1: for (int i = 0; i < n3; ++i) {
                int n4 = this.is.readU8();
                vlog.debug("Server offers security type " + Security.secTypeName(n4) + "(" + n4 + ")");
                if (n != 0) continue;
                Iterator<Object> iterator = list.iterator();
                while (iterator.hasNext()) {
                    int n5 = (Integer)iterator.next();
                    if (n5 != n4) continue;
                    n = n5;
                    continue block1;
                }
            }
            if (n != 0) {
                this.os.writeU8(n);
                this.os.flush();
                vlog.debug("Choosing security type " + Security.secTypeName(n) + "(" + n + ")");
            }
        }
        if (n == 0) {
            this.state_ = 7;
            vlog.error("No matching security types");
            throw new Exception("No matching security types");
        }
        this.state_ = 3;
        this.csecurity = this.security.GetCSecurity(n);
        this.processSecurityMsg();
    }

    private void processSecurityMsg() {
        vlog.debug("processing security message");
        if (this.csecurity.processMsg(this)) {
            this.state_ = 4;
            this.processSecurityResultMsg();
        }
    }

    private void processSecurityResultMsg() {
        int n;
        vlog.debug("processing security result message");
        if (this.cp.beforeVersion(3, 8) && this.csecurity.getType() == 1) {
            n = 0;
        } else {
            if (!this.is.checkNoWait(1)) {
                return;
            }
            n = this.is.readU32();
        }
        switch (n) {
            case 0: {
                this.securityCompleted();
                return;
            }
            case 1: {
                vlog.debug("auth failed");
                break;
            }
            case 2: {
                vlog.debug("auth failed - too many tries");
                break;
            }
            default: {
                throw new Exception("Unknown security result from server");
            }
        }
        String string = this.cp.beforeVersion(3, 8) ? "Authentication failure" : this.is.readString();
        this.state_ = 7;
        throw new AuthFailureException(string);
    }

    private void processInitMsg() {
        vlog.debug("reading server initialisation");
        this.reader_.readServerInit();
    }

    private void throwConnFailedException() {
        this.state_ = 7;
        String string = this.is.readString();
        throw new ConnFailedException(string);
    }

    private void securityCompleted() {
        this.state_ = 5;
        this.reader_ = new CMsgReader(this, this.is);
        this.writer_ = new CMsgWriter(this.cp, this.os);
        vlog.debug("Authentication success!");
        this.authSuccess();
        this.writer_.writeClientInit(this.shared);
    }

    @Override
    public void setDesktopSize(int n, int n2) {
        this.decoder.flush();
        super.setDesktopSize(n, n2);
    }

    @Override
    public void setExtendedDesktopSize(int n, int n2, int n3, int n4, ScreenSet screenSet) {
        this.decoder.flush();
        super.setExtendedDesktopSize(n, n2, n3, n4, screenSet);
    }

    @Override
    public void readAndDecodeRect(Rect rect, int n, ModifiablePixelBuffer modifiablePixelBuffer) {
        this.decoder.decodeRect(rect, n, modifiablePixelBuffer);
        this.decoder.flush();
    }

    @Override
    public void framebufferUpdateStart() {
        super.framebufferUpdateStart();
    }

    @Override
    public void framebufferUpdateEnd() {
        this.decoder.flush();
        super.framebufferUpdateEnd();
    }

    @Override
    public void dataRect(Rect rect, int n) {
        this.decoder.decodeRect(rect, n, this.framebuffer);
    }

    public void authSuccess() {
    }

    @Override
    public void serverInit() {
        this.state_ = 6;
        vlog.debug("initialisation done");
    }

    public CMsgReader reader() {
        return this.reader_;
    }

    public CMsgWriter writer() {
        return this.writer_;
    }

    public InStream getInStream() {
        return this.is;
    }

    public OutStream getOutStream() {
        return this.os;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int state() {
        return this.state_;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int n) {
        this.serverPort = n;
    }

    protected void setState(int n) {
        this.state_ = n;
    }

    protected void setReader(CMsgReader cMsgReader) {
        this.reader_ = cMsgReader;
    }

    protected void setWriter(CMsgWriter cMsgWriter) {
        this.writer_ = cMsgWriter;
    }

    protected ModifiablePixelBuffer getFramebuffer() {
        return this.framebuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fence(int n, int n2, byte[] byArray) {
        super.fence(n, n2, byArray);
        if ((n & Integer.MIN_VALUE) != 0) {
            return;
        }
        n = 0;
        CConnection cConnection = this;
        synchronized (cConnection) {
            this.writer().writeFence(n, n2, byArray);
        }
    }

    private void throwAuthFailureException() {
        vlog.debug("state=" + this.state() + ", ver=" + this.cp.majorVersion + "." + this.cp.minorVersion);
        String string = this.state() == 4 && !this.cp.beforeVersion(3, 8) ? this.is.readString() : "Authentication failure";
        this.state_ = 7;
        vlog.error(string);
        throw new AuthFailureException(string);
    }
}

