/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.diagram;

import com.baselet.control.constants.SystemInfo;
import com.baselet.control.enums.Metakey;
import com.baselet.control.enums.Program;
import com.baselet.control.util.Utils;
import com.baselet.diagram.DrawPanel;
import com.baselet.diagram.UpdateCheckTimerTask;
import com.baselet.gui.CurrentGui;
import com.baselet.gui.listener.HyperLinkActiveListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Scanner;
import javax.swing.JEditorPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartUpHelpText
extends JEditorPane
implements ContainerListener,
ComponentListener {
    private static final long serialVersionUID = 1L;
    static final Logger log = LoggerFactory.getLogger(StartUpHelpText.class);
    private DrawPanel panel;
    private boolean visible;

    public StartUpHelpText(DrawPanel panel) {
        this.panel = panel;
        if (CurrentGui.getInstance().getGui() == null) {
            return;
        }
        panel.addContainerListener(this);
        panel.addComponentListener(this);
        this.addMouseListener(new DelegatingMouseListener());
        try {
            if (UpdateCheckTimerTask.getInstance().getFilename() == null) {
                this.showHTML(StartUpHelpText.createTempFileWithText(StartUpHelpText.getDefaultTextWithReplacedSystemspecificMetakeys()));
            } else {
                this.showHTML(UpdateCheckTimerTask.getInstance().getFilename());
            }
        }
        catch (IOException e) {
            log.error("Cannot load startupinfo", (Throwable)e);
            this.setText("Cannot load startupinfo");
            this.setSize(130, 10);
        }
    }

    @Override
    public void setEnabled(boolean en) {
        super.setEnabled(en);
        if (en && this.visible) {
            if (this.panel.getGridElements().size() == 0) {
                this.setVisible(true);
            } else {
                this.visible = false;
            }
        } else {
            this.visible = this.isVisible();
            this.setVisible(false);
        }
    }

    static InputStream getStartUpFileName() {
        return StartUpHelpText.class.getClassLoader().getResourceAsStream("startuphelp.html");
    }

    private void showHTML(String filename) throws MalformedURLException, IOException {
        this.setPage(new URL("file:///" + filename));
        this.addHyperlinkListener(new HyperLinkActiveListener());
        this.setEditable(false);
        this.setBackground(Color.WHITE);
        this.setSelectionColor(this.getBackground());
        this.setSelectedTextColor(this.getForeground());
    }

    static String createTempFileWithText(String textToWriteIntoFile) throws IOException {
        File tempFile = File.createTempFile(Program.getInstance().getProgramName() + "_startupfile", ".html");
        tempFile.deleteOnExit();
        FileWriter w = new FileWriter(tempFile);
        w.write(textToWriteIntoFile);
        w.close();
        return tempFile.getAbsolutePath();
    }

    private static String getDefaultTextWithReplacedSystemspecificMetakeys() throws FileNotFoundException {
        StringBuilder sb = new StringBuilder("");
        Scanner sc = null;
        try {
            sc = new Scanner(StartUpHelpText.getStartUpFileName());
            while (sc.hasNextLine()) {
                String line = sc.nextLine();
                if (SystemInfo.META_KEY == Metakey.CTRL) {
                    line = line.replace(Metakey.CMD.toString(), Metakey.CTRL.toString());
                } else if (SystemInfo.META_KEY == Metakey.CMD) {
                    line = line.replace(Metakey.CTRL.toString(), Metakey.CMD.toString());
                }
                sb.append(line).append("\n");
            }
        }
        finally {
            if (sc != null) {
                sc.close();
            }
        }
        return sb.toString();
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        boolean gridElementAdded;
        boolean bl = gridElementAdded = this.panel.getElementToComponent(e.getChild()) != null;
        if (gridElementAdded) {
            this.setVisible(false);
        }
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        if (e.getContainer().getComponentCount() <= 1 && !this.equals(e.getChild())) {
            this.setVisible(true);
        }
    }

    @Override
    public void componentResized(ComponentEvent arg0) {
        Dimension size = this.panel.getSize();
        Dimension labelSize = this.getPreferredSize();
        this.setSize(labelSize);
        int minDistanceFromTop = 25;
        int labelSizeToSubtract = Math.max(150, labelSize.height);
        this.setLocation(size.width / 2 - labelSize.width / 2, Math.max(minDistanceFromTop, size.height / 2 - labelSizeToSubtract));
    }

    @Override
    public void paint(Graphics g) {
        ((Graphics2D)g).setRenderingHints(Utils.getUxRenderingQualityHigh(false));
        super.paint(g);
        ((Graphics2D)g).setRenderingHints(Utils.getUxRenderingQualityHigh(true));
    }

    @Override
    public void componentHidden(ComponentEvent arg0) {
    }

    @Override
    public void componentMoved(ComponentEvent arg0) {
    }

    @Override
    public void componentShown(ComponentEvent arg0) {
    }

    private class DelegatingMouseListener
    implements MouseListener {
        private DelegatingMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            StartUpHelpText.this.panel.getHandler().getListener().mouseClicked(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            StartUpHelpText.this.panel.getHandler().getListener().mouseEntered(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            StartUpHelpText.this.panel.getHandler().getListener().mouseExited(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            StartUpHelpText.this.panel.getHandler().getListener().mousePressed(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            StartUpHelpText.this.panel.getHandler().getListener().mouseReleased(e);
        }
    }
}

