/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.sticking;

import com.baselet.control.SharedUtils;
import com.baselet.element.sticking.PointDoubleIndexed;
import com.baselet.element.sticking.Stickable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StickableMap {
    public static final StickableMap EMPTY_MAP = new StickableMap();
    Map<Stickable, List<Integer>> stickingIndexMap = new HashMap<Stickable, List<Integer>>();

    public boolean equalsMap(StickableMap other) {
        return StickableMap.checkMapsEqual(this.stickingIndexMap, other.stickingIndexMap);
    }

    private static boolean checkMapsEqual(Map<Stickable, List<Integer>> mapA, Map<Stickable, List<Integer>> mapB) {
        if (!StickableMap.containSameElements(mapA.keySet(), mapB.keySet())) {
            return false;
        }
        for (Map.Entry<Stickable, List<Integer>> entry : mapA.entrySet()) {
            List<Integer> setB;
            List<Integer> setA = entry.getValue();
            if (StickableMap.containSameElements(setA, setB = mapB.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    private static boolean containSameElements(Collection<?> setA, Collection<?> setB) {
        return setA.containsAll(setB) && setB.containsAll(setA);
    }

    public boolean isEmpty() {
        for (List<Integer> valueList : this.stickingIndexMap.values()) {
            if (valueList.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void add(Stickable stickable, PointDoubleIndexed p) {
        List<Integer> points = this.stickingIndexMap.get(stickable);
        if (points == null) {
            points = new ArrayList<Integer>();
            this.stickingIndexMap.put(stickable, points);
        }
        points.add(p.getIndex());
    }

    public Set<Stickable> getStickables() {
        return this.stickingIndexMap.keySet();
    }

    public List<PointDoubleIndexed> getStickablePoints(Stickable stickable) {
        List<Integer> stickingIndexes = this.stickingIndexMap.get(stickable);
        ArrayList<PointDoubleIndexed> returnList = new ArrayList<PointDoubleIndexed>();
        for (PointDoubleIndexed p : stickable.getStickablePoints()) {
            if (!stickingIndexes.contains(p.getIndex())) continue;
            returnList.add(p);
        }
        return returnList;
    }

    public void setStickablePoints(Stickable stickable, List<PointDoubleIndexed> updatedChangedPoints) {
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        for (PointDoubleIndexed p : updatedChangedPoints) {
            indexList.add(p.getIndex());
        }
        this.stickingIndexMap.put(stickable, indexList);
    }

    public String toString() {
        return "StickableMap [map=" + SharedUtils.mapToString("\n", ",", this.stickingIndexMap) + "]";
    }
}

