/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.parosproxy.paros.core.scanner.NameValuePair;
import org.parosproxy.paros.core.scanner.Variant;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;

public class VariantUserDefined
implements Variant {
    private static Map<String, int[][]> injectionPointMap = new HashMap<String, int[][]>();
    private int headerLength;
    private int bodyLength;
    private int[][] injectionPoints = null;
    private static final Logger logger = Logger.getLogger(VariantUserDefined.class);

    public static void setInjectionPoints(String string, int[][] nArray) {
        injectionPointMap.put(string, nArray);
    }

    @Override
    public void setMessage(HttpMessage httpMessage) {
        this.headerLength = httpMessage.getRequestHeader().toString().length();
        this.bodyLength = httpMessage.getRequestBody().toString().length();
        String string = httpMessage.getRequestHeader().getURI().toString();
        this.injectionPoints = injectionPointMap.get(string);
    }

    @Override
    public List<NameValuePair> getParamList() {
        ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>();
        if (this.injectionPoints != null) {
            for (int i = 0; i < this.injectionPoints.length; ++i) {
                if (this.isInHeader(this.injectionPoints[i]) || this.isInBody(this.injectionPoints[i])) {
                    arrayList.add(new NameValuePair(-1, "", "", i));
                    continue;
                }
                logger.warn((Object)("Invalid injection point: " + Arrays.toString(this.injectionPoints[i])));
            }
        }
        return arrayList;
    }

    @Override
    public String setParameter(HttpMessage httpMessage, NameValuePair nameValuePair, String string, String string2) {
        int[] nArray = this.injectionPoints[nameValuePair.getPosition()];
        if (this.isInHeader(nArray)) {
            String string3 = httpMessage.getRequestHeader().toString();
            StringBuilder stringBuilder = new StringBuilder(string3.length());
            stringBuilder.append(string3.substring(0, nArray[0]));
            stringBuilder.append(string2);
            stringBuilder.append(string3.substring(nArray[1]));
            try {
                httpMessage.getRequestHeader().setMessage(stringBuilder.toString());
            }
            catch (HttpMalformedHeaderException httpMalformedHeaderException) {
                logger.error((Object)httpMalformedHeaderException.getMessage(), (Throwable)httpMalformedHeaderException);
            }
        } else {
            String string4 = httpMessage.getRequestBody().toString();
            StringBuilder stringBuilder = new StringBuilder(string4.length());
            stringBuilder.append(string4.substring(0, nArray[0] - this.headerLength));
            stringBuilder.append(string2);
            stringBuilder.append(string4.substring(nArray[1] - this.headerLength));
            httpMessage.getRequestBody().setBody(stringBuilder.toString());
        }
        return "value";
    }

    @Override
    public String setEscapedParameter(HttpMessage httpMessage, NameValuePair nameValuePair, String string, String string2) {
        return this.setParameter(httpMessage, nameValuePair, string, string2);
    }

    private boolean isInHeader(int[] nArray) {
        return nArray[0] < this.headerLength && nArray[1] < this.headerLength;
    }

    private boolean isInBody(int[] nArray) {
        return nArray[0] > this.headerLength && nArray[1] > this.headerLength && nArray[0] - this.headerLength < this.bodyLength && nArray[1] - this.headerLength < this.bodyLength;
    }
}

