/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.control;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.parosproxy.paros.core.scanner.AbstractPlugin;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.control.AddOnClassLoader;
import org.zaproxy.zap.extension.pscan.PluginPassiveScanner;

final class AddOnLoaderUtils {
    private static final Logger LOGGER = Logger.getLogger(AddOnLoaderUtils.class);

    private AddOnLoaderUtils() {
    }

    public static <T> T loadAndInstantiateClass(AddOnClassLoader addOnClassLoader, String string, Class<T> clazz, String string2) {
        AddOnLoaderUtils.validateNotNull(addOnClassLoader, "addOnClassLoader");
        AddOnLoaderUtils.validateNotNull(string, "classname");
        AddOnLoaderUtils.validateNotNull(clazz, "clazz");
        AddOnLoaderUtils.validateNotNull(string2, "type");
        return AddOnLoaderUtils.loadAndInstantiateClassImpl(addOnClassLoader, string, clazz, string2);
    }

    private static <T> T loadAndInstantiateClassImpl(AddOnClassLoader addOnClassLoader, String string, Class<T> clazz, String string2) {
        Class<?> clazz2;
        try {
            clazz2 = addOnClassLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOGGER.error((Object)("Declared \"" + string2 + "\" was not found: " + string), (Throwable)classNotFoundException);
            return null;
        }
        if (Modifier.isAbstract(clazz2.getModifiers()) || Modifier.isInterface(clazz2.getModifiers())) {
            LOGGER.error((Object)("Declared \"" + string2 + "\" is abstract or an interface: " + string));
            return null;
        }
        if (!clazz.isAssignableFrom(clazz2)) {
            LOGGER.error((Object)("Declared \"" + string2 + "\" is not of type \"" + clazz.getName() + "\": " + string));
            return null;
        }
        try {
            Constructor<?> constructor = clazz2.getConstructor(new Class[0]);
            Object obj = constructor.newInstance(new Object[0]);
            return (T)obj;
        }
        catch (Exception exception) {
            LOGGER.debug((Object)exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    public static <T> List<T> loadDeclaredClasses(AddOnClassLoader addOnClassLoader, List<String> list, Class<T> clazz, String string) {
        AddOnLoaderUtils.validateNotNull(addOnClassLoader, "addOnClassLoader");
        AddOnLoaderUtils.validateNotNull(list, "classnames");
        AddOnLoaderUtils.validateNotNull(clazz, "clazz");
        AddOnLoaderUtils.validateNotNull(string, "type");
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> arrayList = new ArrayList<T>(list.size());
        for (String string2 : list) {
            T t = AddOnLoaderUtils.loadAndInstantiateClassImpl(addOnClassLoader, string2, clazz, string);
            if (t == null) continue;
            arrayList.add(t);
        }
        arrayList.trimToSize();
        return Collections.unmodifiableList(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<AbstractPlugin> getActiveScanRules(AddOn addOn, AddOnClassLoader addOnClassLoader) {
        AddOnLoaderUtils.validateNotNull(addOn, "addOn");
        AddOnLoaderUtils.validateNotNull(addOnClassLoader, "addOnClassLoader");
        AddOn addOn2 = addOn;
        synchronized (addOn2) {
            if (addOn.isLoadedAscanrulesSet()) {
                return addOn.getLoadedAscanrules();
            }
            List<AbstractPlugin> list = AddOnLoaderUtils.loadDeclaredClasses(addOnClassLoader, addOn.getAscanrules(), AbstractPlugin.class, "ascanrule");
            addOn.setLoadedAscanrules(list);
            addOn.setLoadedAscanrulesSet(true);
            return Collections.unmodifiableList(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PluginPassiveScanner> getPassiveScanRules(AddOn addOn, AddOnClassLoader addOnClassLoader) {
        AddOnLoaderUtils.validateNotNull(addOn, "addOn");
        AddOnLoaderUtils.validateNotNull(addOnClassLoader, "addOnClassLoader");
        AddOn addOn2 = addOn;
        synchronized (addOn2) {
            if (addOn.isLoadedPscanrulesSet()) {
                return addOn.getLoadedPscanrules();
            }
            List<PluginPassiveScanner> list = AddOnLoaderUtils.loadDeclaredClasses(addOnClassLoader, addOn.getPscanrules(), PluginPassiveScanner.class, "pscanrule");
            addOn.setLoadedPscanrules(list);
            addOn.setLoadedPscanrulesSet(true);
            return Collections.unmodifiableList(list);
        }
    }

    private static void validateNotNull(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException("Parameter " + string + " must not be null.");
        }
    }
}

