/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.api.AbstractAPIGenerator;
import org.zaproxy.zap.extension.api.ApiElement;
import org.zaproxy.zap.extension.api.ApiImplementor;

public class DotNetAPIGenerator
extends AbstractAPIGenerator {
    private final String HEADER = "/* Zed Attack Proxy (ZAP) and its related class files.\n *\n * ZAP is an HTTP/HTTPS proxy for assessing web application security.\n *\n * Copyright the ZAP development team\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *   http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n";
    private static final Map<String, String> nameMap;

    public DotNetAPIGenerator() {
        super("../zap-api-dotnet/src/OWASPZAPDotNetAPI/OWASPZAPDotNetAPI/Generated");
    }

    public DotNetAPIGenerator(String string, boolean bl) {
        super(string, bl);
    }

    @Deprecated
    public void generateCSharpFiles(List<ApiImplementor> list) throws IOException {
        this.generateAPIFiles((List)list);
    }

    private void generateCSharpElement(ApiElement apiElement, String string, String string2, Writer writer) throws IOException {
        boolean bl;
        block35: {
            bl = false;
            String string3 = apiElement.getDescriptionTag();
            if (string3 == null) {
                string3 = string + ".api." + string2 + "." + apiElement.getName();
            }
            try {
                Iterator<String> iterator = this.getMessages().getString(string3);
                writer.write("\t\t/// <summary>\n");
                writer.write("\t\t///" + (String)((Object)iterator) + "\n");
                if (this.isOptional()) {
                    writer.write("\t\t///This component is optional and therefore the API will only work if it is installed\n");
                }
                writer.write("\t\t/// </summary>\n");
                writer.write("\t\t/// <returns></returns>\n");
            }
            catch (Exception exception) {
                System.out.println("No i18n for: " + string3);
                if (!this.isOptional()) break block35;
                writer.write("\t\t/// <summary>\n");
                writer.write("\t\t///This component is optional and therefore the API will only work if it is installed\n");
                writer.write("\t\t/// </summary>\n");
                writer.write("\t\t/// <returns></returns>\n");
            }
        }
        if (string2.equals("other")) {
            writer.write("\t\tpublic byte[] " + DotNetAPIGenerator.createMethodName(apiElement.getName()) + "(");
        } else {
            writer.write("\t\tpublic IApiResponse " + DotNetAPIGenerator.createMethodName(apiElement.getName()) + "(");
        }
        if (string2.equals("action") || string2.equals("other")) {
            bl = true;
            writer.write("string ");
            writer.write(API.API_KEY_PARAM);
        }
        if (apiElement.getMandatoryParamNames() != null) {
            for (String string4 : apiElement.getMandatoryParamNames()) {
                if (!bl) {
                    bl = true;
                } else {
                    writer.write(", ");
                }
                if (string4.toLowerCase().equals("boolean")) {
                    writer.write("bool boolean");
                    continue;
                }
                if (string4.toLowerCase().equals("integer")) {
                    writer.write("int i");
                    continue;
                }
                writer.write("string ");
                writer.write(DotNetAPIGenerator.createParameterName(string4.toLowerCase()));
            }
        }
        if (apiElement.getOptionalParamNames() != null) {
            for (String string4 : apiElement.getOptionalParamNames()) {
                if (!bl) {
                    bl = true;
                } else {
                    writer.write(", ");
                }
                if (string4.toLowerCase().equals("boolean")) {
                    writer.write("bool boolean");
                    continue;
                }
                if (string4.toLowerCase().equals("integer")) {
                    writer.write("int i");
                    continue;
                }
                writer.write("string ");
                writer.write(DotNetAPIGenerator.createParameterName(string4.toLowerCase()));
            }
        }
        writer.write(")\n\t\t{\n");
        writer.write("\t\t\tDictionary<string, string> parameters = null;\n");
        if (bl) {
            writer.write("\t\t\tparameters = new Dictionary<string, string>();\n");
            if (string2.equals("action") || string2.equals("other")) {
                writer.write("\t\t\tif (!string.IsNullOrWhiteSpace(apikey)){\n");
                writer.write("\t\t\t\tparameters.Add(\"apikey\", apikey);\n");
                writer.write("\t\t\t}\n");
            }
            if (apiElement.getMandatoryParamNames() != null) {
                for (String string4 : apiElement.getMandatoryParamNames()) {
                    writer.write("\t\t\tparameters.Add(\"" + string4 + "\", ");
                    if (string4.toLowerCase().equals("boolean")) {
                        writer.write("Convert.ToString(boolean)");
                    } else if (string4.toLowerCase().equals("integer")) {
                        writer.write("Convert.ToString(i)");
                    } else {
                        writer.write(DotNetAPIGenerator.createParameterName(string4.toLowerCase()));
                    }
                    writer.write(");\n");
                }
            }
            if (apiElement.getOptionalParamNames() != null) {
                for (String string4 : apiElement.getOptionalParamNames()) {
                    writer.write("\t\t\tparameters.Add(\"" + string4 + "\", ");
                    if (string4.toLowerCase().equals("boolean")) {
                        writer.write("Convert.ToString(boolean)");
                    } else if (string4.toLowerCase().equals("integer")) {
                        writer.write("Convert.ToString(i)");
                    } else {
                        writer.write(DotNetAPIGenerator.createParameterName(string4.toLowerCase()));
                    }
                    writer.write(");\n");
                }
            }
        }
        if (string2.equals("other")) {
            writer.write("\t\t\treturn api.CallApiOther(\"" + string + "\", \"" + string2 + "\", \"" + apiElement.getName() + "\", parameters);\n");
        } else {
            writer.write("\t\t\treturn api.CallApi(\"" + string + "\", \"" + string2 + "\", \"" + apiElement.getName() + "\", parameters);\n");
        }
        writer.write("\t\t}\n\n");
    }

    private static String createMethodName(String string) {
        if (nameMap.containsKey(string)) {
            string = nameMap.get(string);
        }
        return DotNetAPIGenerator.removeAllFullStopCharacters(string);
    }

    private static String removeAllFullStopCharacters(String string) {
        return string.replaceAll("\\.", "");
    }

    private static String createParameterName(String string) {
        if (nameMap.containsKey(string)) {
            string = nameMap.get(string);
        }
        return DotNetAPIGenerator.removeAllFullStopCharacters(string);
    }

    @Override
    protected void generateAPIFiles(ApiImplementor apiImplementor) throws IOException {
        String string = apiImplementor.getPrefix().substring(0, 1).toUpperCase() + apiImplementor.getPrefix().substring(1);
        Path path = this.getDirectory().resolve(string + ".cs");
        System.out.println("Generating " + path.toAbsolutePath());
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            bufferedWriter.write("/* Zed Attack Proxy (ZAP) and its related class files.\n *\n * ZAP is an HTTP/HTTPS proxy for assessing web application security.\n *\n * Copyright the ZAP development team\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *   http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n");
            bufferedWriter.write("\n\n");
            bufferedWriter.write("using System;\n");
            bufferedWriter.write("using System.Collections.Generic;\n");
            bufferedWriter.write("using System.Text;\n");
            bufferedWriter.write("\n");
            bufferedWriter.write("\n");
            bufferedWriter.write("/*\n");
            bufferedWriter.write(" * This file was automatically generated.\n");
            bufferedWriter.write(" */\n");
            bufferedWriter.write("namespace OWASPZAPDotNetAPI.Generated\n");
            bufferedWriter.write("{\n");
            bufferedWriter.write("\tpublic class " + string + " \n\t{");
            bufferedWriter.write("\n\t\tprivate ClientApi api = null;\n\n");
            bufferedWriter.write("\t\tpublic " + string + "(ClientApi api) \n\t\t{\n");
            bufferedWriter.write("\t\t\tthis.api = api;\n");
            bufferedWriter.write("\t\t}\n\n");
            for (ApiElement apiElement : apiImplementor.getApiViews()) {
                this.generateCSharpElement(apiElement, apiImplementor.getPrefix(), "view", bufferedWriter);
            }
            for (ApiElement apiElement : apiImplementor.getApiActions()) {
                this.generateCSharpElement(apiElement, apiImplementor.getPrefix(), "action", bufferedWriter);
            }
            for (ApiElement apiElement : apiImplementor.getApiOthers()) {
                this.generateCSharpElement(apiElement, apiImplementor.getPrefix(), "other", bufferedWriter);
            }
            bufferedWriter.write("\t}\n");
            bufferedWriter.write("}\n");
        }
    }

    public static void main(String[] stringArray) throws Exception {
        DotNetAPIGenerator dotNetAPIGenerator = new DotNetAPIGenerator("../zap-api-dotnet/src/OWASPZAPDotNetAPI/OWASPZAPDotNetAPI/Generated", false);
        dotNetAPIGenerator.generateCoreAPIFiles();
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("break", "brk");
        hashMap.put("continue", "cont");
        hashMap.put("string", "str");
        hashMap.put("params", "parameters");
        nameMap = Collections.unmodifiableMap(hashMap);
    }
}

