/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.charts;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.lib.profiler.charts.ChartItem;
import org.netbeans.lib.profiler.charts.ChartItemChange;
import org.netbeans.lib.profiler.charts.ItemsListener;

public interface ItemsModel {
    public int getItemsCount();

    public ChartItem getItem(int var1);

    public void addItemsListener(ItemsListener var1);

    public void removeItemsListener(ItemsListener var1);

    public static abstract class Abstract
    implements ItemsModel {
        private List<ItemsListener> listeners;

        @Override
        public void addItemsListener(ItemsListener itemsListener) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<ItemsListener>();
            }
            if (!this.listeners.contains(itemsListener)) {
                this.listeners.add(itemsListener);
            }
        }

        @Override
        public void removeItemsListener(ItemsListener itemsListener) {
            if (this.listeners != null) {
                this.listeners.remove(itemsListener);
                if (this.listeners.isEmpty()) {
                    this.listeners = null;
                }
            }
        }

        protected void fireItemsAdded(List<ChartItem> list) {
            if (this.listeners != null) {
                for (ItemsListener itemsListener : this.listeners) {
                    itemsListener.itemsAdded(list);
                }
            }
        }

        protected void fireItemsRemoved(List<ChartItem> list) {
            if (this.listeners != null) {
                for (ItemsListener itemsListener : this.listeners) {
                    itemsListener.itemsRemoved(list);
                }
            }
        }

        protected void fireItemsChanged(List<ChartItemChange> list) {
            if (this.listeners != null) {
                for (ItemsListener itemsListener : this.listeners) {
                    itemsListener.itemsChanged(list);
                }
            }
        }
    }
}

