

  {extends file="main.tpl"}
    <!DOCTYPE head PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"><head xmlns="http://www.w3.org/1999/xhtml">
  {block name=title}GPSBabel development:Memory-Map Navigator overlay files (.mmo) (mmo){/block}
  {block name=body}{literal}
                       
  <div xmlns="http://www.w3.org/1999/xhtml" class="navheader"><table width="100%" summary="Navigation header"><tr><th colspan="3" align="center">Memory-Map Navigator overlay files (.mmo) (mmo)</th></tr><tr><td width="20%" align="left"><a accesskey="p" href="fmt_mtk_locus.html">Prev</a> </td><th width="60%" align="center">Chapter 3. The Formats</th><td width="20%" align="right"> <a accesskey="n" href="fmt_s_and_t.html">Next</a></td></tr></table><hr /></div><div xmlns="http://www.w3.org/1999/xhtml" class="section"><div class="titlepage"><div><div><h2 class="title" ><a id="fmt_mmo"></a>Memory-Map Navigator overlay files (.mmo) (mmo)</h2></div></div></div><p class="fmtcapshdr">
    This format can...
    </p><div class="itemizedlist"><ul class="itemizedlist" style="list-style-type: disc; "><li class="listitem"><p class="fmtcapsitem">
          read and write waypoints
        </p></li><li class="listitem"><p class="fmtcapsitem">
          read and write tracks
        </p></li><li class="listitem"><p class="fmtcapsitem">
          read and write routes
        </p></li></ul></div><p>This format has the following options: <a class="link" href="fmt_mmo.html#fmt_mmo_o_locked" title="locked option">locked</a>, <a class="link" href="fmt_mmo.html#fmt_mmo_o_visible" title="visible option">visible</a>, <a class="link" href="fmt_mmo.html#fmt_mmo_o_ver" title="ver option">ver</a> .</p><p>
   The 'mmo' format provides support for binary .mmo files used by the
   Memory-Map Navigator software.
</p><p>
   Our module was reverse engineered from a couple of .mmo files found
   in the www. The results of the writing code have been tested with a current
   Memory-Map Navigator trial ('Viewer') release.
</p><p>
   Because of different file versions and sometimes slightly different file structure
   we cannot ensure, that every .mmo file is loadable at this time. If you have one,
   which causes errors, please provide it [mailto:gpsbabel-misc@lists.sourceforge.net].
</p><p>
   More information can be found at the 
   <a class="ulink" href="http://www.memory-map.com/" target="_top">Memory-Map</a> site.
</p><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_mmo_o_locked"></a><code class="option">locked</code> option</h3></div></div></div><p>
      Write items 'locked' [default no].
    </p><p>
   By default GPSBabel creates only 'un-locked' items.
</p><p>
   Sample command to write an mmo file with 'locked' items:
</p><p>
   <strong class="userinput"><code>
      gpsbabel -i gpx -f in.gpx -o mmo,locked=y -F out.mmo
   </code></strong>
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_mmo_o_visible"></a><code class="option">visible</code> option</h3></div></div></div><p>
      Write items 'visible' [default yes].
    </p><p>
   This option can be useful, if you want to convert a big file with a lot of entries.
   By default GPSBabel creates only 'visible' items.
</p><p>
   Sample command to write an mmo file with 'invisible' items:
</p><p>
   <strong class="userinput"><code>
      gpsbabel -i gpx -f in.gpx -o mmo,visible=n -F out.mmo
   </code></strong>
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_mmo_o_ver"></a><code class="option">ver</code> option</h3></div></div></div><p>
      Write files with internal version [n].
    </p><p>
Two major strains of Mobile Mapper files have been identified in the wild.  Version 17 is reported as "Memory Map OS Edition 2004, Versio 4.2.3 Build 432" and version 18 is used by the large majority of current files.   We can read either and when writing, we write version 18 by default.  
</p><p>
If you have a particularly old Mobile Mapper installation, it may complain "This file was created with a newer version of the Software" when reading our output.You can get around this if force GPSBabel to create the old format with this option.   
</p><div class="example"><a id="mmo_ver"></a><p class="title"><strong>Example 3.19. Forcing creation of old Mobile Mapper files</strong></p><div class="example-contents"><p>
  gpsbabel -i gpx -f whaetever.gpx -o mmo,ver=17 -F whatever.mmo
</p></div></div><br class="example-break" /></div></div><div xmlns="http://www.w3.org/1999/xhtml" class="navfooter"><hr /><table width="100%" summary="Navigation footer"><tr><td width="40%" align="left"><a accesskey="p" href="fmt_mtk_locus.html">Prev</a> </td><td width="20%" align="center"><a accesskey="u" href="The_Formats.html">Up</a></td><td width="40%" align="right"> <a accesskey="n" href="fmt_s_and_t.html">Next</a></td></tr><tr><td width="40%" align="left" valign="top">MediaTek Locus (mtk_locus) </td><td width="20%" align="center"><a accesskey="h" href="index.html">Home</a></td><td width="40%" align="right" valign="top"> Microsoft Streets and Trips 2002-2007 (s_and_t)</td></tr></table></div>
  
      {/literal}{/block}
  