/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.Closure;
import groovy.lang.GString;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainingTransformer<T>
implements Transformer<T, T> {
    private final List<Transformer<T, T>> transformers = new ArrayList<Transformer<T, T>>();
    private final Class<T> type;

    public ChainingTransformer(Class<T> type) {
        this.type = type;
    }

    public T transform(T original) {
        T value = original;
        for (Transformer<T, T> transformer : this.transformers) {
            value = this.type.cast(transformer.transform(value));
        }
        return value;
    }

    public void add(Transformer<T, T> transformer) {
        this.transformers.add(transformer);
    }

    public void add(final Closure transformer) {
        this.transformers.add(new Transformer<T, T>(){

            public T transform(T original) {
                transformer.setDelegate(original);
                transformer.setResolveStrategy(1);
                Object value = transformer.call(original);
                if (ChainingTransformer.this.type.isInstance(value)) {
                    return ChainingTransformer.this.type.cast(value);
                }
                if (ChainingTransformer.this.type == String.class && value instanceof GString) {
                    return ChainingTransformer.this.type.cast(value.toString());
                }
                return original;
            }
        });
    }

    public boolean hasTransformers() {
        return !this.transformers.isEmpty();
    }
}

