#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: vector
version: 0.12.0.1
id: vector-0.12.0.1-FyKxZ6HyOdr5RycjHR2p0f
key: vector-0.12.0.1-FyKxZ6HyOdr5RycjHR2p0f
license: BSD3
copyright: (c) Roman Leshchinskiy 2008-2012
maintainer: Haskell Libraries Team <libraries@haskell.org>
homepage: https://github.com/haskell/vector
synopsis: Efficient Arrays
description:
    .
    An efficient implementation of Int-indexed arrays (both mutable
    and immutable), with a powerful loop optimisation framework .
    .
    It is structured as follows:
    .
    ["Data.Vector"] Boxed vectors of arbitrary types.
    .
    ["Data.Vector.Unboxed"] Unboxed vectors with an adaptive
    representation based on data type families.
    .
    ["Data.Vector.Storable"] Unboxed vectors of '\''Storable'\'' types.
    .
    ["Data.Vector.Primitive"] Unboxed vectors of primitive types as
    defined by the @primitive@ package. "Data.Vector.Unboxed" is more
    flexible at no performance cost.
    .
    ["Data.Vector.Generic"] Generic interface to the vector types.
    .
    There is also a (draft) tutorial on common uses of vector.
    .
    * <http://haskell.org/haskellwiki/Numeric_Haskell:_A_Vector_Tutorial>
category: Data, Data Structures
author: Roman Leshchinskiy <rl@cse.unsw.edu.au>
exposed: True
exposed-modules:
    Data.Vector.Internal.Check Data.Vector.Fusion.Util
    Data.Vector.Fusion.Stream.Monadic Data.Vector.Fusion.Bundle.Size
    Data.Vector.Fusion.Bundle.Monadic Data.Vector.Fusion.Bundle
    Data.Vector.Generic.Mutable.Base Data.Vector.Generic.Mutable
    Data.Vector.Generic.Base Data.Vector.Generic.New
    Data.Vector.Generic Data.Vector.Primitive.Mutable
    Data.Vector.Primitive Data.Vector.Storable.Internal
    Data.Vector.Storable.Mutable Data.Vector.Storable
    Data.Vector.Unboxed.Base Data.Vector.Unboxed.Mutable
    Data.Vector.Unboxed Data.Vector.Mutable Data.Vector
abi: 445487e873b9e03f808ce1867c8b888e
trusted: False
import-dirs: /usr/lib/ghc-8.0.1/site-local/vector-0.12.0.1
library-dirs: /usr/lib/ghc-8.0.1/site-local/vector-0.12.0.1
data-dir: /usr/share/arm-linux-ghc-8.0.1/vector-0.12.0.1
hs-libraries: HSvector-0.12.0.1-FyKxZ6HyOdr5RycjHR2p0f
include-dirs: /usr/lib/ghc-8.0.1/site-local/vector-0.12.0.1/include
depends:
    base-4.9.0.0 deepseq-1.4.2.0 ghc-prim-0.5.0.0
    primitive-0.6.2.0-3HSsNCfUEEE4fjqDYVydYZ
haddock-interfaces: /usr/share/doc/haskell-vector/html/vector.haddock
haddock-html: /usr/share/doc/haskell-vector/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
