/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.ArgumentAndDeclIndex;
import org.jetbrains.kotlin.codegen.ArgumentGenerator;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.CallGenerator;
import org.jetbrains.kotlin.codegen.DefaultCallArgs;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VarargValueArgument;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.org.objectweb.asm.Type;

public class CallBasedArgumentGenerator
extends ArgumentGenerator {
    private final ExpressionCodegen codegen;
    private final CallGenerator callGenerator;
    private final List<ValueParameterDescriptor> valueParameters;
    private final List<Type> valueParameterTypes;

    public CallBasedArgumentGenerator(@NotNull ExpressionCodegen codegen, @NotNull CallGenerator callGenerator, @NotNull List<ValueParameterDescriptor> valueParameters, @NotNull List<Type> valueParameterTypes) {
        if (codegen == null) {
            CallBasedArgumentGenerator.$$$reportNull$$$0(0);
        }
        if (callGenerator == null) {
            CallBasedArgumentGenerator.$$$reportNull$$$0(1);
        }
        if (valueParameters == null) {
            CallBasedArgumentGenerator.$$$reportNull$$$0(2);
        }
        if (valueParameterTypes == null) {
            CallBasedArgumentGenerator.$$$reportNull$$$0(3);
        }
        this.codegen = codegen;
        this.callGenerator = callGenerator;
        this.valueParameters = valueParameters;
        this.valueParameterTypes = valueParameterTypes;
        assert (valueParameters.size() == valueParameterTypes.size()) : "Value parameters and their types mismatch in sizes: " + valueParameters.size() + " != " + valueParameterTypes.size();
    }

    @Override
    @NotNull
    public DefaultCallArgs generate(@NotNull List<? extends ResolvedValueArgument> valueArgumentsByIndex, @NotNull List<? extends ResolvedValueArgument> valueArgs, @Nullable CallableDescriptor calleeDescriptor) {
        if (valueArgumentsByIndex == null) {
            CallBasedArgumentGenerator.$$$reportNull$$$0(4);
        }
        if (valueArgs == null) {
            CallBasedArgumentGenerator.$$$reportNull$$$0(5);
        }
        boolean shouldMarkLineNumbers = this.codegen.isShouldMarkLineNumbers();
        this.codegen.setShouldMarkLineNumbers(false);
        DefaultCallArgs defaultArgs = super.generate(valueArgumentsByIndex, valueArgs, calleeDescriptor);
        this.codegen.setShouldMarkLineNumbers(shouldMarkLineNumbers);
        DefaultCallArgs defaultCallArgs = defaultArgs;
        if (defaultCallArgs == null) {
            CallBasedArgumentGenerator.$$$reportNull$$$0(6);
        }
        return defaultCallArgs;
    }

    @Override
    protected void generateExpression(int i, @NotNull ExpressionValueArgument argument) {
        if (argument == null) {
            CallBasedArgumentGenerator.$$$reportNull$$$0(7);
        }
        ValueParameterDescriptor parameter = this.valueParameters.get(i);
        Type type2 = this.valueParameterTypes.get(i);
        ValueArgument valueArgument = argument.getValueArgument();
        assert (valueArgument != null);
        KtExpression argumentExpression = valueArgument.getArgumentExpression();
        assert (argumentExpression != null) : valueArgument.asElement().getText();
        this.callGenerator.genValueAndPut(parameter, argumentExpression, type2, i);
    }

    @Override
    protected void generateDefault(int i, @NotNull DefaultValueArgument argument) {
        if (argument == null) {
            CallBasedArgumentGenerator.$$$reportNull$$$0(8);
        }
        Type type2 = this.valueParameterTypes.get(i);
        AsmUtil.pushDefaultValueOnStack(type2, this.codegen.v);
        this.callGenerator.afterParameterPut(type2, null, i);
    }

    @Override
    protected void generateVararg(int i, @NotNull VarargValueArgument argument) {
        if (argument == null) {
            CallBasedArgumentGenerator.$$$reportNull$$$0(9);
        }
        ValueParameterDescriptor parameter = this.valueParameters.get(i);
        Type type2 = this.valueParameterTypes.get(i);
        this.codegen.genVarargs(argument, FlexibleTypesKt.upperIfFlexible(parameter.getType()));
        this.callGenerator.afterParameterPut(type2, null, i);
    }

    @Override
    protected void reorderArgumentsIfNeeded(@NotNull List<ArgumentAndDeclIndex> actualArgsWithDeclIndex) {
        if (actualArgsWithDeclIndex == null) {
            CallBasedArgumentGenerator.$$$reportNull$$$0(10);
        }
        this.callGenerator.reorderArgumentsIfNeeded(actualArgsWithDeclIndex, this.valueParameterTypes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codegen";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callGenerator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueParameters";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueParameterTypes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueArgumentsByIndex";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueArgs";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/CallBasedArgumentGenerator";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualArgsWithDeclIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/CallBasedArgumentGenerator";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "generate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "generate";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "generateExpression";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generateDefault";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "generateVararg";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "reorderArgumentsIfNeeded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

