/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rdr.InStream;
import com.tigervnc.rdr.OutStream;
import com.tigervnc.rfb.ConnParams;
import com.tigervnc.rfb.Decoder;
import com.tigervnc.rfb.LogWriter;
import com.tigervnc.rfb.ModifiablePixelBuffer;
import com.tigervnc.rfb.Rect;

public class RawDecoder
extends Decoder {
    static LogWriter vlog = new LogWriter("RawDecoder");

    public RawDecoder() {
        super(Decoder.DecoderFlags.DecoderPlain);
    }

    @Override
    public void readRect(Rect rect, InStream inStream, ConnParams connParams, OutStream outStream) {
        outStream.copyBytes(inStream, rect.area() * connParams.pf().bpp / 8);
    }

    @Override
    public void decodeRect(Rect rect, Object object, int n, ConnParams connParams, ModifiablePixelBuffer modifiablePixelBuffer) {
        assert (n >= rect.area() * connParams.pf().bpp / 8);
        modifiablePixelBuffer.imageRect(connParams.pf(), rect, (byte[])object);
    }
}

