/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset.serial;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;
import javax.sql.rowset.serial.SerialException;

public class SerialBlob
implements Blob,
Serializable,
Cloneable {
    private byte[] buf;
    private Blob blob;
    private long len;
    private long origLen;
    static final long serialVersionUID = -8144641928112860441L;

    public SerialBlob(byte[] b) throws SerialException, SQLException {
        this.len = b.length;
        this.buf = new byte[(int)this.len];
        int i = 0;
        while ((long)i < this.len) {
            this.buf[i] = b[i];
            ++i;
        }
        this.origLen = this.len;
    }

    public SerialBlob(Blob blob) throws SerialException, SQLException {
        if (blob == null) {
            throw new SQLException("Cannot instantiate a SerialBlob object with a null Blob object");
        }
        this.len = blob.length();
        this.buf = blob.getBytes(1L, (int)this.len);
        this.blob = blob;
        this.origLen = this.len;
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SerialException {
        if ((long)length > this.len) {
            length = (int)this.len;
        }
        if (pos < 1L || this.len - pos < 0L) {
            throw new SerialException("Invalid arguments: position cannot be less than 1 or greater than the length of the SerialBlob");
        }
        --pos;
        byte[] b = new byte[length];
        for (int i = 0; i < length; ++i) {
            b[i] = this.buf[(int)pos];
            ++pos;
        }
        return b;
    }

    @Override
    public long length() throws SerialException {
        return this.len;
    }

    @Override
    public InputStream getBinaryStream() throws SerialException {
        ByteArrayInputStream stream = new ByteArrayInputStream(this.buf);
        return stream;
    }

    @Override
    public long position(byte[] pattern, long start) throws SerialException, SQLException {
        if (start < 1L || start > this.len) {
            return -1L;
        }
        int pos = (int)start - 1;
        int i = 0;
        long patlen = pattern.length;
        while ((long)pos < this.len) {
            if (pattern[i] == this.buf[pos]) {
                if ((long)(i + 1) == patlen) {
                    return (long)(pos + 1) - (patlen - 1L);
                }
                ++i;
                ++pos;
                continue;
            }
            if (pattern[i] == this.buf[pos]) continue;
            ++pos;
        }
        return -1L;
    }

    @Override
    public long position(Blob pattern, long start) throws SerialException, SQLException {
        return this.position(pattern.getBytes(1L, (int)pattern.length()), start);
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SerialException, SQLException {
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int length) throws SerialException, SQLException {
        int i;
        if (offset < 0 || offset > bytes.length) {
            throw new SerialException("Invalid offset in byte array set");
        }
        if (pos < 1L || pos > this.length()) {
            throw new SerialException("Invalid position in BLOB object set");
        }
        if ((long)length > this.origLen) {
            throw new SerialException("Buffer is not sufficient to hold the value");
        }
        if (length + offset > bytes.length) {
            throw new SerialException("Invalid OffSet. Cannot have combined offset and length that is greater that the Blob buffer");
        }
        --pos;
        for (i = 0; i < length || offset + i + 1 < bytes.length - offset; ++i) {
            this.buf[(int)pos + i] = bytes[offset + i];
        }
        return i;
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SerialException, SQLException {
        if (this.blob.setBinaryStream(pos) != null) {
            return this.blob.setBinaryStream(pos);
        }
        throw new SerialException("Unsupported operation. SerialBlob cannot return a writable binary stream, unless instantiated with a Blob object that provides a setBinaryStream() implementation");
    }

    @Override
    public void truncate(long length) throws SerialException {
        if (length > this.len) {
            throw new SerialException("Length more than what can be truncated");
        }
        if ((int)length == 0) {
            this.buf = new byte[0];
            this.len = length;
        } else {
            this.len = length;
            this.buf = this.getBytes(1L, (int)this.len);
        }
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void free() throws SQLException {
        throw new UnsupportedOperationException("Not supported");
    }
}

