/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import org.jdesktop.swingx.MultiSplitLayout;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.painter.Painter;

public class JXMultiSplitPane
extends JPanel {
    private AccessibleContext accessibleContext = null;
    private boolean continuousLayout = true;
    private DividerPainter dividerPainter = new DefaultDividerPainter();
    private Painter backgroundPainter;
    private boolean dragUnderway = false;
    private MultiSplitLayout.Divider dragDivider = null;
    private Rectangle initialDividerBounds = null;
    private boolean oldFloatingDividers = true;
    private int dragOffsetX = 0;
    private int dragOffsetY = 0;
    private int dragMin = -1;
    private int dragMax = -1;

    public JXMultiSplitPane() {
        this(new MultiSplitLayout());
    }

    public JXMultiSplitPane(MultiSplitLayout layout) {
        super(layout);
        InputHandler inputHandler = new InputHandler();
        this.addMouseListener(inputHandler);
        this.addMouseMotionListener(inputHandler);
        this.addKeyListener(inputHandler);
        this.setFocusable(true);
    }

    public final MultiSplitLayout getMultiSplitLayout() {
        return (MultiSplitLayout)this.getLayout();
    }

    public final void setModel(MultiSplitLayout.Node model) {
        this.getMultiSplitLayout().setModel(model);
    }

    public final void setDividerSize(int dividerSize) {
        this.getMultiSplitLayout().setDividerSize(dividerSize);
    }

    public final int getDividerSize() {
        return this.getMultiSplitLayout().getDividerSize();
    }

    public void setContinuousLayout(boolean continuousLayout) {
        boolean oldContinuousLayout = this.isContinuousLayout();
        this.continuousLayout = continuousLayout;
        this.firePropertyChange("continuousLayout", oldContinuousLayout, this.isContinuousLayout());
    }

    public boolean isContinuousLayout() {
        return this.continuousLayout;
    }

    public MultiSplitLayout.Divider activeDivider() {
        return this.dragDivider;
    }

    public DividerPainter getDividerPainter() {
        return this.dividerPainter;
    }

    public void setDividerPainter(DividerPainter dividerPainter) {
        DividerPainter old = this.getDividerPainter();
        this.dividerPainter = dividerPainter;
        this.firePropertyChange("dividerPainter", old, this.getDividerPainter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintComponent(Graphics g) {
        if (this.backgroundPainter != null) {
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                Insets ins = this.getInsets();
                g2.translate(ins.left, ins.top);
                this.backgroundPainter.paint(g2, this, this.getWidth() - ins.left - ins.right, this.getHeight() - ins.top - ins.bottom);
            }
            finally {
                g2.dispose();
            }
        } else {
            super.paintComponent(g);
        }
    }

    public void setBackgroundPainter(Painter p) {
        Painter old = this.getBackgroundPainter();
        this.backgroundPainter = p;
        if (p != null) {
            this.setOpaque(false);
        }
        this.firePropertyChange("backgroundPainter", old, this.getBackgroundPainter());
        this.repaint();
    }

    public Painter getBackgroundPainter() {
        return this.backgroundPainter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintChildren(Graphics g) {
        MultiSplitLayout msl;
        super.paintChildren(g);
        DividerPainter dp = this.getDividerPainter();
        Rectangle clipR = g.getClipBounds();
        if (dp != null && clipR != null && (msl = this.getMultiSplitLayout()).hasModel()) {
            for (MultiSplitLayout.Divider divider : msl.dividersThatOverlap(clipR)) {
                Rectangle bounds = divider.getBounds();
                Graphics cg = g.create(bounds.x, bounds.y, bounds.width, bounds.height);
                try {
                    dp.paint((Graphics2D)cg, divider, bounds.width, bounds.height);
                }
                finally {
                    cg.dispose();
                }
            }
        }
    }

    private void startDrag(int mx, int my) {
        this.requestFocusInWindow();
        MultiSplitLayout msl = this.getMultiSplitLayout();
        MultiSplitLayout.Divider divider = msl.dividerAt(mx, my);
        if (divider != null) {
            MultiSplitLayout.Node prevNode = divider.previousSibling();
            MultiSplitLayout.Node nextNode = divider.nextSibling();
            if (prevNode == null || nextNode == null) {
                this.dragUnderway = false;
            } else {
                this.initialDividerBounds = divider.getBounds();
                this.dragOffsetX = mx - this.initialDividerBounds.x;
                this.dragOffsetY = my - this.initialDividerBounds.y;
                this.dragDivider = divider;
                Rectangle prevNodeBounds = prevNode.getBounds();
                Rectangle nextNodeBounds = nextNode.getBounds();
                if (this.dragDivider.isVertical()) {
                    this.dragMin = prevNodeBounds.x;
                    this.dragMax = nextNodeBounds.x + nextNodeBounds.width;
                    this.dragMax -= this.dragDivider.getBounds().width;
                    if (msl.getLayoutMode() == 2) {
                        this.dragMax -= msl.getUserMinSize();
                    }
                } else {
                    this.dragMin = prevNodeBounds.y;
                    this.dragMax = nextNodeBounds.y + nextNodeBounds.height;
                    this.dragMax -= this.dragDivider.getBounds().height;
                    if (msl.getLayoutMode() == 2) {
                        this.dragMax -= msl.getUserMinSize();
                    }
                }
                if (msl.getLayoutMode() == 2) {
                    this.dragMin += msl.getUserMinSize();
                } else if (this.dragDivider.isVertical()) {
                    this.dragMin = Math.max(this.dragMin, this.dragMin + this.getMinNodeSize((MultiSplitLayout)msl, (MultiSplitLayout.Node)prevNode).width);
                    this.dragMax = Math.min(this.dragMax, this.dragMax - this.getMinNodeSize((MultiSplitLayout)msl, (MultiSplitLayout.Node)nextNode).width);
                    Dimension maxDim = this.getMaxNodeSize(msl, prevNode);
                    if (maxDim != null) {
                        this.dragMax = Math.min(this.dragMax, prevNodeBounds.x + maxDim.width);
                    }
                } else {
                    this.dragMin = Math.max(this.dragMin, this.dragMin + this.getMinNodeSize((MultiSplitLayout)msl, (MultiSplitLayout.Node)prevNode).height);
                    this.dragMax = Math.min(this.dragMax, this.dragMax - this.getMinNodeSize((MultiSplitLayout)msl, (MultiSplitLayout.Node)nextNode).height);
                    Dimension maxDim = this.getMaxNodeSize(msl, prevNode);
                    if (maxDim != null) {
                        this.dragMax = Math.min(this.dragMax, prevNodeBounds.y + maxDim.height);
                    }
                }
                this.oldFloatingDividers = this.getMultiSplitLayout().getFloatingDividers();
                this.getMultiSplitLayout().setFloatingDividers(false);
                this.dragUnderway = true;
            }
        } else {
            this.dragUnderway = false;
        }
    }

    protected Dimension getMaxNodeSize(MultiSplitLayout msl, MultiSplitLayout.Node n) {
        return null;
    }

    protected Dimension getMinNodeSize(MultiSplitLayout msl, MultiSplitLayout.Node n) {
        return msl.minimumNodeSize(n);
    }

    private void repaintDragLimits() {
        Rectangle damageR = this.dragDivider.getBounds();
        if (this.dragDivider.isVertical()) {
            damageR.x = this.dragMin;
            damageR.width = this.dragMax - this.dragMin;
        } else {
            damageR.y = this.dragMin;
            damageR.height = this.dragMax - this.dragMin;
        }
        this.repaint(damageR);
    }

    private void updateDrag(int mx, int my) {
        if (!this.dragUnderway) {
            return;
        }
        Rectangle oldBounds = this.dragDivider.getBounds();
        Rectangle bounds = new Rectangle(oldBounds);
        if (this.dragDivider.isVertical()) {
            bounds.x = mx - this.dragOffsetX;
            bounds.x = Math.max(bounds.x, this.dragMin);
            bounds.x = Math.min(bounds.x, this.dragMax);
        } else {
            bounds.y = my - this.dragOffsetY;
            bounds.y = Math.max(bounds.y, this.dragMin);
            bounds.y = Math.min(bounds.y, this.dragMax);
        }
        this.dragDivider.setBounds(bounds);
        if (this.isContinuousLayout()) {
            this.revalidate();
            this.repaintDragLimits();
        } else {
            this.repaint(oldBounds.union(bounds));
        }
    }

    private void clearDragState() {
        this.dragDivider = null;
        this.initialDividerBounds = null;
        this.oldFloatingDividers = true;
        this.dragOffsetY = 0;
        this.dragOffsetX = 0;
        this.dragMax = -1;
        this.dragMin = -1;
        this.dragUnderway = false;
    }

    private void finishDrag(int x, int y) {
        if (this.dragUnderway) {
            this.clearDragState();
            if (!this.isContinuousLayout()) {
                this.revalidate();
                this.repaint();
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void cancelDrag() {
        if (this.dragUnderway) {
            this.dragDivider.setBounds(this.initialDividerBounds);
            this.getMultiSplitLayout().setFloatingDividers(this.oldFloatingDividers);
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.repaint();
            this.revalidate();
            this.clearDragState();
        }
    }

    private void updateCursor(int x, int y, boolean show) {
        MultiSplitLayout.Divider divider;
        if (this.dragUnderway) {
            return;
        }
        int cursorID = 0;
        if (show && (divider = this.getMultiSplitLayout().dividerAt(x, y)) != null) {
            cursorID = divider.isVertical() ? 11 : 8;
        }
        this.setCursor(Cursor.getPredefinedCursor(cursorID));
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleMultiSplitPane();
        }
        return this.accessibleContext;
    }

    protected class AccessibleMultiSplitPane
    extends JPanel.AccessibleJPanel {
        protected AccessibleMultiSplitPane() {
            super(JXMultiSplitPane.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SPLIT_PANE;
        }
    }

    private class InputHandler
    extends MouseInputAdapter
    implements KeyListener {
        private InputHandler() {
        }

        public void mouseEntered(MouseEvent e) {
            JXMultiSplitPane.this.updateCursor(e.getX(), e.getY(), true);
        }

        public void mouseMoved(MouseEvent e) {
            JXMultiSplitPane.this.updateCursor(e.getX(), e.getY(), true);
        }

        public void mouseExited(MouseEvent e) {
            JXMultiSplitPane.this.updateCursor(e.getX(), e.getY(), false);
        }

        public void mousePressed(MouseEvent e) {
            JXMultiSplitPane.this.startDrag(e.getX(), e.getY());
        }

        public void mouseReleased(MouseEvent e) {
            JXMultiSplitPane.this.finishDrag(e.getX(), e.getY());
        }

        public void mouseDragged(MouseEvent e) {
            JXMultiSplitPane.this.updateDrag(e.getX(), e.getY());
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                JXMultiSplitPane.this.cancelDrag();
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }
    }

    private class DefaultDividerPainter
    extends DividerPainter {
        private DefaultDividerPainter() {
        }

        protected void doPaint(Graphics2D g, MultiSplitLayout.Divider divider, int width, int height) {
            if (divider == JXMultiSplitPane.this.activeDivider() && !JXMultiSplitPane.this.isContinuousLayout()) {
                g.setColor(Color.black);
                g.fillRect(0, 0, width, height);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class DividerPainter
    extends AbstractPainter<MultiSplitLayout.Divider> {
    }
}

