/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.imagery;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.util.Optional;
import org.openstreetmap.josm.Main;

public class ColorfulFilter
implements BufferedImageOp {
    private final double colorfulness;

    ColorfulFilter(double d) {
        this.colorfulness = d;
    }

    @Override
    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n;
        int n2;
        int n3;
        if (bufferedImage.getWidth() == 0 || bufferedImage.getHeight() == 0 || bufferedImage.getType() == 0) {
            return bufferedImage;
        }
        BufferedImage bufferedImage3 = Optional.ofNullable(bufferedImage2).orElseGet(() -> this.createCompatibleDestImage(bufferedImage, null));
        DataBuffer dataBuffer = bufferedImage.getRaster().getDataBuffer();
        DataBuffer dataBuffer2 = bufferedImage3.getRaster().getDataBuffer();
        if (!(dataBuffer instanceof DataBufferByte) || !(dataBuffer2 instanceof DataBufferByte)) {
            Main.trace("Cannot apply color filter: Images do not use DataBufferByte.");
            return bufferedImage;
        }
        int n4 = bufferedImage.getType();
        if (n4 != bufferedImage3.getType()) {
            Main.trace("Cannot apply color filter: Src / Dest differ in type (" + n4 + '/' + bufferedImage3.getType() + ')');
            return bufferedImage;
        }
        int n5 = 0;
        switch (n4) {
            case 5: {
                n3 = 0;
                n2 = 1;
                n = 2;
                break;
            }
            case 6: 
            case 7: {
                n3 = 1;
                n2 = 2;
                n = 3;
                break;
            }
            case 2: 
            case 3: {
                n = 0;
                n2 = 1;
                n3 = 2;
                n5 = 3;
                break;
            }
            default: {
                Main.trace("Cannot apply color filter: Source image is of wrong type (" + n4 + ").");
                return bufferedImage;
            }
        }
        this.doFilter((DataBufferByte)dataBuffer, (DataBufferByte)dataBuffer2, n, n2, n3, n5, bufferedImage.getAlphaRaster() != null);
        return bufferedImage3;
    }

    private void doFilter(DataBufferByte dataBufferByte, DataBufferByte dataBufferByte2, int n, int n2, int n3, int n4, boolean bl) {
        byte[] byArray;
        byte[] byArray2 = dataBufferByte.getData();
        if (byArray2.length != (byArray = dataBufferByte2.getData()).length) {
            Main.trace("Cannot apply color filter: Source/Dest lengths differ.");
            return;
        }
        int n5 = bl ? 4 : 3;
        for (int i = 0; i < byArray2.length; i += n5) {
            int n6 = byArray2[i + n] & 0xFF;
            int n7 = byArray2[i + n2] & 0xFF;
            int n8 = byArray2[i + n3] & 0xFF;
            double d = (double)n6 * 0.21 + (double)n7 * 0.72 + (double)n8 * 0.07;
            byArray[i + n] = this.mix(n6, d);
            byArray[i + n2] = this.mix(n7, d);
            byArray[i + n3] = this.mix(n8, d);
            if (!bl) continue;
            byArray[i + n4] = byArray2[i + n4];
        }
    }

    private byte mix(int n, double d) {
        int n2 = (int)(this.colorfulness * (double)n + (1.0 - this.colorfulness) * d);
        if (n2 < 0) {
            return 0;
        }
        if (n2 > 255) {
            return -1;
        }
        return (byte)n2;
    }

    @Override
    public Rectangle2D getBounds2D(BufferedImage bufferedImage) {
        return new Rectangle(bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    @Override
    public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
        return new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getType());
    }

    @Override
    public Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        return (Point2D)point2D.clone();
    }

    @Override
    public RenderingHints getRenderingHints() {
        return null;
    }
}

