/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.resolve.calls.CallTransformer;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.OperatorCallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.ErrorUtils;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/OperatorCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "Companion", "kotlin-compiler"})
public final class OperatorCallChecker
implements CallChecker {
    public static final Companion Companion = new Companion(null);

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        boolean isConventionOperator;
        Call call2;
        KtElement element;
        FunctionDescriptor functionDescriptor;
        block10: {
            Call outerCall;
            block11: {
                Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
                Intrinsics.checkParameterIsNotNull(reportOn, "reportOn");
                Intrinsics.checkParameterIsNotNull(context, "context");
                Object obj = resolvedCall2.getResultingDescriptor();
                if (!(obj instanceof FunctionDescriptor)) {
                    obj = null;
                }
                FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)obj;
                if (functionDescriptor2 == null) {
                    return;
                }
                functionDescriptor = functionDescriptor2;
                if (!OperatorCallChecker.Companion.checkNotErrorOrDynamic(functionDescriptor)) {
                    return;
                }
                KtExpression ktExpression = resolvedCall2.getCall().getCalleeExpression();
                element = ktExpression != null ? (KtElement)ktExpression : resolvedCall2.getCall().getCallElement();
                call2 = resolvedCall2.getCall();
                if (!(resolvedCall2 instanceof VariableAsFunctionResolvedCall) || !(call2 instanceof CallTransformer.CallForImplicitInvoke) || !((CallTransformer.CallForImplicitInvoke)call2).itIsVariableAsFunctionCall) break block10;
                Call call3 = outerCall = ((CallTransformer.CallForImplicitInvoke)call2).getOuterCall();
                Intrinsics.checkExpressionValueIsNotNull(call3, "outerCall");
                if (CallResolverUtilKt.isConventionCall(call3)) break block11;
                VariableAsFunctionResolvedCall variableAsFunctionResolvedCall = (VariableAsFunctionResolvedCall)((Object)resolvedCall2);
                Call call4 = outerCall;
                Intrinsics.checkExpressionValueIsNotNull(call4, "outerCall");
                if (!OperatorCallChecker.Companion.isWrongCallWithExplicitTypeArguments(variableAsFunctionResolvedCall, call4)) break block10;
            }
            throw (Throwable)((Object)new AssertionError((Object)("Illegal resolved call to variable with invoke for " + outerCall + ". " + ("Variable: " + ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall().getResultingDescriptor()) + ("Invoke: " + ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getFunctionCall().getResultingDescriptor()))));
        }
        if (call2.getCallElement() instanceof KtDestructuringDeclarationEntry || call2 instanceof CallTransformer.CallForImplicitInvoke) {
            if (!functionDescriptor.isOperator()) {
                Companion.report(reportOn, functionDescriptor, context.getTrace());
            }
            return;
        }
        boolean bl = isConventionOperator = element instanceof KtOperationReferenceExpression && ((KtOperationReferenceExpression)element).isConventionOperator();
        if (isConventionOperator) {
            OperatorCallCheckerKt.access$checkModConvention(functionDescriptor, context.getLanguageVersionSettings(), context.getTrace(), reportOn);
        }
        if ((isConventionOperator || element instanceof KtArrayAccessExpression) && !functionDescriptor.isOperator()) {
            Companion.report(reportOn, functionDescriptor, context.getTrace());
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/OperatorCallChecker$Companion;", "", "()V", "checkNotErrorOrDynamic", "", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "isWrongCallWithExplicitTypeArguments", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/VariableAsFunctionResolvedCall;", "outerCall", "Lorg/jetbrains/kotlin/psi/Call;", "report", "", "reportOn", "Lcom/intellij/psi/PsiElement;", "descriptor", "sink", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "kotlin-compiler"})
    public static final class Companion {
        public final void report(@NotNull PsiElement reportOn, @NotNull FunctionDescriptor descriptor2, @NotNull DiagnosticSink sink) {
            Intrinsics.checkParameterIsNotNull(reportOn, "reportOn");
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(sink, "sink");
            if (!this.checkNotErrorOrDynamic(descriptor2)) {
                return;
            }
            DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
            String containingDeclarationName = DescriptorUtilsKt.getFqNameUnsafe(containingDeclaration).asString();
            sink.report(Errors.OPERATOR_MODIFIER_REQUIRED.on(reportOn, descriptor2, containingDeclarationName));
        }

        private final boolean checkNotErrorOrDynamic(FunctionDescriptor functionDescriptor) {
            return !DynamicCallsKt.isDynamic(functionDescriptor) && !ErrorUtils.isError(functionDescriptor);
        }

        private final boolean isWrongCallWithExplicitTypeArguments(VariableAsFunctionResolvedCall resolvedCall2, Call outerCall) {
            boolean passedTypeArgumentsToInvoke;
            Collection collection = outerCall.getTypeArguments();
            boolean bl = !collection.isEmpty() && !(collection = (Collection)resolvedCall2.getFunctionCall().getCandidateDescriptor().getTypeParameters()).isEmpty() ? true : (passedTypeArgumentsToInvoke = false);
            return passedTypeArgumentsToInvoke && !(collection = (Collection)resolvedCall2.getVariableCall().getCandidateDescriptor().getTypeParameters()).isEmpty();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

