/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.toolkit.ctx;

import com.sun.jndi.toolkit.ctx.Continuation;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.CannotProceedException;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ResolveResult;
import javax.naming.spi.Resolver;

public abstract class PartialCompositeContext
implements Context,
Resolver {
    protected static final int _PARTIAL = 1;
    protected static final int _COMPONENT = 2;
    protected static final int _ATOMIC = 3;
    protected int _contextType = 1;
    static final CompositeName _EMPTY_NAME = new CompositeName();
    static CompositeName _NNS_NAME;

    protected PartialCompositeContext() {
    }

    protected abstract ResolveResult p_resolveToClass(Name var1, Class<?> var2, Continuation var3) throws NamingException;

    protected abstract Object p_lookup(Name var1, Continuation var2) throws NamingException;

    protected abstract Object p_lookupLink(Name var1, Continuation var2) throws NamingException;

    protected abstract NamingEnumeration<NameClassPair> p_list(Name var1, Continuation var2) throws NamingException;

    protected abstract NamingEnumeration<Binding> p_listBindings(Name var1, Continuation var2) throws NamingException;

    protected abstract void p_bind(Name var1, Object var2, Continuation var3) throws NamingException;

    protected abstract void p_rebind(Name var1, Object var2, Continuation var3) throws NamingException;

    protected abstract void p_unbind(Name var1, Continuation var2) throws NamingException;

    protected abstract void p_destroySubcontext(Name var1, Continuation var2) throws NamingException;

    protected abstract Context p_createSubcontext(Name var1, Continuation var2) throws NamingException;

    protected abstract void p_rename(Name var1, Name var2, Continuation var3) throws NamingException;

    protected abstract NameParser p_getNameParser(Name var1, Continuation var2) throws NamingException;

    protected Hashtable<?, ?> p_getEnvironment() throws NamingException {
        return this.getEnvironment();
    }

    @Override
    public ResolveResult resolveToClass(String name, Class<? extends Context> contextType) throws NamingException {
        return this.resolveToClass(new CompositeName(name), contextType);
    }

    @Override
    public ResolveResult resolveToClass(Name name, Class<? extends Context> contextType) throws NamingException {
        ResolveResult answer;
        PartialCompositeContext ctx = this;
        Hashtable<?, ?> env = this.p_getEnvironment();
        Continuation cont = new Continuation(name, env);
        Name nm = name;
        try {
            answer = ctx.p_resolveToClass(nm, contextType, cont);
            while (cont.isContinue()) {
                nm = cont.getRemainingName();
                ctx = PartialCompositeContext.getPCContext(cont);
                answer = ctx.p_resolveToClass(nm, contextType, cont);
            }
        }
        catch (CannotProceedException e) {
            Context cctx = NamingManager.getContinuationContext(e);
            if (!(cctx instanceof Resolver)) {
                throw e;
            }
            answer = ((Resolver)((Object)cctx)).resolveToClass(e.getRemainingName(), contextType);
        }
        return answer;
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.lookup(new CompositeName(name));
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        Object answer;
        PartialCompositeContext ctx = this;
        Hashtable<?, ?> env = this.p_getEnvironment();
        Continuation cont = new Continuation(name, env);
        Name nm = name;
        try {
            answer = ctx.p_lookup(nm, cont);
            while (cont.isContinue()) {
                nm = cont.getRemainingName();
                ctx = PartialCompositeContext.getPCContext(cont);
                answer = ctx.p_lookup(nm, cont);
            }
        }
        catch (CannotProceedException e) {
            Context cctx = NamingManager.getContinuationContext(e);
            answer = cctx.lookup(e.getRemainingName());
        }
        return answer;
    }

    @Override
    public void bind(String name, Object newObj) throws NamingException {
        this.bind(new CompositeName(name), newObj);
    }

    @Override
    public void bind(Name name, Object newObj) throws NamingException {
        PartialCompositeContext ctx = this;
        Name nm = name;
        Hashtable<?, ?> env = this.p_getEnvironment();
        Continuation cont = new Continuation(name, env);
        try {
            ctx.p_bind(nm, newObj, cont);
            while (cont.isContinue()) {
                nm = cont.getRemainingName();
                ctx = PartialCompositeContext.getPCContext(cont);
                ctx.p_bind(nm, newObj, cont);
            }
        }
        catch (CannotProceedException e) {
            Context cctx = NamingManager.getContinuationContext(e);
            cctx.bind(e.getRemainingName(), newObj);
        }
    }

    @Override
    public void rebind(String name, Object newObj) throws NamingException {
        this.rebind(new CompositeName(name), newObj);
    }

    @Override
    public void rebind(Name name, Object newObj) throws NamingException {
        PartialCompositeContext ctx = this;
        Name nm = name;
        Hashtable<?, ?> env = this.p_getEnvironment();
        Continuation cont = new Continuation(name, env);
        try {
            ctx.p_rebind(nm, newObj, cont);
            while (cont.isContinue()) {
                nm = cont.getRemainingName();
                ctx = PartialCompositeContext.getPCContext(cont);
                ctx.p_rebind(nm, newObj, cont);
            }
        }
        catch (CannotProceedException e) {
            Context cctx = NamingManager.getContinuationContext(e);
            cctx.rebind(e.getRemainingName(), newObj);
        }
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.unbind(new CompositeName(name));
    }

    @Override
    public void unbind(Name name) throws NamingException {
        PartialCompositeContext ctx = this;
        Name nm = name;
        Hashtable<?, ?> env = this.p_getEnvironment();
        Continuation cont = new Continuation(name, env);
        try {
            ctx.p_unbind(nm, cont);
            while (cont.isContinue()) {
                nm = cont.getRemainingName();
                ctx = PartialCompositeContext.getPCContext(cont);
                ctx.p_unbind(nm, cont);
            }
        }
        catch (CannotProceedException e) {
            Context cctx = NamingManager.getContinuationContext(e);
            cctx.unbind(e.getRemainingName());
        }
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.rename(new CompositeName(oldName), new CompositeName(newName));
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        PartialCompositeContext ctx = this;
        Name nm = oldName;
        Hashtable<?, ?> env = this.p_getEnvironment();
        Continuation cont = new Continuation(oldName, env);
        try {
            ctx.p_rename(nm, newName, cont);
            while (cont.isContinue()) {
                nm = cont.getRemainingName();
                ctx = PartialCompositeContext.getPCContext(cont);
                ctx.p_rename(nm, newName, cont);
            }
        }
        catch (CannotProceedException e) {
            Context cctx = NamingManager.getContinuationContext(e);
            if (e.getRemainingNewName() != null) {
                newName = e.getRemainingNewName();
            }
            cctx.rename(e.getRemainingName(), newName);
        }
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        return this.list(new CompositeName(name));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        NamingEnumeration<NameClassPair> answer;
        PartialCompositeContext ctx = this;
        Name nm = name;
        Hashtable<?, ?> env = this.p_getEnvironment();
        Continuation cont = new Continuation(name, env);
        try {
            answer = ctx.p_list(nm, cont);
            while (cont.isContinue()) {
                nm = cont.getRemainingName();
                ctx = PartialCompositeContext.getPCContext(cont);
                answer = ctx.p_list(nm, cont);
            }
        }
        catch (CannotProceedException e) {
            Context cctx = NamingManager.getContinuationContext(e);
            answer = cctx.list(e.getRemainingName());
        }
        return answer;
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        return this.listBindings(new CompositeName(name));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        NamingEnumeration<Binding> answer;
        PartialCompositeContext ctx = this;
        Name nm = name;
        Hashtable<?, ?> env = this.p_getEnvironment();
        Continuation cont = new Continuation(name, env);
        try {
            answer = ctx.p_listBindings(nm, cont);
            while (cont.isContinue()) {
                nm = cont.getRemainingName();
                ctx = PartialCompositeContext.getPCContext(cont);
                answer = ctx.p_listBindings(nm, cont);
            }
        }
        catch (CannotProceedException e) {
            Context cctx = NamingManager.getContinuationContext(e);
            answer = cctx.listBindings(e.getRemainingName());
        }
        return answer;
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(new CompositeName(name));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        PartialCompositeContext ctx = this;
        Name nm = name;
        Hashtable<?, ?> env = this.p_getEnvironment();
        Continuation cont = new Continuation(name, env);
        try {
            ctx.p_destroySubcontext(nm, cont);
            while (cont.isContinue()) {
                nm = cont.getRemainingName();
                ctx = PartialCompositeContext.getPCContext(cont);
                ctx.p_destroySubcontext(nm, cont);
            }
        }
        catch (CannotProceedException e) {
            Context cctx = NamingManager.getContinuationContext(e);
            cctx.destroySubcontext(e.getRemainingName());
        }
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(new CompositeName(name));
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        Context answer;
        PartialCompositeContext ctx = this;
        Name nm = name;
        Hashtable<?, ?> env = this.p_getEnvironment();
        Continuation cont = new Continuation(name, env);
        try {
            answer = ctx.p_createSubcontext(nm, cont);
            while (cont.isContinue()) {
                nm = cont.getRemainingName();
                ctx = PartialCompositeContext.getPCContext(cont);
                answer = ctx.p_createSubcontext(nm, cont);
            }
        }
        catch (CannotProceedException e) {
            Context cctx = NamingManager.getContinuationContext(e);
            answer = cctx.createSubcontext(e.getRemainingName());
        }
        return answer;
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookupLink(new CompositeName(name));
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        Object answer;
        PartialCompositeContext ctx = this;
        Hashtable<?, ?> env = this.p_getEnvironment();
        Continuation cont = new Continuation(name, env);
        Name nm = name;
        try {
            answer = ctx.p_lookupLink(nm, cont);
            while (cont.isContinue()) {
                nm = cont.getRemainingName();
                ctx = PartialCompositeContext.getPCContext(cont);
                answer = ctx.p_lookupLink(nm, cont);
            }
        }
        catch (CannotProceedException e) {
            Context cctx = NamingManager.getContinuationContext(e);
            answer = cctx.lookupLink(e.getRemainingName());
        }
        return answer;
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return this.getNameParser(new CompositeName(name));
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        NameParser answer;
        PartialCompositeContext ctx = this;
        Name nm = name;
        Hashtable<?, ?> env = this.p_getEnvironment();
        Continuation cont = new Continuation(name, env);
        try {
            answer = ctx.p_getNameParser(nm, cont);
            while (cont.isContinue()) {
                nm = cont.getRemainingName();
                ctx = PartialCompositeContext.getPCContext(cont);
                answer = ctx.p_getNameParser(nm, cont);
            }
        }
        catch (CannotProceedException e) {
            Context cctx = NamingManager.getContinuationContext(e);
            answer = cctx.getNameParser(e.getRemainingName());
        }
        return answer;
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        Name fullName = this.composeName(new CompositeName(name), new CompositeName(prefix));
        return fullName.toString();
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        Name res = (Name)prefix.clone();
        if (name == null) {
            return res;
        }
        res.addAll(name);
        String elide = (String)this.p_getEnvironment().get("java.naming.provider.compose.elideEmpty");
        if (elide == null || !elide.equalsIgnoreCase("true")) {
            return res;
        }
        int len = prefix.size();
        if (!PartialCompositeContext.allEmpty(prefix) && !PartialCompositeContext.allEmpty(name)) {
            if (res.get(len - 1).equals("")) {
                res.remove(len - 1);
            } else if (res.get(len).equals("")) {
                res.remove(len);
            }
        }
        return res;
    }

    protected static boolean allEmpty(Name name) {
        Enumeration<String> enum_ = name.getAll();
        while (enum_.hasMoreElements()) {
            if (enum_.nextElement().isEmpty()) continue;
            return false;
        }
        return true;
    }

    protected static PartialCompositeContext getPCContext(Continuation cont) throws NamingException {
        Object obj = cont.getResolvedObj();
        Object pctx = null;
        if (obj instanceof PartialCompositeContext) {
            return (PartialCompositeContext)obj;
        }
        throw cont.fillInException(new CannotProceedException());
    }

    static {
        try {
            _NNS_NAME = new CompositeName("/");
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
    }
}

