/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart;

import info.monitorenter.gui.chart.ITrace2D;
import java.awt.geom.Point2D;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TracePoint2D
extends Point2D.Double
implements Comparable<TracePoint2D>,
Serializable,
Cloneable {
    public static final transient int STATE_ADDED = 1;
    public static final transient int STATE_CHANGED = 4;
    public static final transient int STATE_REMOVED = 2;
    private boolean m_highlight;
    private ITrace2D m_listener;
    private double m_scaledX;
    private double m_scaledY;
    private double m_x;
    private double m_y;

    public TracePoint2D(double xValue, double yValue) {
        this.m_x = xValue;
        this.m_y = yValue;
    }

    @Override
    public Object clone() {
        TracePoint2D result = (TracePoint2D)super.clone();
        result.m_x = this.m_x;
        result.m_y = this.m_y;
        result.m_scaledX = this.m_scaledX;
        result.m_scaledY = this.m_scaledY;
        result.m_highlight = this.m_highlight;
        return result;
    }

    @Override
    public int compareTo(TracePoint2D obj) {
        double othx = obj.getX();
        int result = this.m_x < othx ? -1 : (this.m_x == othx ? 0 : 1);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        return this.compareTo((TracePoint2D)o) == 0;
    }

    public ITrace2D getListener() {
        return this.m_listener;
    }

    public double getManhattanDistance(double xNormalized, double yNormalized) {
        double result = Math.abs(this.m_scaledX - xNormalized) + Math.abs(this.m_scaledY - yNormalized);
        return result;
    }

    public double getManhattanDistance(TracePoint2D point) {
        return this.getManhattanDistance(point.getX(), point.getY());
    }

    public final double getScaledX() {
        return this.m_scaledX;
    }

    public final double getScaledY() {
        return this.m_scaledY;
    }

    @Override
    public double getX() {
        return this.m_x;
    }

    @Override
    public double getY() {
        return this.m_y;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public final boolean isHighlight() {
        return this.m_highlight;
    }

    public final void setHighlight(boolean highlight) {
        this.m_highlight = highlight;
    }

    public void setListener(ITrace2D listener) {
        this.m_listener = listener;
    }

    @Override
    public void setLocation(double xValue, double yValue) {
        this.m_x = xValue;
        this.m_y = yValue;
        if (this.m_listener != null) {
            this.m_listener.firePointChanged(this, 4);
        }
    }

    public final void setScaledX(double scaledX) {
        this.m_scaledX = scaledX;
    }

    public final void setScaledY(double scaledY) {
        this.m_scaledY = scaledY;
    }

    @Override
    public String toString() {
        return "TracePoint2D[" + this.m_x + ", " + this.m_y + "]";
    }
}

