

  {extends file="main.tpl"}
    <!DOCTYPE head PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"><head xmlns="http://www.w3.org/1999/xhtml">
  {block name=title}GPSBabel development:Garmin Points of Interest (.gpi) (garmin_gpi){/block}
  {block name=body}{literal}
                       
  <div xmlns="http://www.w3.org/1999/xhtml" class="navheader"><table width="100%" summary="Navigation header"><tr><th colspan="3" align="center">Garmin Points of Interest (.gpi) (garmin_gpi)</th></tr><tr><td width="20%" align="left"><a accesskey="p" href="fmt_garmin_poi.html">Prev</a> </td><th width="60%" align="center">Chapter 3. The Formats</th><td width="20%" align="right"> <a accesskey="n" href="fmt_garmin.html">Next</a></td></tr></table><hr /></div><div xmlns="http://www.w3.org/1999/xhtml" class="section"><div class="titlepage"><div><div><h2 class="title" ><a id="fmt_garmin_gpi"></a>Garmin Points of Interest (.gpi) (garmin_gpi)</h2></div></div></div><p class="fmtcapshdr">
    This format can...
    </p><div class="itemizedlist"><ul class="itemizedlist" style="list-style-type: disc; "><li class="listitem"><p class="fmtcapsitem">
          read and write waypoints
        </p></li></ul></div><p>This format has the following options: <a class="link" href="fmt_garmin_gpi.html#fmt_garmin_gpi_o_alerts" title="alerts option">alerts</a>, <a class="link" href="fmt_garmin_gpi.html#fmt_garmin_gpi_o_bitmap" title="bitmap option">bitmap</a>, <a class="link" href="fmt_garmin_gpi.html#fmt_garmin_gpi_o_category" title="category option">category</a>, <a class="link" href="fmt_garmin_gpi.html#fmt_garmin_gpi_o_hide" title="hide option">hide</a>, <a class="link" href="fmt_garmin_gpi.html#fmt_garmin_gpi_o_descr" title="descr option">descr</a>, <a class="link" href="fmt_garmin_gpi.html#fmt_garmin_gpi_o_notes" title="notes option">notes</a>, <a class="link" href="fmt_garmin_gpi.html#fmt_garmin_gpi_o_position" title="position option">position</a>, <a class="link" href="fmt_garmin_gpi.html#fmt_garmin_gpi_o_proximity" title="proximity option">proximity</a>, <a class="link" href="fmt_garmin_gpi.html#fmt_garmin_gpi_o_sleep" title="sleep option">sleep</a>, <a class="link" href="fmt_garmin_gpi.html#fmt_garmin_gpi_o_speed" title="speed option">speed</a>, <a class="link" href="fmt_garmin_gpi.html#fmt_garmin_gpi_o_unique" title="unique option">unique</a>, <a class="link" href="fmt_garmin_gpi.html#fmt_garmin_gpi_o_units" title="units option">units</a>, <a class="link" href="fmt_garmin_gpi.html#fmt_garmin_gpi_o_writecodec" title="writecodec option">writecodec</a> .</p><p>
   The format garmin_gpi supports the binary POI (.gpi) files that are useable
   on newer Garmin GPS receivers.  See <a class="link" href="fmt_garmin_poi.html" title="Garmin POI database (garmin_poi)">garmin_poi</a> for additional information about Garmin's own Poiloader program.
   <a class="ulink" href="http://www.garmin.com/support/agree.jsp?id=927" target="_top">Garmin POI-Loader</a> is the standard application that creates GPI files
   with all possible features.
</p><p>
  Some of the third party and commercial GPI files are using some kind of
  encryption or compression that makes the file contents completely unreadable
  to us. If you get an error "Unsupported code page NNN. File is likely
   encrypted." means we could basically recognize it as a Garmin GPI file,
   but it's mangled beyond what we're likely to successfully read.
</p><p>
  If a waypoint name is annotated with a trailing '@'NNN where NNN is 
  a number, that number will be used as the speed for POI alerts, just
  as with Garmin's POI Loader program. The units default to metric kilometers
  per hour, but this cn be changed to statute via the units argument.
  A speed associated with a specific POI will get precdence over any
  'speed' argument provided. For example, a waypoint named "Point@30" will
  associate a speed of 30 km/h with that specific point even if 'speed=40m'
  is present in the output arguments.
</p><p>
   The layout of GPI files isn't documented and our module was created
   via reverse engineering. If you get a problem on reading or writing 
   a GPI file, please provide that file (mailto:gpsbabel-misc@lists.sourceforge.net).
</p><p>
   At this time we don't support special features as "Tour-Guide" or links
   to sounds and pictures.
</p><div class="important" style="margin-left: 0.5in; margin-right: 0.5in;"><h3 class="title">Important</h3><p>
   Creation timestamp issue: See the option <a class="link" href="fmt_garmin_gpi.html" title="Garmin Points of Interest (.gpi) (garmin_gpi)">sleep</a> !!!
</p><p>
	This module does not support direct transfer of .GPI files to
	receivers in Garmin protocol mode.  For units like Nuvi, Zumo, or 
	Streetpilot, just choose a file that's on the drive where your
	GPS is mounted.   For units like the X series (GPSMap 60CSx, GPSMap 60Cx, Legend Hcx, etc.) 
	you must explictly put the unit in mass storage mode or mount
	the memory chip in an external reader and transfer the file 
	directly.
</p></div><div class="example"><a id="all_garmin_gpi_options"></a><p class="title"><strong>Example 3.8. Command showing garmin_gpi output example</strong></p><div class="example-contents"><p>
    <strong class="userinput"><code>
      gpsbabel -i gpx -f "My Points.gpx" -o garmin_gpi,category="Nice Restaurants",bitmap=restaurant.bmp,notes -F "My Points.gpi"
    </code></strong>
  </p></div></div><br class="example-break" /><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_garmin_gpi_o_alerts"></a><code class="option">alerts</code> option</h3></div></div></div><p>
      Enable alerts on speed or proximity distance.
    </p><p>
   Because speed isn't a real member of a normal waypoint, you can put the speed values into
   the waypoint names. "Point@30" will result in a speed value of 30. By default we assume these
   values are in kilometers per hour.
</p><p>
   Proximity distance is also supported by <a class="link" href="fmt_gpx.html" title="GPX XML (gpx)">GPX</a>, <a class="link" href="fmt_gdb.html" title="Garmin MapSource - gdb (gdb)">Garmin GDB</a>, <a class="link" href="fmt_ozi.html" title="OziExplorer (ozi)">OZI Explorer</a>, 
   <a class="link" href="fmt_compegps.html" title="CompeGPS data files (.wpt/.trk/.rte) (compegps)">CompeGPS</a> and <a class="link" href="fmt_unicsv.html" title="Universal csv with field structure in first line (unicsv)">Universal CSV</a>.
</p><p>
  <strong class="userinput"><code>
    gpsbabel -i gpx -f "warnings.gpx" -o garmin_gpi,alerts=1 -F "warnings.gpi"
  </code></strong>
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_garmin_gpi_o_bitmap"></a><code class="option">bitmap</code> option</h3></div></div></div><p>
      Use specified bitmap on output.
    </p><p>
   The bitmap (BMP) should be 24x24 (or smaller) and can be in
   RGB-colors (24- and 32-bit) or 8-bit indexed color format.
</p><p>
  If you're starting from images in another format, you may need to
  use another tool like Gimp or ImageMagick's convert to get the imaga
  into oen of the above formats to avoid errors about "Unsupported color 
  depth".
</p><p>
  Not all devices can support all color depths.   GPSBabel (and its 
  developers) have no way of knowing what is supported on any given model
  so some experimentation may be necessary on your part.   It was reported
  that a Nuvi 3790, for example, will read the POIs only if they use 8BPP.
</p><p>
   A color value of 0xFF00FF (blue=255, green=0, red=255), 
   also called "Magenta", can be used for transparent areas.
</p><p>
  <strong class="userinput"><code>
    gpsbabel -i gpx -f "My Points.gpx" -o garmin_gpi,bitmap="tux.bmp" -F "My Points.gpi"
  </code></strong>
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_garmin_gpi_o_category"></a><code class="option">category</code> option</h3></div></div></div><p>
      Default category on output.
    </p><p>
    With this option you can specify the category which is primary
    visible on the device (default is "My points").
</p><p>
  <strong class="userinput"><code>
    gpsbabel -i gpx -f "My Points.gpx" -o garmin_gpi,category="Best Restaurants" -F "My Points.gpi"
  </code></strong>
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_garmin_gpi_o_hide"></a><code class="option">hide</code> option</h3></div></div></div><p>
      Don't show gpi bitmap on device.
    </p><p>
   For a large list of points (or whyever) it can be useful when
   no bitmaps are displayed on device. With this option no bitmap
   is stored and displayed.
</p><p>
  <strong class="userinput"><code>
    gpsbabel -i gpx -f "My Points.gpx" -o garmin_gpi,hide -F "My Points.gpi"
  </code></strong>
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_garmin_gpi_o_descr"></a><code class="option">descr</code> option</h3></div></div></div><p>
      Write description to address field.
    </p><p>
   The GPI address field is often visible in lists on the device. Use this
   option if you want to see the waypoint description (which can be an address too)
   in this lists.
</p><p>
  <strong class="userinput"><code>
    gpsbabel -i gpx -f "My Points.gpx" -o garmin_gpi,descr -F "My Points.gpi"
  </code></strong>
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_garmin_gpi_o_notes"></a><code class="option">notes</code> option</h3></div></div></div><p>
      Write notes to address field.
    </p><p>
   The GPI address field is often visible in lists on the device. Use this
   option if you want to see the waypoint notes (which can be an address too)
   in this lists.
</p><p>
  <strong class="userinput"><code>
    gpsbabel -i gpx -f "My Points.gpx" -o garmin_gpi,notes -F "My Points.gpi"
  </code></strong>
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_garmin_gpi_o_position"></a><code class="option">position</code> option</h3></div></div></div><p>
      Write position to address field.
    </p><p>
   The GPI address field is often visible in lists on the device. Use this
   option if you want to see the waypoint position (coordinates) in this lists.
</p><p>
  <strong class="userinput"><code>
    gpsbabel -i gpx -f "My Points.gpx" -o garmin_gpi,position -F "My Points.gpi"
  </code></strong>
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_garmin_gpi_o_proximity"></a><code class="option">proximity</code> option</h3></div></div></div><p>
      Default proximity.
    </p><p>
  When no proximity data is available in the source input, GPSBabel uses this as the default proximity value.
  The parameter has to be in meters, or, when units=s specified, in miles.
  <a class="link" href="fmt_garmin_gpi.html#fmt_garmin_gpi_o_alerts" title="alerts option">alerts</a> are automatically enabled.
</p><div class="example"><a id="garmin_gpi_speedcams"></a><p class="title"><strong>Example 3.9. Read GPX file, create GPI to alert when you're 1/2 mile from a speed camera.</strong></p><div class="example-contents"><p>
  <strong class="userinput"><code>
    gpsbabel -i gpx -f "SpeedCameras.gpx" -o garmin_gpi,units=s,proximity=0.5 -F "SpeedCameras.gpi"
  </code></strong>
</p></div></div><br class="example-break" /><p>
  Its also possible to append a specific distance unit to the parameter.
</p><p>
  <strong class="userinput"><code>
    gpsbabel -i gpx -f "SpeedCameras.gpx" -o garmin_gpi,proximity=500m -F "SpeedCameras.gpi"
  </code></strong>
</p><p>
  </p><div class="table"><a id="distance_units"></a><p class="title"><strong>Table 3.2. Supported distance units (garmin_gpi)</strong></p><div class="table-contents"><table class="table" summary="Supported distance units (garmin_gpi)" border="1"><colgroup><col /><col /></colgroup><thead><tr><th>Unit</th><th>Description</th></tr></thead><tbody><tr><td>fa</td><td>Fathoms</td></tr><tr><td>feet</td><td>Feet</td></tr><tr><td>ft</td><td>Feet</td></tr><tr><td>km</td><td>Kilometers</td></tr><tr><td>m</td><td>Meters</td></tr><tr><td>mi</td><td>Miles</td></tr><tr><td>nm</td><td>Nautical miles</td></tr></tbody></table></div></div><p><br class="table-break" />
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_garmin_gpi_o_sleep"></a><code class="option">sleep</code> option</h3></div></div></div><p>
      After output job done sleep n second(s).
    </p><p>
  The Garmin units seem to use the creation timestamp of GPI files for internal purposes. 
  In other words,  if you load GPI files with same creation timestamp on your device, 
  strange things will happen,  such as having missing or repeated POIs. With the sleep option, GPSBabel waits a given
  number of seconds after the GPI file was written.
</p><p>
  In the normal case of using GPSBabel from the command line or from the GUI, the chance of creating files
  with the same timestamp is in the nearly ZERO. In scripts or batch files where you are writing multiple files - even from different GPSBabel instances - the odds of this happening is rather good.
  The sleep option forces GPSBabel to wait after creating a file to ensure the timestamps are unique. Values are specified in seconds and can be 1 or more.
</p><p>
  <strong class="userinput"><code>
    gpsbabel -i gpx -f "SpeedCameras.gpx" -o garmin_gpi,sleep=1 -F "SpeedCameras.gpi"
  </code></strong>
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_garmin_gpi_o_speed"></a><code class="option">speed</code> option</h3></div></div></div><p>
      Default speed.
    </p><p>
  When no speed data is available in the source input, GPSBabel uses this as the default speed value.
  The parameter has to be in kilometers per hour, or, when units=s specified,
  in miles per hour. <a class="link" href="fmt_garmin_gpi.html#fmt_garmin_gpi_o_alerts" title="alerts option">alerts</a> are
  automatically enabled.
</p><p>
  <strong class="userinput"><code>
    gpsbabel -i gpx -f "SpeedCameras.gpx" -o garmin_gpi,units=s,speed=30 -F "SpeedCameras.gpi"
  </code></strong>
</p><p>
  Its also possible to append a specific speed unit to the parameter.
</p><p>
  <strong class="userinput"><code>
    gpsbabel -i gpx -f "SpeedCameras.gpx" -o garmin_gpi,speed=30mph -F "SpeedCameras.gpi"
  </code></strong>
</p><p>
  </p><div class="table"><a id="garmin_gpi_speed_units"></a><p class="title"><strong>Table 3.3. Supported speed units (garmin_gpi)</strong></p><div class="table-contents"><table class="table" summary="Supported speed units (garmin_gpi)" border="1"><colgroup><col /><col /></colgroup><thead><tr><th>Unit</th><th>Description</th></tr></thead><tbody><tr><td>km/h</td><td>Kilometers per hour</td></tr><tr><td>kmh</td><td>Kilometers per hour</td></tr><tr><td>kph</td><td>Kilometers per hour</td></tr><tr><td>kt</td><td>Knots</td></tr><tr><td>knot</td><td>Knots</td></tr><tr><td>m/s</td><td>Meters per second</td></tr><tr><td>mps</td><td>Meters per second</td></tr><tr><td>mi/h</td><td>Miles per hour</td></tr></tbody></table></div></div><p><br class="table-break" />
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_garmin_gpi_o_unique"></a><code class="option">unique</code> option</h3></div></div></div><p>
      Create unique waypoint names (default = yes).
    </p><p>
   Don't create unique names sample:
</p><p>
  <strong class="userinput"><code>
    gpsbabel -i gpx -f "My Points.gpx" -o garmin_gpi,unique=0 -F "My Points.gpi"
  </code></strong>
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_garmin_gpi_o_units"></a><code class="option">units</code> option</h3></div></div></div><p>
      Units used for names with @speed ('s'tatute or 'm'etric).
    </p><p>
   Sample command tells GPSBabel to handle speed values in miles per hour:
  <strong class="userinput"><code>
    gpsbabel -i gpx -f "My Points.gpx" -o garmin_gpi,units=s -F "My Points.gpi"
  </code></strong>
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_garmin_gpi_o_writecodec"></a><code class="option">writecodec</code> option</h3></div></div></div><p>
      codec to use for writing strings.
    </p><p>
This lets you overwride the default codec of 'windows-1252' when writing
strings in Garmin GPI files. This option may be removed in future versions
of GPSBabel as it's not known which Garmin devices support which character
sets.
</p></div></div><div xmlns="http://www.w3.org/1999/xhtml" class="navfooter"><hr /><table width="100%" summary="Navigation footer"><tr><td width="40%" align="left"><a accesskey="p" href="fmt_garmin_poi.html">Prev</a> </td><td width="20%" align="center"><a accesskey="u" href="The_Formats.html">Up</a></td><td width="40%" align="right"> <a accesskey="n" href="fmt_garmin.html">Next</a></td></tr><tr><td width="40%" align="left" valign="top">Garmin POI database (garmin_poi) </td><td width="20%" align="center"><a accesskey="h" href="index.html">Home</a></td><td width="40%" align="right" valign="top"> Garmin serial/USB protocol (garmin)</td></tr></table></div>
  
      {/literal}{/block}
  