/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import org.gradle.api.Nullable;
import org.gradle.api.Transformer;
import org.gradle.cache.internal.AsyncCacheAccess;
import org.gradle.cache.internal.FileLock;
import org.gradle.cache.internal.MultiProcessSafeAsyncPersistentIndexedCache;
import org.gradle.cache.internal.MultiProcessSafePersistentIndexedCache;
import org.gradle.internal.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncCacheAccessDecoratedCache<K, V>
implements MultiProcessSafeAsyncPersistentIndexedCache<K, V> {
    private final AsyncCacheAccess asyncCacheAccess;
    private final MultiProcessSafePersistentIndexedCache<K, V> persistentCache;

    public AsyncCacheAccessDecoratedCache(AsyncCacheAccess asyncCacheAccess, MultiProcessSafePersistentIndexedCache<K, V> persistentCache) {
        this.asyncCacheAccess = asyncCacheAccess;
        this.persistentCache = persistentCache;
    }

    @Override
    @Nullable
    public V get(final K key) {
        return (V)this.asyncCacheAccess.read(new Factory<V>(){

            public V create() {
                return AsyncCacheAccessDecoratedCache.this.persistentCache.get(key);
            }
        });
    }

    @Override
    public V get(K key, Transformer<? extends V, ? super K> producer, Runnable completion) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putLater(final K key, final V value, final Runnable completion) {
        this.asyncCacheAccess.enqueue(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    AsyncCacheAccessDecoratedCache.this.persistentCache.put(key, value);
                }
                finally {
                    completion.run();
                }
            }
        });
    }

    @Override
    public void removeLater(final K key, final Runnable completion) {
        this.asyncCacheAccess.enqueue(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    AsyncCacheAccessDecoratedCache.this.persistentCache.remove(key);
                }
                finally {
                    completion.run();
                }
            }
        });
    }

    @Override
    public void afterLockAcquire(FileLock.State currentCacheState) {
        this.persistentCache.afterLockAcquire(currentCacheState);
    }

    @Override
    public void finishWork() {
        this.persistentCache.finishWork();
    }

    @Override
    public void beforeLockRelease(FileLock.State currentCacheState) {
        this.persistentCache.beforeLockRelease(currentCacheState);
    }
}

