/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.AdaptiveCoding;
import com.sun.java.util.jar.pack.BandStructure;
import com.sun.java.util.jar.pack.Coding;
import com.sun.java.util.jar.pack.CodingMethod;
import com.sun.java.util.jar.pack.Histogram;
import com.sun.java.util.jar.pack.PopulationCoding;
import com.sun.java.util.jar.pack.PropMap;
import com.sun.java.util.jar.pack.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

class CodingChooser {
    int verbose;
    int effort;
    boolean optUseHistogram = true;
    boolean optUsePopulationCoding = true;
    boolean optUseAdaptiveCoding = true;
    boolean disablePopCoding;
    boolean disableRunCoding;
    boolean topLevel = true;
    double fuzz;
    Coding[] allCodingChoices;
    Choice[] choices;
    ByteArrayOutputStream context;
    CodingChooser popHelper;
    CodingChooser runHelper;
    Random stress;
    private int[] values;
    private int start;
    private int end;
    private int[] deltas;
    private int min;
    private int max;
    private Histogram vHist;
    private Histogram dHist;
    private int searchOrder;
    private Choice regularChoice;
    private Choice bestChoice;
    private CodingMethod bestMethod;
    private int bestByteSize;
    private int bestZipSize;
    private int targetSize;
    public static final int MIN_EFFORT = 1;
    public static final int MID_EFFORT = 5;
    public static final int MAX_EFFORT = 9;
    public static final int POP_EFFORT = 4;
    public static final int RUN_EFFORT = 3;
    public static final int BYTE_SIZE = 0;
    public static final int ZIP_SIZE = 1;
    private Sizer zipSizer = new Sizer();
    private Deflater zipDef = new Deflater();
    private DeflaterOutputStream zipOut = new DeflaterOutputStream((OutputStream)this.zipSizer, this.zipDef);
    private Sizer byteSizer = new Sizer(this.zipOut);
    private Sizer byteOnlySizer = new Sizer();

    CodingChooser(int effort, Coding[] allCodingChoices) {
        int i;
        PropMap p200 = Utils.currentPropMap();
        if (p200 != null) {
            this.verbose = Math.max(p200.getInteger("com.sun.java.util.jar.pack.verbose"), p200.getInteger("com.sun.java.util.jar.pack.verbose.coding"));
            this.optUseHistogram = !p200.getBoolean("com.sun.java.util.jar.pack.no.histogram");
            this.optUsePopulationCoding = !p200.getBoolean("com.sun.java.util.jar.pack.no.population.coding");
            this.optUseAdaptiveCoding = !p200.getBoolean("com.sun.java.util.jar.pack.no.adaptive.coding");
            int lstress = p200.getInteger("com.sun.java.util.jar.pack.stress.coding");
            if (lstress != 0) {
                this.stress = new Random(lstress);
            }
        }
        this.effort = effort;
        this.allCodingChoices = allCodingChoices;
        this.fuzz = 1.0 + 0.0025 * (double)(effort - 5);
        int nc = 0;
        for (i = 0; i < allCodingChoices.length; ++i) {
            if (allCodingChoices[i] == null) continue;
            ++nc;
        }
        this.choices = new Choice[nc];
        nc = 0;
        for (i = 0; i < allCodingChoices.length; ++i) {
            if (allCodingChoices[i] == null) continue;
            int[] distance = new int[this.choices.length];
            this.choices[nc++] = new Choice(allCodingChoices[i], i, distance);
        }
        for (i = 0; i < this.choices.length; ++i) {
            Coding ci = this.choices[i].coding;
            assert (ci.distanceFrom(ci) == 0);
            for (int j = 0; j < i; ++j) {
                Coding cj = this.choices[j].coding;
                int dij = ci.distanceFrom(cj);
                assert (dij > 0);
                assert (dij == cj.distanceFrom(ci));
                this.choices[i].distance[j] = dij;
                this.choices[j].distance[i] = dij;
            }
        }
    }

    Choice makeExtraChoice(Coding coding) {
        int[] distance = new int[this.choices.length];
        for (int i = 0; i < distance.length; ++i) {
            Coding ci = this.choices[i].coding;
            int dij = coding.distanceFrom(ci);
            assert (dij > 0);
            assert (dij == ci.distanceFrom(coding));
            distance[i] = dij;
        }
        Choice c = new Choice(coding, -1, distance);
        c.reset();
        return c;
    }

    ByteArrayOutputStream getContext() {
        if (this.context == null) {
            this.context = new ByteArrayOutputStream(65536);
        }
        return this.context;
    }

    private void reset(int[] values, int start, int end) {
        this.values = values;
        this.start = start;
        this.end = end;
        this.deltas = null;
        this.min = Integer.MAX_VALUE;
        this.max = Integer.MIN_VALUE;
        this.vHist = null;
        this.dHist = null;
        this.searchOrder = 0;
        this.regularChoice = null;
        this.bestChoice = null;
        this.bestMethod = null;
        this.bestZipSize = Integer.MAX_VALUE;
        this.bestByteSize = Integer.MAX_VALUE;
        this.targetSize = Integer.MAX_VALUE;
    }

    CodingMethod choose(int[] values, int start, int end, Coding regular, int[] sizes) {
        int X;
        this.reset(values, start, end);
        if (this.effort <= 1 || start >= end) {
            if (sizes != null) {
                int[] computed = this.computeSizePrivate(regular);
                sizes[0] = computed[0];
                sizes[1] = computed[1];
            }
            return regular;
        }
        if (this.optUseHistogram) {
            this.getValueHistogram();
            this.getDeltaHistogram();
        }
        for (int i = start; i < end; ++i) {
            int val = values[i];
            if (this.min > val) {
                this.min = val;
            }
            if (this.max >= val) continue;
            this.max = val;
        }
        int numChoices = this.markUsableChoices(regular);
        if (this.stress != null) {
            int rand = this.stress.nextInt(numChoices * 2 + 4);
            CodingMethod coding = null;
            for (int i = 0; i < this.choices.length; ++i) {
                Choice c = this.choices[i];
                if (c.searchOrder < 0 || rand-- != 0) continue;
                coding = c.coding;
                break;
            }
            if (coding == null) {
                coding = (rand & 7) != 0 ? regular : this.stressCoding(this.min, this.max);
            }
            if (!this.disablePopCoding && this.optUsePopulationCoding && this.effort >= 4) {
                coding = this.stressPopCoding(coding);
            }
            if (!this.disableRunCoding && this.optUseAdaptiveCoding && this.effort >= 3) {
                coding = this.stressAdaptiveCoding(coding);
            }
            return coding;
        }
        double searchScale = 1.0;
        for (int x = this.effort; x < 9; ++x) {
            searchScale /= 1.414;
        }
        int searchOrderLimit = (int)Math.ceil((double)numChoices * searchScale);
        this.bestChoice = this.regularChoice;
        this.evaluate(this.regularChoice);
        int maxd = this.updateDistances(this.regularChoice);
        int zipSize1 = this.bestZipSize;
        int byteSize1 = this.bestByteSize;
        if (this.regularChoice.coding == regular && this.topLevel && regular.canRepresentSigned(X = BandStructure.encodeEscapeValue(115, regular))) {
            int Xlen = regular.getLength(X);
            this.regularChoice.zipSize -= Xlen;
            this.bestByteSize = this.regularChoice.byteSize;
            this.bestZipSize = this.regularChoice.zipSize;
        }
        int dscale = 1;
        while (this.searchOrder < searchOrderLimit) {
            int dlo;
            int dhi;
            Choice nextChoice;
            if (dscale > maxd) {
                dscale = 1;
            }
            if ((nextChoice = this.findChoiceNear(this.bestChoice, dhi = maxd / dscale, dlo = maxd / (dscale *= 2) + 1)) == null) continue;
            assert (nextChoice.coding.canRepresent(this.min, this.max));
            this.evaluate(nextChoice);
            int nextMaxd = this.updateDistances(nextChoice);
            if (nextChoice != this.bestChoice) continue;
            maxd = nextMaxd;
            if (this.verbose <= 5) continue;
            Utils.log.info("maxd = " + maxd);
        }
        Coding plainBest = this.bestChoice.coding;
        assert (plainBest == this.bestMethod);
        if (this.verbose > 2) {
            Utils.log.info("chooser: plain result=" + this.bestChoice + " after " + this.bestChoice.searchOrder + " rounds, " + (this.regularChoice.zipSize - this.bestZipSize) + " fewer bytes than regular " + regular);
        }
        this.bestChoice = null;
        if (!this.disablePopCoding && this.optUsePopulationCoding && this.effort >= 4 && this.bestMethod instanceof Coding) {
            this.tryPopulationCoding(plainBest);
        }
        if (!this.disableRunCoding && this.optUseAdaptiveCoding && this.effort >= 3 && this.bestMethod instanceof Coding) {
            this.tryAdaptiveCoding(plainBest);
        }
        if (sizes != null) {
            sizes[0] = this.bestByteSize;
            sizes[1] = this.bestZipSize;
        }
        if (this.verbose > 1) {
            Utils.log.info("chooser: result=" + this.bestMethod + " " + (zipSize1 - this.bestZipSize) + " fewer bytes than regular " + regular + "; win=" + CodingChooser.pct(zipSize1 - this.bestZipSize, zipSize1));
        }
        CodingMethod lbestMethod = this.bestMethod;
        this.reset(null, 0, 0);
        return lbestMethod;
    }

    CodingMethod choose(int[] values, int start, int end, Coding regular) {
        return this.choose(values, start, end, regular, null);
    }

    CodingMethod choose(int[] values, Coding regular, int[] sizes) {
        return this.choose(values, 0, values.length, regular, sizes);
    }

    CodingMethod choose(int[] values, Coding regular) {
        return this.choose(values, 0, values.length, regular, null);
    }

    private int markUsableChoices(Coding regular) {
        Choice c;
        int i;
        int numChoices = 0;
        for (i = 0; i < this.choices.length; ++i) {
            c = this.choices[i];
            c.reset();
            if (!c.coding.canRepresent(this.min, this.max)) {
                c.searchOrder = -1;
                if (this.verbose <= 1 || c.coding != regular) continue;
                Utils.log.info("regular coding cannot represent [" + this.min + ".." + this.max + "]: " + regular);
                continue;
            }
            if (c.coding == regular) {
                this.regularChoice = c;
            }
            ++numChoices;
        }
        if (this.regularChoice == null && regular.canRepresent(this.min, this.max)) {
            this.regularChoice = this.makeExtraChoice(regular);
            if (this.verbose > 1) {
                Utils.log.info("*** regular choice is extra: " + this.regularChoice.coding);
            }
        }
        if (this.regularChoice == null) {
            for (i = 0; i < this.choices.length; ++i) {
                c = this.choices[i];
                if (c.searchOrder == -1) continue;
                this.regularChoice = c;
                break;
            }
            if (this.verbose > 1) {
                Utils.log.info("*** regular choice does not apply " + regular);
                Utils.log.info("    using instead " + this.regularChoice.coding);
            }
        }
        if (this.verbose > 2) {
            Utils.log.info("chooser: #choices=" + numChoices + " [" + this.min + ".." + this.max + "]");
            if (this.verbose > 4) {
                for (i = 0; i < this.choices.length; ++i) {
                    c = this.choices[i];
                    if (c.searchOrder < 0) continue;
                    Utils.log.info("  " + c);
                }
            }
        }
        return numChoices;
    }

    private Choice findChoiceNear(Choice near, int dhi, int dlo) {
        if (this.verbose > 5) {
            Utils.log.info("findChoice " + dhi + ".." + dlo + " near: " + near);
        }
        int[] distance = near.distance;
        Choice found = null;
        for (int i = 0; i < this.choices.length; ++i) {
            Choice c = this.choices[i];
            if (c.searchOrder < this.searchOrder || distance[i] < dlo || distance[i] > dhi) continue;
            if (c.minDistance >= dlo && c.minDistance <= dhi) {
                if (this.verbose > 5) {
                    Utils.log.info("findChoice => good " + c);
                }
                return c;
            }
            found = c;
        }
        if (this.verbose > 5) {
            Utils.log.info("findChoice => found " + found);
        }
        return found;
    }

    private void evaluate(Choice c) {
        boolean mustComputeSize;
        assert (c.searchOrder == Integer.MAX_VALUE);
        c.searchOrder = this.searchOrder++;
        if (c == this.bestChoice || c.isExtra()) {
            mustComputeSize = true;
        } else if (this.optUseHistogram) {
            Histogram hist = this.getHistogram(c.coding.isDelta());
            c.byteSize = c.histSize = (int)Math.ceil(hist.getBitLength(c.coding) / 8.0);
            mustComputeSize = c.byteSize <= this.targetSize;
        } else {
            mustComputeSize = true;
        }
        if (mustComputeSize) {
            int[] sizes = this.computeSizePrivate(c.coding);
            c.byteSize = sizes[0];
            c.zipSize = sizes[1];
            if (this.noteSizes(c.coding, c.byteSize, c.zipSize)) {
                this.bestChoice = c;
            }
        }
        if (c.histSize >= 0) assert (c.byteSize == c.histSize);
        if (this.verbose > 4) {
            Utils.log.info("evaluated " + c);
        }
    }

    private boolean noteSizes(CodingMethod c, int byteSize, int zipSize) {
        boolean better;
        assert (zipSize > 0 && byteSize > 0);
        boolean bl = better = zipSize < this.bestZipSize;
        if (this.verbose > 3) {
            Utils.log.info("computed size " + c + " " + byteSize + "/zs=" + zipSize + (better && this.bestMethod != null ? " better by " + CodingChooser.pct(this.bestZipSize - zipSize, zipSize) : ""));
        }
        if (better) {
            this.bestMethod = c;
            this.bestZipSize = zipSize;
            this.bestByteSize = byteSize;
            this.targetSize = (int)((double)byteSize * this.fuzz);
            return true;
        }
        return false;
    }

    private int updateDistances(Choice c) {
        int[] distance = c.distance;
        int maxd = 0;
        for (int i = 0; i < this.choices.length; ++i) {
            int mind;
            Choice c2 = this.choices[i];
            if (c2.searchOrder < this.searchOrder) continue;
            int d = distance[i];
            if (this.verbose > 5) {
                Utils.log.info("evaluate dist " + d + " to " + c2);
            }
            if ((mind = c2.minDistance) > d) {
                c2.minDistance = mind = d;
            }
            if (maxd >= d) continue;
            maxd = d;
        }
        if (this.verbose > 5) {
            Utils.log.info("evaluate maxd => " + maxd);
        }
        return maxd;
    }

    public void computeSize(CodingMethod c, int[] values, int start, int end, int[] sizes) {
        if (end <= start) {
            sizes[1] = 0;
            sizes[0] = 0;
            return;
        }
        try {
            this.resetData();
            c.writeArrayTo(this.byteSizer, values, start, end);
            sizes[0] = this.getByteSize();
            sizes[1] = this.getZipSize();
        }
        catch (IOException ee) {
            throw new RuntimeException(ee);
        }
    }

    public void computeSize(CodingMethod c, int[] values, int[] sizes) {
        this.computeSize(c, values, 0, values.length, sizes);
    }

    public int[] computeSize(CodingMethod c, int[] values, int start, int end) {
        int[] sizes = new int[]{0, 0};
        this.computeSize(c, values, start, end, sizes);
        return sizes;
    }

    public int[] computeSize(CodingMethod c, int[] values) {
        return this.computeSize(c, values, 0, values.length);
    }

    private int[] computeSizePrivate(CodingMethod c) {
        int[] sizes = new int[]{0, 0};
        this.computeSize(c, this.values, this.start, this.end, sizes);
        return sizes;
    }

    public int computeByteSize(CodingMethod cm, int[] values, int start, int end) {
        int len = end - start;
        if (len < 0) {
            return 0;
        }
        if (cm instanceof Coding) {
            int size2;
            Coding c = (Coding)cm;
            int size = c.getLength(values, start, end);
            assert (size == (size2 = this.countBytesToSizer(cm, values, start, end))) : cm + " : " + size + " != " + size2;
            return size;
        }
        return this.countBytesToSizer(cm, values, start, end);
    }

    private int countBytesToSizer(CodingMethod cm, int[] values, int start, int end) {
        try {
            this.byteOnlySizer.reset();
            cm.writeArrayTo(this.byteOnlySizer, values, start, end);
            return this.byteOnlySizer.getSize();
        }
        catch (IOException ee) {
            throw new RuntimeException(ee);
        }
    }

    int[] getDeltas(int min, int max) {
        if ((min | max) != 0) {
            return Coding.makeDeltas(this.values, this.start, this.end, min, max);
        }
        if (this.deltas == null) {
            this.deltas = Coding.makeDeltas(this.values, this.start, this.end, 0, 0);
        }
        return this.deltas;
    }

    Histogram getValueHistogram() {
        if (this.vHist == null) {
            this.vHist = new Histogram(this.values, this.start, this.end);
            if (this.verbose > 3) {
                this.vHist.print("vHist", System.out);
            } else if (this.verbose > 1) {
                this.vHist.print("vHist", null, System.out);
            }
        }
        return this.vHist;
    }

    Histogram getDeltaHistogram() {
        if (this.dHist == null) {
            this.dHist = new Histogram(this.getDeltas(0, 0));
            if (this.verbose > 3) {
                this.dHist.print("dHist", System.out);
            } else if (this.verbose > 1) {
                this.dHist.print("dHist", null, System.out);
            }
        }
        return this.dHist;
    }

    Histogram getHistogram(boolean isDelta) {
        return isDelta ? this.getDeltaHistogram() : this.getValueHistogram();
    }

    private void tryPopulationCoding(Coding plainCoding) {
        Histogram hist = this.getValueHistogram();
        int approxL = 64;
        Coding favoredCoding = plainCoding.getValueCoding();
        Coding tokenCoding = BandStructure.UNSIGNED5.setL(64);
        Coding unfavoredCoding = plainCoding.getValueCoding();
        int BAND_HEADER = 4;
        int currentFSize = 4 + Math.max(favoredCoding.getLength(this.min), favoredCoding.getLength(this.max));
        int ZERO_LEN = tokenCoding.getLength(0);
        int currentTSize = ZERO_LEN * (this.end - this.start);
        int currentUSize = (int)Math.ceil(hist.getBitLength(unfavoredCoding) / 8.0);
        int bestPopSize = currentFSize + currentTSize + currentUSize;
        int bestPopFVC = 0;
        int[] allFavoredValues = new int[1 + hist.getTotalLength()];
        int targetLowFVC = -1;
        int targetHighFVC = -1;
        int[][] matrix = hist.getMatrix();
        int mrow = -1;
        int mcol = 1;
        int mrowFreq = 0;
        for (int fvcount = 1; fvcount <= hist.getTotalLength(); ++fvcount) {
            int thisValue;
            if (mcol == 1) {
                mrowFreq = matrix[++mrow][0];
                mcol = matrix[mrow].length;
            }
            allFavoredValues[fvcount] = thisValue = matrix[mrow][--mcol];
            int thisVLen = favoredCoding.getLength(thisValue);
            int thisVCount = mrowFreq;
            int thisToken = fvcount;
            int currentSize = (currentFSize += thisVLen) + (currentTSize += (tokenCoding.getLength(thisToken) - ZERO_LEN) * thisVCount) + (currentUSize -= thisVLen * thisVCount);
            if (bestPopSize <= currentSize) continue;
            if (currentSize <= this.targetSize) {
                targetHighFVC = fvcount;
                if (targetLowFVC < 0) {
                    targetLowFVC = fvcount;
                }
                if (this.verbose > 4) {
                    Utils.log.info("better pop-size at fvc=" + fvcount + " by " + CodingChooser.pct(bestPopSize - currentSize, bestPopSize));
                }
            }
            bestPopSize = currentSize;
            bestPopFVC = fvcount;
        }
        if (targetLowFVC < 0) {
            if (this.verbose > 1 && this.verbose > 1) {
                Utils.log.info("no good pop-size; best was " + bestPopSize + " at " + bestPopFVC + " worse by " + CodingChooser.pct(bestPopSize - this.bestByteSize, this.bestByteSize));
            }
            return;
        }
        if (this.verbose > 1) {
            Utils.log.info("initial best pop-size at fvc=" + bestPopFVC + " in [" + targetLowFVC + ".." + targetHighFVC + "]" + " by " + CodingChooser.pct(this.bestByteSize - bestPopSize, this.bestByteSize));
        }
        int oldZipSize = this.bestZipSize;
        int[] LValuesCoded = PopulationCoding.LValuesCoded;
        ArrayList<Coding> bestFits = new ArrayList<Coding>();
        ArrayList<Coding> fullFits = new ArrayList<Coding>();
        ArrayList<Coding> longFits = new ArrayList<Coding>();
        boolean PACK_TO_MAX_S = true;
        if (bestPopFVC <= 255) {
            bestFits.add(BandStructure.BYTE1);
        } else {
            boolean doFullAlso;
            int bestB = 5;
            boolean bl = doFullAlso = this.effort > 4;
            if (doFullAlso) {
                fullFits.add(BandStructure.BYTE1.setS(1));
            }
            for (int i = LValuesCoded.length - 1; i >= 1; --i) {
                int L = LValuesCoded[i];
                Coding c0 = PopulationCoding.fitTokenCoding(targetLowFVC, L);
                Coding c1 = PopulationCoding.fitTokenCoding(bestPopFVC, L);
                Coding c3 = PopulationCoding.fitTokenCoding(targetHighFVC, L);
                if (c1 != null) {
                    if (!bestFits.contains(c1)) {
                        bestFits.add(c1);
                    }
                    if (bestB > c1.B()) {
                        bestB = c1.B();
                    }
                }
                if (!doFullAlso) continue;
                if (c3 == null) {
                    c3 = c1;
                }
                for (int B = c0.B(); B <= c3.B(); ++B) {
                    Coding c2;
                    if (B == c1.B() || B == 1 || fullFits.contains(c2 = c3.setB(B).setS(1))) continue;
                    fullFits.add(c2);
                }
            }
            Iterator i = bestFits.iterator();
            while (i.hasNext()) {
                Coding c = (Coding)i.next();
                if (c.B() <= bestB) continue;
                i.remove();
                longFits.add(0, c);
            }
        }
        ArrayList allFits = new ArrayList();
        Iterator i = bestFits.iterator();
        Iterator j = fullFits.iterator();
        Iterator k = longFits.iterator();
        while (i.hasNext() || j.hasNext() || k.hasNext()) {
            if (i.hasNext()) {
                allFits.add(i.next());
            }
            if (j.hasNext()) {
                allFits.add(j.next());
            }
            if (!k.hasNext()) continue;
            allFits.add(k.next());
        }
        bestFits.clear();
        fullFits.clear();
        longFits.clear();
        int maxFits = allFits.size();
        if (this.effort == 4) {
            maxFits = 2;
        } else if (maxFits > 4) {
            maxFits -= 4;
            maxFits = maxFits * (this.effort - 4) / 5;
            maxFits += 4;
        }
        if (allFits.size() > maxFits) {
            if (this.verbose > 4) {
                Utils.log.info("allFits before clip: " + allFits);
            }
            allFits.subList(maxFits, allFits.size()).clear();
        }
        if (this.verbose > 3) {
            Utils.log.info("allFits: " + allFits);
        }
        for (Coding tc : allFits) {
            int fVlen;
            boolean packToMax = false;
            if (tc.S() == 1) {
                packToMax = true;
                tc = tc.setS(0);
            }
            if (!packToMax) {
                fVlen = bestPopFVC;
                assert (tc.umax() >= fVlen);
                assert (tc.B() == 1 || tc.setB(tc.B() - 1).umax() < fVlen);
            } else {
                fVlen = Math.min(tc.umax(), targetHighFVC);
                if (fVlen < targetLowFVC || fVlen == bestPopFVC) continue;
            }
            PopulationCoding pop = new PopulationCoding();
            pop.setHistogram(hist);
            pop.setL(tc.L());
            pop.setFavoredValues(allFavoredValues, fVlen);
            assert (pop.tokenCoding == tc);
            pop.resortFavoredValues();
            int[] tcsizes = this.computePopSizePrivate(pop, favoredCoding, unfavoredCoding);
            this.noteSizes(pop, tcsizes[0], 4 + tcsizes[1]);
        }
        if (this.verbose > 3) {
            Utils.log.info("measured best pop, size=" + this.bestByteSize + "/zs=" + this.bestZipSize + " better by " + CodingChooser.pct(oldZipSize - this.bestZipSize, oldZipSize));
            if (this.bestZipSize < oldZipSize) {
                Utils.log.info(">>> POP WINS BY " + (oldZipSize - this.bestZipSize));
            }
        }
    }

    private int[] computePopSizePrivate(PopulationCoding pop, Coding favoredCoding, Coding unfavoredCoding) {
        int[] sizes;
        if (this.popHelper == null) {
            this.popHelper = new CodingChooser(this.effort, this.allCodingChoices);
            if (this.stress != null) {
                this.popHelper.addStressSeed(this.stress.nextInt());
            }
            this.popHelper.topLevel = false;
            --this.popHelper.verbose;
            this.popHelper.disablePopCoding = true;
            this.popHelper.disableRunCoding = this.disableRunCoding;
            if (this.effort < 5) {
                this.popHelper.disableRunCoding = true;
            }
        }
        int fVlen = pop.fVlen;
        if (this.verbose > 2) {
            Utils.log.info("computePopSizePrivate fvlen=" + fVlen + " tc=" + pop.tokenCoding);
            Utils.log.info("{ //BEGIN");
        }
        int[] favoredValues = pop.fValues;
        int[][] vals = pop.encodeValues(this.values, this.start, this.end);
        int[] tokens = vals[0];
        int[] unfavoredValues = vals[1];
        if (this.verbose > 2) {
            Utils.log.info("-- refine on fv[" + fVlen + "] fc=" + favoredCoding);
        }
        pop.setFavoredCoding(this.popHelper.choose(favoredValues, 1, 1 + fVlen, favoredCoding));
        if (pop.tokenCoding instanceof Coding && (this.stress == null || this.stress.nextBoolean())) {
            CodingMethod tc;
            if (this.verbose > 2) {
                Utils.log.info("-- refine on tv[" + tokens.length + "] tc=" + pop.tokenCoding);
            }
            if ((tc = this.popHelper.choose(tokens, (Coding)pop.tokenCoding)) != pop.tokenCoding) {
                if (this.verbose > 2) {
                    Utils.log.info(">>> refined tc=" + tc);
                }
                pop.setTokenCoding(tc);
            }
        }
        if (unfavoredValues.length == 0) {
            pop.setUnfavoredCoding(null);
        } else {
            if (this.verbose > 2) {
                Utils.log.info("-- refine on uv[" + unfavoredValues.length + "] uc=" + pop.unfavoredCoding);
            }
            pop.setUnfavoredCoding(this.popHelper.choose(unfavoredValues, unfavoredCoding));
        }
        if (this.verbose > 3) {
            Utils.log.info("finish computePopSizePrivate fvlen=" + fVlen + " fc=" + pop.favoredCoding + " tc=" + pop.tokenCoding + " uc=" + pop.unfavoredCoding);
            StringBuilder sb = new StringBuilder();
            sb.append("fv = {");
            for (int i = 1; i <= fVlen; ++i) {
                if (i % 10 == 0) {
                    sb.append('\n');
                }
                sb.append(" ").append(favoredValues[i]);
            }
            sb.append('\n');
            sb.append("}");
            Utils.log.info(sb.toString());
        }
        if (this.verbose > 2) {
            Utils.log.info("} //END");
        }
        if (this.stress != null) {
            return null;
        }
        try {
            this.resetData();
            pop.writeSequencesTo(this.byteSizer, tokens, unfavoredValues);
            sizes = new int[]{this.getByteSize(), this.getZipSize()};
        }
        catch (IOException ee) {
            throw new RuntimeException(ee);
        }
        int[] checkSizes = null;
        assert ((checkSizes = this.computeSizePrivate(pop)) != null);
        assert (checkSizes[0] == sizes[0]) : checkSizes[0] + " != " + sizes[0];
        return sizes;
    }

    private void tryAdaptiveCoding(Coding plainCoding) {
        int i;
        int oldZipSize = this.bestZipSize;
        int lstart = this.start;
        int lend = this.end;
        int[] lvalues = this.values;
        int len = lend - lstart;
        if (plainCoding.isDelta()) {
            lvalues = this.getDeltas(0, 0);
            lstart = 0;
            lend = lvalues.length;
        }
        int[] sizes = new int[len + 1];
        int fillp = 0;
        int totalSize = 0;
        for (int i2 = lstart; i2 < lend; ++i2) {
            int val = lvalues[i2];
            sizes[fillp++] = totalSize;
            int size = plainCoding.getLength(val);
            assert (size < Integer.MAX_VALUE);
            totalSize += size;
        }
        sizes[fillp++] = totalSize;
        assert (fillp == sizes.length);
        double avgSize = (double)totalSize / (double)len;
        double sizeFuzz = this.effort >= 5 ? (this.effort > 6 ? 1.001 : 1.003) : (this.effort > 3 ? 1.01 : 1.03);
        sizeFuzz *= sizeFuzz;
        double sizeFuzz2 = sizeFuzz * sizeFuzz;
        double sizeFuzz3 = sizeFuzz * sizeFuzz * sizeFuzz;
        double[] dmeshes = new double[1 + (this.effort - 3)];
        double logLen = Math.log(len);
        for (int i3 = 0; i3 < dmeshes.length; ++i3) {
            dmeshes[i3] = Math.exp(logLen * (double)(i3 + 1) / (double)(dmeshes.length + 1));
        }
        int[] meshes = new int[dmeshes.length];
        int mfillp = 0;
        for (int i4 = 0; i4 < dmeshes.length; ++i4) {
            int m = (int)Math.round(dmeshes[i4]);
            if ((m = AdaptiveCoding.getNextK(m - 1)) <= 0 || m >= len || mfillp > 0 && m == meshes[mfillp - 1]) continue;
            meshes[mfillp++] = m;
        }
        meshes = BandStructure.realloc(meshes, mfillp);
        int BAND_HEADER = 4;
        int[] threshes = new int[meshes.length];
        double[] fuzzes = new double[meshes.length];
        for (i = 0; i < meshes.length; ++i) {
            int mesh = meshes[i];
            double lfuzz = mesh < 10 ? sizeFuzz3 : (mesh < 100 ? sizeFuzz2 : sizeFuzz);
            fuzzes[i] = lfuzz;
            threshes[i] = 4 + (int)Math.ceil((double)mesh * avgSize * lfuzz);
        }
        if (this.verbose > 1) {
            System.out.print("tryAdaptiveCoding [" + len + "]" + " avgS=" + avgSize + " fuzz=" + sizeFuzz + " meshes: {");
            for (i = 0; i < meshes.length; ++i) {
                System.out.print(" " + meshes[i] + "(" + threshes[i] + ")");
            }
            Utils.log.info(" }");
        }
        if (this.runHelper == null) {
            this.runHelper = new CodingChooser(this.effort, this.allCodingChoices);
            if (this.stress != null) {
                this.runHelper.addStressSeed(this.stress.nextInt());
            }
            this.runHelper.topLevel = false;
            --this.runHelper.verbose;
            this.runHelper.disableRunCoding = true;
            this.runHelper.disablePopCoding = this.disablePopCoding;
            if (this.effort < 5) {
                this.runHelper.disablePopCoding = true;
            }
        }
        block5: for (i = 0; i < len; ++i) {
            if ((i = AdaptiveCoding.getNextK(i - 1)) > len) {
                i = len;
            }
            for (int j = meshes.length - 1; j >= 0; --j) {
                CodingMethod endcm;
                CodingMethod begcm;
                CodingMethod midcm;
                int size;
                int mesh = meshes[j];
                int thresh = threshes[j];
                if (i + mesh > len || (size = sizes[i + mesh] - sizes[i]) < thresh) continue;
                int bend = i + mesh;
                int bsize = size;
                double bigSize = avgSize * fuzzes[j];
                while (bend < len && bend - i <= len / 2) {
                    int bend0 = bend;
                    int bsize0 = bsize;
                    bend += mesh;
                    if ((bend = i + AdaptiveCoding.getNextK(bend - i - 1)) < 0 || bend > len) {
                        bend = len;
                    }
                    if (!((double)(bsize = sizes[bend] - sizes[i]) < 4.0 + (double)(bend - i) * bigSize)) continue;
                    bsize = bsize0;
                    bend = bend0;
                    break;
                }
                int nexti = bend;
                if (this.verbose > 2) {
                    Utils.log.info("bulge at " + i + "[" + (bend - i) + "] of " + CodingChooser.pct((double)bsize - avgSize * (double)(bend - i), avgSize * (double)(bend - i)));
                    Utils.log.info("{ //BEGIN");
                }
                if ((midcm = this.runHelper.choose(this.values, this.start + i, this.start + bend, plainCoding)) == plainCoding) {
                    begcm = plainCoding;
                    endcm = plainCoding;
                } else {
                    begcm = this.runHelper.choose(this.values, this.start, this.start + i, plainCoding);
                    endcm = this.runHelper.choose(this.values, this.start + bend, this.start + len, plainCoding);
                }
                if (this.verbose > 2) {
                    Utils.log.info("} //END");
                }
                if (begcm == midcm && i > 0 && AdaptiveCoding.isCodableLength(bend)) {
                    i = 0;
                }
                if (midcm == endcm && bend < len) {
                    bend = len;
                }
                if (begcm != plainCoding || midcm != plainCoding || endcm != plainCoding) {
                    CodingMethod chain;
                    int hlen = 0;
                    if (bend == len) {
                        chain = midcm;
                    } else {
                        chain = new AdaptiveCoding(bend - i, midcm, endcm);
                        hlen += 4;
                    }
                    if (i > 0) {
                        chain = new AdaptiveCoding(i, begcm, chain);
                        hlen += 4;
                    }
                    int[] chainSize = this.computeSizePrivate(chain);
                    this.noteSizes(chain, chainSize[0], chainSize[1] + hlen);
                }
                i = nexti;
                continue block5;
            }
        }
        if (this.verbose > 3 && this.bestZipSize < oldZipSize) {
            Utils.log.info(">>> RUN WINS BY " + (oldZipSize - this.bestZipSize));
        }
    }

    private static String pct(double num, double den) {
        return (double)Math.round(num / den * 10000.0) / 100.0 + "%";
    }

    private void resetData() {
        this.flushData();
        this.zipDef.reset();
        if (this.context != null) {
            try {
                this.context.writeTo(this.byteSizer);
            }
            catch (IOException ee) {
                throw new RuntimeException(ee);
            }
        }
        this.zipSizer.reset();
        this.byteSizer.reset();
    }

    private void flushData() {
        try {
            this.zipOut.finish();
        }
        catch (IOException ee) {
            throw new RuntimeException(ee);
        }
    }

    private int getByteSize() {
        return this.byteSizer.getSize();
    }

    private int getZipSize() {
        this.flushData();
        return this.zipSizer.getSize();
    }

    void addStressSeed(int x) {
        if (this.stress == null) {
            return;
        }
        this.stress.setSeed((long)x + ((long)this.stress.nextInt() << 32));
    }

    private CodingMethod stressPopCoding(CodingMethod coding) {
        int reorder;
        assert (this.stress != null);
        if (!(coding instanceof Coding)) {
            return coding;
        }
        Coding valueCoding = ((Coding)coding).getValueCoding();
        Histogram hist = this.getValueHistogram();
        int fVlen = this.stressLen(hist.getTotalLength());
        if (fVlen == 0) {
            return coding;
        }
        ArrayList<Integer> popvals = new ArrayList<Integer>();
        if (this.stress.nextBoolean()) {
            HashSet<Integer> popset = new HashSet<Integer>();
            for (int i = this.start; i < this.end; ++i) {
                if (!popset.add(this.values[i])) continue;
                popvals.add(this.values[i]);
            }
        } else {
            int[][] matrix = hist.getMatrix();
            for (int mrow = 0; mrow < matrix.length; ++mrow) {
                int[] row = matrix[mrow];
                for (int mcol = 1; mcol < row.length; ++mcol) {
                    popvals.add(row[mcol]);
                }
            }
        }
        if (((reorder = this.stress.nextInt()) & 7) <= 2) {
            Collections.shuffle(popvals, this.stress);
        } else {
            if (((reorder >>>= 3) & 7) <= 2) {
                Collections.sort(popvals);
            }
            if (((reorder >>>= 3) & 7) <= 2) {
                Collections.reverse(popvals);
            }
            if (((reorder >>>= 3) & 7) <= 2) {
                Collections.rotate(popvals, this.stressLen(popvals.size()));
            }
        }
        if (popvals.size() > fVlen) {
            if (((reorder >>>= 3) & 7) <= 2) {
                popvals.subList(fVlen, popvals.size()).clear();
            } else {
                popvals.subList(0, popvals.size() - fVlen).clear();
            }
        }
        fVlen = popvals.size();
        int[] fvals = new int[1 + fVlen];
        for (int i = 0; i < fVlen; ++i) {
            fvals[1 + i] = (Integer)popvals.get(i);
        }
        PopulationCoding pop = new PopulationCoding();
        pop.setFavoredValues(fvals, fVlen);
        int[] lvals = PopulationCoding.LValuesCoded;
        for (int i = 0; i < lvals.length / 2; ++i) {
            int popl = lvals[this.stress.nextInt(lvals.length)];
            if (popl < 0 || PopulationCoding.fitTokenCoding(fVlen, popl) == null) continue;
            pop.setL(popl);
            break;
        }
        if (pop.tokenCoding == null) {
            int lmin;
            int lmax = lmin = fvals[1];
            for (int i = 2; i <= fVlen; ++i) {
                int val = fvals[i];
                if (lmin > val) {
                    lmin = val;
                }
                if (lmax >= val) continue;
                lmax = val;
            }
            pop.tokenCoding = this.stressCoding(lmin, lmax);
        }
        this.computePopSizePrivate(pop, valueCoding, valueCoding);
        return pop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CodingMethod stressAdaptiveCoding(CodingMethod coding) {
        assert (this.stress != null);
        if (!(coding instanceof Coding)) {
            return coding;
        }
        Coding plainCoding = (Coding)coding;
        int len = this.end - this.start;
        if (len < 2) {
            return coding;
        }
        int spanlen = this.stressLen(len - 1) + 1;
        if (spanlen == len) {
            return coding;
        }
        try {
            assert (!this.disableRunCoding);
            this.disableRunCoding = true;
            int[] allValues = (int[])this.values.clone();
            CodingMethod result = null;
            int scan = this.end;
            int lstart = this.start;
            while (scan > lstart) {
                int thisspan;
                int rand;
                int n = rand = scan - lstart < 100 ? -1 : this.stress.nextInt();
                if ((rand & 7) != 0) {
                    thisspan = spanlen == 1 ? spanlen : this.stressLen(spanlen - 1) + 1;
                } else {
                    int KX = (rand >>>= 3) & 3;
                    int KB = (rand >>>= 3) & 0xFF;
                    while ((thisspan = AdaptiveCoding.decodeK(KX, KB)) > scan - lstart) {
                        if (KB != 3) {
                            KB = 3;
                            continue;
                        }
                        --KX;
                    }
                    assert (AdaptiveCoding.isCodableLength(thisspan));
                }
                if (thisspan > scan - lstart) {
                    thisspan = scan - lstart;
                }
                while (!AdaptiveCoding.isCodableLength(thisspan)) {
                    --thisspan;
                }
                int split = scan - thisspan;
                assert (split < scan);
                assert (split >= lstart);
                CodingMethod sc = this.choose(allValues, split, scan, plainCoding);
                result = result == null ? sc : new AdaptiveCoding(scan - split, sc, result);
                scan = split;
            }
            CodingMethod codingMethod = result;
            return codingMethod;
        }
        finally {
            this.disableRunCoding = false;
        }
    }

    private Coding stressCoding(int min, int max) {
        assert (this.stress != null);
        for (int i = 0; i < 100; ++i) {
            Coding dc;
            Coding c = Coding.of(this.stress.nextInt(5) + 1, this.stress.nextInt(256) + 1, this.stress.nextInt(3));
            if (c.B() == 1) {
                c = c.setH(256);
            }
            if (c.H() == 256 && c.B() >= 5) {
                c = c.setB(4);
            }
            if (this.stress.nextBoolean() && (dc = c.setD(1)).canRepresent(min, max)) {
                return dc;
            }
            if (!c.canRepresent(min, max)) continue;
            return c;
        }
        return BandStructure.UNSIGNED5;
    }

    private int stressLen(int len) {
        assert (this.stress != null);
        assert (len >= 0);
        int rand = this.stress.nextInt(100);
        if (rand < 20) {
            return Math.min(len / 5, rand);
        }
        if (rand < 40) {
            return len;
        }
        return this.stress.nextInt(len);
    }

    static class Sizer
    extends OutputStream {
        final OutputStream out;
        private int count;

        Sizer(OutputStream out) {
            this.out = out;
        }

        Sizer() {
            this(null);
        }

        @Override
        public void write(int b) throws IOException {
            ++this.count;
            if (this.out != null) {
                this.out.write(b);
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.count += len;
            if (this.out != null) {
                this.out.write(b, off, len);
            }
        }

        public void reset() {
            this.count = 0;
        }

        public int getSize() {
            return this.count;
        }

        public String toString() {
            String str = super.toString();
            assert ((str = this.stringForDebug()) != null);
            return str;
        }

        String stringForDebug() {
            return "<Sizer " + this.getSize() + ">";
        }
    }

    static class Choice {
        final Coding coding;
        final int index;
        final int[] distance;
        int searchOrder;
        int minDistance;
        int zipSize;
        int byteSize;
        int histSize;

        Choice(Coding coding, int index, int[] distance) {
            this.coding = coding;
            this.index = index;
            this.distance = distance;
        }

        void reset() {
            this.searchOrder = Integer.MAX_VALUE;
            this.minDistance = Integer.MAX_VALUE;
            this.histSize = -1;
            this.byteSize = -1;
            this.zipSize = -1;
        }

        boolean isExtra() {
            return this.index < 0;
        }

        public String toString() {
            return this.stringForDebug();
        }

        private String stringForDebug() {
            String s = "";
            if (this.searchOrder < Integer.MAX_VALUE) {
                s = s + " so: " + this.searchOrder;
            }
            if (this.minDistance < Integer.MAX_VALUE) {
                s = s + " md: " + this.minDistance;
            }
            if (this.zipSize > 0) {
                s = s + " zs: " + this.zipSize;
            }
            if (this.byteSize > 0) {
                s = s + " bs: " + this.byteSize;
            }
            if (this.histSize > 0) {
                s = s + " hs: " + this.histSize;
            }
            return "Choice[" + this.index + "] " + s + " " + this.coding;
        }
    }
}

